/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.DataOverride;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.configuration.ExecutionType;
import org.apache.phoenix.pherf.configuration.Query;
import org.apache.phoenix.pherf.configuration.QuerySet;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.workload.WorkloadExecutor;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationParserTest {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationParserTest.class);

    @Test
    public void testConfigFilesParsing() {
        try {
            WorkloadExecutor workloadExec = new WorkloadExecutor();
            List scenarioList = workloadExec.getParser().getScenarios();
            Assert.assertTrue((String)"Could not load the scenarios from xml.", (scenarioList != null && scenarioList.size() > 0 ? 1 : 0) != 0);
            logger.info("Number of scenarios loaded: " + scenarioList.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testConfigReader() {
        URL resourceUrl = this.getClass().getResource("/scenario/test_scenario.xml");
        Assert.assertNotNull((String)"Test data XML file is missing", (Object)resourceUrl);
        try {
            logger.debug("DataModel: " + this.writeXML());
            Path resourcePath = Paths.get(resourceUrl.toURI());
            DataModel data = XMLConfigParser.readDataModel((Path)resourcePath);
            List scenarioList = data.getScenarios();
            Assert.assertTrue((String)"Could not load the scenarios from xml.", (scenarioList != null && scenarioList.size() > 0 ? 1 : 0) != 0);
            List dataMappingColumns = data.getDataMappingColumns();
            Assert.assertTrue((String)"Could not load the data columns from xml.", (dataMappingColumns != null && dataMappingColumns.size() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Could not load the data DataValue list from xml.", (((Column)dataMappingColumns.get(6)).getDataValues() != null && ((Column)dataMappingColumns.get(6)).getDataValues().size() > 0 ? 1 : 0) != 0);
            this.assertDateValue(dataMappingColumns);
            for (Column column : dataMappingColumns) {
                Assert.assertNotNull((String)("Column (" + column.getName() + ") is missing its type"), (Object)column.getType());
            }
            Scenario scenario = (Scenario)scenarioList.get(0);
            Assert.assertNotNull((Object)scenario);
            Assert.assertEquals((Object)"PHERF.TEST_TABLE", (Object)scenario.getTableName());
            Assert.assertEquals((long)10L, (long)scenario.getRowCount());
            Assert.assertEquals((long)1L, (long)scenario.getDataOverride().getColumn().size());
            QuerySet qs = (QuerySet)scenario.getQuerySet().get(0);
            Assert.assertEquals((Object)ExecutionType.SERIAL, (Object)qs.getExecutionType());
            Assert.assertEquals((long)5000L, (long)qs.getExecutionDurationInMs());
            Assert.assertEquals((long)2L, (long)qs.getQuery().size());
            Query firstQuery = (Query)qs.getQuery().get(0);
            Assert.assertEquals((Object)"1-3", (Object)qs.getConcurrency());
            Assert.assertEquals((long)1L, (long)qs.getMinConcurrency());
            Assert.assertEquals((long)3L, (long)qs.getMaxConcurrency());
            Assert.assertEquals((long)100L, (long)qs.getNumberOfExecutions());
            Assert.assertEquals((Object)"select count(*) from PHERF.TEST_TABLE", (Object)firstQuery.getStatement());
            Assert.assertEquals((Object)"123456789012345", (Object)firstQuery.getTenantId());
            Assert.assertEquals(null, (Object)firstQuery.getDdl());
            Assert.assertEquals((long)0L, (long)firstQuery.getExpectedAggregateRowCount());
            Query secondQuery = (Query)qs.getQuery().get(1);
            Assert.assertEquals((String)"Could not get statement.", (Object)"select sum(SOME_INT) from PHERF.TEST_TABLE", (Object)secondQuery.getStatement());
            Assert.assertEquals((String)"Could not get queryGroup.", (Object)"g1", (Object)secondQuery.getQueryGroup());
            DataOverride override = scenario.getDataOverride();
            for (Column column : override.getColumn()) {
                Assert.assertTrue((String)("Could not lookup Column (" + column.getName() + ") in DataMapping columns: " + dataMappingColumns), (boolean)dataMappingColumns.contains(column));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private void assertDateValue(List<Column> dataMappingColumns) {
        for (Column dataMapping : dataMappingColumns) {
            if (dataMapping.getType() != DataTypeMapping.DATE || !dataMapping.getName().equals("CREATED_DATE")) continue;
            Assert.assertNotNull((Object)((DataValue)dataMapping.getDataValues().get(0)).getMinValue());
            Assert.assertNotNull((Object)((DataValue)dataMapping.getDataValues().get(0)).getMaxValue());
            Assert.assertNotNull((Object)((DataValue)dataMapping.getDataValues().get(1)).getValue());
            Assert.assertNotNull((Object)((DataValue)dataMapping.getDataValues().get(2)).getMinValue());
            Assert.assertNotNull((Object)((DataValue)dataMapping.getDataValues().get(2)).getMaxValue());
            return;
        }
        Assert.fail((String)"We should have found a Rule value that matched.");
    }

    private String writeXML() {
        DataModel data = new DataModel();
        try {
            DataValue dataValue = new DataValue();
            dataValue.setDistribution(20);
            dataValue.setValue("jnhgGhHminwiajn");
            ArrayList<DataValue> dataValueList = new ArrayList<DataValue>();
            dataValueList.add(dataValue);
            Column column = new Column();
            column.setLength(15);
            column.setDataSequence(DataSequence.RANDOM);
            column.setName("TEST_COL");
            column.setUserDefined(true);
            column.setDataValues(dataValueList);
            ArrayList<Column> columnList = new ArrayList<Column>();
            columnList.add(column);
            data.setRelease("192");
            data.setDataMappingColumns(columnList);
            Scenario scenario = new Scenario();
            scenario.setPhoenixProperties(new HashMap());
            scenario.getPhoenixProperties().put("phoenix.query.threadPoolSize", "200");
            scenario.setDataOverride(new DataOverride());
            scenario.setTableName("tableName");
            scenario.setRowCount(10);
            QuerySet querySet = new QuerySet();
            querySet.setExecutionType(ExecutionType.PARALLEL);
            querySet.setExecutionDurationInMs(10000L);
            scenario.getQuerySet().add(querySet);
            Query query = new Query();
            querySet.getQuery().add(query);
            querySet.setConcurrency("15");
            querySet.setNumberOfExecutions(20L);
            query.setStatement("select * from FHA");
            Scenario scenario2 = new Scenario();
            scenario2.setPhoenixProperties(new HashMap());
            scenario2.setDataOverride(new DataOverride());
            scenario2.setTableName("tableName2");
            scenario2.setRowCount(500);
            ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
            scenarios.add(scenario);
            scenarios.add(scenario2);
            data.setScenarios(scenarios);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataModel.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            jaxbMarshaller.marshal((Object)data, (OutputStream)System.out);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return data.toString();
    }
}

