/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.result.ResultUtil;
import org.apache.phoenix.pherf.schema.SchemaReader;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ResultBaseTestIT
extends BaseTest {
    protected static final String matcherScenario = ".*scenario/.*test.*xml";
    protected static final String matcherSchema = ".*datamodel/.*test.*sql";
    protected static PhoenixUtil util = PhoenixUtil.create((boolean)true);
    protected static Properties properties;
    protected static SchemaReader reader;
    protected static XMLConfigParser parser;
    protected static List<Path> resources;
    protected static ResultUtil resultUtil;

    protected static Configuration getTestClusterConfig() {
        return new Configuration(config);
    }

    @BeforeClass
    public static synchronized void setUp() throws Exception {
        PherfConstants constants = PherfConstants.create();
        properties = constants.getProperties("pherf.properties", false);
        String dir = properties.getProperty("pherf.default.results.dir");
        resultUtil.ensureBaseDirExists(dir);
        PhoenixUtil.setZookeeper((String)"localhost");
        reader = new SchemaReader(util, matcherSchema);
        parser = new XMLConfigParser(matcherScenario);
        ResultBaseTestIT.setUpTestDriver((ReadOnlyProps)ReadOnlyProps.EMPTY_PROPS);
    }

    @AfterClass
    public static synchronized void tearDown() throws Exception {
        ResultBaseTestIT.dropNonSystemTables();
        resultUtil.deleteDir(properties.getProperty("pherf.default.results.dir"));
    }

    @After
    public void cleanUpAfterTest() throws Exception {
        ResultBaseTestIT.deletePriorMetaData((long)Long.MAX_VALUE, (String)ResultBaseTestIT.getUrl());
    }

    static {
        resultUtil = new ResultUtil();
    }
}

