/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.configuration.Query;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.result.DataModelResult;
import org.apache.phoenix.pherf.result.ResultManager;
import org.apache.phoenix.pherf.result.RunTime;
import org.apache.phoenix.pherf.result.ThreadTime;
import org.apache.phoenix.pherf.rules.RulesApplier;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.WorkloadExecutor;
import org.apache.phoenix.pherf.workload.WriteWorkload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultiThreadedRunner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MultiThreadedRunner.class);
    private Query query;
    private ThreadTime threadTime;
    private PhoenixUtil pUtil = PhoenixUtil.create();
    private String threadName;
    private DataModelResult dataModelResult;
    private long numberOfExecutions;
    private long executionDurationInMs;
    private static long lastResultWritten = System.currentTimeMillis() - 1000L;
    private final ResultManager resultManager;
    private final RulesApplier ruleApplier;
    private final Scenario scenario;
    private final WorkloadExecutor workloadExecutor;
    private final XMLConfigParser parser;

    MultiThreadedRunner(String threadName, Query query, DataModelResult dataModelResult, ThreadTime threadTime, long numberOfExecutions, long executionDurationInMs, boolean writeRuntimeResults, RulesApplier ruleApplier, Scenario scenario, WorkloadExecutor workloadExecutor, XMLConfigParser parser) {
        this.query = query;
        this.threadName = threadName;
        this.threadTime = threadTime;
        this.dataModelResult = dataModelResult;
        this.numberOfExecutions = numberOfExecutions;
        this.executionDurationInMs = executionDurationInMs;
        this.ruleApplier = ruleApplier;
        this.scenario = scenario;
        this.resultManager = new ResultManager(dataModelResult.getName(), writeRuntimeResults);
        this.workloadExecutor = workloadExecutor;
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("\n\nThread Starting " + this.threadName + " ; " + this.query.getStatement() + " for " + this.numberOfExecutions + "times\n\n");
        Long start = System.currentTimeMillis();
        for (long i = this.numberOfExecutions; i > 0L && System.currentTimeMillis() - start < this.executionDurationInMs; --i) {
            try {
                ResultManager resultManager = this.resultManager;
                synchronized (resultManager) {
                    this.timedQuery();
                    if (System.currentTimeMillis() - lastResultWritten > 1000L) {
                        this.resultManager.write(this.dataModelResult, this.ruleApplier);
                        lastResultWritten = System.currentTimeMillis();
                    }
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.resultManager.flush();
        logger.info("\n\nThread exiting." + this.threadName + "\n\n");
    }

    private synchronized ThreadTime getThreadTime() {
        return this.threadTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timedQuery() throws Exception {
        boolean isSelectCountStatement = this.query.getStatement().toUpperCase().trim().contains("COUNT(");
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Long start = System.currentTimeMillis();
        Date startDate = Calendar.getInstance().getTime();
        String exception = null;
        long resultRowCount = 0L;
        try {
            boolean isQuery;
            conn = this.pUtil.getConnection(this.query.getTenantId(), this.scenario.getPhoenixProperties());
            conn.setAutoCommit(true);
            String statementString = this.query.getDynamicStatement(this.ruleApplier, this.scenario);
            statement = conn.prepareStatement(statementString);
            logger.info("Executing: " + statementString);
            if (this.scenario.getWriteParams() != null) {
                WriteWorkload writes = new WriteWorkload(PhoenixUtil.create(), this.parser, this.scenario, PherfConstants.GeneratePhoenixStats.NO);
                this.workloadExecutor.add(writes);
            }
            if (isQuery = statement.execute()) {
                rs = statement.getResultSet();
                while (rs.next()) {
                    if (null != this.query.getExpectedAggregateRowCount() && rs.getLong(1) != this.query.getExpectedAggregateRowCount().longValue()) {
                        throw new RuntimeException("Aggregate count " + rs.getLong(1) + " does not match expected " + this.query.getExpectedAggregateRowCount());
                    }
                    if (isSelectCountStatement) {
                        resultRowCount = rs.getLong(1);
                        continue;
                    }
                    ++resultRowCount;
                }
            } else {
                conn.commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            exception = e.getMessage();
        }
        finally {
            this.getThreadTime().getRunTimesInMs().add(new RunTime(exception, startDate, resultRowCount, (int)(System.currentTimeMillis() - start)));
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }
}

