/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.rules;

import javax.xml.bind.annotation.XmlAttribute;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;

public class DataValue {
    private DataTypeMapping type;
    private String value;
    private String maxValue;
    private String minValue;
    private int distribution;
    private boolean useCurrentDate;

    public DataValue() {
    }

    public DataValue(DataTypeMapping type, String value) {
        this.type = type;
        this.value = value;
        this.distribution = Integer.MIN_VALUE;
        this.useCurrentDate = false;
    }

    public DataValue(DataValue dataValue) {
        this(dataValue.getType(), dataValue.getValue());
        this.setDistribution(dataValue.getDistribution());
        this.setMinValue(dataValue.getMinValue());
        this.setMaxValue(dataValue.getMaxValue());
        this.setUseCurrentDate(dataValue.getUseCurrentDate());
    }

    public String getValue() {
        return this.value;
    }

    public DataTypeMapping getType() {
        return this.type;
    }

    public int getDistribution() {
        return this.distribution;
    }

    @XmlAttribute
    public void setDistribution(int distribution) {
        this.distribution = distribution;
    }

    public void setType(DataTypeMapping type) {
        this.type = type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public boolean getUseCurrentDate() {
        return this.useCurrentDate;
    }

    public void setUseCurrentDate(boolean useCurrentDate) {
        this.useCurrentDate = useCurrentDate;
    }
}

