/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.configuration.Query;
import org.apache.phoenix.pherf.configuration.QuerySet;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.rules.RulesApplier;
import org.apache.phoenix.schema.TableNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixUtil {
    private static final Logger logger = LoggerFactory.getLogger(PhoenixUtil.class);
    private static String zookeeper;
    private static int rowCountOverride;
    private boolean testEnabled;
    private static PhoenixUtil instance;
    private static boolean useThinDriver;
    private static String queryServerUrl;
    private static final String ASYNC_KEYWORD = "ASYNC";
    private static final int ONE_MIN_IN_MS = 60000;
    private static String CurrentSCN;

    private PhoenixUtil() {
        this(false);
    }

    private PhoenixUtil(boolean testEnabled) {
        this.testEnabled = testEnabled;
    }

    public static PhoenixUtil create() {
        return PhoenixUtil.create(false);
    }

    public static PhoenixUtil create(boolean testEnabled) {
        instance = instance != null ? instance : new PhoenixUtil(testEnabled);
        return instance;
    }

    public static void useThinDriver(String queryServerUrl) {
        useThinDriver = true;
        PhoenixUtil.queryServerUrl = Objects.requireNonNull(queryServerUrl);
    }

    public static String getQueryServerUrl() {
        return queryServerUrl;
    }

    public static boolean isThinDriver() {
        return useThinDriver;
    }

    public Connection getConnection() throws Exception {
        return this.getConnection(null);
    }

    public Connection getConnection(String tenantId) throws Exception {
        return this.getConnection(tenantId, this.testEnabled, null);
    }

    public Connection getConnection(String tenantId, Map<String, String> phoenixProperty) throws Exception {
        return this.getConnection(tenantId, this.testEnabled, phoenixProperty);
    }

    public Connection getConnection(String tenantId, boolean testEnabled, Map<String, String> phoenixProperty) throws Exception {
        if (useThinDriver) {
            if (null == queryServerUrl) {
                throw new IllegalArgumentException("QueryServer URL must be set before initializing connection");
            }
            Properties props = new Properties();
            if (null != tenantId) {
                props.setProperty("TenantId", tenantId);
                logger.debug("\nSetting tenantId to " + tenantId);
            }
            String url = "jdbc:phoenix:thin:url=" + queryServerUrl + ";serialization=PROTOBUF";
            return DriverManager.getConnection(url, props);
        }
        if (null == zookeeper) {
            throw new IllegalArgumentException("Zookeeper must be set before initializing connection!");
        }
        Properties props = new Properties();
        if (null != tenantId) {
            props.setProperty("TenantId", tenantId);
            logger.debug("\nSetting tenantId to " + tenantId);
        }
        if (phoenixProperty != null) {
            for (Map.Entry<String, String> phxProperty : phoenixProperty.entrySet()) {
                props.setProperty(phxProperty.getKey(), phxProperty.getValue());
                System.out.println("Setting connection property " + phxProperty.getKey() + " to " + phxProperty.getValue());
            }
        }
        String url = "jdbc:phoenix:" + zookeeper + (testEnabled ? ";test=true" : "");
        return DriverManager.getConnection(url, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeStatement(String sql, Scenario scenario) throws Exception {
        boolean result = false;
        try (Connection connection = null;){
            connection = this.getConnection(scenario.getTenantId());
            result = this.executeStatement(sql, connection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeStatementThrowException(String sql, Connection connection) throws SQLException {
        boolean result = false;
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = connection.prepareStatement(sql);
            result = preparedStatement.execute();
            connection.commit();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeStatement(String sql, Connection connection) throws SQLException {
        boolean result = false;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(sql);
            result = preparedStatement.execute();
            connection.commit();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean executeStatement(PreparedStatement preparedStatement, Connection connection) {
        boolean result = false;
        try {
            result = preparedStatement.execute();
            connection.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTables(String regexMatch) throws Exception {
        regexMatch = regexMatch.toUpperCase().replace("ALL", ".*");
        try (Connection conn = this.getConnection();){
            ResultSet resultSet = this.getTableMetaData("PHERF", null, conn);
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_SCHEM") == null ? resultSet.getString("TABLE_NAME") : resultSet.getString("TABLE_SCHEM") + "." + resultSet.getString("TABLE_NAME");
                if (!tableName.matches(regexMatch)) continue;
                logger.info("\nDropping " + tableName);
                try {
                    this.executeStatementThrowException("DROP TABLE " + tableName + " CASCADE", conn);
                }
                catch (TableNotFoundException tnf) {
                    logger.error("Table might be already be deleted via cascade. Schema: " + tnf.getSchemaName() + " Table: " + tnf.getTableName());
                }
            }
        }
    }

    public ResultSet getTableMetaData(String schemaName, String tableName, Connection connection) throws SQLException {
        DatabaseMetaData dbmd = connection.getMetaData();
        ResultSet resultSet = dbmd.getTables(null, schemaName, tableName, null);
        return resultSet;
    }

    public ResultSet getColumnsMetaData(String schemaName, String tableName, Connection connection) throws SQLException {
        DatabaseMetaData dbmd = connection.getMetaData();
        ResultSet resultSet = dbmd.getColumns(null, schemaName.toUpperCase(), tableName.toUpperCase(), null);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Column> getColumnsFromPhoenix(String schemaName, String tableName, Connection connection) throws SQLException {
        ArrayList<Column> columnList = new ArrayList<Column>();
        ResultSet resultSet = null;
        try {
            resultSet = this.getColumnsMetaData(schemaName, tableName, connection);
            while (resultSet.next()) {
                Column column = new Column();
                column.setName(resultSet.getString("COLUMN_NAME"));
                column.setType(DataTypeMapping.valueOf(resultSet.getString("TYPE_NAME").replace(" ", "_")));
                column.setLength(resultSet.getInt("COLUMN_SIZE"));
                columnList.add(column);
            }
        }
        finally {
            if (null != resultSet) {
                resultSet.close();
            }
        }
        return Collections.unmodifiableList(columnList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuerySetDdls(QuerySet querySet) throws Exception {
        for (Query query : querySet.getQuery()) {
            if (null == query.getDdl()) continue;
            Connection conn = null;
            try {
                logger.info("\nExecuting DDL:" + query.getDdl() + " on tenantId:" + query.getTenantId());
                conn = this.getConnection(query.getTenantId());
                this.executeStatement(query.getDdl(), conn);
            }
            finally {
                if (null == conn) continue;
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeScenarioDdl(Scenario scenario) throws Exception {
        if (null != scenario.getDdl()) {
            Connection conn = null;
            try {
                logger.info("\nExecuting DDL:" + scenario.getDdl() + " on tenantId:" + scenario.getTenantId());
                conn = this.getConnection(scenario.getTenantId());
                this.executeStatement(scenario.getDdl(), conn);
            }
            finally {
                if (null != conn) {
                    conn.close();
                }
            }
        }
    }

    public static String getZookeeper() {
        return zookeeper;
    }

    public static void setZookeeper(String zookeeper) {
        logger.info("Setting zookeeper: " + zookeeper);
        PhoenixUtil.useThickDriver(zookeeper);
    }

    public static void useThickDriver(String zookeeper) {
        useThinDriver = false;
        PhoenixUtil.zookeeper = Objects.requireNonNull(zookeeper);
    }

    public static int getRowCountOverride() {
        return rowCountOverride;
    }

    public static void setRowCountOverride(int rowCountOverride) {
        PhoenixUtil.rowCountOverride = rowCountOverride;
    }

    public void updatePhoenixStats(String tableName, Scenario scenario) throws Exception {
        logger.info("Updating stats for " + tableName);
        this.executeStatement("UPDATE STATISTICS " + tableName, scenario);
    }

    public String getExplainPlan(Query query) throws SQLException {
        return this.getExplainPlan(query, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExplainPlan(Query query, Scenario scenario, RulesApplier ruleApplier) throws SQLException {
        Connection conn = null;
        ResultSet rs = null;
        Statement statement = null;
        StringBuilder buf = new StringBuilder();
        try {
            conn = this.getConnection(query.getTenantId());
            String explainQuery = scenario != null && ruleApplier != null ? query.getDynamicStatement(ruleApplier, scenario) : query.getStatement();
            statement = conn.prepareStatement("EXPLAIN " + explainQuery);
            rs = statement.executeQuery();
            while (rs.next()) {
                buf.append(rs.getString(1).trim().replace(",", "-"));
            }
            statement.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        return buf.toString();
    }

    static {
        rowCountOverride = 0;
        CurrentSCN = null;
    }
}

