/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import junit.framework.Assert;
import org.apache.phoenix.pherf.util.RowCalculator;
import org.junit.Test;

public class RowCalculatorTest {
    @Test
    public void testRowsEvenDivide() throws Exception {
        int threadPoolSize = 10;
        int tableRowCount = 100;
        this.assertRowsSum(threadPoolSize, tableRowCount);
    }

    @Test
    public void testRowsNotEvenDivide() throws Exception {
        int threadPoolSize = 9;
        int tableRowCount = 100;
        this.assertRowsSum(threadPoolSize, tableRowCount);
    }

    @Test
    public void testRowsNotEvenDivideSmallRC() throws Exception {
        int threadPoolSize = 50;
        int tableRowCount = 21;
        this.assertRowsSum(threadPoolSize, tableRowCount);
    }

    @Test
    public void testRowsEqualToPool() throws Exception {
        int threadPoolSize = 50;
        int tableRowCount = 50;
        this.assertRowsSum(threadPoolSize, tableRowCount);
    }

    private void assertRowsSum(int threadPoolSize, int tableRowCount) {
        int sum = 0;
        RowCalculator rc = new RowCalculator(threadPoolSize, tableRowCount);
        Assert.assertEquals((String)"Rows generated did not match expected count! ", (int)threadPoolSize, (int)rc.size());
        for (int i = 0; i < threadPoolSize; ++i) {
            sum += rc.getNext();
        }
        Assert.assertEquals((String)"Rows did not sum up correctly", (int)tableRowCount, (int)sum);
        Assert.assertEquals((int)rc.size(), (int)0);
    }
}

