/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.util;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.result.file.ResultFileDetails;

public class GoogleChartGenerator {
    private String[] labels;
    private PherfConstants.CompareType compareType;
    private final Map<String, DataNode> datanodes = new TreeMap<String, DataNode>();
    private final PherfConstants constants = PherfConstants.create();
    private final String resultDir = this.constants.getProperty("pherf.default.results.dir");
    private final double threshold = Double.parseDouble(this.constants.getProperty("pherf.default.comparison.threshold"));

    public GoogleChartGenerator(String labels, PherfConstants.CompareType compareType) {
        this.setLabels(labels);
        this.setCompareType(compareType);
    }

    String[] getLabels() {
        return this.labels;
    }

    void setLabels(String[] labels) {
        this.labels = labels;
    }

    void setLabels(String labels) {
        this.labels = labels.split(",");
    }

    PherfConstants.CompareType getCompareType() {
        return this.compareType;
    }

    void setCompareType(PherfConstants.CompareType compareType) {
        this.compareType = compareType;
    }

    public void readAndRender() {
        try {
            for (String label : this.labels) {
                this.read(label);
            }
            this.renderAsGoogleChartsHTML();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void read(String label) throws Exception {
        String resultFileName = this.resultDir + "/" + "RESULT_" + label + (Object)((Object)ResultFileDetails.CSV_AGGREGATE_PERFORMANCE.getExtension());
        FileReader in = new FileReader(resultFileName);
        CSVParser parser = new CSVParser((Reader)in, CSVFormat.DEFAULT.withHeader(new String[0]));
        for (CSVRecord record : parser) {
            String group = record.get("QUERY_GROUP");
            String query = record.get("QUERY");
            String explain = record.get("EXPLAIN_PLAN");
            String tenantId = record.get("TENANT_ID");
            long avgTime = Long.parseLong(record.get("AVG_TIME_MS"));
            long minTime = Long.parseLong(record.get("AVG_MIN_TIME_MS"));
            long numRuns = Long.parseLong(record.get("RUN_COUNT"));
            long rowCount = Long.parseLong(record.get("RESULT_ROW_COUNT"));
            Node node = new Node(minTime, avgTime, numRuns, explain, query, tenantId, label, rowCount);
            if (this.datanodes.containsKey(group)) {
                this.datanodes.get(group).getDataSet().put(label, node);
                continue;
            }
            this.datanodes.put(group, new DataNode(label, node));
        }
        parser.close();
    }

    private boolean verifyWithinThreshold(double threshold) {
        long resetTimeToCompare;
        long timeToCompare = resetTimeToCompare = -1L;
        for (Map.Entry<String, DataNode> dn : this.datanodes.entrySet()) {
            for (Map.Entry<String, Node> node : dn.getValue().getDataSet().entrySet()) {
                if (timeToCompare == -1L && (timeToCompare = node.getValue().getTime(this.getCompareType())) < 10L) {
                    return true;
                }
                if (!((double)(timeToCompare - node.getValue().getTime(this.getCompareType())) / (double)node.getValue().getTime(this.getCompareType()) > threshold)) continue;
                return false;
            }
            timeToCompare = resetTimeToCompare;
        }
        return true;
    }

    private void renderAsGoogleChartsHTML() throws FileNotFoundException, UnsupportedEncodingException {
        String lastKeyPrefix = "";
        StringBuffer sb = new StringBuffer();
        for (String label : this.labels) {
            sb.append("dataTable.addColumn('number', '" + label + "');\n");
            sb.append("dataTable.addColumn({type: 'string', role: 'tooltip', 'p': {'html': true}});\n");
        }
        sb.append("dataTable.addRows([\n");
        for (Map.Entry<String, DataNode> dn : this.datanodes.entrySet()) {
            String currentKeyPrefix = dn.getKey().substring(0, dn.getKey().indexOf(124));
            if (!lastKeyPrefix.equalsIgnoreCase(currentKeyPrefix) && lastKeyPrefix != "") {
                sb.append(this.getBlankRow());
            }
            lastKeyPrefix = currentKeyPrefix;
            sb.append("['" + dn.getKey() + "'");
            for (Map.Entry<String, Node> nodeSet : dn.getValue().getDataSet().entrySet()) {
                sb.append(", " + nodeSet.getValue().getTime(this.getCompareType()));
                sb.append(",'" + this.getToolTipAsHTML(dn.getValue().getDataSet()) + "'");
            }
            sb.append("],\n");
        }
        String summaryFile = PherfConstants.create().getProperty("pherf.default.summary.file");
        String title = this.labels[0];
        PrintWriter writer = new PrintWriter(summaryFile, "UTF-8");
        writer.println(StaticGoogleChartsRenderingData.HEADER.replace("[title]", title));
        writer.println(sb.substring(0, sb.length() - 2) + "\n]);");
        String thresholdString = Math.round(this.threshold * 100.0) + "%";
        String footer = StaticGoogleChartsRenderingData.FOOTER.replace("[summary]", (this.verifyWithinThreshold(this.threshold) ? "<font color=green>PASSED | Results are within " : "<font color=red>FAILED | Results are outside ") + "set threshold of " + thresholdString + "</font><br>" + new SimpleDateFormat("yyyy/MM/dd ha z").format(new Date()));
        footer = footer.replace("[title]", title);
        writer.println(footer);
        writer.close();
    }

    private String getBlankRow() {
        String ret = "['" + new String(new char[60]).replace("\u0000", ".") + "'";
        for (int i = 0; i < this.labels.length; ++i) {
            ret = ret + ",0,''";
        }
        ret = ret + "],";
        return ret;
    }

    private String getToolTipAsHTML(Map<String, Node> nodeDataSet) {
        String ret = "<table width=1000 cellpadding=1 cellspacing=0 border=0 bgcolor=#F4F4F4><tr>";
        for (Map.Entry<String, Node> nodeSet : nodeDataSet.entrySet()) {
            ret = ret + "<td>" + this.getToolText(nodeSet.getValue()) + "</td>";
        }
        return ret + "</tr></table>";
    }

    private String getToolText(Node node) {
        return node.getLabelAsHTML() + node.getAvgTimeAsHTML() + node.getMinTimeAsHTML() + node.getNumRunsAsHTML() + node.getRowCountAsHTML() + node.getExplainPlanAsHTML() + node.getQueryAsHTML();
    }

    static class StaticGoogleChartsRenderingData {
        public static String HEADER = "<html><head><title>[title]</title><script type='text/javascript' src='https://www.google.com/jsapi'></script><script type='text/javascript'>google.load('visualization', '1', {packages: ['corechart', 'bar']});google.setOnLoadCallback(drawMaterial);function drawMaterial() {var dataTable = new google.visualization.DataTable();dataTable.addColumn('string', 'Query');";
        public static String FOOTER = "var options = {title: '',titleTextStyle: {color: 'gray', fontName: 'Raleway', fontSize: '24'},hAxis: {title: 'Minimum query time for all runs in milli-seconds (ms) | Scaled logrithmic | Hover to see details',titleTextStyle: {italic: false,fontName: 'arial', fontSize: '12'},logScale: true,minValue: 0,textStyle: { fontName: 'arial', fontSize: '14'},},vAxis: {textStyle: {fontName: 'arial', fontSize: '12', fontWidth: 'normal', paddingRight: '100',marginRight: '100'}},chartArea: {left:300, width: 500, right: 400, top: 50, height: 700},legend:{textStyle:{fontSize:'13', fontName:'arial'}},tooltip: {isHtml: true},width: 1200,height: 800,bars:'horizontal',bar: { groupWidth: '75%' },colors: ['#E1A5A9', '#A9A5BC', '#A9A5E1']};var material = new google.visualization.BarChart(document.getElementById('chart_div'));material.draw(dataTable, options);}</script></head><body><b><font face=raleway size=5>PHERFED [title]</font><br><font face=raleway size=4>[summary]</font></b><div id='chart_div' style='margin:0px;padding:0px;'></div></body></html>";

        StaticGoogleChartsRenderingData() {
        }
    }

    class Node {
        private String explainPlan;
        private String query;
        private String tenantId;
        private long minTime;
        private long avgTime;
        private long numRuns;
        private long rowCount;
        private String label;
        private DecimalFormat df = new DecimalFormat("#.#");

        public Node(long minTime, long avgTime, long numRuns, String explainPlan, String query, String tenantId, String label, long rowCount) {
            this.setMinTime(minTime);
            this.setAvgTime(avgTime);
            this.setNumRuns(numRuns);
            this.setExplainPlan(explainPlan);
            this.setQuery(query);
            this.setTenantId(tenantId);
            this.setLabel(label);
            this.setRowCount(rowCount);
        }

        String getExplainPlan() {
            return this.explainPlan;
        }

        String getExplainPlanAsHTML() {
            return "</br><font face=arial size=1><b>EXPLAIN PLAN </b>" + this.explainPlan.replace("'", "") + "</font><br>";
        }

        void setExplainPlan(String explainPlan) {
            this.explainPlan = explainPlan;
        }

        long getTime(PherfConstants.CompareType compareType) {
            return compareType == PherfConstants.CompareType.AVERAGE ? this.getAvgTime() : this.getMinTime();
        }

        long getMinTime() {
            if (this.minTime <= 2L) {
                return 2L;
            }
            return this.minTime;
        }

        public String getMinTimeAsHTML() {
            return "<font face=arial size=1><b>MIN TIME </b></font><font face=arial size=3>" + this.minTime + " ms (" + this.df.format((double)this.minTime / 1000.0) + " sec)</font><br>";
        }

        void setMinTime(long minTime) {
            this.minTime = minTime;
        }

        long getAvgTime() {
            return this.avgTime;
        }

        public String getAvgTimeAsHTML() {
            return "<font face=arial size=1><b>AVERAGE TIME </b></font><font face=arial size=3>" + this.avgTime + " ms (" + this.df.format((double)this.avgTime / 1000.0) + " sec)</font><br>";
        }

        void setAvgTime(long avgTime) {
            this.avgTime = avgTime;
        }

        public long getNumRuns() {
            return this.numRuns;
        }

        public String getNumRunsAsHTML() {
            return "<font face=arial size=1><b>NUMBER OF RUNS </b></font><font face=arial size=3>" + this.numRuns + "</font><br>";
        }

        public void setNumRuns(long numRuns) {
            this.numRuns = numRuns;
        }

        public String getQuery() {
            return this.query;
        }

        public String getQueryAsHTML() {
            return "<br><font face=arial size=1><b>QUERY </b>" + this.query.replace("'", "") + " (TENANT ID: " + this.getTenantId() + ")</font><br>";
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getLabel() {
            return this.label;
        }

        public String getLabelAsHTML() {
            return "<font face=arial size=4 color=#666699>" + this.label + "</font><br>";
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public long getRowCount() {
            return this.rowCount;
        }

        public String getRowCountAsHTML() {
            return "<font face=arial size=1><b>RESULT ROW COUNT </b></font><font face=arial size=3>" + this.rowCount + "</font><br>";
        }

        public void setRowCount(long rowCount) {
            this.rowCount = rowCount;
        }
    }

    class DataNode {
        private Map<String, Node> dataSet = new LinkedHashMap<String, Node>();

        public DataNode(String label, Node node) {
            this.getDataSet().put(label, node);
        }

        public Map<String, Node> getDataSet() {
            return this.dataSet;
        }

        public void setDataSet(Map<String, Node> dataSet) {
            this.dataSet = dataSet;
        }
    }
}

