/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.result;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.phoenix.pherf.configuration.Query;
import org.apache.phoenix.pherf.result.ResultUtil;
import org.apache.phoenix.pherf.result.ResultValue;
import org.apache.phoenix.pherf.result.ThreadTime;
import org.apache.phoenix.pherf.result.file.ResultFileDetails;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.util.DateUtil;

public class QueryResult
extends Query {
    private List<ThreadTime> threadTimes = new ArrayList<ThreadTime>();
    private static PhoenixUtil pUtil = PhoenixUtil.create();

    public QueryResult() {
    }

    public synchronized List<ThreadTime> getThreadTimes() {
        return this.threadTimes;
    }

    public synchronized void setThreadTimes(List<ThreadTime> threadTimes) {
        this.threadTimes = threadTimes;
    }

    public QueryResult(Query query) {
        this.setStatement(query.getStatement());
        this.setExpectedAggregateRowCount(query.getExpectedAggregateRowCount());
        this.setTenantId(query.getTenantId());
        this.setDdl(query.getDdl());
        this.setQueryGroup(query.getQueryGroup());
        this.setId(query.getId());
    }

    public Date getStartTime() {
        Date startTime = null;
        for (ThreadTime tt : this.getThreadTimes()) {
            Date currStartTime = tt.getStartTime();
            if (null == currStartTime) continue;
            if (null == startTime) {
                startTime = currStartTime;
                continue;
            }
            if (currStartTime.compareTo(startTime) >= 0) continue;
            startTime = currStartTime;
        }
        return startTime;
    }

    public int getAvgMaxRunTimeInMs() {
        int totalRunTime = 0;
        for (ThreadTime tt : this.getThreadTimes()) {
            if (null == tt.getMaxTimeInMs()) continue;
            totalRunTime += tt.getMaxTimeInMs().getElapsedDurationInMs().intValue();
        }
        return totalRunTime / this.getThreadTimes().size();
    }

    public int getAvgMinRunTimeInMs() {
        int totalRunTime = 0;
        for (ThreadTime tt : this.getThreadTimes()) {
            if (null == tt.getMinTimeInMs()) continue;
            totalRunTime += tt.getMinTimeInMs().getElapsedDurationInMs().intValue();
        }
        return totalRunTime / this.getThreadTimes().size();
    }

    public int getAvgRunTimeInMs() {
        int totalRunTime = 0;
        for (ThreadTime tt : this.getThreadTimes()) {
            if (null == tt.getAvgTimeInMs()) continue;
            totalRunTime += tt.getAvgTimeInMs().intValue();
        }
        return totalRunTime / this.getThreadTimes().size();
    }

    public List<ResultValue> getCsvRepresentation(ResultUtil util) {
        ArrayList<ResultValue> rowValues = new ArrayList<ResultValue>();
        rowValues.add(new ResultValue<String>(util.convertNull(this.getStartTimeText())));
        rowValues.add(new ResultValue<String>(util.convertNull(this.getQueryGroup())));
        rowValues.add(new ResultValue<String>(util.convertNull(this.getStatement())));
        rowValues.add(new ResultValue<String>(util.convertNull(this.getTenantId())));
        rowValues.add(new ResultValue<String>(util.convertNull(String.valueOf(this.getAvgMaxRunTimeInMs()))));
        rowValues.add(new ResultValue<String>(util.convertNull(String.valueOf(this.getAvgRunTimeInMs()))));
        rowValues.add(new ResultValue<String>(util.convertNull(String.valueOf(this.getAvgMinRunTimeInMs()))));
        rowValues.add(new ResultValue<String>(util.convertNull(String.valueOf(this.getRunCount()))));
        rowValues.add(new ResultValue<String>(util.convertNull(String.valueOf(this.getExplainPlan()))));
        rowValues.add(new ResultValue<String>(util.convertNull(String.valueOf(this.getResultRowCount()))));
        return rowValues;
    }

    private String getExplainPlan() {
        try {
            return pUtil.getExplainPlan(this);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private long getResultRowCount() {
        long resultRowCount = -1L;
        for (ThreadTime tt : this.getThreadTimes()) {
            for (int i = 0; i < tt.getRunTimesInMs().size(); ++i) {
                if (resultRowCount == -1L) {
                    resultRowCount = tt.getRunTimesInMs().get(i).getResultRowCount();
                    continue;
                }
                if (resultRowCount == tt.getRunTimesInMs().get(i).getResultRowCount()) continue;
                return -1L;
            }
        }
        return resultRowCount;
    }

    public List<List<ResultValue>> getCsvDetailedRepresentation(ResultUtil util, ResultFileDetails details) {
        ArrayList<List<ResultValue>> rows = new ArrayList<List<ResultValue>>();
        for (ThreadTime tt : this.getThreadTimes()) {
            for (List<ResultValue> runTime : details.isPerformance() ? tt.getCsvPerformanceRepresentation(util) : tt.getCsvFunctionalRepresentation(util)) {
                ArrayList<ResultValue> rowValues = new ArrayList<ResultValue>();
                rowValues.add(new ResultValue<String>(util.convertNull(this.getStartTimeText())));
                rowValues.add(new ResultValue<String>(util.convertNull(this.getQueryGroup())));
                rowValues.add(new ResultValue<String>(util.convertNull(this.getStatement())));
                rowValues.add(new ResultValue<String>(util.convertNull(this.getTenantId())));
                rowValues.addAll(runTime);
                rows.add(rowValues);
            }
        }
        return rows;
    }

    private int getRunCount() {
        int totalRunCount = 0;
        for (ThreadTime tt : this.getThreadTimes()) {
            totalRunCount += tt.getRunCount();
        }
        return totalRunCount;
    }

    private String getStartTimeText() {
        return null == this.getStartTime() ? "" : DateUtil.DEFAULT_MS_DATE_FORMATTER.format(this.getStartTime());
    }
}

