/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.configuration;

import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.exception.FileLoaderException;
import org.apache.phoenix.pherf.util.ResourceList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(XMLConfigParser.class);
    private String filePattern;
    private List<DataModel> dataModels;
    private List<Scenario> scenarios = null;
    private ResourceList resourceList;
    private Collection<Path> paths = null;

    public XMLConfigParser(String pattern) throws Exception {
        this.init(pattern);
    }

    public List<DataModel> getDataModels() {
        return this.dataModels;
    }

    public DataModel getDataModelByName(String name) {
        for (DataModel dataModel : this.getDataModels()) {
            if (!dataModel.getName().equals(name)) continue;
            return dataModel;
        }
        return null;
    }

    public Scenario getScenarioByName(String name) throws Exception {
        for (Scenario scenario : this.getScenarios()) {
            if (!scenario.getName().equals(name)) continue;
            return scenario;
        }
        return null;
    }

    public synchronized Collection<Path> getPaths(String strPattern) throws Exception {
        if (this.paths != null) {
            return this.paths;
        }
        this.paths = this.getResources(strPattern);
        return this.paths;
    }

    public synchronized List<Scenario> getScenarios() throws Exception {
        if (this.scenarios != null) {
            return this.scenarios;
        }
        this.scenarios = Collections.synchronizedList(new ArrayList());
        for (Path path : this.getPaths(this.getFilePattern())) {
            try {
                List<Scenario> scenarioList = XMLConfigParser.readDataModel(path).getScenarios();
                for (Scenario scenario : scenarioList) {
                    this.scenarios.add(scenario);
                }
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
        return this.scenarios;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public static DataModel readDataModel(Path file) throws JAXBException, XMLStreamException {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataModel.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        String fName = "/scenario/" + file.getFileName().toString();
        logger.info("Open config file: " + fName);
        XMLStreamReader xmlReader = xif.createXMLStreamReader(new StreamSource(XMLConfigParser.class.getResourceAsStream(fName)));
        return (DataModel)jaxbUnmarshaller.unmarshal(xmlReader);
    }

    public static String parseSchemaName(String fullTableName) {
        String ret = null;
        if (fullTableName.contains(".")) {
            ret = fullTableName.substring(0, fullTableName.indexOf("."));
        }
        return ret;
    }

    public static String parseTableName(String fullTableName) {
        String ret = fullTableName;
        if (fullTableName.contains(".")) {
            ret = fullTableName.substring(fullTableName.indexOf(".") + 1, fullTableName.length());
        }
        ret = ret.replaceAll("\"", "");
        return ret;
    }

    public static void writeDataModel(DataModel data, OutputStream output) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataModel.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        jaxbMarshaller.marshal((Object)data, output);
    }

    private void init(String pattern) throws Exception {
        if (this.dataModels != null) {
            return;
        }
        this.filePattern = pattern;
        this.dataModels = new ArrayList<DataModel>();
        this.resourceList = new ResourceList("/scenario");
        this.paths = this.getResources(this.filePattern);
        if (this.paths.isEmpty()) {
            throw new FileLoaderException("Could not load the resource files using the pattern: " + pattern);
        }
        for (Path path : this.paths) {
            System.out.println("Adding model for path:" + path.toString());
            this.dataModels.add(XMLConfigParser.readDataModel(path));
        }
    }

    private Collection<Path> getResources(String pattern) throws Exception {
        return this.resourceList.getResourceList(pattern);
    }
}

