/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.result.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.phoenix.pherf.result.Result;
import org.apache.phoenix.pherf.result.ResultValue;
import org.apache.phoenix.pherf.result.impl.CSVResultHandler;

public class CSVFileResultHandler
extends CSVResultHandler {
    @Override
    public synchronized void write(Result result) throws IOException {
        this.util.ensureBaseResultDirExists();
        this.open(result.getHeader());
        super.write(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<Result> read() throws IOException {
        this.util.ensureBaseResultDirExists();
        try (CSVParser parser = null;){
            File file = new File(this.resultFileName);
            parser = CSVParser.parse((File)file, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.DEFAULT);
            List records = parser.getRecords();
            ArrayList<Result> results = new ArrayList<Result>();
            String header = null;
            for (CSVRecord record : records) {
                if (record.getRecordNumber() == 1L) {
                    header = record.toString();
                    continue;
                }
                ArrayList<ResultValue> resultValues = new ArrayList<ResultValue>();
                for (String val : record.toString().split(",")) {
                    resultValues.add(new ResultValue<String>(val));
                }
                Result result = new Result(this.resultFileDetails, header, resultValues);
                results.add(result);
            }
            ArrayList<Result> arrayList = results;
            return arrayList;
        }
    }

    @Override
    protected void open(String header) throws IOException {
        if (this.csvPrinter != null) {
            return;
        }
        this.csvPrinter = new CSVPrinter((Appendable)new PrintWriter(this.resultFileName), CSVFormat.DEFAULT);
        Object[] records = header.split(",");
        this.csvPrinter.printRecord(records);
        this.isClosed = false;
    }
}

