/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compat.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;

public class CompatPermissionUtil {
    private CompatPermissionUtil() {
    }

    public static AccessChecker newAccessChecker(Configuration conf, ZKWatcher zk) {
        return new AccessChecker(conf, zk);
    }

    public static void stopAccessChecker(AccessChecker accessChecker) throws IOException {
        if (accessChecker.getAuthManager() != null) {
            TableAuthManager.release((TableAuthManager)accessChecker.getAuthManager());
        }
    }

    public static String getUserFromUP(UserPermission userPermission) {
        return Bytes.toString((byte[])userPermission.getUser());
    }

    public static Permission getPermissionFromUP(UserPermission userPermission) {
        return userPermission;
    }

    public static boolean authorizeUserTable(AccessChecker accessChecker, User user, TableName table, Permission.Action action) {
        if (accessChecker.getAuthManager().userHasAccess(user, table, action)) {
            return true;
        }
        String[] groupNames = user.getGroupNames();
        if (groupNames != null) {
            for (String group : groupNames) {
                if (!accessChecker.getAuthManager().groupHasAccess(group, table, action)) continue;
                return true;
            }
        }
        return false;
    }
}

