// auto-generated by sbt-boilerplate
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * license agreements; and to You under the Apache License, version 2.0:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * This file is part of the Apache Pekko project, which was derived from Akka.
 */

/*
 * Copyright (C) 2014-2022 Lightbend Inc. <https://www.lightbend.com>
 */

package org.apache.pekko.stream.scaladsl

import org.apache.pekko.stream._
import org.apache.pekko.stream.impl.ContextPropagation
import org.apache.pekko.stream.stage.{ GraphStage, GraphStageLogic, InHandler, OutHandler }

trait ZipLatestWithApply {

  /**
   * Create a new `ZipLatestWith` specialized for 2 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, O](zipper: (A1, A2) => O): ZipLatestWith2[A1, A2, O] =
    new ZipLatestWith2(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 3 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, O](zipper: (A1, A2, A3) => O): ZipLatestWith3[A1, A2, A3, O] =
    new ZipLatestWith3(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 4 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, O](zipper: (A1, A2, A3, A4) => O): ZipLatestWith4[A1, A2, A3, A4, O] =
    new ZipLatestWith4(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 5 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, O](zipper: (A1, A2, A3, A4, A5) => O): ZipLatestWith5[A1, A2, A3, A4, A5, O] =
    new ZipLatestWith5(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 6 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, O](zipper: (A1, A2, A3, A4, A5, A6) => O): ZipLatestWith6[A1, A2, A3, A4, A5, A6, O] =
    new ZipLatestWith6(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 7 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, O](zipper: (A1, A2, A3, A4, A5, A6, A7) => O): ZipLatestWith7[A1, A2, A3, A4, A5, A6, A7, O] =
    new ZipLatestWith7(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 8 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8) => O): ZipLatestWith8[A1, A2, A3, A4, A5, A6, A7, A8, O] =
    new ZipLatestWith8(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 9 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9) => O): ZipLatestWith9[A1, A2, A3, A4, A5, A6, A7, A8, A9, O] =
    new ZipLatestWith9(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 10 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) => O): ZipLatestWith10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, O] =
    new ZipLatestWith10(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 11 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) => O): ZipLatestWith11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, O] =
    new ZipLatestWith11(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 12 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) => O): ZipLatestWith12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, O] =
    new ZipLatestWith12(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 13 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) => O): ZipLatestWith13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, O] =
    new ZipLatestWith13(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 14 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) => O): ZipLatestWith14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, O] =
    new ZipLatestWith14(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 15 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) => O): ZipLatestWith15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, O] =
    new ZipLatestWith15(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 16 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) => O): ZipLatestWith16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, O] =
    new ZipLatestWith16(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 17 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) => O): ZipLatestWith17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, O] =
    new ZipLatestWith17(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 18 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) => O): ZipLatestWith18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, O] =
    new ZipLatestWith18(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 19 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19) => O): ZipLatestWith19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, O] =
    new ZipLatestWith19(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 20 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20) => O): ZipLatestWith20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, O] =
    new ZipLatestWith20(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 21 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21) => O): ZipLatestWith21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, O] =
    new ZipLatestWith21(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 22 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22) => O): ZipLatestWith22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, O] =
    new ZipLatestWith22(zipper, true)
  

  /**
   * Create a new `ZipLatestWith` specialized for 2 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, O](zipper: (A1, A2) => O, eagerComplete: Boolean): ZipLatestWith2[A1, A2, O] =
    new ZipLatestWith2(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 3 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, O](zipper: (A1, A2, A3) => O, eagerComplete: Boolean): ZipLatestWith3[A1, A2, A3, O] =
    new ZipLatestWith3(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 4 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, O](zipper: (A1, A2, A3, A4) => O, eagerComplete: Boolean): ZipLatestWith4[A1, A2, A3, A4, O] =
    new ZipLatestWith4(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 5 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, O](zipper: (A1, A2, A3, A4, A5) => O, eagerComplete: Boolean): ZipLatestWith5[A1, A2, A3, A4, A5, O] =
    new ZipLatestWith5(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 6 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, O](zipper: (A1, A2, A3, A4, A5, A6) => O, eagerComplete: Boolean): ZipLatestWith6[A1, A2, A3, A4, A5, A6, O] =
    new ZipLatestWith6(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 7 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, O](zipper: (A1, A2, A3, A4, A5, A6, A7) => O, eagerComplete: Boolean): ZipLatestWith7[A1, A2, A3, A4, A5, A6, A7, O] =
    new ZipLatestWith7(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 8 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8) => O, eagerComplete: Boolean): ZipLatestWith8[A1, A2, A3, A4, A5, A6, A7, A8, O] =
    new ZipLatestWith8(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 9 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9) => O, eagerComplete: Boolean): ZipLatestWith9[A1, A2, A3, A4, A5, A6, A7, A8, A9, O] =
    new ZipLatestWith9(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 10 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) => O, eagerComplete: Boolean): ZipLatestWith10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, O] =
    new ZipLatestWith10(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 11 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) => O, eagerComplete: Boolean): ZipLatestWith11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, O] =
    new ZipLatestWith11(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 12 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) => O, eagerComplete: Boolean): ZipLatestWith12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, O] =
    new ZipLatestWith12(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 13 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) => O, eagerComplete: Boolean): ZipLatestWith13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, O] =
    new ZipLatestWith13(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 14 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) => O, eagerComplete: Boolean): ZipLatestWith14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, O] =
    new ZipLatestWith14(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 15 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) => O, eagerComplete: Boolean): ZipLatestWith15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, O] =
    new ZipLatestWith15(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 16 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) => O, eagerComplete: Boolean): ZipLatestWith16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, O] =
    new ZipLatestWith16(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 17 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) => O, eagerComplete: Boolean): ZipLatestWith17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, O] =
    new ZipLatestWith17(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 18 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) => O, eagerComplete: Boolean): ZipLatestWith18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, O] =
    new ZipLatestWith18(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 19 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19) => O, eagerComplete: Boolean): ZipLatestWith19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, O] =
    new ZipLatestWith19(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 20 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20) => O, eagerComplete: Boolean): ZipLatestWith20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, O] =
    new ZipLatestWith20(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 21 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21) => O, eagerComplete: Boolean): ZipLatestWith21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, O] =
    new ZipLatestWith21(zipper, eagerComplete)
  

  /**
   * Create a new `ZipLatestWith` specialized for 22 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22) => O, eagerComplete: Boolean): ZipLatestWith22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, O] =
    new ZipLatestWith22(zipper, eagerComplete)
  

}

/** `ZipLatestWith` specialized for 2 inputs */
class ZipLatestWith2[A1, A2, O] (val zipper: (A1, A2) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape2[A1, A2, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith2")
  override val shape: FanInShape2[A1, A2, O] = new FanInShape2[A1, A2, O]("ZipLatestWith2")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1

  def this(zipper: (A1, A2) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 2
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith2"
}

/** `ZipLatestWith` specialized for 3 inputs */
class ZipLatestWith3[A1, A2, A3, O] (val zipper: (A1, A2, A3) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape3[A1, A2, A3, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith3")
  override val shape: FanInShape3[A1, A2, A3, O] = new FanInShape3[A1, A2, A3, O]("ZipLatestWith3")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2

  def this(zipper: (A1, A2, A3) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 3
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith3"
}

/** `ZipLatestWith` specialized for 4 inputs */
class ZipLatestWith4[A1, A2, A3, A4, O] (val zipper: (A1, A2, A3, A4) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape4[A1, A2, A3, A4, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith4")
  override val shape: FanInShape4[A1, A2, A3, A4, O] = new FanInShape4[A1, A2, A3, A4, O]("ZipLatestWith4")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3

  def this(zipper: (A1, A2, A3, A4) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 4
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith4"
}

/** `ZipLatestWith` specialized for 5 inputs */
class ZipLatestWith5[A1, A2, A3, A4, A5, O] (val zipper: (A1, A2, A3, A4, A5) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape5[A1, A2, A3, A4, A5, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith5")
  override val shape: FanInShape5[A1, A2, A3, A4, A5, O] = new FanInShape5[A1, A2, A3, A4, A5, O]("ZipLatestWith5")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4

  def this(zipper: (A1, A2, A3, A4, A5) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 5
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith5"
}

/** `ZipLatestWith` specialized for 6 inputs */
class ZipLatestWith6[A1, A2, A3, A4, A5, A6, O] (val zipper: (A1, A2, A3, A4, A5, A6) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape6[A1, A2, A3, A4, A5, A6, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith6")
  override val shape: FanInShape6[A1, A2, A3, A4, A5, A6, O] = new FanInShape6[A1, A2, A3, A4, A5, A6, O]("ZipLatestWith6")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5

  def this(zipper: (A1, A2, A3, A4, A5, A6) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 6
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith6"
}

/** `ZipLatestWith` specialized for 7 inputs */
class ZipLatestWith7[A1, A2, A3, A4, A5, A6, A7, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape7[A1, A2, A3, A4, A5, A6, A7, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith7")
  override val shape: FanInShape7[A1, A2, A3, A4, A5, A6, A7, O] = new FanInShape7[A1, A2, A3, A4, A5, A6, A7, O]("ZipLatestWith7")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 7
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith7"
}

/** `ZipLatestWith` specialized for 8 inputs */
class ZipLatestWith8[A1, A2, A3, A4, A5, A6, A7, A8, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape8[A1, A2, A3, A4, A5, A6, A7, A8, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith8")
  override val shape: FanInShape8[A1, A2, A3, A4, A5, A6, A7, A8, O] = new FanInShape8[A1, A2, A3, A4, A5, A6, A7, A8, O]("ZipLatestWith8")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 8
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith8"
}

/** `ZipLatestWith` specialized for 9 inputs */
class ZipLatestWith9[A1, A2, A3, A4, A5, A6, A7, A8, A9, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape9[A1, A2, A3, A4, A5, A6, A7, A8, A9, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith9")
  override val shape: FanInShape9[A1, A2, A3, A4, A5, A6, A7, A8, A9, O] = new FanInShape9[A1, A2, A3, A4, A5, A6, A7, A8, A9, O]("ZipLatestWith9")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 9
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private val inlet8 = new ZipLatestInlet(in8)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)
      setHandler(in8, inlet8)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue&&inlet8.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value, inlet8.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
        if (!hasBeenPulled(in8)) {
          tryPull(in8)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith9"
}

/** `ZipLatestWith` specialized for 10 inputs */
class ZipLatestWith10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith10")
  override val shape: FanInShape10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, O] = new FanInShape10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, O]("ZipLatestWith10")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 10
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private val inlet8 = new ZipLatestInlet(in8)
      private val inlet9 = new ZipLatestInlet(in9)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)
      setHandler(in8, inlet8)
      setHandler(in9, inlet9)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue&&inlet8.hasValue&&inlet9.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value, inlet8.value, inlet9.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
        if (!hasBeenPulled(in8)) {
          tryPull(in8)
        }
        if (!hasBeenPulled(in9)) {
          tryPull(in9)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith10"
}

/** `ZipLatestWith` specialized for 11 inputs */
class ZipLatestWith11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith11")
  override val shape: FanInShape11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, O] = new FanInShape11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, O]("ZipLatestWith11")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 11
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private val inlet8 = new ZipLatestInlet(in8)
      private val inlet9 = new ZipLatestInlet(in9)
      private val inlet10 = new ZipLatestInlet(in10)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)
      setHandler(in8, inlet8)
      setHandler(in9, inlet9)
      setHandler(in10, inlet10)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue&&inlet8.hasValue&&inlet9.hasValue&&inlet10.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value, inlet8.value, inlet9.value, inlet10.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
        if (!hasBeenPulled(in8)) {
          tryPull(in8)
        }
        if (!hasBeenPulled(in9)) {
          tryPull(in9)
        }
        if (!hasBeenPulled(in10)) {
          tryPull(in10)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith11"
}

/** `ZipLatestWith` specialized for 12 inputs */
class ZipLatestWith12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith12")
  override val shape: FanInShape12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, O] = new FanInShape12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, O]("ZipLatestWith12")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 12
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private val inlet8 = new ZipLatestInlet(in8)
      private val inlet9 = new ZipLatestInlet(in9)
      private val inlet10 = new ZipLatestInlet(in10)
      private val inlet11 = new ZipLatestInlet(in11)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)
      setHandler(in8, inlet8)
      setHandler(in9, inlet9)
      setHandler(in10, inlet10)
      setHandler(in11, inlet11)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue&&inlet8.hasValue&&inlet9.hasValue&&inlet10.hasValue&&inlet11.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value, inlet8.value, inlet9.value, inlet10.value, inlet11.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
        if (!hasBeenPulled(in8)) {
          tryPull(in8)
        }
        if (!hasBeenPulled(in9)) {
          tryPull(in9)
        }
        if (!hasBeenPulled(in10)) {
          tryPull(in10)
        }
        if (!hasBeenPulled(in11)) {
          tryPull(in11)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith12"
}

/** `ZipLatestWith` specialized for 13 inputs */
class ZipLatestWith13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith13")
  override val shape: FanInShape13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, O] = new FanInShape13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, O]("ZipLatestWith13")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 13
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private val inlet8 = new ZipLatestInlet(in8)
      private val inlet9 = new ZipLatestInlet(in9)
      private val inlet10 = new ZipLatestInlet(in10)
      private val inlet11 = new ZipLatestInlet(in11)
      private val inlet12 = new ZipLatestInlet(in12)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)
      setHandler(in8, inlet8)
      setHandler(in9, inlet9)
      setHandler(in10, inlet10)
      setHandler(in11, inlet11)
      setHandler(in12, inlet12)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue&&inlet8.hasValue&&inlet9.hasValue&&inlet10.hasValue&&inlet11.hasValue&&inlet12.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value, inlet8.value, inlet9.value, inlet10.value, inlet11.value, inlet12.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
        if (!hasBeenPulled(in8)) {
          tryPull(in8)
        }
        if (!hasBeenPulled(in9)) {
          tryPull(in9)
        }
        if (!hasBeenPulled(in10)) {
          tryPull(in10)
        }
        if (!hasBeenPulled(in11)) {
          tryPull(in11)
        }
        if (!hasBeenPulled(in12)) {
          tryPull(in12)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith13"
}

/** `ZipLatestWith` specialized for 14 inputs */
class ZipLatestWith14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith14")
  override val shape: FanInShape14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, O] = new FanInShape14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, O]("ZipLatestWith14")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 14
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private val inlet8 = new ZipLatestInlet(in8)
      private val inlet9 = new ZipLatestInlet(in9)
      private val inlet10 = new ZipLatestInlet(in10)
      private val inlet11 = new ZipLatestInlet(in11)
      private val inlet12 = new ZipLatestInlet(in12)
      private val inlet13 = new ZipLatestInlet(in13)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)
      setHandler(in8, inlet8)
      setHandler(in9, inlet9)
      setHandler(in10, inlet10)
      setHandler(in11, inlet11)
      setHandler(in12, inlet12)
      setHandler(in13, inlet13)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue&&inlet8.hasValue&&inlet9.hasValue&&inlet10.hasValue&&inlet11.hasValue&&inlet12.hasValue&&inlet13.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value, inlet8.value, inlet9.value, inlet10.value, inlet11.value, inlet12.value, inlet13.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
        if (!hasBeenPulled(in8)) {
          tryPull(in8)
        }
        if (!hasBeenPulled(in9)) {
          tryPull(in9)
        }
        if (!hasBeenPulled(in10)) {
          tryPull(in10)
        }
        if (!hasBeenPulled(in11)) {
          tryPull(in11)
        }
        if (!hasBeenPulled(in12)) {
          tryPull(in12)
        }
        if (!hasBeenPulled(in13)) {
          tryPull(in13)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith14"
}

/** `ZipLatestWith` specialized for 15 inputs */
class ZipLatestWith15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith15")
  override val shape: FanInShape15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, O] = new FanInShape15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, O]("ZipLatestWith15")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 15
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private val inlet8 = new ZipLatestInlet(in8)
      private val inlet9 = new ZipLatestInlet(in9)
      private val inlet10 = new ZipLatestInlet(in10)
      private val inlet11 = new ZipLatestInlet(in11)
      private val inlet12 = new ZipLatestInlet(in12)
      private val inlet13 = new ZipLatestInlet(in13)
      private val inlet14 = new ZipLatestInlet(in14)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)
      setHandler(in8, inlet8)
      setHandler(in9, inlet9)
      setHandler(in10, inlet10)
      setHandler(in11, inlet11)
      setHandler(in12, inlet12)
      setHandler(in13, inlet13)
      setHandler(in14, inlet14)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue&&inlet8.hasValue&&inlet9.hasValue&&inlet10.hasValue&&inlet11.hasValue&&inlet12.hasValue&&inlet13.hasValue&&inlet14.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value, inlet8.value, inlet9.value, inlet10.value, inlet11.value, inlet12.value, inlet13.value, inlet14.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
        if (!hasBeenPulled(in8)) {
          tryPull(in8)
        }
        if (!hasBeenPulled(in9)) {
          tryPull(in9)
        }
        if (!hasBeenPulled(in10)) {
          tryPull(in10)
        }
        if (!hasBeenPulled(in11)) {
          tryPull(in11)
        }
        if (!hasBeenPulled(in12)) {
          tryPull(in12)
        }
        if (!hasBeenPulled(in13)) {
          tryPull(in13)
        }
        if (!hasBeenPulled(in14)) {
          tryPull(in14)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith15"
}

/** `ZipLatestWith` specialized for 16 inputs */
class ZipLatestWith16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith16")
  override val shape: FanInShape16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, O] = new FanInShape16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, O]("ZipLatestWith16")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14
  val in15: Inlet[A16] = shape.in15

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 16
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private val inlet8 = new ZipLatestInlet(in8)
      private val inlet9 = new ZipLatestInlet(in9)
      private val inlet10 = new ZipLatestInlet(in10)
      private val inlet11 = new ZipLatestInlet(in11)
      private val inlet12 = new ZipLatestInlet(in12)
      private val inlet13 = new ZipLatestInlet(in13)
      private val inlet14 = new ZipLatestInlet(in14)
      private val inlet15 = new ZipLatestInlet(in15)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
        pull(in15)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)
      setHandler(in8, inlet8)
      setHandler(in9, inlet9)
      setHandler(in10, inlet10)
      setHandler(in11, inlet11)
      setHandler(in12, inlet12)
      setHandler(in13, inlet13)
      setHandler(in14, inlet14)
      setHandler(in15, inlet15)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue&&inlet8.hasValue&&inlet9.hasValue&&inlet10.hasValue&&inlet11.hasValue&&inlet12.hasValue&&inlet13.hasValue&&inlet14.hasValue&&inlet15.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value, inlet8.value, inlet9.value, inlet10.value, inlet11.value, inlet12.value, inlet13.value, inlet14.value, inlet15.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
        if (!hasBeenPulled(in8)) {
          tryPull(in8)
        }
        if (!hasBeenPulled(in9)) {
          tryPull(in9)
        }
        if (!hasBeenPulled(in10)) {
          tryPull(in10)
        }
        if (!hasBeenPulled(in11)) {
          tryPull(in11)
        }
        if (!hasBeenPulled(in12)) {
          tryPull(in12)
        }
        if (!hasBeenPulled(in13)) {
          tryPull(in13)
        }
        if (!hasBeenPulled(in14)) {
          tryPull(in14)
        }
        if (!hasBeenPulled(in15)) {
          tryPull(in15)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith16"
}

/** `ZipLatestWith` specialized for 17 inputs */
class ZipLatestWith17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith17")
  override val shape: FanInShape17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, O] = new FanInShape17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, O]("ZipLatestWith17")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14
  val in15: Inlet[A16] = shape.in15
  val in16: Inlet[A17] = shape.in16

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 17
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private val inlet8 = new ZipLatestInlet(in8)
      private val inlet9 = new ZipLatestInlet(in9)
      private val inlet10 = new ZipLatestInlet(in10)
      private val inlet11 = new ZipLatestInlet(in11)
      private val inlet12 = new ZipLatestInlet(in12)
      private val inlet13 = new ZipLatestInlet(in13)
      private val inlet14 = new ZipLatestInlet(in14)
      private val inlet15 = new ZipLatestInlet(in15)
      private val inlet16 = new ZipLatestInlet(in16)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
        pull(in15)
        pull(in16)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)
      setHandler(in8, inlet8)
      setHandler(in9, inlet9)
      setHandler(in10, inlet10)
      setHandler(in11, inlet11)
      setHandler(in12, inlet12)
      setHandler(in13, inlet13)
      setHandler(in14, inlet14)
      setHandler(in15, inlet15)
      setHandler(in16, inlet16)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue&&inlet8.hasValue&&inlet9.hasValue&&inlet10.hasValue&&inlet11.hasValue&&inlet12.hasValue&&inlet13.hasValue&&inlet14.hasValue&&inlet15.hasValue&&inlet16.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value, inlet8.value, inlet9.value, inlet10.value, inlet11.value, inlet12.value, inlet13.value, inlet14.value, inlet15.value, inlet16.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
        if (!hasBeenPulled(in8)) {
          tryPull(in8)
        }
        if (!hasBeenPulled(in9)) {
          tryPull(in9)
        }
        if (!hasBeenPulled(in10)) {
          tryPull(in10)
        }
        if (!hasBeenPulled(in11)) {
          tryPull(in11)
        }
        if (!hasBeenPulled(in12)) {
          tryPull(in12)
        }
        if (!hasBeenPulled(in13)) {
          tryPull(in13)
        }
        if (!hasBeenPulled(in14)) {
          tryPull(in14)
        }
        if (!hasBeenPulled(in15)) {
          tryPull(in15)
        }
        if (!hasBeenPulled(in16)) {
          tryPull(in16)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith17"
}

/** `ZipLatestWith` specialized for 18 inputs */
class ZipLatestWith18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith18")
  override val shape: FanInShape18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, O] = new FanInShape18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, O]("ZipLatestWith18")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14
  val in15: Inlet[A16] = shape.in15
  val in16: Inlet[A17] = shape.in16
  val in17: Inlet[A18] = shape.in17

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 18
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private val inlet8 = new ZipLatestInlet(in8)
      private val inlet9 = new ZipLatestInlet(in9)
      private val inlet10 = new ZipLatestInlet(in10)
      private val inlet11 = new ZipLatestInlet(in11)
      private val inlet12 = new ZipLatestInlet(in12)
      private val inlet13 = new ZipLatestInlet(in13)
      private val inlet14 = new ZipLatestInlet(in14)
      private val inlet15 = new ZipLatestInlet(in15)
      private val inlet16 = new ZipLatestInlet(in16)
      private val inlet17 = new ZipLatestInlet(in17)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
        pull(in15)
        pull(in16)
        pull(in17)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)
      setHandler(in8, inlet8)
      setHandler(in9, inlet9)
      setHandler(in10, inlet10)
      setHandler(in11, inlet11)
      setHandler(in12, inlet12)
      setHandler(in13, inlet13)
      setHandler(in14, inlet14)
      setHandler(in15, inlet15)
      setHandler(in16, inlet16)
      setHandler(in17, inlet17)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue&&inlet8.hasValue&&inlet9.hasValue&&inlet10.hasValue&&inlet11.hasValue&&inlet12.hasValue&&inlet13.hasValue&&inlet14.hasValue&&inlet15.hasValue&&inlet16.hasValue&&inlet17.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value, inlet8.value, inlet9.value, inlet10.value, inlet11.value, inlet12.value, inlet13.value, inlet14.value, inlet15.value, inlet16.value, inlet17.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
        if (!hasBeenPulled(in8)) {
          tryPull(in8)
        }
        if (!hasBeenPulled(in9)) {
          tryPull(in9)
        }
        if (!hasBeenPulled(in10)) {
          tryPull(in10)
        }
        if (!hasBeenPulled(in11)) {
          tryPull(in11)
        }
        if (!hasBeenPulled(in12)) {
          tryPull(in12)
        }
        if (!hasBeenPulled(in13)) {
          tryPull(in13)
        }
        if (!hasBeenPulled(in14)) {
          tryPull(in14)
        }
        if (!hasBeenPulled(in15)) {
          tryPull(in15)
        }
        if (!hasBeenPulled(in16)) {
          tryPull(in16)
        }
        if (!hasBeenPulled(in17)) {
          tryPull(in17)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith18"
}

/** `ZipLatestWith` specialized for 19 inputs */
class ZipLatestWith19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith19")
  override val shape: FanInShape19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, O] = new FanInShape19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, O]("ZipLatestWith19")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14
  val in15: Inlet[A16] = shape.in15
  val in16: Inlet[A17] = shape.in16
  val in17: Inlet[A18] = shape.in17
  val in18: Inlet[A19] = shape.in18

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 19
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private val inlet8 = new ZipLatestInlet(in8)
      private val inlet9 = new ZipLatestInlet(in9)
      private val inlet10 = new ZipLatestInlet(in10)
      private val inlet11 = new ZipLatestInlet(in11)
      private val inlet12 = new ZipLatestInlet(in12)
      private val inlet13 = new ZipLatestInlet(in13)
      private val inlet14 = new ZipLatestInlet(in14)
      private val inlet15 = new ZipLatestInlet(in15)
      private val inlet16 = new ZipLatestInlet(in16)
      private val inlet17 = new ZipLatestInlet(in17)
      private val inlet18 = new ZipLatestInlet(in18)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
        pull(in15)
        pull(in16)
        pull(in17)
        pull(in18)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)
      setHandler(in8, inlet8)
      setHandler(in9, inlet9)
      setHandler(in10, inlet10)
      setHandler(in11, inlet11)
      setHandler(in12, inlet12)
      setHandler(in13, inlet13)
      setHandler(in14, inlet14)
      setHandler(in15, inlet15)
      setHandler(in16, inlet16)
      setHandler(in17, inlet17)
      setHandler(in18, inlet18)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue&&inlet8.hasValue&&inlet9.hasValue&&inlet10.hasValue&&inlet11.hasValue&&inlet12.hasValue&&inlet13.hasValue&&inlet14.hasValue&&inlet15.hasValue&&inlet16.hasValue&&inlet17.hasValue&&inlet18.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value, inlet8.value, inlet9.value, inlet10.value, inlet11.value, inlet12.value, inlet13.value, inlet14.value, inlet15.value, inlet16.value, inlet17.value, inlet18.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
        if (!hasBeenPulled(in8)) {
          tryPull(in8)
        }
        if (!hasBeenPulled(in9)) {
          tryPull(in9)
        }
        if (!hasBeenPulled(in10)) {
          tryPull(in10)
        }
        if (!hasBeenPulled(in11)) {
          tryPull(in11)
        }
        if (!hasBeenPulled(in12)) {
          tryPull(in12)
        }
        if (!hasBeenPulled(in13)) {
          tryPull(in13)
        }
        if (!hasBeenPulled(in14)) {
          tryPull(in14)
        }
        if (!hasBeenPulled(in15)) {
          tryPull(in15)
        }
        if (!hasBeenPulled(in16)) {
          tryPull(in16)
        }
        if (!hasBeenPulled(in17)) {
          tryPull(in17)
        }
        if (!hasBeenPulled(in18)) {
          tryPull(in18)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith19"
}

/** `ZipLatestWith` specialized for 20 inputs */
class ZipLatestWith20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith20")
  override val shape: FanInShape20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, O] = new FanInShape20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, O]("ZipLatestWith20")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14
  val in15: Inlet[A16] = shape.in15
  val in16: Inlet[A17] = shape.in16
  val in17: Inlet[A18] = shape.in17
  val in18: Inlet[A19] = shape.in18
  val in19: Inlet[A20] = shape.in19

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 20
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private val inlet8 = new ZipLatestInlet(in8)
      private val inlet9 = new ZipLatestInlet(in9)
      private val inlet10 = new ZipLatestInlet(in10)
      private val inlet11 = new ZipLatestInlet(in11)
      private val inlet12 = new ZipLatestInlet(in12)
      private val inlet13 = new ZipLatestInlet(in13)
      private val inlet14 = new ZipLatestInlet(in14)
      private val inlet15 = new ZipLatestInlet(in15)
      private val inlet16 = new ZipLatestInlet(in16)
      private val inlet17 = new ZipLatestInlet(in17)
      private val inlet18 = new ZipLatestInlet(in18)
      private val inlet19 = new ZipLatestInlet(in19)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
        pull(in15)
        pull(in16)
        pull(in17)
        pull(in18)
        pull(in19)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)
      setHandler(in8, inlet8)
      setHandler(in9, inlet9)
      setHandler(in10, inlet10)
      setHandler(in11, inlet11)
      setHandler(in12, inlet12)
      setHandler(in13, inlet13)
      setHandler(in14, inlet14)
      setHandler(in15, inlet15)
      setHandler(in16, inlet16)
      setHandler(in17, inlet17)
      setHandler(in18, inlet18)
      setHandler(in19, inlet19)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue&&inlet8.hasValue&&inlet9.hasValue&&inlet10.hasValue&&inlet11.hasValue&&inlet12.hasValue&&inlet13.hasValue&&inlet14.hasValue&&inlet15.hasValue&&inlet16.hasValue&&inlet17.hasValue&&inlet18.hasValue&&inlet19.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value, inlet8.value, inlet9.value, inlet10.value, inlet11.value, inlet12.value, inlet13.value, inlet14.value, inlet15.value, inlet16.value, inlet17.value, inlet18.value, inlet19.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
        if (!hasBeenPulled(in8)) {
          tryPull(in8)
        }
        if (!hasBeenPulled(in9)) {
          tryPull(in9)
        }
        if (!hasBeenPulled(in10)) {
          tryPull(in10)
        }
        if (!hasBeenPulled(in11)) {
          tryPull(in11)
        }
        if (!hasBeenPulled(in12)) {
          tryPull(in12)
        }
        if (!hasBeenPulled(in13)) {
          tryPull(in13)
        }
        if (!hasBeenPulled(in14)) {
          tryPull(in14)
        }
        if (!hasBeenPulled(in15)) {
          tryPull(in15)
        }
        if (!hasBeenPulled(in16)) {
          tryPull(in16)
        }
        if (!hasBeenPulled(in17)) {
          tryPull(in17)
        }
        if (!hasBeenPulled(in18)) {
          tryPull(in18)
        }
        if (!hasBeenPulled(in19)) {
          tryPull(in19)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith20"
}

/** `ZipLatestWith` specialized for 21 inputs */
class ZipLatestWith21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith21")
  override val shape: FanInShape21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, O] = new FanInShape21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, O]("ZipLatestWith21")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14
  val in15: Inlet[A16] = shape.in15
  val in16: Inlet[A17] = shape.in16
  val in17: Inlet[A18] = shape.in17
  val in18: Inlet[A19] = shape.in18
  val in19: Inlet[A20] = shape.in19
  val in20: Inlet[A21] = shape.in20

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 21
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private val inlet8 = new ZipLatestInlet(in8)
      private val inlet9 = new ZipLatestInlet(in9)
      private val inlet10 = new ZipLatestInlet(in10)
      private val inlet11 = new ZipLatestInlet(in11)
      private val inlet12 = new ZipLatestInlet(in12)
      private val inlet13 = new ZipLatestInlet(in13)
      private val inlet14 = new ZipLatestInlet(in14)
      private val inlet15 = new ZipLatestInlet(in15)
      private val inlet16 = new ZipLatestInlet(in16)
      private val inlet17 = new ZipLatestInlet(in17)
      private val inlet18 = new ZipLatestInlet(in18)
      private val inlet19 = new ZipLatestInlet(in19)
      private val inlet20 = new ZipLatestInlet(in20)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
        pull(in15)
        pull(in16)
        pull(in17)
        pull(in18)
        pull(in19)
        pull(in20)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)
      setHandler(in8, inlet8)
      setHandler(in9, inlet9)
      setHandler(in10, inlet10)
      setHandler(in11, inlet11)
      setHandler(in12, inlet12)
      setHandler(in13, inlet13)
      setHandler(in14, inlet14)
      setHandler(in15, inlet15)
      setHandler(in16, inlet16)
      setHandler(in17, inlet17)
      setHandler(in18, inlet18)
      setHandler(in19, inlet19)
      setHandler(in20, inlet20)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue&&inlet8.hasValue&&inlet9.hasValue&&inlet10.hasValue&&inlet11.hasValue&&inlet12.hasValue&&inlet13.hasValue&&inlet14.hasValue&&inlet15.hasValue&&inlet16.hasValue&&inlet17.hasValue&&inlet18.hasValue&&inlet19.hasValue&&inlet20.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value, inlet8.value, inlet9.value, inlet10.value, inlet11.value, inlet12.value, inlet13.value, inlet14.value, inlet15.value, inlet16.value, inlet17.value, inlet18.value, inlet19.value, inlet20.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
        if (!hasBeenPulled(in8)) {
          tryPull(in8)
        }
        if (!hasBeenPulled(in9)) {
          tryPull(in9)
        }
        if (!hasBeenPulled(in10)) {
          tryPull(in10)
        }
        if (!hasBeenPulled(in11)) {
          tryPull(in11)
        }
        if (!hasBeenPulled(in12)) {
          tryPull(in12)
        }
        if (!hasBeenPulled(in13)) {
          tryPull(in13)
        }
        if (!hasBeenPulled(in14)) {
          tryPull(in14)
        }
        if (!hasBeenPulled(in15)) {
          tryPull(in15)
        }
        if (!hasBeenPulled(in16)) {
          tryPull(in16)
        }
        if (!hasBeenPulled(in17)) {
          tryPull(in17)
        }
        if (!hasBeenPulled(in18)) {
          tryPull(in18)
        }
        if (!hasBeenPulled(in19)) {
          tryPull(in19)
        }
        if (!hasBeenPulled(in20)) {
          tryPull(in20)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith21"
}

/** `ZipLatestWith` specialized for 22 inputs */
class ZipLatestWith22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22) => O, val eagerComplete: Boolean) extends GraphStage[FanInShape22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, O]] {
  override def initialAttributes = Attributes.name("ZipLatestWith22")
  override val shape: FanInShape22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, O] = new FanInShape22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, O]("ZipLatestWith22")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14
  val in15: Inlet[A16] = shape.in15
  val in16: Inlet[A17] = shape.in16
  val in17: Inlet[A18] = shape.in17
  val in18: Inlet[A19] = shape.in18
  val in19: Inlet[A20] = shape.in19
  val in20: Inlet[A21] = shape.in20
  val in21: Inlet[A22] = shape.in21

  def this(zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22) => O) = this(zipper, eagerComplete = true)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) { outer =>
      private var upstreamsToWait: Int = 22
      // Without this field the completion signalling would take one extra pull
      private def willShutDown: Boolean = upstreamsToWait == 0

      private val contextPropagation = ContextPropagation()
      private val inlet0 = new ZipLatestInlet(in0)
      private val inlet1 = new ZipLatestInlet(in1)
      private val inlet2 = new ZipLatestInlet(in2)
      private val inlet3 = new ZipLatestInlet(in3)
      private val inlet4 = new ZipLatestInlet(in4)
      private val inlet5 = new ZipLatestInlet(in5)
      private val inlet6 = new ZipLatestInlet(in6)
      private val inlet7 = new ZipLatestInlet(in7)
      private val inlet8 = new ZipLatestInlet(in8)
      private val inlet9 = new ZipLatestInlet(in9)
      private val inlet10 = new ZipLatestInlet(in10)
      private val inlet11 = new ZipLatestInlet(in11)
      private val inlet12 = new ZipLatestInlet(in12)
      private val inlet13 = new ZipLatestInlet(in13)
      private val inlet14 = new ZipLatestInlet(in14)
      private val inlet15 = new ZipLatestInlet(in15)
      private val inlet16 = new ZipLatestInlet(in16)
      private val inlet17 = new ZipLatestInlet(in17)
      private val inlet18 = new ZipLatestInlet(in18)
      private val inlet19 = new ZipLatestInlet(in19)
      private val inlet20 = new ZipLatestInlet(in20)
      private val inlet21 = new ZipLatestInlet(in21)
      private var waitingForTuple = false
      private var staleTupleValues = true

      override def preStart(): Unit = {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
        pull(in15)
        pull(in16)
        pull(in17)
        pull(in18)
        pull(in19)
        pull(in20)
        pull(in21)
      }

      setHandler(
        out,
        new OutHandler {
          override def onPull(): Unit = {
            if (hasAllValues) {
                if (staleTupleValues) {
                    waitingForTuple = true
                } else {
                    pushOutput()
                }
            } else {
                waitingForTuple = true
            }
            tryPullAllIfNeeded()
          }
        }
      )

      setHandler(in0, inlet0)
      setHandler(in1, inlet1)
      setHandler(in2, inlet2)
      setHandler(in3, inlet3)
      setHandler(in4, inlet4)
      setHandler(in5, inlet5)
      setHandler(in6, inlet6)
      setHandler(in7, inlet7)
      setHandler(in8, inlet8)
      setHandler(in9, inlet9)
      setHandler(in10, inlet10)
      setHandler(in11, inlet11)
      setHandler(in12, inlet12)
      setHandler(in13, inlet13)
      setHandler(in14, inlet14)
      setHandler(in15, inlet15)
      setHandler(in16, inlet16)
      setHandler(in17, inlet17)
      setHandler(in18, inlet18)
      setHandler(in19, inlet19)
      setHandler(in20, inlet20)
      setHandler(in21, inlet21)

      private def hasAllValues = inlet0.hasValue&&inlet1.hasValue&&inlet2.hasValue&&inlet3.hasValue&&inlet4.hasValue&&inlet5.hasValue&&inlet6.hasValue&&inlet7.hasValue&&inlet8.hasValue&&inlet9.hasValue&&inlet10.hasValue&&inlet11.hasValue&&inlet12.hasValue&&inlet13.hasValue&&inlet14.hasValue&&inlet15.hasValue&&inlet16.hasValue&&inlet17.hasValue&&inlet18.hasValue&&inlet19.hasValue&&inlet20.hasValue&&inlet21.hasValue

      private def pushOutput(): Unit = {
        contextPropagation.resumeContext()
        push(out, zipper(inlet0.value, inlet1.value, inlet2.value, inlet3.value, inlet4.value, inlet5.value, inlet6.value, inlet7.value, inlet8.value, inlet9.value, inlet10.value, inlet11.value, inlet12.value, inlet13.value, inlet14.value, inlet15.value, inlet16.value, inlet17.value, inlet18.value, inlet19.value, inlet20.value, inlet21.value))
        if (willShutDown) completeStage()
        staleTupleValues = true
      }

      private def tryPullAllIfNeeded(): Unit = {
        if (!hasBeenPulled(in0)) {
          tryPull(in0)
        }
        if (!hasBeenPulled(in1)) {
          tryPull(in1)
        }
        if (!hasBeenPulled(in2)) {
          tryPull(in2)
        }
        if (!hasBeenPulled(in3)) {
          tryPull(in3)
        }
        if (!hasBeenPulled(in4)) {
          tryPull(in4)
        }
        if (!hasBeenPulled(in5)) {
          tryPull(in5)
        }
        if (!hasBeenPulled(in6)) {
          tryPull(in6)
        }
        if (!hasBeenPulled(in7)) {
          tryPull(in7)
        }
        if (!hasBeenPulled(in8)) {
          tryPull(in8)
        }
        if (!hasBeenPulled(in9)) {
          tryPull(in9)
        }
        if (!hasBeenPulled(in10)) {
          tryPull(in10)
        }
        if (!hasBeenPulled(in11)) {
          tryPull(in11)
        }
        if (!hasBeenPulled(in12)) {
          tryPull(in12)
        }
        if (!hasBeenPulled(in13)) {
          tryPull(in13)
        }
        if (!hasBeenPulled(in14)) {
          tryPull(in14)
        }
        if (!hasBeenPulled(in15)) {
          tryPull(in15)
        }
        if (!hasBeenPulled(in16)) {
          tryPull(in16)
        }
        if (!hasBeenPulled(in17)) {
          tryPull(in17)
        }
        if (!hasBeenPulled(in18)) {
          tryPull(in18)
        }
        if (!hasBeenPulled(in19)) {
          tryPull(in19)
        }
        if (!hasBeenPulled(in20)) {
          tryPull(in20)
        }
        if (!hasBeenPulled(in21)) {
          tryPull(in21)
        }
      }

      private class ZipLatestInlet[T](in: Inlet[T]) extends InHandler {
         var value: T = _
         var hasValue = false

         override def onPush() = {
              hasValue = true
              value = outer.grab(in)
              // Only one context can be propagated.
              if (outer.hasAllValues) contextPropagation.suspendContext()
              outer.staleTupleValues = false
              if (outer.waitingForTuple && outer.hasAllValues) {
                  outer.pushOutput()
                  outer.waitingForTuple = false
                  outer.tryPullAllIfNeeded()
              }
         }

         override def onUpstreamFinish(): Unit = {
           if (!hasValue) completeStage()
           else if (eagerComplete) outer.upstreamsToWait = 0
           else outer.upstreamsToWait = outer.upstreamsToWait - 1
           if (willShutDown && staleTupleValues) completeStage()
         }
       }
    }

    override def toString = "ZipLatestWith22"
}

