/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.state;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.persistence.Persistence$;
import org.apache.pekko.persistence.PersistencePlugin;
import org.apache.pekko.persistence.PluginProvider;
import org.apache.pekko.persistence.state.DurableStateStoreProvider;
import org.apache.pekko.persistence.state.DurableStateStoreRegistry$;
import org.apache.pekko.persistence.state.javadsl.DurableStateStore;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class DurableStateStoreRegistry
extends PersistencePlugin<org.apache.pekko.persistence.state.scaladsl.DurableStateStore<?>, DurableStateStore<?>, DurableStateStoreProvider>
implements Extension {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DurableStateStoreRegistry.class.getDeclaredField("defaultPluginId$lzy1"));
    private final Config systemConfig;
    private volatile Object defaultPluginId$lzy1;

    public static Extension apply(ActorSystem actorSystem) {
        return DurableStateStoreRegistry$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return DurableStateStoreRegistry$.MODULE$.apply(classicActorSystemProvider);
    }

    public static DurableStateStoreRegistry createExtension(ExtendedActorSystem extendedActorSystem) {
        return DurableStateStoreRegistry$.MODULE$.createExtension(extendedActorSystem);
    }

    public static DurableStateStoreRegistry get(ActorSystem actorSystem) {
        return DurableStateStoreRegistry$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return DurableStateStoreRegistry$.MODULE$.get(actorSystem);
    }

    public static DurableStateStoreRegistry get(ClassicActorSystemProvider classicActorSystemProvider) {
        return DurableStateStoreRegistry$.MODULE$.get(classicActorSystemProvider);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return DurableStateStoreRegistry$.MODULE$.get(classicActorSystemProvider);
    }

    public static DurableStateStoreRegistry$ lookup() {
        return DurableStateStoreRegistry$.MODULE$.lookup();
    }

    public static PluginProvider<DurableStateStoreProvider, org.apache.pekko.persistence.state.scaladsl.DurableStateStore<?>, DurableStateStore<?>> pluginProvider() {
        return DurableStateStoreRegistry$.MODULE$.pluginProvider();
    }

    public DurableStateStoreRegistry(ExtendedActorSystem system) {
        super(system, ClassTag$.MODULE$.apply(DurableStateStoreProvider.class), DurableStateStoreRegistry$.MODULE$.pluginProvider());
        this.systemConfig = system.settings().config();
    }

    private String defaultPluginId() {
        Object object = this.defaultPluginId$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.defaultPluginId$lzyINIT1();
    }

    private Object defaultPluginId$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.defaultPluginId$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        String configPath = this.systemConfig.getString("pekko.persistence.state.plugin");
                        Persistence$.MODULE$.verifyPluginConfigIsDefined(configPath, "Default DurableStateStore");
                        Persistence$.MODULE$.verifyPluginConfigExists(this.systemConfig, configPath, "DurableStateStore");
                        string = configPath;
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultPluginId$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultPluginId$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private String pluginIdOrDefault(String pluginId) {
        String configPath = this.isEmpty(pluginId) ? this.defaultPluginId() : pluginId;
        Persistence$.MODULE$.verifyPluginConfigExists(this.systemConfig, configPath, "DurableStateStore");
        return configPath;
    }

    private Config pluginConfig(String pluginId) {
        String configPath = this.pluginIdOrDefault(pluginId);
        return this.systemConfig.getConfig(configPath).withFallback((ConfigMergeable)this.systemConfig.getConfig("pekko.persistence.state-plugin-fallback"));
    }

    private boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public final <T extends org.apache.pekko.persistence.state.scaladsl.DurableStateStore<?>> T durableStateStoreFor(String pluginId) {
        return (T)((org.apache.pekko.persistence.state.scaladsl.DurableStateStore)this.pluginFor(this.pluginIdOrDefault(pluginId), this.pluginConfig(pluginId)).scaladslPlugin());
    }

    public final <T extends DurableStateStore<?>> T getDurableStateStoreFor(Class<T> clazz, String pluginId) {
        return (T)((DurableStateStore)this.pluginFor(this.pluginIdOrDefault(pluginId), this.pluginConfig(pluginId)).javadslPlugin());
    }
}

