/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.journal;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.Actor$;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.persistence.JournalProtocol;
import org.apache.pekko.persistence.JournalProtocol$ReplayMessagesFailure$;
import org.apache.pekko.persistence.JournalProtocol$ReplayedMessage$;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.journal.ReplayFilter$;
import org.apache.pekko.persistence.journal.ReplayFilter$Disabled$;
import org.apache.pekko.persistence.journal.ReplayFilter$Fail$;
import org.apache.pekko.persistence.journal.ReplayFilter$RepairByDiscardOld$;
import org.apache.pekko.persistence.journal.ReplayFilter$Warn$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

public class ReplayFilter
implements Actor,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    public final ActorRef org$apache$pekko$persistence$journal$ReplayFilter$$persistentActor;
    public final Mode org$apache$pekko$persistence$journal$ReplayFilter$$mode;
    public final int org$apache$pekko$persistence$journal$ReplayFilter$$windowSize;
    public final int org$apache$pekko$persistence$journal$ReplayFilter$$maxOldWriters;
    public final boolean org$apache$pekko$persistence$journal$ReplayFilter$$debugEnabled;
    private final LinkedList buffer;
    private final LinkedHashSet oldWriters;
    private String writerUuid;
    private long seqNo;

    public static Props props(ActorRef actorRef, Mode mode, int n, int n2) {
        return ReplayFilter$.MODULE$.props(actorRef, mode, n, n2);
    }

    public static Props props(ActorRef actorRef, Mode mode, int n, int n2, boolean bl) {
        return ReplayFilter$.MODULE$.props(actorRef, mode, n, n2, bl);
    }

    public ReplayFilter(ActorRef persistentActor, Mode mode, int windowSize, int maxOldWriters, boolean debugEnabled) {
        this.org$apache$pekko$persistence$journal$ReplayFilter$$persistentActor = persistentActor;
        this.org$apache$pekko$persistence$journal$ReplayFilter$$mode = mode;
        this.org$apache$pekko$persistence$journal$ReplayFilter$$windowSize = windowSize;
        this.org$apache$pekko$persistence$journal$ReplayFilter$$maxOldWriters = maxOldWriters;
        this.org$apache$pekko$persistence$journal$ReplayFilter$$debugEnabled = debugEnabled;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.buffer = new LinkedList();
        this.oldWriters = LinkedHashSet$.MODULE$.empty();
        this.writerUuid = "";
        this.seqNo = -1L;
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public ReplayFilter(ActorRef persistentActor, Mode mode, int windowSize, int maxOldWriters) {
        this(persistentActor, mode, windowSize, maxOldWriters, false);
    }

    public LinkedList<JournalProtocol.ReplayedMessage> buffer() {
        return this.buffer;
    }

    public LinkedHashSet<String> oldWriters() {
        return this.oldWriters;
    }

    public String writerUuid() {
        return this.writerUuid;
    }

    public void writerUuid_$eq(String x$1) {
        this.writerUuid = x$1;
    }

    public long seqNo() {
        return this.seqNo;
    }

    public void seqNo_$eq(long x$1) {
        this.seqNo = x$1;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ ReplayFilter $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof JournalProtocol.ReplayedMessage) {
                    PersistentRepr persistentRepr;
                    JournalProtocol.ReplayedMessage replayedMessage = (JournalProtocol.ReplayedMessage)object;
                    JournalProtocol.ReplayedMessage replayedMessage2 = JournalProtocol$ReplayedMessage$.MODULE$.unapply(replayedMessage);
                    PersistentRepr persistent = persistentRepr = replayedMessage2._1();
                    JournalProtocol.ReplayedMessage r = replayedMessage;
                    return true;
                }
                if (object instanceof JournalProtocol.RecoverySuccess || object instanceof JournalProtocol.ReplayMessagesFailure) {
                    Serializable msg = (Serializable)object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                block31: {
                    BoxedUnit boxedUnit;
                    PersistentRepr persistentRepr;
                    object = x;
                    if (!(object instanceof JournalProtocol.ReplayedMessage)) break block31;
                    JournalProtocol.ReplayedMessage replayedMessage = (JournalProtocol.ReplayedMessage)object;
                    JournalProtocol.ReplayedMessage replayedMessage2 = JournalProtocol$ReplayedMessage$.MODULE$.unapply(replayedMessage);
                    PersistentRepr persistent = persistentRepr = replayedMessage2._1();
                    JournalProtocol.ReplayedMessage r = replayedMessage;
                    if (this.$outer.org$apache$pekko$persistence$journal$ReplayFilter$$debugEnabled) {
                        this.$outer.log().debug("Replay: {}", (Object)persistent);
                    }
                    try {
                        if (this.$outer.buffer().size() == this.$outer.org$apache$pekko$persistence$journal$ReplayFilter$$windowSize) {
                            JournalProtocol.ReplayedMessage msg = this.$outer.buffer().removeFirst();
                            this.$outer.org$apache$pekko$persistence$journal$ReplayFilter$$persistentActor.tell((Object)msg, Actor$.MODULE$.noSender());
                        }
                        String string = r.persistent().writerUuid();
                        String string2 = this.$outer.writerUuid();
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            if (r.persistent().sequenceNr() < this.$outer.seqNo()) {
                                String errMsg = new StringBuilder(151).append("Invalid replayed event [sequenceNr=").append(r.persistent().sequenceNr()).append(", writerUUID=").append(r.persistent().writerUuid()).append("] as ").append(new StringBuilder(154).append("the sequenceNr should be equal to or greater than already-processed event [sequenceNr=").append(this.$outer.seqNo()).append(", writerUUID=").append(this.$outer.writerUuid()).append("] from the same writer, for the same persistenceId [").append(r.persistent().persistenceId()).append("]. ").toString()).append("Perhaps, events were journaled out of sequence, or duplicate persistenceId for different entities?").toString();
                                this.$outer.logIssue(errMsg);
                                Mode mode = this.$outer.org$apache$pekko$persistence$journal$ReplayFilter$$mode;
                                if (!ReplayFilter$RepairByDiscardOld$.MODULE$.equals(mode)) {
                                    if (ReplayFilter$Fail$.MODULE$.equals(mode)) {
                                        throw new IllegalStateException(errMsg);
                                    }
                                    if (ReplayFilter$Warn$.MODULE$.equals(mode)) {
                                        this.$outer.buffer().add(r);
                                    } else {
                                        if (ReplayFilter$Disabled$.MODULE$.equals(mode)) {
                                            throw new IllegalArgumentException("mode must not be Disabled");
                                        }
                                        throw new MatchError((Object)mode);
                                    }
                                }
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.$outer.buffer().add(r);
                                this.$outer.seqNo_$eq(r.persistent().sequenceNr());
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        } else if (this.$outer.oldWriters().contains((Object)r.persistent().writerUuid())) {
                            String errMsg = new StringBuilder(180).append("Invalid replayed event [sequenceNr=").append(r.persistent().sequenceNr()).append(", writerUUID=").append(r.persistent().writerUuid()).append("]. ").append(new StringBuilder(120).append("There was already a newer writer whose last replayed event was [sequenceNr=").append(this.$outer.seqNo()).append(", writerUUID=").append(this.$outer.writerUuid()).append("] for the same persistenceId [").append(r.persistent().persistenceId()).append("].").toString()).append("Perhaps, the old writer kept journaling messages after the new writer created, or duplicate persistenceId for different entities?").toString();
                            this.$outer.logIssue(errMsg);
                            Mode mode = this.$outer.org$apache$pekko$persistence$journal$ReplayFilter$$mode;
                            if (!ReplayFilter$RepairByDiscardOld$.MODULE$.equals(mode)) {
                                if (ReplayFilter$Fail$.MODULE$.equals(mode)) {
                                    throw new IllegalStateException(errMsg);
                                }
                                if (ReplayFilter$Warn$.MODULE$.equals(mode)) {
                                    this.$outer.buffer().add(r);
                                } else {
                                    if (ReplayFilter$Disabled$.MODULE$.equals(mode)) {
                                        throw new IllegalArgumentException("mode must not be Disabled");
                                    }
                                    throw new MatchError((Object)mode);
                                }
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string3 = this.$outer.writerUuid();
                            String string4 = "";
                            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                                this.$outer.oldWriters().add((Object)this.$outer.writerUuid());
                            }
                            if (this.$outer.oldWriters().size() > this.$outer.org$apache$pekko$persistence$journal$ReplayFilter$$maxOldWriters) {
                                this.$outer.oldWriters().remove(this.$outer.oldWriters().head());
                            }
                            this.$outer.writerUuid_$eq(r.persistent().writerUuid());
                            this.$outer.seqNo_$eq(r.persistent().sequenceNr());
                            Iterator<E> iter = this.$outer.buffer().iterator();
                            while (iter.hasNext()) {
                                JournalProtocol.ReplayedMessage msg = (JournalProtocol.ReplayedMessage)iter.next();
                                if (msg.persistent().sequenceNr() < this.$outer.seqNo()) continue;
                                String errMsg = new StringBuilder(180).append("Invalid replayed event [sequenceNr=").append(r.persistent().sequenceNr()).append(", writerUUID=").append(r.persistent().writerUuid()).append("] from a new writer. ").append(new StringBuilder(139).append("An older writer already sent an event [sequenceNr=").append(msg.persistent().sequenceNr()).append(", writerUUID=").append(msg.persistent().writerUuid()).append("] whose sequence number was equal or greater for the same persistenceId [").append(r.persistent().persistenceId()).append("]. ").toString()).append("Perhaps, the new writer journaled the event out of sequence, or duplicate persistenceId for different entities?").toString();
                                this.$outer.logIssue(errMsg);
                                Mode mode = this.$outer.org$apache$pekko$persistence$journal$ReplayFilter$$mode;
                                if (ReplayFilter$RepairByDiscardOld$.MODULE$.equals(mode)) {
                                    iter.remove();
                                    continue;
                                }
                                if (ReplayFilter$Fail$.MODULE$.equals(mode)) {
                                    throw new IllegalStateException(errMsg);
                                }
                                if (ReplayFilter$Warn$.MODULE$.equals(mode)) continue;
                                if (ReplayFilter$Disabled$.MODULE$.equals(mode)) {
                                    throw new IllegalArgumentException("mode must not be Disabled");
                                }
                                throw new MatchError((Object)mode);
                            }
                            this.$outer.buffer().add(r);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    catch (Throwable throwable) {
                        IllegalStateException e;
                        block33: {
                            block32: {
                                Throwable throwable2 = throwable;
                                if (!(throwable2 instanceof IllegalStateException)) break block32;
                                e = (IllegalStateException)throwable2;
                                Mode mode = this.$outer.org$apache$pekko$persistence$journal$ReplayFilter$$mode;
                                ReplayFilter$Fail$ replayFilter$Fail$ = ReplayFilter$Fail$.MODULE$;
                                if (!(mode != null ? !mode.equals(replayFilter$Fail$) : replayFilter$Fail$ != null)) break block33;
                            }
                            throw throwable;
                        }
                        this.$outer.fail(e);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                if (object instanceof JournalProtocol.RecoverySuccess || object instanceof JournalProtocol.ReplayMessagesFailure) {
                    Serializable msg = (Serializable)object;
                    if (this.$outer.org$apache$pekko$persistence$journal$ReplayFilter$$debugEnabled) {
                        this.$outer.log().debug("Replay completed: {}", (Object)msg);
                    }
                    this.$outer.sendBuffered();
                    this.$outer.org$apache$pekko$persistence$journal$ReplayFilter$$persistentActor.tell((Object)msg, Actor$.MODULE$.noSender());
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public void sendBuffered() {
        Iterator iter = this.buffer().iterator();
        while (iter.hasNext()) {
            this.org$apache$pekko$persistence$journal$ReplayFilter$$persistentActor.tell(iter.next(), Actor$.MODULE$.noSender());
        }
        this.buffer().clear();
    }

    public void logIssue(String errMsg) {
        Mode mode = this.org$apache$pekko$persistence$journal$ReplayFilter$$mode;
        if (ReplayFilter$Warn$.MODULE$.equals(mode) || ReplayFilter$RepairByDiscardOld$.MODULE$.equals(mode)) {
            this.log().warning(errMsg);
            return;
        }
        if (ReplayFilter$Fail$.MODULE$.equals(mode)) {
            this.log().error(errMsg);
            return;
        }
        if (ReplayFilter$Disabled$.MODULE$.equals(mode)) {
            throw new IllegalArgumentException("mode must not be Disabled");
        }
        throw new MatchError((Object)mode);
    }

    public void fail(IllegalStateException cause) {
        this.buffer().clear();
        this.org$apache$pekko$persistence$journal$ReplayFilter$$persistentActor.tell((Object)JournalProtocol$ReplayMessagesFailure$.MODULE$.apply(cause), Actor$.MODULE$.noSender());
        this.context().become((PartialFunction)new Serializable(this){
            private final /* synthetic */ ReplayFilter $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof JournalProtocol.ReplayedMessage) {
                    return true;
                }
                return object instanceof JournalProtocol.RecoverySuccess || object instanceof JournalProtocol.ReplayMessagesFailure;
                {
                }
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof JournalProtocol.ReplayedMessage) {
                    return BoxedUnit.UNIT;
                }
                if (object instanceof JournalProtocol.RecoverySuccess || object instanceof JournalProtocol.ReplayMessagesFailure) {
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        });
    }

    public static interface Mode {
    }
}

