/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.journal;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.Actor$;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.pattern.CircuitBreaker;
import org.apache.pekko.pattern.CircuitBreaker$;
import org.apache.pekko.persistence.AtomicWrite;
import org.apache.pekko.persistence.DeleteMessagesFailure$;
import org.apache.pekko.persistence.DeleteMessagesSuccess;
import org.apache.pekko.persistence.DeleteMessagesSuccess$;
import org.apache.pekko.persistence.JournalProtocol;
import org.apache.pekko.persistence.JournalProtocol$DeleteMessagesTo$;
import org.apache.pekko.persistence.JournalProtocol$LoopMessageSuccess$;
import org.apache.pekko.persistence.JournalProtocol$RecoverySuccess$;
import org.apache.pekko.persistence.JournalProtocol$ReplayMessages$;
import org.apache.pekko.persistence.JournalProtocol$ReplayMessagesFailure$;
import org.apache.pekko.persistence.JournalProtocol$ReplayedMessage$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessageFailure$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessageRejected$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessageSuccess$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessages$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessagesFailed$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessagesSuccessful$;
import org.apache.pekko.persistence.NonPersistentRepr;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.Persistence$;
import org.apache.pekko.persistence.PersistentEnvelope;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.journal.AsyncRecovery;
import org.apache.pekko.persistence.journal.AsyncWriteJournal$;
import org.apache.pekko.persistence.journal.AsyncWriteJournal$Desequenced$;
import org.apache.pekko.persistence.journal.ReplayFilter;
import org.apache.pekko.persistence.journal.ReplayFilter$;
import org.apache.pekko.persistence.journal.ReplayFilter$Disabled$;
import org.apache.pekko.persistence.journal.ReplayFilter$Fail$;
import org.apache.pekko.persistence.journal.ReplayFilter$RepairByDiscardOld$;
import org.apache.pekko.persistence.journal.ReplayFilter$Warn$;
import org.apache.pekko.persistence.journal.WriteJournalBase;
import org.apache.pekko.util.Helpers$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.deriving.Mirror;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public interface AsyncWriteJournal
extends Actor,
WriteJournalBase,
AsyncRecovery {
    public static Success<BoxedUnit> successUnit() {
        return AsyncWriteJournal$.MODULE$.successUnit();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void $init$(AsyncWriteJournal $this) {
        Mirror.Singleton singleton;
        block6: {
            $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$extension_$eq((Persistence)Persistence$.MODULE$.apply($this.context().system()));
            $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$publish_$eq($this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$extension().settings().internal().publishPluginCommands());
            $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$config_$eq($this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$extension().configFor($this.self()));
            int maxFailures = $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$config().getInt("circuit-breaker.max-failures");
            FiniteDuration callTimeout = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong($this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$config().getDuration("circuit-breaker.call-timeout", scala.concurrent.duration.package$.MODULE$.MILLISECONDS()))).millis();
            FiniteDuration resetTimeout = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong($this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$config().getDuration("circuit-breaker.reset-timeout", scala.concurrent.duration.package$.MODULE$.MILLISECONDS()))).millis();
            $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$breaker_$eq(CircuitBreaker$.MODULE$.apply($this.context().system().scheduler(), maxFailures, callTimeout, resetTimeout));
            String string = Helpers$.MODULE$.toRootLowerCase($this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$config().getString("replay-filter.mode"));
            switch (string == null ? 0 : string.hashCode()) {
                case 109935: {
                    if (!"off".equals(string)) break;
                    singleton = ReplayFilter$Disabled$.MODULE$;
                    break block6;
                }
                case 3135262: {
                    if (!"fail".equals(string)) break;
                    singleton = ReplayFilter$Fail$.MODULE$;
                    break block6;
                }
                case 3641990: {
                    if (!"warn".equals(string)) break;
                    singleton = ReplayFilter$Warn$.MODULE$;
                    break block6;
                }
                case 1269686850: {
                    if (!"repair-by-discard-old".equals(string)) break;
                    singleton = ReplayFilter$RepairByDiscardOld$.MODULE$;
                    break block6;
                }
            }
            String other = string;
            throw new IllegalArgumentException(new StringBuilder(88).append("invalid replay-filter.mode [").append(other).append("], supported values [off, repair-by-discard-old, fail, warn]").toString());
        }
        $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMode_$eq((ReplayFilter.Mode)singleton);
        $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterWindowSize_$eq($this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$config().getInt("replay-filter.window-size"));
        $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMaxOldWriters_$eq($this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$config().getInt("replay-filter.max-old-writers"));
        $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencer_$eq($this.context().actorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(Resequencer.class))));
        $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencerCounter_$eq(1L);
        boolean replayDebugEnabled = $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$config().getBoolean("replay-filter.debug");
        boolean enableGlobalWriteResponseOrder = $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$config().getBoolean("write-response-global-order");
        EventStream eventStream = $this.context().system().eventStream();
        ExecutionContextExecutor ec = $this.context().dispatcher();
        $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$receiveWriteJournal_$eq((PartialFunction)new Serializable((ExecutionContext)ec, replayDebugEnabled, eventStream, enableGlobalWriteResponseOrder, $this){
            private final ExecutionContext ec$1;
            private final boolean replayDebugEnabled$1;
            private final EventStream eventStream$1;
            private final boolean enableGlobalWriteResponseOrder$2;
            private final /* synthetic */ AsyncWriteJournal $outer;
            {
                this.ec$1 = ec$2;
                this.replayDebugEnabled$1 = replayDebugEnabled$2;
                this.eventStream$1 = eventStream$2;
                this.enableGlobalWriteResponseOrder$2 = enableGlobalWriteResponseOrder$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof JournalProtocol.WriteMessages) {
                    JournalProtocol.WriteMessages writeMessages = JournalProtocol$WriteMessages$.MODULE$.unapply((JournalProtocol.WriteMessages)object);
                    Seq<PersistentEnvelope> seq = writeMessages._1();
                    ActorRef actorRef = writeMessages._2();
                    int n = writeMessages._3();
                    Seq<PersistentEnvelope> messages = seq;
                    ActorRef persistentActor = actorRef;
                    int actorInstanceId = n;
                    return true;
                }
                if (object instanceof JournalProtocol.ReplayMessages) {
                    JournalProtocol.ReplayMessages replayMessages = (JournalProtocol.ReplayMessages)object;
                    JournalProtocol.ReplayMessages replayMessages2 = JournalProtocol$ReplayMessages$.MODULE$.unapply(replayMessages);
                    long l = replayMessages2._1();
                    long l2 = replayMessages2._2();
                    long l3 = replayMessages2._3();
                    String string = replayMessages2._4();
                    ActorRef actorRef = replayMessages2._5();
                    long fromSequenceNr = l;
                    long toSequenceNr = l2;
                    long max = l3;
                    String persistenceId = string;
                    ActorRef persistentActor = actorRef;
                    JournalProtocol.ReplayMessages r = replayMessages;
                    return true;
                }
                if (object instanceof JournalProtocol.DeleteMessagesTo) {
                    JournalProtocol.DeleteMessagesTo deleteMessagesTo = (JournalProtocol.DeleteMessagesTo)object;
                    JournalProtocol.DeleteMessagesTo deleteMessagesTo2 = JournalProtocol$DeleteMessagesTo$.MODULE$.unapply(deleteMessagesTo);
                    String string = deleteMessagesTo2._1();
                    long l = deleteMessagesTo2._2();
                    ActorRef actorRef = deleteMessagesTo2._3();
                    String persistenceId = string;
                    long toSequenceNr = l;
                    ActorRef persistentActor = actorRef;
                    JournalProtocol.DeleteMessagesTo d = deleteMessagesTo;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof JournalProtocol.WriteMessages) {
                    Future future;
                    Try prepared;
                    JournalProtocol.WriteMessages writeMessages = JournalProtocol$WriteMessages$.MODULE$.unapply((JournalProtocol.WriteMessages)object);
                    Seq<PersistentEnvelope> seq = writeMessages._1();
                    ActorRef actorRef = writeMessages._2();
                    int n = writeMessages._3();
                    Seq<PersistentEnvelope> messages = seq;
                    ActorRef persistentActor = actorRef;
                    int actorInstanceId = n;
                    long cctr = this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencerCounter();
                    this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencerCounter_$eq(this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencerCounter() + (long)BoxesRunTime.unboxToInt((Object)messages.foldLeft((Object)BoxesRunTime.boxToInteger((int)1), AsyncWriteJournal::org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$adapted$1)));
                    int atomicWriteCount = messages.count(AsyncWriteJournal::org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$_$$anonfun$1);
                    Try try_ = prepared = Try$.MODULE$.apply(() -> this.$anonfun$2(messages));
                    if (try_ instanceof Success) {
                        Seq seq2 = (Seq)((Success)try_).value();
                        Seq prep = seq2;
                        if (prep.isEmpty()) {
                            future = Future$.MODULE$.successful((Object)scala.package$.MODULE$.Nil());
                        } else {
                            Seq prep2 = seq2;
                            try {
                                future = this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$breaker().withCircuitBreaker(() -> this.$anonfun$3(prep2));
                            }
                            catch (Throwable throwable) {
                                Option option;
                                Throwable throwable2 = throwable;
                                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                    Throwable throwable3;
                                    Throwable e = throwable3 = (Throwable)option.get();
                                    future = Future$.MODULE$.failed(e);
                                }
                                throw throwable;
                            }
                        }
                    } else if (try_ instanceof Failure) {
                        Failure f = (Failure)try_;
                        future = Future$.MODULE$.successful(messages.collect((PartialFunction)new Serializable(f){
                            private final Failure f$1;
                            {
                                this.f$1 = f$2;
                            }

                            public final boolean isDefinedAt(PersistentEnvelope x) {
                                PersistentEnvelope persistentEnvelope = x;
                                return persistentEnvelope instanceof AtomicWrite;
                            }

                            public final Object applyOrElse(PersistentEnvelope x, Function1 function1) {
                                PersistentEnvelope persistentEnvelope = x;
                                if (persistentEnvelope instanceof AtomicWrite) {
                                    return this.f$1;
                                }
                                return function1.apply((Object)x);
                            }
                        }));
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    Future writeResult = future.map(arg_0 -> AsyncWriteJournal.org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$_$$anonfun$4(atomicWriteCount, prepared, arg_0), this.ec$1);
                    writeResult.onComplete((Function1)(JProcedure1 & Serializable)x$12 -> {
                        Try try_ = x$12;
                        if (try_ instanceof Success) {
                            Seq results = (Seq)((Success)try_).value();
                            this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$_$sendWriteResponse$1(this.enableGlobalWriteResponseOrder$2, JournalProtocol$WriteMessagesSuccessful$.MODULE$, cctr, persistentActor, this.$outer.self());
                            Iterator resultsIter = results.isEmpty() ? scala.package$.MODULE$.Iterator().fill(atomicWriteCount, AsyncWriteJournal::org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$_$$anonfun$5) : results.iterator();
                            LongRef n = LongRef.create((long)(cctr + 1L));
                            messages.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                                PersistentEnvelope persistentEnvelope = x$1;
                                if (persistentEnvelope instanceof AtomicWrite) {
                                    AtomicWrite a = (AtomicWrite)persistentEnvelope;
                                    Try try_ = (Try)resultsIter.next();
                                    if (try_ instanceof Success) {
                                        a.payload().foreach((Function1)(JProcedure1 & Serializable)p -> {
                                            this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$_$sendWriteResponse$1(this.enableGlobalWriteResponseOrder$2, JournalProtocol$WriteMessageSuccess$.MODULE$.apply((PersistentRepr)p, actorInstanceId), n$2.elem, persistentActor, p.sender());
                                            ++n$2.elem;
                                        });
                                        return;
                                    }
                                    if (try_ instanceof Failure) {
                                        Throwable e = ((Failure)try_).exception();
                                        a.payload().foreach((Function1)(JProcedure1 & Serializable)p -> {
                                            this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$_$sendWriteResponse$1(this.enableGlobalWriteResponseOrder$2, JournalProtocol$WriteMessageRejected$.MODULE$.apply((PersistentRepr)p, e, actorInstanceId), n$3.elem, persistentActor, p.sender());
                                            ++n$3.elem;
                                        });
                                        return;
                                    }
                                    throw new MatchError((Object)try_);
                                }
                                if (persistentEnvelope instanceof NonPersistentRepr) {
                                    NonPersistentRepr r = (NonPersistentRepr)persistentEnvelope;
                                    this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$_$sendWriteResponse$1(this.enableGlobalWriteResponseOrder$2, JournalProtocol$LoopMessageSuccess$.MODULE$.apply(r.payload(), actorInstanceId), n$1.elem, persistentActor, r.sender());
                                    ++n$1.elem;
                                    return;
                                }
                                throw new MatchError((Object)persistentEnvelope);
                            });
                            return;
                        }
                        if (try_ instanceof Failure) {
                            Throwable e = ((Failure)try_).exception();
                            this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$_$sendWriteResponse$1(this.enableGlobalWriteResponseOrder$2, JournalProtocol$WriteMessagesFailed$.MODULE$.apply(e, atomicWriteCount), cctr, persistentActor, this.$outer.self());
                            LongRef n = LongRef.create((long)(cctr + 1L));
                            messages.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                                PersistentEnvelope persistentEnvelope = x$1;
                                if (persistentEnvelope instanceof AtomicWrite) {
                                    AtomicWrite a = (AtomicWrite)persistentEnvelope;
                                    a.payload().foreach((Function1)(JProcedure1 & Serializable)p -> {
                                        this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$_$sendWriteResponse$1(this.enableGlobalWriteResponseOrder$2, JournalProtocol$WriteMessageFailure$.MODULE$.apply((PersistentRepr)p, e, actorInstanceId), n$5.elem, persistentActor, p.sender());
                                        ++n$5.elem;
                                    });
                                    return;
                                }
                                if (persistentEnvelope instanceof NonPersistentRepr) {
                                    NonPersistentRepr r = (NonPersistentRepr)persistentEnvelope;
                                    this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$_$sendWriteResponse$1(this.enableGlobalWriteResponseOrder$2, JournalProtocol$LoopMessageSuccess$.MODULE$.apply(r.payload(), actorInstanceId), n$4.elem, persistentActor, r.sender());
                                    ++n$4.elem;
                                    return;
                                }
                                throw new MatchError((Object)persistentEnvelope);
                            });
                            return;
                        }
                        throw new MatchError((Object)try_);
                    }, this.ec$1);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof JournalProtocol.ReplayMessages) {
                    JournalProtocol.ReplayMessages replayMessages = (JournalProtocol.ReplayMessages)object;
                    JournalProtocol.ReplayMessages replayMessages2 = JournalProtocol$ReplayMessages$.MODULE$.unapply(replayMessages);
                    long l = replayMessages2._1();
                    long l2 = replayMessages2._2();
                    long l3 = replayMessages2._3();
                    String string = replayMessages2._4();
                    ActorRef actorRef = replayMessages2._5();
                    long fromSequenceNr = l;
                    long toSequenceNr = l2;
                    long max = l3;
                    String persistenceId = string;
                    ActorRef persistentActor = actorRef;
                    JournalProtocol.ReplayMessages r = replayMessages;
                    ActorRef replyTo = this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$isReplayFilterEnabled() ? this.$outer.context().actorOf(ReplayFilter$.MODULE$.props(persistentActor, this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMode(), this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterWindowSize(), this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMaxOldWriters(), this.replayDebugEnabled$1)) : persistentActor;
                    long readHighestSequenceNrFrom = package$.MODULE$.max(0L, fromSequenceNr - 1L);
                    org.apache.pekko.pattern.package$.MODULE$.pipe(this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$breaker().withCircuitBreaker(() -> this.applyOrElse$$anonfun$3(persistenceId, readHighestSequenceNrFrom)).flatMap((Function1 & Serializable)highSeqNr -> this.applyOrElse$$anonfun$4(toSequenceNr, fromSequenceNr, persistenceId, max, replyTo, BoxesRunTime.unboxToLong((Object)highSeqNr)), this.ec$1).map(AsyncWriteJournal::org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$adapted$3, this.ec$1).recover((PartialFunction)new Serializable(){

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable;
                            Throwable e = throwable = x;
                            return true;
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Throwable throwable;
                            Throwable e = throwable = x;
                            return JournalProtocol$ReplayMessagesFailure$.MODULE$.apply(e);
                        }
                    }, this.ec$1), this.ec$1).pipeTo(replyTo, this.$outer.self()).foreach((Function1)(JProcedure1 & Serializable)_$3 -> {
                        if (this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$publish()) {
                            this.eventStream$1.publish((Object)r);
                            return;
                        }
                    }, this.ec$1);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof JournalProtocol.DeleteMessagesTo) {
                    JournalProtocol.DeleteMessagesTo deleteMessagesTo = (JournalProtocol.DeleteMessagesTo)object;
                    JournalProtocol.DeleteMessagesTo deleteMessagesTo2 = JournalProtocol$DeleteMessagesTo$.MODULE$.unapply(deleteMessagesTo);
                    String string = deleteMessagesTo2._1();
                    long l = deleteMessagesTo2._2();
                    ActorRef actorRef = deleteMessagesTo2._3();
                    String persistenceId = string;
                    long toSequenceNr = l;
                    ActorRef persistentActor = actorRef;
                    JournalProtocol.DeleteMessagesTo d = deleteMessagesTo;
                    org.apache.pekko.pattern.package$.MODULE$.pipe(this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$breaker().withCircuitBreaker(() -> this.applyOrElse$$anonfun$7(persistenceId, toSequenceNr)).map(arg_0 -> AsyncWriteJournal.org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$8(toSequenceNr, arg_0), this.ec$1).recover((PartialFunction)new Serializable(toSequenceNr){
                        private final long toSequenceNr$4;
                        {
                            this.toSequenceNr$4 = toSequenceNr$6;
                        }

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable;
                            Throwable e = throwable = x;
                            return true;
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Throwable throwable;
                            Throwable e = throwable = x;
                            return DeleteMessagesFailure$.MODULE$.apply(e, this.toSequenceNr$4);
                        }
                    }, this.ec$1), this.ec$1).pipeTo(persistentActor, this.$outer.self()).onComplete((Function1)(JProcedure1 & Serializable)_$5 -> {
                        if (this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$$publish()) {
                            this.eventStream$1.publish((Object)d);
                            return;
                        }
                    }, this.ec$1);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private final Seq $anonfun$2(Seq messages$1) {
                return this.$outer.preparePersistentBatch(messages$1);
            }

            private final Future $anonfun$3(Seq prep$1) {
                return this.$outer.asyncWriteMessages((Seq<AtomicWrite>)prep$1);
            }

            private final Future applyOrElse$$anonfun$3(String persistenceId$1, long readHighestSequenceNrFrom$1) {
                return this.$outer.asyncReadHighestSequenceNr(persistenceId$1, readHighestSequenceNrFrom$1);
            }

            private final /* synthetic */ Future applyOrElse$$anonfun$4(long toSequenceNr$1, long fromSequenceNr$1, String persistenceId$2, long max$1, ActorRef replyTo$1, long highSeqNr) {
                long toSeqNr = package$.MODULE$.min(toSequenceNr$1, highSeqNr);
                if (toSeqNr <= 0L || fromSequenceNr$1 > toSeqNr) {
                    return Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)highSeqNr));
                }
                return this.$outer.asyncReplayMessages(persistenceId$2, fromSequenceNr$1, toSeqNr, max$1, (Function1)(JProcedure1 & Serializable)p -> {
                    if (!p.deleted()) {
                        this.$outer.adaptFromJournal((PersistentRepr)p).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> AsyncWriteJournal.org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$4$$anonfun$1$$anonfun$1(replyTo$1, arg_0)));
                        return;
                    }
                }).map(arg_0 -> AsyncWriteJournal.org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$4$$anonfun$2(highSeqNr, arg_0), this.ec$1);
            }

            private final Future applyOrElse$$anonfun$7(String persistenceId$3, long toSequenceNr$2) {
                return this.$outer.asyncDeleteMessagesTo(persistenceId$3, toSequenceNr$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$adapted$1(java.lang.Object java.lang.Object ), org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$_$$anonfun$1(org.apache.pekko.persistence.PersistentEnvelope ), $anonfun$2(scala.collection.immutable.Seq ), $anonfun$3(scala.collection.immutable.Seq ), org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$_$$anonfun$4(int scala.util.Try scala.collection.immutable.Seq ), applyOrElse$$anonfun$2(long org.apache.pekko.actor.ActorRef int scala.collection.immutable.Seq int scala.util.Try ), applyOrElse$$anonfun$3(java.lang.String long ), applyOrElse$$anonfun$adapted$2(long long java.lang.String long org.apache.pekko.actor.ActorRef java.lang.Object ), org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$adapted$3(java.lang.Object ), applyOrElse$$anonfun$6(org.apache.pekko.persistence.JournalProtocol$ReplayMessages org.apache.pekko.actor.DeadLetterSuppression ), applyOrElse$$anonfun$7(java.lang.String long ), org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$8(long scala.runtime.BoxedUnit ), applyOrElse$$anonfun$9(org.apache.pekko.persistence.JournalProtocol$DeleteMessagesTo scala.util.Try ), applyOrElse$$anonfun$2$$anonfun$1$$anonfun$1(int scala.runtime.LongRef org.apache.pekko.actor.ActorRef org.apache.pekko.persistence.PersistentRepr ), applyOrElse$$anonfun$2$$anonfun$1$$anonfun$2(java.lang.Throwable int scala.runtime.LongRef org.apache.pekko.actor.ActorRef org.apache.pekko.persistence.PersistentRepr ), applyOrElse$$anonfun$2$$anonfun$2$$anonfun$1(java.lang.Throwable int scala.runtime.LongRef org.apache.pekko.actor.ActorRef org.apache.pekko.persistence.PersistentRepr ), org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$_$$anonfun$5(), applyOrElse$$anonfun$2$$anonfun$1(scala.collection.Iterator int scala.runtime.LongRef org.apache.pekko.actor.ActorRef org.apache.pekko.persistence.PersistentEnvelope ), applyOrElse$$anonfun$2$$anonfun$2(java.lang.Throwable int scala.runtime.LongRef org.apache.pekko.actor.ActorRef org.apache.pekko.persistence.PersistentEnvelope ), org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$4$$anonfun$1$$anonfun$1(org.apache.pekko.actor.ActorRef org.apache.pekko.persistence.PersistentRepr ), applyOrElse$$anonfun$4$$anonfun$1(org.apache.pekko.actor.ActorRef org.apache.pekko.persistence.PersistentRepr ), org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$4$$anonfun$2(long scala.runtime.BoxedUnit )}, serializedLambda);
            }
        });
    }

    public Persistence org$apache$pekko$persistence$journal$AsyncWriteJournal$$extension();

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$extension_$eq(Persistence var1);

    public boolean org$apache$pekko$persistence$journal$AsyncWriteJournal$$publish();

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$publish_$eq(boolean var1);

    public Config org$apache$pekko$persistence$journal$AsyncWriteJournal$$config();

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$config_$eq(Config var1);

    public CircuitBreaker org$apache$pekko$persistence$journal$AsyncWriteJournal$$breaker();

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$breaker_$eq(CircuitBreaker var1);

    public ReplayFilter.Mode org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMode();

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMode_$eq(ReplayFilter.Mode var1);

    public static boolean org$apache$pekko$persistence$journal$AsyncWriteJournal$$isReplayFilterEnabled$(AsyncWriteJournal $this) {
        return $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$isReplayFilterEnabled();
    }

    default public boolean org$apache$pekko$persistence$journal$AsyncWriteJournal$$isReplayFilterEnabled() {
        ReplayFilter.Mode mode = this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMode();
        ReplayFilter$Disabled$ replayFilter$Disabled$ = ReplayFilter$Disabled$.MODULE$;
        return mode == null ? replayFilter$Disabled$ != null : !mode.equals(replayFilter$Disabled$);
    }

    public int org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterWindowSize();

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterWindowSize_$eq(int var1);

    public int org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMaxOldWriters();

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMaxOldWriters_$eq(int var1);

    public ActorRef org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencer();

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencer_$eq(ActorRef var1);

    public long org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencerCounter();

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencerCounter_$eq(long var1);

    public static PartialFunction receive$(AsyncWriteJournal $this) {
        return $this.receive();
    }

    default public PartialFunction<Object, BoxedUnit> receive() {
        return this.receiveWriteJournal().orElse(this.receivePluginInternal());
    }

    public PartialFunction<Object, BoxedUnit> receiveWriteJournal();

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$receiveWriteJournal_$eq(PartialFunction var1);

    public Future<Seq<Try<BoxedUnit>>> asyncWriteMessages(Seq<AtomicWrite> var1);

    public Future<BoxedUnit> asyncDeleteMessagesTo(String var1, long var2);

    public static PartialFunction receivePluginInternal$(AsyncWriteJournal $this) {
        return $this.receivePluginInternal();
    }

    default public PartialFunction<Object, BoxedUnit> receivePluginInternal() {
        return Actor.emptyBehavior$.MODULE$;
    }

    public static void org$apache$pekko$persistence$journal$AsyncWriteJournal$$_$sendWriteResponse$1$(AsyncWriteJournal $this, boolean enableGlobalWriteResponseOrder$1, Object msg, long snr, ActorRef target, ActorRef sender) {
        $this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$_$sendWriteResponse$1(enableGlobalWriteResponseOrder$1, msg, snr, target, sender);
    }

    @InternalApi
    default public void org$apache$pekko$persistence$journal$AsyncWriteJournal$$_$sendWriteResponse$1(boolean enableGlobalWriteResponseOrder$1, Object msg, long snr, ActorRef target, ActorRef sender) {
        if (enableGlobalWriteResponseOrder$1) {
            this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencer().$bang((Object)AsyncWriteJournal$Desequenced$.MODULE$.apply(msg, snr, target, sender), this.self());
            return;
        }
        target.tell(msg, sender);
    }

    private static /* synthetic */ int applyOrElse$$anonfun$1(int acc, PersistentEnvelope m) {
        return acc + m.size();
    }

    public static /* bridge */ /* synthetic */ int org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$adapted$1(Object acc, Object m) {
        return AsyncWriteJournal.applyOrElse$$anonfun$1(BoxesRunTime.unboxToInt((Object)acc), (PersistentEnvelope)m);
    }

    public static /* synthetic */ boolean org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$_$$anonfun$1(PersistentEnvelope _$1) {
        return _$1 instanceof AtomicWrite;
    }

    public static /* synthetic */ Seq org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$_$$anonfun$4(int atomicWriteCount$1, Try prepared$1, Seq results) {
        if (results.nonEmpty() && results.size() != atomicWriteCount$1) {
            throw new IllegalStateException(new StringBuilder(55).append("asyncWriteMessages returned invalid number of results. ").append(new StringBuilder(23).append("Expected [").append(((SeqOps)prepared$1.get()).size()).append("], but got [").append(results.size()).append("]").toString()).toString());
        }
        return results;
    }

    public static Success org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$_$$anonfun$5() {
        return AsyncWriteJournal$.MODULE$.successUnit();
    }

    public static /* synthetic */ void org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$4$$anonfun$1$$anonfun$1(ActorRef replyTo$3, PersistentRepr adaptedPersistentRepr) {
        replyTo$3.tell((Object)JournalProtocol$ReplayedMessage$.MODULE$.apply(adaptedPersistentRepr), Actor$.MODULE$.noSender());
    }

    public static /* synthetic */ long org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$4$$anonfun$2(long highSeqNr$1, BoxedUnit _$2) {
        return highSeqNr$1;
    }

    public static /* bridge */ /* synthetic */ JournalProtocol.RecoverySuccess org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$adapted$3(Object highSeqNr) {
        return JournalProtocol$RecoverySuccess$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)highSeqNr));
    }

    public static /* synthetic */ DeleteMessagesSuccess org$apache$pekko$persistence$journal$AsyncWriteJournal$$anon$1$$_$applyOrElse$$anonfun$8(long toSequenceNr$3, BoxedUnit _$4) {
        return DeleteMessagesSuccess$.MODULE$.apply(toSequenceNr$3);
    }

    public static final class Desequenced
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final Object msg;
        private final long snr;
        private final ActorRef target;
        private final ActorRef sender;

        public static Desequenced apply(Object object, long l, ActorRef actorRef, ActorRef actorRef2) {
            return AsyncWriteJournal$Desequenced$.MODULE$.apply(object, l, actorRef, actorRef2);
        }

        public static Desequenced fromProduct(Product product) {
            return AsyncWriteJournal$Desequenced$.MODULE$.fromProduct(product);
        }

        public static Desequenced unapply(Desequenced desequenced) {
            return AsyncWriteJournal$Desequenced$.MODULE$.unapply(desequenced);
        }

        public Desequenced(Object msg, long snr, ActorRef target, ActorRef sender) {
            this.msg = msg;
            this.snr = snr;
            this.target = target;
            this.sender = sender;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.msg()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.snr()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.target()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sender()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Desequenced)) return false;
            Desequenced desequenced = (Desequenced)object;
            if (this.snr() != desequenced.snr()) return false;
            if (!BoxesRunTime.equals((Object)this.msg(), (Object)desequenced.msg())) return false;
            ActorRef actorRef = this.target();
            ActorRef actorRef2 = desequenced.target();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            ActorRef actorRef3 = this.sender();
            ActorRef actorRef4 = desequenced.sender();
            if (actorRef3 == null) {
                if (actorRef4 == null) return true;
                return false;
            } else {
                if (!actorRef3.equals(actorRef4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Desequenced;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Desequenced";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "msg";
                }
                case 1: {
                    return "snr";
                }
                case 2: {
                    return "target";
                }
                case 3: {
                    return "sender";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Object msg() {
            return this.msg;
        }

        public long snr() {
            return this.snr;
        }

        public ActorRef target() {
            return this.target;
        }

        public ActorRef sender() {
            return this.sender;
        }

        public Desequenced copy(Object msg, long snr, ActorRef target, ActorRef sender) {
            return new Desequenced(msg, snr, target, sender);
        }

        public Object copy$default$1() {
            return this.msg();
        }

        public long copy$default$2() {
            return this.snr();
        }

        public ActorRef copy$default$3() {
            return this.target();
        }

        public ActorRef copy$default$4() {
            return this.sender();
        }

        public Object _1() {
            return this.msg();
        }

        public long _2() {
            return this.snr();
        }

        public ActorRef _3() {
            return this.target();
        }

        public ActorRef _4() {
            return this.sender();
        }
    }

    public static class Resequencer
    implements Actor {
        private ActorContext context;
        private ActorRef self;
        private final Map<Object, Desequenced> delayed;
        private long delivered;

        public Resequencer() {
            Actor.$init$((Actor)this);
            this.delayed = (Map)Map$.MODULE$.empty();
            this.delivered = 0L;
            Statics.releaseFence();
        }

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
            this.context = x$0;
        }

        public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
            this.self = x$0;
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                private final /* synthetic */ Resequencer $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Object x) {
                    Object object = x;
                    if (object instanceof Desequenced) {
                        Desequenced d = (Desequenced)object;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Object object = x;
                    if (object instanceof Desequenced) {
                        Desequenced d = (Desequenced)object;
                        this.$outer.org$apache$pekko$persistence$journal$AsyncWriteJournal$Resequencer$$resequence(d);
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply(x);
                }
            };
        }

        public void org$apache$pekko$persistence$journal$AsyncWriteJournal$Resequencer$$resequence(Desequenced d) {
            while (true) {
                BoxedUnit boxedUnit;
                if (d.snr() == this.delivered + 1L) {
                    this.delivered = d.snr();
                    d.target().tell(d.msg(), d.sender());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    Long l = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)d.snr()));
                    boxedUnit = this.delayed.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l, (Object)d));
                }
                Option ro = this.delayed.remove((Object)BoxesRunTime.boxToLong((long)(this.delivered + 1L)));
                if (!ro.isDefined()) break;
                d = (Desequenced)ro.get();
            }
        }
    }
}

