/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.LinkedList;
import java.util.UUID;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.DeadLetter$;
import org.apache.pekko.actor.StashOverflowException;
import org.apache.pekko.actor.StashSupport;
import org.apache.pekko.actor.Timers;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.Envelope$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.persistence.AtomicWrite;
import org.apache.pekko.persistence.AtomicWrite$;
import org.apache.pekko.persistence.DeleteMessagesFailure;
import org.apache.pekko.persistence.DeleteMessagesFailure$;
import org.apache.pekko.persistence.DeleteSnapshotFailure;
import org.apache.pekko.persistence.DeleteSnapshotFailure$;
import org.apache.pekko.persistence.DeleteSnapshotsFailure;
import org.apache.pekko.persistence.DeleteSnapshotsFailure$;
import org.apache.pekko.persistence.DiscardToDeadLetterStrategy$;
import org.apache.pekko.persistence.Eventsourced$;
import org.apache.pekko.persistence.Eventsourced$AsyncHandlerInvocation$;
import org.apache.pekko.persistence.Eventsourced$RecoveryTick$;
import org.apache.pekko.persistence.Eventsourced$StashingHandlerInvocation$;
import org.apache.pekko.persistence.JournalProtocol;
import org.apache.pekko.persistence.JournalProtocol$DeleteMessagesTo$;
import org.apache.pekko.persistence.JournalProtocol$LoopMessageSuccess$;
import org.apache.pekko.persistence.JournalProtocol$RecoverySuccess$;
import org.apache.pekko.persistence.JournalProtocol$ReplayMessages$;
import org.apache.pekko.persistence.JournalProtocol$ReplayMessagesFailure$;
import org.apache.pekko.persistence.JournalProtocol$ReplayedMessage$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessageFailure$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessageRejected$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessageSuccess$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessages$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessagesFailed$;
import org.apache.pekko.persistence.JournalProtocol$WriteMessagesSuccessful$;
import org.apache.pekko.persistence.NonPersistentRepr;
import org.apache.pekko.persistence.NonPersistentRepr$;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.Persistence$;
import org.apache.pekko.persistence.PersistenceIdentity;
import org.apache.pekko.persistence.PersistenceRecovery;
import org.apache.pekko.persistence.PersistenceStash;
import org.apache.pekko.persistence.PersistentActor;
import org.apache.pekko.persistence.PersistentEnvelope;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.PersistentRepr$;
import org.apache.pekko.persistence.Recovery;
import org.apache.pekko.persistence.RecoveryCompleted$;
import org.apache.pekko.persistence.RecoveryPermitter$RecoveryPermitGranted$;
import org.apache.pekko.persistence.RecoveryPermitter$RequestRecoveryPermit$;
import org.apache.pekko.persistence.RecoveryPermitter$ReturnRecoveryPermit$;
import org.apache.pekko.persistence.RecoveryTimedOut;
import org.apache.pekko.persistence.ReplyToStrategy;
import org.apache.pekko.persistence.ReplyToStrategy$;
import org.apache.pekko.persistence.RuntimePluginConfig;
import org.apache.pekko.persistence.SaveSnapshotFailure;
import org.apache.pekko.persistence.SaveSnapshotFailure$;
import org.apache.pekko.persistence.SaveSnapshotSuccess;
import org.apache.pekko.persistence.SelectedSnapshot;
import org.apache.pekko.persistence.SelectedSnapshot$;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.SnapshotOffer;
import org.apache.pekko.persistence.SnapshotOffer$;
import org.apache.pekko.persistence.SnapshotProtocol;
import org.apache.pekko.persistence.SnapshotProtocol$LoadSnapshotFailed$;
import org.apache.pekko.persistence.SnapshotProtocol$LoadSnapshotResult$;
import org.apache.pekko.persistence.SnapshotSelectionCriteria;
import org.apache.pekko.persistence.Snapshotter;
import org.apache.pekko.persistence.StashOverflowStrategy;
import org.apache.pekko.persistence.ThrowOverflowExceptionStrategy$;
import org.apache.pekko.persistence.TraitOrder$;
import org.apache.pekko.util.Helpers;
import org.apache.pekko.util.Helpers$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public interface Eventsourced
extends Snapshotter,
PersistenceStash,
PersistenceIdentity,
PersistenceRecovery {
    public static void $init$(Eventsourced $this) {
        Config config;
        TraitOrder$.MODULE$.checkBefore($this.getClass(), Timers.class, PersistentActor.class);
        $this.org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$extension_$eq((Persistence)Persistence$.MODULE$.apply($this.context().system()));
        $this.org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$instanceId_$eq(Eventsourced$.org$apache$pekko$persistence$Eventsourced$$$instanceIdCounter.getAndIncrement());
        $this.org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$writerUuid_$eq(UUID.randomUUID().toString());
        $this.org$apache$pekko$persistence$Eventsourced$$journalBatch_$eq((Vector<PersistentEnvelope>)package$.MODULE$.Vector().empty());
        Eventsourced eventsourced = $this;
        if (eventsourced instanceof RuntimePluginConfig) {
            Eventsourced c = (Eventsourced)((Object)((RuntimePluginConfig)((Object)eventsourced)));
            config = ((RuntimePluginConfig)((Object)c)).journalPluginConfig();
        } else {
            config = ConfigFactory.empty();
        }
        Config journalPluginConfig = config;
        $this.org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$maxMessageBatchSize_$eq($this.org$apache$pekko$persistence$Eventsourced$$extension().journalConfigFor($this.journalPluginId(), journalPluginConfig).getInt("max-message-batch-size"));
        $this.org$apache$pekko$persistence$Eventsourced$$writeInProgress_$eq(false);
        $this.org$apache$pekko$persistence$Eventsourced$$sequenceNr_$eq(0L);
        $this.org$apache$pekko$persistence$Eventsourced$$_lastSequenceNr_$eq(0L);
        $this.org$apache$pekko$persistence$Eventsourced$$currentState_$eq(null);
        $this.org$apache$pekko$persistence$Eventsourced$$pendingStashingPersistInvocations_$eq(0L);
        $this.org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$pendingInvocations_$eq(new LinkedList());
        $this.org$apache$pekko$persistence$Eventsourced$$eventBatch_$eq((List<PersistentEnvelope>)package$.MODULE$.Nil());
        $this.org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$internalStash_$eq($this.createStash($this.context(), $this.self()));
        $this.org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$unstashFilterPredicate_$eq((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof JournalProtocol.WriteMessageSuccess) {
                return false;
            }
            return !(object instanceof JournalProtocol.ReplayedMessage);
        });
        $this.org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$processingCommands_$eq(new ProcessingState($this){
            private final /* synthetic */ Eventsourced $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public String toString() {
                return "processing commands";
            }

            public void stateReceive(PartialFunction receive, Object message) {
                if (this.common().isDefinedAt(message)) {
                    this.common().apply(message);
                    return;
                }
                try {
                    this.$outer.org$apache$pekko$persistence$Eventsourced$$super$aroundReceive(receive, message);
                    this.aroundReceiveComplete(false);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable e = throwable3 = (Throwable)option.get();
                        this.aroundReceiveComplete(true);
                        throw e;
                    }
                    throw throwable;
                }
            }

            private void aroundReceiveComplete(boolean err) {
                if (this.$outer.org$apache$pekko$persistence$Eventsourced$$eventBatch().nonEmpty()) {
                    this.$outer.org$apache$pekko$persistence$Eventsourced$$flushBatch();
                }
                if (this.$outer.org$apache$pekko$persistence$Eventsourced$$pendingStashingPersistInvocations() > 0L) {
                    this.$outer.org$apache$pekko$persistence$Eventsourced$$changeState(this.$outer.org$apache$pekko$persistence$Eventsourced$$persistingEvents());
                    return;
                }
                this.$outer.org$apache$pekko$persistence$Eventsourced$$unstashInternally(err);
            }

            public void onWriteMessageComplete(boolean err) {
                this.$outer.org$apache$pekko$persistence$Eventsourced$$pendingInvocations().pop();
                this.$outer.org$apache$pekko$persistence$Eventsourced$$unstashInternally(err);
            }
        });
        $this.org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$persistingEvents_$eq(new ProcessingState($this){
            private final /* synthetic */ Eventsourced $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public String toString() {
                return "persisting events";
            }

            public void stateReceive(PartialFunction receive, Object message) {
                if (this.common().isDefinedAt(message)) {
                    this.common().apply(message);
                    return;
                }
                this.$outer.org$apache$pekko$persistence$Eventsourced$$stashInternally(message);
            }

            public void onWriteMessageComplete(boolean err) {
                PendingHandlerInvocation pendingHandlerInvocation = this.$outer.org$apache$pekko$persistence$Eventsourced$$pendingInvocations().pop();
                if (pendingHandlerInvocation instanceof StashingHandlerInvocation) {
                    this.$outer.org$apache$pekko$persistence$Eventsourced$$pendingStashingPersistInvocations_$eq(this.$outer.org$apache$pekko$persistence$Eventsourced$$pendingStashingPersistInvocations() - 1L);
                }
                if (this.$outer.org$apache$pekko$persistence$Eventsourced$$pendingStashingPersistInvocations() == 0L) {
                    this.$outer.org$apache$pekko$persistence$Eventsourced$$changeState(this.$outer.org$apache$pekko$persistence$Eventsourced$$processingCommands());
                    this.$outer.org$apache$pekko$persistence$Eventsourced$$unstashInternally(err);
                    return;
                }
            }
        });
    }

    public /* synthetic */ void org$apache$pekko$persistence$Eventsourced$$super$aroundPreStart();

    public /* synthetic */ void org$apache$pekko$persistence$Eventsourced$$super$aroundPreRestart(Throwable var1, Option var2);

    public /* synthetic */ void org$apache$pekko$persistence$Eventsourced$$super$aroundPostRestart(Throwable var1);

    public /* synthetic */ void org$apache$pekko$persistence$Eventsourced$$super$aroundPostStop();

    public /* synthetic */ void org$apache$pekko$persistence$Eventsourced$$super$unhandled(Object var1);

    public /* synthetic */ void org$apache$pekko$persistence$Eventsourced$$super$stash();

    public /* synthetic */ void org$apache$pekko$persistence$Eventsourced$$super$aroundReceive(PartialFunction var1, Object var2);

    public Persistence org$apache$pekko$persistence$Eventsourced$$extension();

    public void org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$extension_$eq(Persistence var1);

    public static ActorRef journal$(Eventsourced $this) {
        return $this.journal();
    }

    default public ActorRef journal() {
        Config config;
        Eventsourced eventsourced = this;
        if (eventsourced instanceof RuntimePluginConfig) {
            Eventsourced c = (Eventsourced)((Object)((RuntimePluginConfig)((Object)eventsourced)));
            config = ((RuntimePluginConfig)((Object)c)).journalPluginConfig();
        } else {
            config = ConfigFactory.empty();
        }
        Config journalPluginConfig = config;
        return this.org$apache$pekko$persistence$Eventsourced$$extension().journalFor(this.journalPluginId(), journalPluginConfig);
    }

    public static ActorRef snapshotStore$(Eventsourced $this) {
        return $this.snapshotStore();
    }

    @Override
    default public ActorRef snapshotStore() {
        Config config;
        Eventsourced eventsourced = this;
        if (eventsourced instanceof RuntimePluginConfig) {
            Eventsourced c = (Eventsourced)((Object)((RuntimePluginConfig)((Object)eventsourced)));
            config = ((RuntimePluginConfig)((Object)c)).snapshotPluginConfig();
        } else {
            config = ConfigFactory.empty();
        }
        Config snapshotPluginConfig = config;
        return this.org$apache$pekko$persistence$Eventsourced$$extension().snapshotStoreFor(this.snapshotPluginId(), snapshotPluginConfig);
    }

    public int org$apache$pekko$persistence$Eventsourced$$instanceId();

    public void org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$instanceId_$eq(int var1);

    public String org$apache$pekko$persistence$Eventsourced$$writerUuid();

    public void org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$writerUuid_$eq(String var1);

    public Vector<PersistentEnvelope> org$apache$pekko$persistence$Eventsourced$$journalBatch();

    public void org$apache$pekko$persistence$Eventsourced$$journalBatch_$eq(Vector<PersistentEnvelope> var1);

    public int org$apache$pekko$persistence$Eventsourced$$maxMessageBatchSize();

    public void org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$maxMessageBatchSize_$eq(int var1);

    public boolean org$apache$pekko$persistence$Eventsourced$$writeInProgress();

    public void org$apache$pekko$persistence$Eventsourced$$writeInProgress_$eq(boolean var1);

    public long org$apache$pekko$persistence$Eventsourced$$sequenceNr();

    public void org$apache$pekko$persistence$Eventsourced$$sequenceNr_$eq(long var1);

    public long org$apache$pekko$persistence$Eventsourced$$_lastSequenceNr();

    public void org$apache$pekko$persistence$Eventsourced$$_lastSequenceNr_$eq(long var1);

    public State org$apache$pekko$persistence$Eventsourced$$currentState();

    public void org$apache$pekko$persistence$Eventsourced$$currentState_$eq(State var1);

    public long org$apache$pekko$persistence$Eventsourced$$pendingStashingPersistInvocations();

    public void org$apache$pekko$persistence$Eventsourced$$pendingStashingPersistInvocations_$eq(long var1);

    public LinkedList<PendingHandlerInvocation> org$apache$pekko$persistence$Eventsourced$$pendingInvocations();

    public void org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$pendingInvocations_$eq(LinkedList var1);

    public List<PersistentEnvelope> org$apache$pekko$persistence$Eventsourced$$eventBatch();

    public void org$apache$pekko$persistence$Eventsourced$$eventBatch_$eq(List<PersistentEnvelope> var1);

    public StashSupport org$apache$pekko$persistence$Eventsourced$$internalStash();

    public void org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$internalStash_$eq(StashSupport var1);

    public Function1<Object, Object> org$apache$pekko$persistence$Eventsourced$$unstashFilterPredicate();

    public void org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$unstashFilterPredicate_$eq(Function1 var1);

    public static String snapshotterId$(Eventsourced $this) {
        return $this.snapshotterId();
    }

    @Override
    default public String snapshotterId() {
        return this.persistenceId();
    }

    public static long lastSequenceNr$(Eventsourced $this) {
        return $this.lastSequenceNr();
    }

    default public long lastSequenceNr() {
        return this.org$apache$pekko$persistence$Eventsourced$$_lastSequenceNr();
    }

    public static long snapshotSequenceNr$(Eventsourced $this) {
        return $this.snapshotSequenceNr();
    }

    @Override
    default public long snapshotSequenceNr() {
        return this.lastSequenceNr();
    }

    public static void onReplaySuccess$(Eventsourced $this) {
        $this.onReplaySuccess();
    }

    @InternalStableApi
    default public void onReplaySuccess() {
    }

    public static void onRecoveryFailure$(Eventsourced $this, Throwable cause, Option event) {
        $this.onRecoveryFailure(cause, (Option<Object>)event);
    }

    default public void onRecoveryFailure(Throwable cause, Option<Object> event) {
        Option<Object> option = event;
        if (option instanceof Some) {
            Object evt = ((Some)option).value();
            this.org$apache$pekko$persistence$Eventsourced$$log().error(cause, "Exception in receiveRecover when replaying event type [{}] with sequence number [{}] for persistenceId [{}].", (Object)evt.getClass().getName(), (Object)BoxesRunTime.boxToLong((long)this.lastSequenceNr()), (Object)this.persistenceId());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.org$apache$pekko$persistence$Eventsourced$$log().error(cause, "Persistence failure when replaying events for persistenceId [{}]. Last known sequence number [{}]", (Object)this.persistenceId(), (Object)BoxesRunTime.boxToLong((long)this.lastSequenceNr()));
            return;
        }
        throw new MatchError(option);
    }

    public static void onPersistFailure$(Eventsourced $this, Throwable cause, Object event, long seqNr) {
        $this.onPersistFailure(cause, event, seqNr);
    }

    @InternalStableApi
    default public void onPersistFailure(Throwable cause, Object event, long seqNr) {
        this.org$apache$pekko$persistence$Eventsourced$$log().error(cause, "Failed to persist event type [{}] with sequence number [{}] for persistenceId [{}].", (Object)event.getClass().getName(), (Object)BoxesRunTime.boxToLong((long)seqNr), (Object)this.persistenceId());
    }

    public static void onPersistRejected$(Eventsourced $this, Throwable cause, Object event, long seqNr) {
        $this.onPersistRejected(cause, event, seqNr);
    }

    @InternalStableApi
    default public void onPersistRejected(Throwable cause, Object event, long seqNr) {
        this.org$apache$pekko$persistence$Eventsourced$$log().error(cause, "Rejected to persist event type [{}] with sequence number [{}] for persistenceId [{}] due to [{}].", (Object)event.getClass().getName(), (Object)BoxesRunTime.boxToLong((long)seqNr), (Object)this.persistenceId(), (Object)cause.getMessage());
    }

    public static void org$apache$pekko$persistence$Eventsourced$$stashInternally$(Eventsourced $this, Object currMsg) {
        $this.org$apache$pekko$persistence$Eventsourced$$stashInternally(currMsg);
    }

    default public void org$apache$pekko$persistence$Eventsourced$$stashInternally(Object currMsg) {
        try {
            this.org$apache$pekko$persistence$Eventsourced$$internalStash().stash();
        }
        catch (StashOverflowException e) {
            StashOverflowStrategy stashOverflowStrategy = this.internalStashOverflowStrategy();
            if (DiscardToDeadLetterStrategy$.MODULE$.equals(stashOverflowStrategy)) {
                ActorRef snd = this.sender();
                this.context().system().deadLetters().tell((Object)DeadLetter$.MODULE$.apply(currMsg, snd, this.self()), snd);
            }
            if (stashOverflowStrategy instanceof ReplyToStrategy) {
                Object object;
                ReplyToStrategy replyToStrategy = ReplyToStrategy$.MODULE$.unapply((ReplyToStrategy)stashOverflowStrategy);
                Object response = object = replyToStrategy._1();
                this.sender().$bang(response, this.self());
            }
            if (ThrowOverflowExceptionStrategy$.MODULE$.equals(stashOverflowStrategy)) {
                throw e;
            }
            throw new MatchError((Object)stashOverflowStrategy);
        }
    }

    public static void org$apache$pekko$persistence$Eventsourced$$unstashInternally$(Eventsourced $this, boolean all) {
        $this.org$apache$pekko$persistence$Eventsourced$$unstashInternally(all);
    }

    default public void org$apache$pekko$persistence$Eventsourced$$unstashInternally(boolean all) {
        if (all) {
            this.org$apache$pekko$persistence$Eventsourced$$internalStash().unstashAll();
            return;
        }
        this.org$apache$pekko$persistence$Eventsourced$$internalStash().unstash();
    }

    public static void org$apache$pekko$persistence$Eventsourced$$startRecovery$(Eventsourced $this, Recovery recovery) {
        $this.org$apache$pekko$persistence$Eventsourced$$startRecovery(recovery);
    }

    @InternalStableApi
    default public void org$apache$pekko$persistence$Eventsourced$$startRecovery(Recovery recovery) {
        Config config;
        Eventsourced eventsourced = this;
        if (eventsourced instanceof RuntimePluginConfig) {
            Eventsourced c = (Eventsourced)((Object)((RuntimePluginConfig)((Object)eventsourced)));
            config = ((RuntimePluginConfig)((Object)c)).journalPluginConfig();
        } else {
            config = ConfigFactory.empty();
        }
        Config journalPluginConfig = config;
        FiniteDuration timeout = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$persistence$Eventsourced$$extension().journalConfigFor(this.journalPluginId(), journalPluginConfig)), "recovery-event-timeout");
        this.org$apache$pekko$persistence$Eventsourced$$changeState(this.recoveryStarted(recovery.replayMax(), timeout));
        this.loadSnapshot(this.snapshotterId(), recovery.fromSnapshot(), recovery.toSequenceNr());
    }

    public static void aroundReceive$(Eventsourced $this, PartialFunction receive, Object message) {
        $this.aroundReceive((PartialFunction<Object, BoxedUnit>)receive, message);
    }

    default public void aroundReceive(PartialFunction<Object, BoxedUnit> receive, Object message) {
        this.org$apache$pekko$persistence$Eventsourced$$currentState().stateReceive(receive, message);
    }

    public static void aroundPreStart$(Eventsourced $this) {
        $this.aroundPreStart();
    }

    default public void aroundPreStart() {
        Predef$.MODULE$.require(this.persistenceId() != null, this::aroundPreStart$$anonfun$1);
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.persistenceId().trim())), this::aroundPreStart$$anonfun$2);
        this.journal();
        this.snapshotStore();
        this.requestRecoveryPermit();
        this.org$apache$pekko$persistence$Eventsourced$$super$aroundPreStart();
    }

    private void requestRecoveryPermit() {
        this.org$apache$pekko$persistence$Eventsourced$$extension().recoveryPermitter().tell((Object)RecoveryPermitter$RequestRecoveryPermit$.MODULE$, this.self());
        this.org$apache$pekko$persistence$Eventsourced$$changeState(this.waitingRecoveryPermit(this.recovery()));
    }

    public static void aroundPreRestart$(Eventsourced $this, Throwable reason, Option message) {
        $this.aroundPreRestart(reason, (Option<Object>)message);
    }

    /*
     * Unable to fully structure code
     */
    default public void aroundPreRestart(Throwable reason, Option<Object> message) {
        try {
            this.org$apache$pekko$persistence$Eventsourced$$internalStash().unstashAll();
            this.unstashAll(this.org$apache$pekko$persistence$Eventsourced$$unstashFilterPredicate());
        }
        finally {
            var4_5 = message;
            if (!(var4_5 instanceof Some)) ** GOTO lbl-1000
            var5_7 = ((Some)var4_5).value();
            if (var5_7 instanceof JournalProtocol.WriteMessageSuccess) {
                var6_9 = JournalProtocol$WriteMessageSuccess$.MODULE$.unapply((JournalProtocol.WriteMessageSuccess)var5_7);
                var7_11 = var6_9._1();
                var8_13 = var6_9._2();
                m = var7_11;
                this.org$apache$pekko$persistence$Eventsourced$$flushJournalBatch();
                this.org$apache$pekko$persistence$Eventsourced$$super$aroundPreRestart(reason, (Option)Some$.MODULE$.apply((Object)m));
            } else if (var5_7 instanceof JournalProtocol.LoopMessageSuccess) {
                var10_17 = JournalProtocol$LoopMessageSuccess$.MODULE$.unapply((JournalProtocol.LoopMessageSuccess)var5_7);
                var11_19 = var10_17._1();
                var12_21 = var10_17._2();
                m = var11_19;
                this.org$apache$pekko$persistence$Eventsourced$$flushJournalBatch();
                this.org$apache$pekko$persistence$Eventsourced$$super$aroundPreRestart(reason, (Option)Some$.MODULE$.apply(m));
            } else if (var5_7 instanceof JournalProtocol.ReplayedMessage) {
                var14_25 = JournalProtocol$ReplayedMessage$.MODULE$.unapply((JournalProtocol.ReplayedMessage)var5_7);
                m = var15_27 = var14_25._1();
                this.org$apache$pekko$persistence$Eventsourced$$flushJournalBatch();
                this.org$apache$pekko$persistence$Eventsourced$$super$aroundPreRestart(reason, (Option)Some$.MODULE$.apply((Object)m));
            } else lbl-1000:
            // 2 sources

            {
                mo = var4_5;
                this.org$apache$pekko$persistence$Eventsourced$$flushJournalBatch();
                this.org$apache$pekko$persistence$Eventsourced$$super$aroundPreRestart(reason, mo);
            }
        }
    }

    public static void aroundPostRestart$(Eventsourced $this, Throwable reason) {
        $this.aroundPostRestart(reason);
    }

    default public void aroundPostRestart(Throwable reason) {
        this.requestRecoveryPermit();
        this.org$apache$pekko$persistence$Eventsourced$$super$aroundPostRestart(reason);
    }

    public static void aroundPostStop$(Eventsourced $this) {
        $this.aroundPostStop();
    }

    default public void aroundPostStop() {
        try {
            this.org$apache$pekko$persistence$Eventsourced$$internalStash().unstashAll();
            this.unstashAll(this.org$apache$pekko$persistence$Eventsourced$$unstashFilterPredicate());
        }
        finally {
            this.org$apache$pekko$persistence$Eventsourced$$super$aroundPostStop();
        }
    }

    public static void unhandled$(Eventsourced $this, Object message) {
        $this.unhandled(message);
    }

    default public void unhandled(Object message) {
        Object object = message;
        if (RecoveryCompleted$.MODULE$.equals(object)) {
            return;
        }
        if (object instanceof SaveSnapshotFailure) {
            SaveSnapshotFailure saveSnapshotFailure = SaveSnapshotFailure$.MODULE$.unapply((SaveSnapshotFailure)object);
            SnapshotMetadata snapshotMetadata = saveSnapshotFailure._1();
            Throwable throwable = saveSnapshotFailure._2();
            SnapshotMetadata m = snapshotMetadata;
            Throwable e = throwable;
            this.org$apache$pekko$persistence$Eventsourced$$log().warning("Failed to saveSnapshot given metadata [{}] due to: [{}: {}]", (Object)m, (Object)e.getClass().getCanonicalName(), (Object)e.getMessage());
            return;
        }
        if (object instanceof DeleteSnapshotFailure) {
            DeleteSnapshotFailure deleteSnapshotFailure = DeleteSnapshotFailure$.MODULE$.unapply((DeleteSnapshotFailure)object);
            SnapshotMetadata snapshotMetadata = deleteSnapshotFailure._1();
            Throwable throwable = deleteSnapshotFailure._2();
            SnapshotMetadata m = snapshotMetadata;
            Throwable e = throwable;
            this.org$apache$pekko$persistence$Eventsourced$$log().warning("Failed to deleteSnapshot given metadata [{}] due to: [{}: {}]", (Object)m, (Object)e.getClass().getCanonicalName(), (Object)e.getMessage());
            return;
        }
        if (object instanceof DeleteSnapshotsFailure) {
            DeleteSnapshotsFailure deleteSnapshotsFailure = DeleteSnapshotsFailure$.MODULE$.unapply((DeleteSnapshotsFailure)object);
            SnapshotSelectionCriteria snapshotSelectionCriteria = deleteSnapshotsFailure._1();
            Throwable throwable = deleteSnapshotsFailure._2();
            SnapshotSelectionCriteria c = snapshotSelectionCriteria;
            Throwable e = throwable;
            this.org$apache$pekko$persistence$Eventsourced$$log().warning("Failed to deleteSnapshots given criteria [{}] due to: [{}: {}]", (Object)c, (Object)e.getClass().getCanonicalName(), (Object)e.getMessage());
            return;
        }
        if (object instanceof DeleteMessagesFailure) {
            DeleteMessagesFailure deleteMessagesFailure = DeleteMessagesFailure$.MODULE$.unapply((DeleteMessagesFailure)object);
            Throwable throwable = deleteMessagesFailure._1();
            long l = deleteMessagesFailure._2();
            Throwable e = throwable;
            long toSequenceNr = l;
            this.org$apache$pekko$persistence$Eventsourced$$log().warning("Failed to deleteMessages toSequenceNr [{}] for persistenceId [{}] due to [{}: {}].", (Object)BoxesRunTime.boxToLong((long)toSequenceNr), (Object)this.persistenceId(), (Object)e.getClass().getCanonicalName(), (Object)e.getMessage());
            return;
        }
        Object m = object;
        this.org$apache$pekko$persistence$Eventsourced$$super$unhandled(m);
    }

    public static void org$apache$pekko$persistence$Eventsourced$$changeState$(Eventsourced $this, State state) {
        $this.org$apache$pekko$persistence$Eventsourced$$changeState(state);
    }

    default public void org$apache$pekko$persistence$Eventsourced$$changeState(State state) {
        this.org$apache$pekko$persistence$Eventsourced$$currentState_$eq(state);
    }

    public static void org$apache$pekko$persistence$Eventsourced$$updateLastSequenceNr$(Eventsourced $this, PersistentRepr persistent) {
        $this.org$apache$pekko$persistence$Eventsourced$$updateLastSequenceNr(persistent);
    }

    default public void org$apache$pekko$persistence$Eventsourced$$updateLastSequenceNr(PersistentRepr persistent) {
        if (persistent.sequenceNr() > this.org$apache$pekko$persistence$Eventsourced$$_lastSequenceNr()) {
            this.org$apache$pekko$persistence$Eventsourced$$_lastSequenceNr_$eq(persistent.sequenceNr());
            return;
        }
    }

    public static void org$apache$pekko$persistence$Eventsourced$$setLastSequenceNr$(Eventsourced $this, long value) {
        $this.org$apache$pekko$persistence$Eventsourced$$setLastSequenceNr(value);
    }

    default public void org$apache$pekko$persistence$Eventsourced$$setLastSequenceNr(long value) {
        this.org$apache$pekko$persistence$Eventsourced$$_lastSequenceNr_$eq(value);
    }

    private long nextSequenceNr() {
        this.org$apache$pekko$persistence$Eventsourced$$sequenceNr_$eq(this.org$apache$pekko$persistence$Eventsourced$$sequenceNr() + 1L);
        return this.org$apache$pekko$persistence$Eventsourced$$sequenceNr();
    }

    public static void org$apache$pekko$persistence$Eventsourced$$flushJournalBatch$(Eventsourced $this) {
        $this.org$apache$pekko$persistence$Eventsourced$$flushJournalBatch();
    }

    default public void org$apache$pekko$persistence$Eventsourced$$flushJournalBatch() {
        if (!this.org$apache$pekko$persistence$Eventsourced$$writeInProgress() && this.org$apache$pekko$persistence$Eventsourced$$journalBatch().nonEmpty()) {
            this.sendBatchedEventsToJournal(this.org$apache$pekko$persistence$Eventsourced$$journalBatch());
            this.org$apache$pekko$persistence$Eventsourced$$journalBatch_$eq((Vector<PersistentEnvelope>)package$.MODULE$.Vector().empty());
            this.org$apache$pekko$persistence$Eventsourced$$writeInProgress_$eq(true);
            return;
        }
    }

    @InternalStableApi
    private void sendBatchedEventsToJournal(Vector<PersistentEnvelope> journalBatch) {
        this.journal().$bang((Object)JournalProtocol$WriteMessages$.MODULE$.apply((Seq<PersistentEnvelope>)journalBatch, this.self(), this.org$apache$pekko$persistence$Eventsourced$$instanceId()), this.self());
    }

    public static LoggingAdapter org$apache$pekko$persistence$Eventsourced$$log$(Eventsourced $this) {
        return $this.org$apache$pekko$persistence$Eventsourced$$log();
    }

    default public LoggingAdapter org$apache$pekko$persistence$Eventsourced$$log() {
        return Logging$.MODULE$.apply(this.context().system(), (Object)this, LogSource$.MODULE$.fromActor());
    }

    public PartialFunction<Object, BoxedUnit> receiveRecover();

    public PartialFunction<Object, BoxedUnit> receiveCommand();

    public static void internalPersist$(Eventsourced $this, Object event, Function1 handler) {
        $this.internalPersist(event, handler);
    }

    @InternalApi
    default public <A> void internalPersist(A event, Function1<A, BoxedUnit> handler) {
        if (this.recoveryRunning()) {
            throw new IllegalStateException("Cannot persist during replay. Events can be persisted when receiving RecoveryCompleted or later.");
        }
        this.org$apache$pekko$persistence$Eventsourced$$pendingStashingPersistInvocations_$eq(this.org$apache$pekko$persistence$Eventsourced$$pendingStashingPersistInvocations() + 1L);
        this.org$apache$pekko$persistence$Eventsourced$$pendingInvocations().addLast(Eventsourced$StashingHandlerInvocation$.MODULE$.apply(event, handler));
        String string = this.persistenceId();
        long l = this.nextSequenceNr();
        ActorRef actorRef = this.sender();
        String string2 = PersistentRepr$.MODULE$.apply$default$4();
        boolean bl = PersistentRepr$.MODULE$.apply$default$5();
        this.batchAtomicWrite(AtomicWrite$.MODULE$.apply(PersistentRepr$.MODULE$.apply(event, l, string, string2, bl, actorRef, this.org$apache$pekko$persistence$Eventsourced$$writerUuid())));
    }

    public static void internalPersistAll$(Eventsourced $this, Seq events, Function1 handler) {
        $this.internalPersistAll(events, handler);
    }

    @InternalApi
    default public <A> void internalPersistAll(Seq<A> events, Function1<A, BoxedUnit> handler) {
        if (this.recoveryRunning()) {
            throw new IllegalStateException("Cannot persist during replay. Events can be persisted when receiving RecoveryCompleted or later.");
        }
        if (events.nonEmpty()) {
            events.foreach((Function1)(JProcedure1 & Serializable)event -> {
                this.org$apache$pekko$persistence$Eventsourced$$pendingStashingPersistInvocations_$eq(this.org$apache$pekko$persistence$Eventsourced$$pendingStashingPersistInvocations() + 1L);
                this.org$apache$pekko$persistence$Eventsourced$$pendingInvocations().addLast(Eventsourced$StashingHandlerInvocation$.MODULE$.apply(event, (Function1<Object, BoxedUnit>)handler));
            });
            this.batchAtomicWrite(AtomicWrite$.MODULE$.apply((Seq<PersistentRepr>)((Seq)events.map((Function1 & Serializable)_$1 -> {
                String string = this.persistenceId();
                long l = this.nextSequenceNr();
                ActorRef actorRef = this.sender();
                String string2 = PersistentRepr$.MODULE$.apply$default$4();
                boolean bl = PersistentRepr$.MODULE$.apply$default$5();
                return PersistentRepr$.MODULE$.apply(_$1, l, string, string2, bl, actorRef, this.org$apache$pekko$persistence$Eventsourced$$writerUuid());
            }))));
            return;
        }
    }

    @InternalStableApi
    private void batchAtomicWrite(AtomicWrite atomicWrite) {
        this.org$apache$pekko$persistence$Eventsourced$$eventBatch_$eq((List<PersistentEnvelope>)this.org$apache$pekko$persistence$Eventsourced$$eventBatch().$colon$colon((Object)atomicWrite));
    }

    public static void internalPersistAsync$(Eventsourced $this, Object event, Function1 handler) {
        $this.internalPersistAsync(event, handler);
    }

    @InternalApi
    default public <A> void internalPersistAsync(A event, Function1<A, BoxedUnit> handler) {
        if (this.recoveryRunning()) {
            throw new IllegalStateException("Cannot persist during replay. Events can be persisted when receiving RecoveryCompleted or later.");
        }
        this.org$apache$pekko$persistence$Eventsourced$$pendingInvocations().addLast(Eventsourced$AsyncHandlerInvocation$.MODULE$.apply(event, handler));
        String string = this.persistenceId();
        long l = this.nextSequenceNr();
        ActorRef actorRef = this.sender();
        String string2 = PersistentRepr$.MODULE$.apply$default$4();
        boolean bl = PersistentRepr$.MODULE$.apply$default$5();
        this.org$apache$pekko$persistence$Eventsourced$$eventBatch_$eq((List<PersistentEnvelope>)this.org$apache$pekko$persistence$Eventsourced$$eventBatch().$colon$colon((Object)AtomicWrite$.MODULE$.apply(PersistentRepr$.MODULE$.apply(event, l, string, string2, bl, actorRef, this.org$apache$pekko$persistence$Eventsourced$$writerUuid()))));
    }

    public static void internalPersistAllAsync$(Eventsourced $this, Seq events, Function1 handler) {
        $this.internalPersistAllAsync(events, handler);
    }

    @InternalApi
    default public <A> void internalPersistAllAsync(Seq<A> events, Function1<A, BoxedUnit> handler) {
        if (this.recoveryRunning()) {
            throw new IllegalStateException("Cannot persist during replay. Events can be persisted when receiving RecoveryCompleted or later.");
        }
        if (events.nonEmpty()) {
            events.foreach((Function1)(JProcedure1 & Serializable)event -> this.org$apache$pekko$persistence$Eventsourced$$pendingInvocations().addLast(Eventsourced$AsyncHandlerInvocation$.MODULE$.apply(event, (Function1<Object, BoxedUnit>)handler)));
            this.org$apache$pekko$persistence$Eventsourced$$eventBatch_$eq((List<PersistentEnvelope>)this.org$apache$pekko$persistence$Eventsourced$$eventBatch().$colon$colon((Object)AtomicWrite$.MODULE$.apply((Seq<PersistentRepr>)((Seq)events.map((Function1 & Serializable)_$2 -> {
                String string = this.persistenceId();
                long l = this.nextSequenceNr();
                ActorRef actorRef = this.sender();
                String string2 = PersistentRepr$.MODULE$.apply$default$4();
                boolean bl = PersistentRepr$.MODULE$.apply$default$5();
                return PersistentRepr$.MODULE$.apply(_$2, l, string, string2, bl, actorRef, this.org$apache$pekko$persistence$Eventsourced$$writerUuid());
            })))));
            return;
        }
    }

    public static void internalDeferAsync$(Eventsourced $this, Object event, Function1 handler) {
        $this.internalDeferAsync(event, handler);
    }

    @InternalApi
    default public <A> void internalDeferAsync(A event, Function1<A, BoxedUnit> handler) {
        if (this.recoveryRunning()) {
            throw new IllegalStateException("Cannot defer during replay. Events can be deferred when receiving RecoveryCompleted or later.");
        }
        if (this.org$apache$pekko$persistence$Eventsourced$$pendingInvocations().isEmpty()) {
            handler.apply(event);
            return;
        }
        this.org$apache$pekko$persistence$Eventsourced$$pendingInvocations().addLast(Eventsourced$AsyncHandlerInvocation$.MODULE$.apply(event, handler));
        NonPersistentRepr nonPersistentRepr = NonPersistentRepr$.MODULE$.apply(event, this.sender());
        this.org$apache$pekko$persistence$Eventsourced$$eventBatch_$eq((List<PersistentEnvelope>)this.org$apache$pekko$persistence$Eventsourced$$eventBatch().$colon$colon((Object)nonPersistentRepr));
    }

    public static void internalDefer$(Eventsourced $this, Object event, Function1 handler) {
        $this.internalDefer(event, handler);
    }

    @InternalApi
    default public <A> void internalDefer(A event, Function1<A, BoxedUnit> handler) {
        if (this.recoveryRunning()) {
            throw new IllegalStateException("Cannot defer during replay. Events can be deferred when receiving RecoveryCompleted or later.");
        }
        if (this.org$apache$pekko$persistence$Eventsourced$$pendingInvocations().isEmpty()) {
            handler.apply(event);
            return;
        }
        this.org$apache$pekko$persistence$Eventsourced$$pendingStashingPersistInvocations_$eq(this.org$apache$pekko$persistence$Eventsourced$$pendingStashingPersistInvocations() + 1L);
        this.org$apache$pekko$persistence$Eventsourced$$pendingInvocations().addLast(Eventsourced$StashingHandlerInvocation$.MODULE$.apply(event, handler));
        NonPersistentRepr nonPersistentRepr = NonPersistentRepr$.MODULE$.apply(event, this.sender());
        this.org$apache$pekko$persistence$Eventsourced$$eventBatch_$eq((List<PersistentEnvelope>)this.org$apache$pekko$persistence$Eventsourced$$eventBatch().$colon$colon((Object)nonPersistentRepr));
    }

    public static void deleteMessages$(Eventsourced $this, long toSequenceNr) {
        $this.deleteMessages(toSequenceNr);
    }

    default public void deleteMessages(long toSequenceNr) {
        if (toSequenceNr == Long.MAX_VALUE || toSequenceNr <= this.lastSequenceNr()) {
            this.journal().$bang((Object)JournalProtocol$DeleteMessagesTo$.MODULE$.apply(this.persistenceId(), toSequenceNr, this.self()), this.self());
            return;
        }
        this.self().$bang((Object)DeleteMessagesFailure$.MODULE$.apply(new RuntimeException(new StringBuilder(63).append("toSequenceNr [").append(toSequenceNr).append("] must be less than or equal to lastSequenceNr [").append(this.lastSequenceNr()).append("]").toString()), toSequenceNr), this.self());
    }

    public static void internalDeleteMessagesBeforeSnapshot$(Eventsourced $this, SaveSnapshotSuccess e, int keepNrOfBatches, int snapshotAfter) {
        $this.internalDeleteMessagesBeforeSnapshot(e, keepNrOfBatches, snapshotAfter);
    }

    @InternalApi
    default public void internalDeleteMessagesBeforeSnapshot(SaveSnapshotSuccess e, int keepNrOfBatches, int snapshotAfter) {
        long sequenceNr = e.metadata().sequenceNr() - (long)(keepNrOfBatches * snapshotAfter);
        if (sequenceNr > 0L) {
            this.deleteMessages(sequenceNr);
            return;
        }
    }

    public static boolean recoveryRunning$(Eventsourced $this) {
        return $this.recoveryRunning();
    }

    default public boolean recoveryRunning() {
        if (this.org$apache$pekko$persistence$Eventsourced$$currentState() == null) {
            return true;
        }
        return this.org$apache$pekko$persistence$Eventsourced$$currentState().recoveryRunning();
    }

    public static boolean recoveryFinished$(Eventsourced $this) {
        return $this.recoveryFinished();
    }

    default public boolean recoveryFinished() {
        return !this.recoveryRunning();
    }

    public static void stash$(Eventsourced $this) {
        $this.stash();
    }

    default public void stash() {
        Envelope envelope = ((ActorCell)this.context()).currentMessage();
        if (envelope != null) {
            Envelope envelope2 = Envelope$.MODULE$.unapply(envelope);
            Object object = envelope2._1();
            ActorRef actorRef = envelope2._2();
            if (object instanceof JournalProtocol.Response) {
                throw new IllegalStateException("Do not call stash inside of persist callback or during recovery.");
            }
        }
        this.org$apache$pekko$persistence$Eventsourced$$super$stash();
    }

    public static void unstashAll$(Eventsourced $this) {
        $this.unstashAll();
    }

    default public void unstashAll() {
        this.org$apache$pekko$persistence$Eventsourced$$internalStash().prepend((Seq)this.clearStash());
    }

    private State waitingRecoveryPermit(Recovery recovery) {
        return new State(recovery, this){
            private final Recovery recovery$1;
            private final /* synthetic */ Eventsourced $outer;
            {
                this.recovery$1 = recovery$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public String toString() {
                return "waiting for recovery permit";
            }

            public boolean recoveryRunning() {
                return true;
            }

            public void stateReceive(PartialFunction receive, Object message) {
                Object object = message;
                if (RecoveryPermitter$RecoveryPermitGranted$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$persistence$Eventsourced$$startRecovery(this.recovery$1);
                    return;
                }
                Object other = object;
                this.$outer.org$apache$pekko$persistence$Eventsourced$$stashInternally(other);
            }
        };
    }

    private State recoveryStarted(long replayMax, FiniteDuration timeout) {
        return new State(timeout, replayMax, this){
            private final long replayMax$2;
            private final FiniteDuration timeout$2;
            private final Cancellable timeoutCancellable;
            private final PartialFunction recoveryBehavior;
            private final /* synthetic */ Eventsourced $outer;
            {
                Actor.emptyBehavior$ emptyBehavior$2;
                this.replayMax$2 = replayMax$1;
                this.timeout$2 = timeout$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.timeoutCancellable = $outer.context().system().scheduler().scheduleOnce(timeout$1, $outer.self(), (Object)Eventsourced$RecoveryTick$.MODULE$.apply(true), (ExecutionContext)$outer.context().dispatcher(), $outer.self());
                $anon$4 var6_4 = this;
                try {
                    emptyBehavior$2 = $outer.receiveRecover();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable e = throwable3 = (Throwable)option.get();
                        try {
                            $outer.onRecoveryFailure(e, (Option<Object>)Some$.MODULE$.apply((Object)e));
                        }
                        finally {
                            $outer.context().stop($outer.self());
                        }
                        this.returnRecoveryPermit();
                        emptyBehavior$2 = Actor.emptyBehavior$.MODULE$;
                    }
                    throw throwable;
                }
                Actor.emptyBehavior$ emptyBehavior$3 = emptyBehavior$2;
                $anon$4 v1 = var6_4;
                var6_4 = null;
                Actor.emptyBehavior$ emptyBehavior$4 = emptyBehavior$3;
                emptyBehavior$3 = null;
                Actor.emptyBehavior$ _receiveRecover = emptyBehavior$4;
                v1.recoveryBehavior = new Serializable((PartialFunction)_receiveRecover, this){
                    private final PartialFunction _receiveRecover$1;
                    private final /* synthetic */ $anon$4 $outer;
                    {
                        this._receiveRecover$1 = _receiveRecover$2;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Object x) {
                        SnapshotOffer s;
                        Option<Tuple2<Object, Object>> option;
                        Object object = x;
                        if (object instanceof PersistentRepr && !(option = PersistentRepr$.MODULE$.unapply((PersistentRepr)object)).isEmpty()) {
                            Tuple2 tuple2 = (Tuple2)option.get();
                            Object payload = tuple2._1();
                            if (this.$outer.recoveryRunning() && this._receiveRecover$1.isDefinedAt(payload)) {
                                return true;
                            }
                        }
                        if (object instanceof SnapshotOffer && this._receiveRecover$1.isDefinedAt((Object)(s = (SnapshotOffer)object))) {
                            return true;
                        }
                        return RecoveryCompleted$.MODULE$.equals(object) && this._receiveRecover$1.isDefinedAt((Object)RecoveryCompleted$.MODULE$);
                    }

                    public final Object applyOrElse(Object x, Function1 function1) {
                        SnapshotOffer s;
                        Option<Tuple2<Object, Object>> option;
                        Object object = x;
                        if (object instanceof PersistentRepr && !(option = PersistentRepr$.MODULE$.unapply((PersistentRepr)object)).isEmpty()) {
                            Tuple2 tuple2 = (Tuple2)option.get();
                            Object payload = tuple2._1();
                            if (this.$outer.recoveryRunning() && this._receiveRecover$1.isDefinedAt(payload)) {
                                return this._receiveRecover$1.apply(payload);
                            }
                        }
                        if (object instanceof SnapshotOffer && this._receiveRecover$1.isDefinedAt((Object)(s = (SnapshotOffer)object))) {
                            return this._receiveRecover$1.apply((Object)s);
                        }
                        if (RecoveryCompleted$.MODULE$.equals(object) && this._receiveRecover$1.isDefinedAt((Object)RecoveryCompleted$.MODULE$)) {
                            return this._receiveRecover$1.apply((Object)RecoveryCompleted$.MODULE$);
                        }
                        return function1.apply(x);
                    }
                };
            }

            public Cancellable timeoutCancellable() {
                return this.timeoutCancellable;
            }

            public String toString() {
                return new StringBuilder(33).append("recovery started (replayMax = [").append(this.replayMax$2).append("])").toString();
            }

            public boolean recoveryRunning() {
                return true;
            }

            public void stateReceive(PartialFunction receive, Object message) {
                block13: {
                    try {
                        RecoveryTick recoveryTick;
                        boolean bl;
                        Object object = message;
                        if (object instanceof SnapshotProtocol.LoadSnapshotResult) {
                            SnapshotProtocol.LoadSnapshotResult loadSnapshotResult = SnapshotProtocol$LoadSnapshotResult$.MODULE$.unapply((SnapshotProtocol.LoadSnapshotResult)object);
                            Option<SelectedSnapshot> option = loadSnapshotResult._1();
                            long l = loadSnapshotResult._2();
                            Option<SelectedSnapshot> snapshot = option;
                            long toSnr = l;
                            this.loadSnapshotResult$1(snapshot, toSnr);
                            break block13;
                        }
                        if (object instanceof SnapshotProtocol.LoadSnapshotFailed) {
                            Throwable throwable;
                            SnapshotProtocol.LoadSnapshotFailed loadSnapshotFailed = SnapshotProtocol$LoadSnapshotFailed$.MODULE$.unapply((SnapshotProtocol.LoadSnapshotFailed)object);
                            Throwable cause = throwable = loadSnapshotFailed._1();
                            if (this.isSnapshotOptional$1()) {
                                this.$outer.org$apache$pekko$persistence$Eventsourced$$log().info("Snapshot load error for persistenceId [{}]. Replaying all events since snapshot-is-optional=true", (Object)this.$outer.persistenceId());
                                this.loadSnapshotResult$1((Option)None$.MODULE$, this.$outer.recovery().toSequenceNr());
                                break block13;
                            }
                            this.timeoutCancellable().cancel();
                            try {
                                this.$outer.onRecoveryFailure(cause, (Option<Object>)None$.MODULE$);
                            }
                            finally {
                                this.$outer.context().stop(this.$outer.self());
                            }
                            this.returnRecoveryPermit();
                            break block13;
                        }
                        if (object instanceof RecoveryTick && (bl = (recoveryTick = Eventsourced$RecoveryTick$.MODULE$.unapply((RecoveryTick)object))._1())) {
                            try {
                                this.$outer.onRecoveryFailure(new RecoveryTimedOut(new StringBuilder(47).append("Recovery timed out, didn't get snapshot within ").append(this.timeout$2).toString()), (Option<Object>)None$.MODULE$);
                            }
                            finally {
                                this.$outer.context().stop(this.$outer.self());
                            }
                            this.returnRecoveryPermit();
                            break block13;
                        }
                        Object other = object;
                        this.$outer.org$apache$pekko$persistence$Eventsourced$$stashInternally(other);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable e = throwable3 = (Throwable)option.get();
                            this.returnRecoveryPermit();
                            throw e;
                        }
                        throw throwable;
                    }
                }
            }

            private void returnRecoveryPermit() {
                this.$outer.org$apache$pekko$persistence$Eventsourced$$extension().recoveryPermitter().tell((Object)RecoveryPermitter$ReturnRecoveryPermit$.MODULE$, this.$outer.self());
            }

            private final void loadSnapshotResult$1(Option snapshot, long toSnr) {
                this.timeoutCancellable().cancel();
                snapshot.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    SelectedSnapshot selectedSnapshot = x$1;
                    if (selectedSnapshot != null) {
                        Object object;
                        Object snapshot;
                        SelectedSnapshot selectedSnapshot2 = SelectedSnapshot$.MODULE$.unapply(selectedSnapshot);
                        SnapshotMetadata snapshotMetadata = selectedSnapshot2._1();
                        SnapshotMetadata metadata = snapshotMetadata;
                        SnapshotOffer offer = SnapshotOffer$.MODULE$.apply(metadata, snapshot = (object = selectedSnapshot2._2()));
                        if (this.recoveryBehavior.isDefinedAt((Object)offer)) {
                            try {
                                this.$outer.org$apache$pekko$persistence$Eventsourced$$setLastSequenceNr(metadata.sequenceNr());
                                this.$outer.org$apache$pekko$persistence$Eventsourced$$super$aroundReceive(this.recoveryBehavior, offer);
                            }
                            catch (Throwable throwable) {
                                Option option;
                                Throwable throwable2 = throwable;
                                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                    Throwable throwable3;
                                    Throwable t = throwable3 = (Throwable)option.get();
                                    try {
                                        this.$outer.onRecoveryFailure(t, (Option<Object>)None$.MODULE$);
                                    }
                                    finally {
                                        this.$outer.context().stop(this.$outer.self());
                                    }
                                    this.returnRecoveryPermit();
                                }
                                throw throwable;
                            }
                            return;
                        }
                        this.$outer.unhandled(offer);
                        return;
                    }
                    throw new MatchError((Object)selectedSnapshot);
                });
                this.$outer.org$apache$pekko$persistence$Eventsourced$$changeState(this.$outer.org$apache$pekko$persistence$Eventsourced$$recovering((PartialFunction<Object, BoxedUnit>)this.recoveryBehavior, this.timeout$2));
                this.$outer.journal().$bang((Object)JournalProtocol$ReplayMessages$.MODULE$.apply(this.$outer.lastSequenceNr() + 1L, toSnr, this.replayMax$2, this.$outer.persistenceId(), this.$outer.self()), this.$outer.self());
            }

            private final boolean isSnapshotOptional$1() {
                boolean bl;
                try {
                    bl = ((Persistence)Persistence$.MODULE$.apply(this.$outer.context().system())).configFor(this.$outer.snapshotStore()).getBoolean("snapshot-is-optional");
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable exc = throwable3 = (Throwable)option.get();
                        this.$outer.org$apache$pekko$persistence$Eventsourced$$log().error(exc, "Invalid snapshot-is-optional configuration.");
                        bl = false;
                    }
                    throw throwable;
                }
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{loadSnapshotResult$1$$anonfun$1(org.apache.pekko.persistence.SelectedSnapshot )}, serializedLambda);
            }
        };
    }

    public static State org$apache$pekko$persistence$Eventsourced$$recovering$(Eventsourced $this, PartialFunction recoveryBehavior, FiniteDuration timeout) {
        return $this.org$apache$pekko$persistence$Eventsourced$$recovering((PartialFunction<Object, BoxedUnit>)recoveryBehavior, timeout);
    }

    default public State org$apache$pekko$persistence$Eventsourced$$recovering(PartialFunction<Object, BoxedUnit> recoveryBehavior, FiniteDuration timeout) {
        return new State(timeout, recoveryBehavior, this){
            private final PartialFunction recoveryBehavior$2;
            private final FiniteDuration timeout$4;
            private final Cancellable timeoutCancellable;
            private boolean eventSeenInInterval;
            private boolean _recoveryRunning;
            private final /* synthetic */ Eventsourced $outer;
            {
                this.recoveryBehavior$2 = recoveryBehavior$1;
                this.timeout$4 = timeout$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.timeoutCancellable = $outer.context().system().scheduler().scheduleWithFixedDelay(timeout$3, timeout$3, $outer.self(), (Object)Eventsourced$RecoveryTick$.MODULE$.apply(false), (ExecutionContext)$outer.context().dispatcher(), $outer.self());
                this.eventSeenInInterval = false;
                this._recoveryRunning = true;
            }

            public Cancellable timeoutCancellable() {
                return this.timeoutCancellable;
            }

            public boolean eventSeenInInterval() {
                return this.eventSeenInInterval;
            }

            public void eventSeenInInterval_$eq(boolean x$1) {
                this.eventSeenInInterval = x$1;
            }

            public boolean _recoveryRunning() {
                return this._recoveryRunning;
            }

            public void _recoveryRunning_$eq(boolean x$1) {
                this._recoveryRunning = x$1;
            }

            public String toString() {
                return "replay started";
            }

            public boolean recoveryRunning() {
                return this._recoveryRunning();
            }

            public void stateReceive(PartialFunction receive, Object message) {
                block25: {
                    try {
                        Object object = message;
                        if (object instanceof JournalProtocol.ReplayedMessage) {
                            PersistentRepr persistentRepr;
                            JournalProtocol.ReplayedMessage replayedMessage = JournalProtocol$ReplayedMessage$.MODULE$.unapply((JournalProtocol.ReplayedMessage)object);
                            PersistentRepr p = persistentRepr = replayedMessage._1();
                            try {
                                this.eventSeenInInterval_$eq(true);
                                this.$outer.org$apache$pekko$persistence$Eventsourced$$updateLastSequenceNr(p);
                                this.$outer.org$apache$pekko$persistence$Eventsourced$$super$aroundReceive(this.recoveryBehavior$2, p);
                                break block25;
                            }
                            catch (Throwable throwable) {
                                Option option;
                                Throwable throwable2 = throwable;
                                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                    Throwable throwable3;
                                    Throwable t = throwable3 = (Throwable)option.get();
                                    this.timeoutCancellable().cancel();
                                    try {
                                        this.$outer.onRecoveryFailure(t, (Option<Object>)Some$.MODULE$.apply(p.payload()));
                                    }
                                    finally {
                                        this.$outer.context().stop(this.$outer.self());
                                    }
                                    this.returnRecoveryPermit();
                                    break block25;
                                }
                                throw throwable;
                            }
                        }
                        if (object instanceof JournalProtocol.RecoverySuccess) {
                            long l;
                            JournalProtocol.RecoverySuccess recoverySuccess = JournalProtocol$RecoverySuccess$.MODULE$.unapply((JournalProtocol.RecoverySuccess)object);
                            long highestJournalSeqNr = l = recoverySuccess._1();
                            this.timeoutCancellable().cancel();
                            this.$outer.onReplaySuccess();
                            long highestSeqNr = Math.max(highestJournalSeqNr, this.$outer.lastSequenceNr());
                            this.$outer.org$apache$pekko$persistence$Eventsourced$$sequenceNr_$eq(highestSeqNr);
                            this.$outer.org$apache$pekko$persistence$Eventsourced$$setLastSequenceNr(highestSeqNr);
                            this._recoveryRunning_$eq(false);
                            try {
                                this.$outer.org$apache$pekko$persistence$Eventsourced$$super$aroundReceive(this.recoveryBehavior$2, RecoveryCompleted$.MODULE$);
                            }
                            finally {
                                this.transitToProcessingState();
                            }
                            this.returnRecoveryPermit();
                            break block25;
                        }
                        if (object instanceof JournalProtocol.ReplayMessagesFailure) {
                            Throwable throwable;
                            JournalProtocol.ReplayMessagesFailure replayMessagesFailure = JournalProtocol$ReplayMessagesFailure$.MODULE$.unapply((JournalProtocol.ReplayMessagesFailure)object);
                            Throwable cause = throwable = replayMessagesFailure._1();
                            this.timeoutCancellable().cancel();
                            try {
                                this.$outer.onRecoveryFailure(cause, (Option<Object>)None$.MODULE$);
                            }
                            finally {
                                this.$outer.context().stop(this.$outer.self());
                            }
                            this.returnRecoveryPermit();
                            break block25;
                        }
                        if (object instanceof RecoveryTick) {
                            RecoveryTick recoveryTick = Eventsourced$RecoveryTick$.MODULE$.unapply((RecoveryTick)object);
                            boolean bl = recoveryTick._1();
                            if (!bl) {
                                if (!this.eventSeenInInterval()) {
                                    this.timeoutCancellable().cancel();
                                    try {
                                        this.$outer.onRecoveryFailure(new RecoveryTimedOut(new StringBuilder(75).append("Recovery timed out, didn't get event within ").append(this.timeout$4).append(", highest sequence number seen ").append(this.$outer.lastSequenceNr()).toString()), (Option<Object>)None$.MODULE$);
                                    }
                                    finally {
                                        this.$outer.context().stop(this.$outer.self());
                                    }
                                    this.returnRecoveryPermit();
                                    break block25;
                                }
                                this.eventSeenInInterval_$eq(false);
                                break block25;
                            }
                            if (bl) break block25;
                        }
                        Object other = object;
                        this.$outer.org$apache$pekko$persistence$Eventsourced$$stashInternally(other);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable4 = throwable;
                        if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                            Throwable throwable5;
                            Throwable e = throwable5 = (Throwable)option.get();
                            this.returnRecoveryPermit();
                            throw e;
                        }
                        throw throwable;
                    }
                }
            }

            private void returnRecoveryPermit() {
                this.$outer.org$apache$pekko$persistence$Eventsourced$$extension().recoveryPermitter().tell((Object)RecoveryPermitter$ReturnRecoveryPermit$.MODULE$, this.$outer.self());
            }

            private void transitToProcessingState() {
                if (this.$outer.org$apache$pekko$persistence$Eventsourced$$eventBatch().nonEmpty()) {
                    this.$outer.org$apache$pekko$persistence$Eventsourced$$flushBatch();
                }
                if (this.$outer.org$apache$pekko$persistence$Eventsourced$$pendingStashingPersistInvocations() > 0L) {
                    this.$outer.org$apache$pekko$persistence$Eventsourced$$changeState(this.$outer.org$apache$pekko$persistence$Eventsourced$$persistingEvents());
                    return;
                }
                this.$outer.org$apache$pekko$persistence$Eventsourced$$changeState(this.$outer.org$apache$pekko$persistence$Eventsourced$$processingCommands());
                this.$outer.org$apache$pekko$persistence$Eventsourced$$internalStash().unstashAll();
            }
        };
    }

    public static void org$apache$pekko$persistence$Eventsourced$$flushBatch$(Eventsourced $this) {
        $this.org$apache$pekko$persistence$Eventsourced$$flushBatch();
    }

    default public void org$apache$pekko$persistence$Eventsourced$$flushBatch() {
        if (this.org$apache$pekko$persistence$Eventsourced$$eventBatch().nonEmpty()) {
            this.org$apache$pekko$persistence$Eventsourced$$journalBatch_$eq((Vector<PersistentEnvelope>)((Vector)this.org$apache$pekko$persistence$Eventsourced$$journalBatch().$plus$plus((IterableOnce)this.org$apache$pekko$persistence$Eventsourced$$eventBatch().reverse())));
            this.org$apache$pekko$persistence$Eventsourced$$eventBatch_$eq((List<PersistentEnvelope>)package$.MODULE$.Nil());
        }
        this.org$apache$pekko$persistence$Eventsourced$$flushJournalBatch();
    }

    public static void org$apache$pekko$persistence$Eventsourced$$peekApplyHandler$(Eventsourced $this, Object payload) {
        $this.org$apache$pekko$persistence$Eventsourced$$peekApplyHandler(payload);
    }

    default public void org$apache$pekko$persistence$Eventsourced$$peekApplyHandler(Object payload) {
        try {
            this.org$apache$pekko$persistence$Eventsourced$$pendingInvocations().peek().handler().apply(payload);
        }
        finally {
            this.org$apache$pekko$persistence$Eventsourced$$flushBatch();
        }
    }

    public static void org$apache$pekko$persistence$Eventsourced$$writeEventSucceeded$(Eventsourced $this, PersistentRepr p) {
        $this.org$apache$pekko$persistence$Eventsourced$$writeEventSucceeded(p);
    }

    @InternalStableApi
    default public void org$apache$pekko$persistence$Eventsourced$$writeEventSucceeded(PersistentRepr p) {
        this.org$apache$pekko$persistence$Eventsourced$$peekApplyHandler(p.payload());
    }

    public static void org$apache$pekko$persistence$Eventsourced$$writeEventRejected$(Eventsourced $this, PersistentRepr p, Throwable cause) {
        $this.org$apache$pekko$persistence$Eventsourced$$writeEventRejected(p, cause);
    }

    @InternalStableApi
    default public void org$apache$pekko$persistence$Eventsourced$$writeEventRejected(PersistentRepr p, Throwable cause) {
        this.onPersistRejected(cause, p.payload(), p.sequenceNr());
    }

    public static void org$apache$pekko$persistence$Eventsourced$$writeEventFailed$(Eventsourced $this, PersistentRepr p, Throwable cause) {
        $this.org$apache$pekko$persistence$Eventsourced$$writeEventFailed(p, cause);
    }

    @InternalStableApi
    default public void org$apache$pekko$persistence$Eventsourced$$writeEventFailed(PersistentRepr p, Throwable cause) {
        this.onPersistFailure(cause, p.payload(), p.sequenceNr());
    }

    public State org$apache$pekko$persistence$Eventsourced$$processingCommands();

    public void org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$processingCommands_$eq(State var1);

    public State org$apache$pekko$persistence$Eventsourced$$persistingEvents();

    public void org$apache$pekko$persistence$Eventsourced$_setter_$org$apache$pekko$persistence$Eventsourced$$persistingEvents_$eq(State var1);

    private Object aroundPreStart$$anonfun$1() {
        return new StringBuilder(46).append("persistenceId is [null] for PersistentActor [").append(this.self().path()).append("]").toString();
    }

    private Object aroundPreStart$$anonfun$2() {
        return new StringBuilder(52).append("persistenceId cannot be empty for PersistentActor [").append(this.self().path()).append("]").toString();
    }

    public static final class AsyncHandlerInvocation
    implements PendingHandlerInvocation,
    Product,
    Serializable {
        private final Object evt;
        private final Function1 handler;

        public static AsyncHandlerInvocation apply(Object object, Function1<Object, BoxedUnit> function1) {
            return Eventsourced$AsyncHandlerInvocation$.MODULE$.apply(object, function1);
        }

        public static AsyncHandlerInvocation fromProduct(Product product) {
            return Eventsourced$AsyncHandlerInvocation$.MODULE$.fromProduct(product);
        }

        public static AsyncHandlerInvocation unapply(AsyncHandlerInvocation asyncHandlerInvocation) {
            return Eventsourced$AsyncHandlerInvocation$.MODULE$.unapply(asyncHandlerInvocation);
        }

        public AsyncHandlerInvocation(Object evt, Function1<Object, BoxedUnit> handler) {
            this.evt = evt;
            this.handler = handler;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AsyncHandlerInvocation)) return false;
            AsyncHandlerInvocation asyncHandlerInvocation = (AsyncHandlerInvocation)object;
            if (!BoxesRunTime.equals((Object)this.evt(), (Object)asyncHandlerInvocation.evt())) return false;
            Function1<Object, BoxedUnit> function1 = this.handler();
            Function1<Object, BoxedUnit> function12 = asyncHandlerInvocation.handler();
            if (function1 != null) {
                if (!function1.equals(function12)) return false;
                return true;
            }
            if (function12 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AsyncHandlerInvocation;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AsyncHandlerInvocation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "evt";
            }
            if (1 == n2) {
                return "handler";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Object evt() {
            return this.evt;
        }

        @Override
        public Function1<Object, BoxedUnit> handler() {
            return this.handler;
        }

        public AsyncHandlerInvocation copy(Object evt, Function1<Object, BoxedUnit> handler) {
            return new AsyncHandlerInvocation(evt, handler);
        }

        public Object copy$default$1() {
            return this.evt();
        }

        public Function1<Object, BoxedUnit> copy$default$2() {
            return this.handler();
        }

        public Object _1() {
            return this.evt();
        }

        public Function1<Object, BoxedUnit> _2() {
            return this.handler();
        }
    }

    public static interface PendingHandlerInvocation {
        public Object evt();

        public Function1<Object, BoxedUnit> handler();
    }

    public abstract class ProcessingState
    implements State {
        private final PartialFunction common;

        public ProcessingState() {
            if (Eventsourced.this == null) {
                throw new NullPointerException();
            }
            this.common = new Serializable(this){
                private final /* synthetic */ ProcessingState $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Object x) {
                    Object object = x;
                    if (object instanceof JournalProtocol.WriteMessageSuccess) {
                        JournalProtocol.WriteMessageSuccess writeMessageSuccess = JournalProtocol$WriteMessageSuccess$.MODULE$.unapply((JournalProtocol.WriteMessageSuccess)object);
                        PersistentRepr persistentRepr = writeMessageSuccess._1();
                        int n = writeMessageSuccess._2();
                        PersistentRepr p = persistentRepr;
                        int id = n;
                        return true;
                    }
                    if (object instanceof JournalProtocol.WriteMessageRejected) {
                        JournalProtocol.WriteMessageRejected writeMessageRejected = JournalProtocol$WriteMessageRejected$.MODULE$.unapply((JournalProtocol.WriteMessageRejected)object);
                        PersistentRepr persistentRepr = writeMessageRejected._1();
                        Throwable throwable = writeMessageRejected._2();
                        int n = writeMessageRejected._3();
                        PersistentRepr p = persistentRepr;
                        Throwable cause = throwable;
                        int id = n;
                        return true;
                    }
                    if (object instanceof JournalProtocol.WriteMessageFailure) {
                        JournalProtocol.WriteMessageFailure writeMessageFailure = JournalProtocol$WriteMessageFailure$.MODULE$.unapply((JournalProtocol.WriteMessageFailure)object);
                        PersistentRepr persistentRepr = writeMessageFailure._1();
                        Throwable throwable = writeMessageFailure._2();
                        int n = writeMessageFailure._3();
                        PersistentRepr p = persistentRepr;
                        Throwable cause = throwable;
                        int id = n;
                        return true;
                    }
                    if (object instanceof JournalProtocol.LoopMessageSuccess) {
                        JournalProtocol.LoopMessageSuccess loopMessageSuccess = JournalProtocol$LoopMessageSuccess$.MODULE$.unapply((JournalProtocol.LoopMessageSuccess)object);
                        Object object2 = loopMessageSuccess._1();
                        int n = loopMessageSuccess._2();
                        Object l = object2;
                        int id = n;
                        return true;
                    }
                    if (JournalProtocol$WriteMessagesSuccessful$.MODULE$.equals(object)) {
                        return true;
                    }
                    if (object instanceof JournalProtocol.WriteMessagesFailed) {
                        int n;
                        JournalProtocol.WriteMessagesFailed writeMessagesFailed = JournalProtocol$WriteMessagesFailed$.MODULE$.unapply((JournalProtocol.WriteMessagesFailed)object);
                        Throwable throwable = writeMessagesFailed._1();
                        int writeCount = n = writeMessagesFailed._2();
                        return true;
                    }
                    return object instanceof RecoveryTick;
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Object object = x;
                    if (object instanceof JournalProtocol.WriteMessageSuccess) {
                        JournalProtocol.WriteMessageSuccess writeMessageSuccess = JournalProtocol$WriteMessageSuccess$.MODULE$.unapply((JournalProtocol.WriteMessageSuccess)object);
                        PersistentRepr persistentRepr = writeMessageSuccess._1();
                        int n = writeMessageSuccess._2();
                        PersistentRepr p = persistentRepr;
                        int id = n;
                        if (id == this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().org$apache$pekko$persistence$Eventsourced$$instanceId()) {
                            BoxedUnit boxedUnit;
                            this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().org$apache$pekko$persistence$Eventsourced$$updateLastSequenceNr(p);
                            try {
                                this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().org$apache$pekko$persistence$Eventsourced$$writeEventSucceeded(p);
                                this.$outer.onWriteMessageComplete(false);
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            catch (Throwable throwable) {
                                Option option;
                                Throwable throwable2 = throwable;
                                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                    Throwable throwable3;
                                    Throwable e = throwable3 = (Throwable)option.get();
                                    this.$outer.onWriteMessageComplete(true);
                                    throw e;
                                }
                                throw throwable;
                            }
                            return boxedUnit;
                        }
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof JournalProtocol.WriteMessageRejected) {
                        JournalProtocol.WriteMessageRejected writeMessageRejected = JournalProtocol$WriteMessageRejected$.MODULE$.unapply((JournalProtocol.WriteMessageRejected)object);
                        PersistentRepr persistentRepr = writeMessageRejected._1();
                        Throwable throwable = writeMessageRejected._2();
                        int n = writeMessageRejected._3();
                        PersistentRepr p = persistentRepr;
                        Throwable cause = throwable;
                        int id = n;
                        if (id == this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().org$apache$pekko$persistence$Eventsourced$$instanceId()) {
                            this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().org$apache$pekko$persistence$Eventsourced$$updateLastSequenceNr(p);
                            this.$outer.onWriteMessageComplete(false);
                            this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().org$apache$pekko$persistence$Eventsourced$$writeEventRejected(p, cause);
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof JournalProtocol.WriteMessageFailure) {
                        JournalProtocol.WriteMessageFailure writeMessageFailure = JournalProtocol$WriteMessageFailure$.MODULE$.unapply((JournalProtocol.WriteMessageFailure)object);
                        PersistentRepr persistentRepr = writeMessageFailure._1();
                        Throwable throwable = writeMessageFailure._2();
                        int n = writeMessageFailure._3();
                        PersistentRepr p = persistentRepr;
                        Throwable cause = throwable;
                        int id = n;
                        if (id == this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().org$apache$pekko$persistence$Eventsourced$$instanceId()) {
                            BoxedUnit boxedUnit;
                            this.$outer.onWriteMessageComplete(false);
                            try {
                                this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().org$apache$pekko$persistence$Eventsourced$$writeEventFailed(p, cause);
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            finally {
                                this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().context().stop(this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().self());
                            }
                            return boxedUnit;
                        }
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof JournalProtocol.LoopMessageSuccess) {
                        JournalProtocol.LoopMessageSuccess loopMessageSuccess = JournalProtocol$LoopMessageSuccess$.MODULE$.unapply((JournalProtocol.LoopMessageSuccess)object);
                        Object object2 = loopMessageSuccess._1();
                        int n = loopMessageSuccess._2();
                        Object l = object2;
                        int id = n;
                        if (id == this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().org$apache$pekko$persistence$Eventsourced$$instanceId()) {
                            BoxedUnit boxedUnit;
                            try {
                                this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().org$apache$pekko$persistence$Eventsourced$$peekApplyHandler(l);
                                this.$outer.onWriteMessageComplete(false);
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            catch (Throwable throwable) {
                                Option option;
                                Throwable throwable4 = throwable;
                                if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                                    Throwable throwable5;
                                    Throwable e = throwable5 = (Throwable)option.get();
                                    this.$outer.onWriteMessageComplete(true);
                                    throw e;
                                }
                                throw throwable;
                            }
                            return boxedUnit;
                        }
                        return BoxedUnit.UNIT;
                    }
                    if (JournalProtocol$WriteMessagesSuccessful$.MODULE$.equals(object)) {
                        this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().org$apache$pekko$persistence$Eventsourced$$writeInProgress_$eq(false);
                        this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().org$apache$pekko$persistence$Eventsourced$$flushJournalBatch();
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof JournalProtocol.WriteMessagesFailed) {
                        JournalProtocol.WriteMessagesFailed writeMessagesFailed = JournalProtocol$WriteMessagesFailed$.MODULE$.unapply((JournalProtocol.WriteMessagesFailed)object);
                        Throwable throwable = writeMessagesFailed._1();
                        int n = writeMessagesFailed._2();
                        int writeCount = n;
                        if (writeCount == 0) {
                            this.$outer.org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer().org$apache$pekko$persistence$Eventsourced$$writeInProgress_$eq(false);
                        }
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof RecoveryTick) {
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply(x);
                }
            };
        }

        @Override
        public boolean recoveryRunning() {
            return false;
        }

        public PartialFunction<Object, BoxedUnit> common() {
            return this.common;
        }

        public abstract void onWriteMessageComplete(boolean var1);

        public final /* synthetic */ Eventsourced org$apache$pekko$persistence$Eventsourced$ProcessingState$$$outer() {
            return Eventsourced.this;
        }
    }

    public static final class RecoveryTick
    implements Product,
    Serializable {
        private final boolean snapshot;

        public static RecoveryTick apply(boolean bl) {
            return Eventsourced$RecoveryTick$.MODULE$.apply(bl);
        }

        public static RecoveryTick fromProduct(Product product) {
            return Eventsourced$RecoveryTick$.MODULE$.fromProduct(product);
        }

        public static RecoveryTick unapply(RecoveryTick recoveryTick) {
            return Eventsourced$RecoveryTick$.MODULE$.unapply(recoveryTick);
        }

        public RecoveryTick(boolean snapshot) {
            this.snapshot = snapshot;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.snapshot() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RecoveryTick)) return false;
            RecoveryTick recoveryTick = (RecoveryTick)object;
            if (this.snapshot() != recoveryTick.snapshot()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RecoveryTick;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RecoveryTick";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToBoolean((boolean)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "snapshot";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean snapshot() {
            return this.snapshot;
        }

        public RecoveryTick copy(boolean snapshot) {
            return new RecoveryTick(snapshot);
        }

        public boolean copy$default$1() {
            return this.snapshot();
        }

        public boolean _1() {
            return this.snapshot();
        }
    }

    public static final class StashingHandlerInvocation
    implements PendingHandlerInvocation,
    Product,
    Serializable {
        private final Object evt;
        private final Function1 handler;

        public static StashingHandlerInvocation apply(Object object, Function1<Object, BoxedUnit> function1) {
            return Eventsourced$StashingHandlerInvocation$.MODULE$.apply(object, function1);
        }

        public static StashingHandlerInvocation fromProduct(Product product) {
            return Eventsourced$StashingHandlerInvocation$.MODULE$.fromProduct(product);
        }

        public static StashingHandlerInvocation unapply(StashingHandlerInvocation stashingHandlerInvocation) {
            return Eventsourced$StashingHandlerInvocation$.MODULE$.unapply(stashingHandlerInvocation);
        }

        public StashingHandlerInvocation(Object evt, Function1<Object, BoxedUnit> handler) {
            this.evt = evt;
            this.handler = handler;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StashingHandlerInvocation)) return false;
            StashingHandlerInvocation stashingHandlerInvocation = (StashingHandlerInvocation)object;
            if (!BoxesRunTime.equals((Object)this.evt(), (Object)stashingHandlerInvocation.evt())) return false;
            Function1<Object, BoxedUnit> function1 = this.handler();
            Function1<Object, BoxedUnit> function12 = stashingHandlerInvocation.handler();
            if (function1 != null) {
                if (!function1.equals(function12)) return false;
                return true;
            }
            if (function12 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StashingHandlerInvocation;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StashingHandlerInvocation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "evt";
            }
            if (1 == n2) {
                return "handler";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Object evt() {
            return this.evt;
        }

        @Override
        public Function1<Object, BoxedUnit> handler() {
            return this.handler;
        }

        public StashingHandlerInvocation copy(Object evt, Function1<Object, BoxedUnit> handler) {
            return new StashingHandlerInvocation(evt, handler);
        }

        public Object copy$default$1() {
            return this.evt();
        }

        public Function1<Object, BoxedUnit> copy$default$2() {
            return this.handler();
        }

        public Object _1() {
            return this.evt();
        }

        public Function1<Object, BoxedUnit> _2() {
            return this.handler();
        }
    }

    public interface State {
        public void stateReceive(PartialFunction<Object, BoxedUnit> var1, Object var2);

        public boolean recoveryRunning();
    }
}

