/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence;

import java.io.Serializable;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorPath$;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.AtLeastOnceDelivery;
import org.apache.pekko.persistence.AtLeastOnceDelivery$AtLeastOnceDeliverySnapshot$;
import org.apache.pekko.persistence.AtLeastOnceDelivery$Internal$Delivery$;
import org.apache.pekko.persistence.AtLeastOnceDelivery$Internal$RedeliveryTick$;
import org.apache.pekko.persistence.AtLeastOnceDelivery$UnconfirmedDelivery$;
import org.apache.pekko.persistence.AtLeastOnceDelivery$UnconfirmedWarning$;
import org.apache.pekko.persistence.Eventsourced;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.Persistence$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public interface AtLeastOnceDeliveryLike
extends Eventsourced {
    public static void $init$(AtLeastOnceDeliveryLike $this) {
        $this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$_setter_$org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultRedeliverInterval_$eq(((Persistence)Persistence$.MODULE$.apply($this.context().system())).settings().atLeastOnceDelivery().redeliverInterval());
        $this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$_setter_$org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultRedeliveryBurstLimit_$eq(((Persistence)Persistence$.MODULE$.apply($this.context().system())).settings().atLeastOnceDelivery().redeliveryBurstLimit());
        $this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$_setter_$org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultWarnAfterNumberOfUnconfirmedAttempts_$eq(((Persistence)Persistence$.MODULE$.apply($this.context().system())).settings().atLeastOnceDelivery().warnAfterNumberOfUnconfirmedAttempts());
        $this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$_setter_$org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultMaxUnconfirmedMessages_$eq(((Persistence)Persistence$.MODULE$.apply($this.context().system())).settings().atLeastOnceDelivery().maxUnconfirmedMessages());
        $this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$redeliverTask_$eq((Option<Cancellable>)None$.MODULE$);
        $this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$deliverySequenceNr_$eq(0L);
        $this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed_$eq((SortedMap<Object, AtLeastOnceDelivery.Internal.Delivery>)((SortedMap)SortedMap$.MODULE$.empty((Ordering)Ordering.Long$.MODULE$)));
    }

    public /* synthetic */ void org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$super$aroundPreRestart(Throwable var1, Option var2);

    public /* synthetic */ void org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$super$aroundPostStop();

    public /* synthetic */ void org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$super$onReplaySuccess();

    public /* synthetic */ void org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$super$aroundReceive(PartialFunction var1, Object var2);

    public static FiniteDuration redeliverInterval$(AtLeastOnceDeliveryLike $this) {
        return $this.redeliverInterval();
    }

    default public FiniteDuration redeliverInterval() {
        return this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultRedeliverInterval();
    }

    public FiniteDuration org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultRedeliverInterval();

    public void org$apache$pekko$persistence$AtLeastOnceDeliveryLike$_setter_$org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultRedeliverInterval_$eq(FiniteDuration var1);

    public static int redeliveryBurstLimit$(AtLeastOnceDeliveryLike $this) {
        return $this.redeliveryBurstLimit();
    }

    default public int redeliveryBurstLimit() {
        return this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultRedeliveryBurstLimit();
    }

    public int org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultRedeliveryBurstLimit();

    public void org$apache$pekko$persistence$AtLeastOnceDeliveryLike$_setter_$org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultRedeliveryBurstLimit_$eq(int var1);

    public static int warnAfterNumberOfUnconfirmedAttempts$(AtLeastOnceDeliveryLike $this) {
        return $this.warnAfterNumberOfUnconfirmedAttempts();
    }

    default public int warnAfterNumberOfUnconfirmedAttempts() {
        return this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultWarnAfterNumberOfUnconfirmedAttempts();
    }

    public int org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultWarnAfterNumberOfUnconfirmedAttempts();

    public void org$apache$pekko$persistence$AtLeastOnceDeliveryLike$_setter_$org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultWarnAfterNumberOfUnconfirmedAttempts_$eq(int var1);

    public static int maxUnconfirmedMessages$(AtLeastOnceDeliveryLike $this) {
        return $this.maxUnconfirmedMessages();
    }

    default public int maxUnconfirmedMessages() {
        return this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultMaxUnconfirmedMessages();
    }

    public int org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultMaxUnconfirmedMessages();

    public void org$apache$pekko$persistence$AtLeastOnceDeliveryLike$_setter_$org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$defaultMaxUnconfirmedMessages_$eq(int var1);

    public Option<Cancellable> org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$redeliverTask();

    public void org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$redeliverTask_$eq(Option<Cancellable> var1);

    public long org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$deliverySequenceNr();

    public void org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$deliverySequenceNr_$eq(long var1);

    public SortedMap<Object, AtLeastOnceDelivery.Internal.Delivery> org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed();

    public void org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed_$eq(SortedMap<Object, AtLeastOnceDelivery.Internal.Delivery> var1);

    private void startRedeliverTask() {
        if (this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$redeliverTask().isEmpty()) {
            FiniteDuration interval = this.redeliverInterval().$div(2L);
            Scheduler scheduler = this.context().system().scheduler();
            this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$redeliverTask_$eq((Option<Cancellable>)Some$.MODULE$.apply((Object)scheduler.scheduleWithFixedDelay(interval, interval, this.self(), (Object)AtLeastOnceDelivery$Internal$RedeliveryTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), scheduler.scheduleWithFixedDelay$default$6(interval, interval, this.self(), (Object)AtLeastOnceDelivery$Internal$RedeliveryTick$.MODULE$))));
            return;
        }
    }

    private void cancelRedeliveryTask() {
        this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$redeliverTask().foreach((Function1 & Serializable)_$1 -> _$1.cancel());
        this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$redeliverTask_$eq((Option<Cancellable>)None$.MODULE$);
    }

    private long nextDeliverySequenceNr() {
        this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$deliverySequenceNr_$eq(this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$deliverySequenceNr() + 1L);
        return this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$deliverySequenceNr();
    }

    public static void internalDeliver$(AtLeastOnceDeliveryLike $this, ActorPath destination, Function1 deliveryIdToMessage) {
        $this.internalDeliver(destination, (Function1<Object, Object>)deliveryIdToMessage);
    }

    @InternalApi
    default public void internalDeliver(ActorPath destination, Function1<Object, Object> deliveryIdToMessage) {
        if (this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed().size() >= this.maxUnconfirmedMessages()) {
            throw new AtLeastOnceDelivery.MaxUnconfirmedMessagesExceededException(new StringBuilder(52).append("Too many unconfirmed messages, maximum allowed is [").append(this.maxUnconfirmedMessages()).append("]").toString());
        }
        long deliveryId = this.nextDeliverySequenceNr();
        long now = this.recoveryRunning() ? System.nanoTime() - this.redeliverInterval().toNanos() : System.nanoTime();
        AtLeastOnceDelivery.Internal.Delivery d = AtLeastOnceDelivery$Internal$Delivery$.MODULE$.apply(destination, deliveryIdToMessage.apply((Object)BoxesRunTime.boxToLong((long)deliveryId)), now, 0);
        if (this.recoveryRunning()) {
            this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed_$eq((SortedMap<Object, AtLeastOnceDelivery.Internal.Delivery>)((SortedMap)this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed().updated((Object)BoxesRunTime.boxToLong((long)deliveryId), (Object)d)));
            return;
        }
        this.send(deliveryId, d, now);
    }

    public static void internalDeliver$(AtLeastOnceDeliveryLike $this, ActorSelection destination, Function1 deliveryIdToMessage) {
        $this.internalDeliver(destination, (Function1<Object, Object>)deliveryIdToMessage);
    }

    @InternalApi
    default public void internalDeliver(ActorSelection destination, Function1<Object, Object> deliveryIdToMessage) {
        boolean isWildcardSelection = destination.pathString().contains("*");
        Predef$.MODULE$.require(!isWildcardSelection, AtLeastOnceDeliveryLike::internalDeliver$$anonfun$1);
        this.internalDeliver(ActorPath$.MODULE$.fromString(destination.toSerializationFormat()), deliveryIdToMessage);
    }

    public static boolean confirmDelivery$(AtLeastOnceDeliveryLike $this, long deliveryId) {
        return $this.confirmDelivery(deliveryId);
    }

    default public boolean confirmDelivery(long deliveryId) {
        if (this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed().contains((Object)BoxesRunTime.boxToLong((long)deliveryId))) {
            this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed_$eq((SortedMap<Object, AtLeastOnceDelivery.Internal.Delivery>)((SortedMap)this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed().$minus((Object)BoxesRunTime.boxToLong((long)deliveryId))));
            if (this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed().isEmpty()) {
                this.cancelRedeliveryTask();
            }
            return true;
        }
        return false;
    }

    public static int numberOfUnconfirmed$(AtLeastOnceDeliveryLike $this) {
        return $this.numberOfUnconfirmed();
    }

    default public int numberOfUnconfirmed() {
        return this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed().size();
    }

    private void redeliverOverdue() {
        long now = System.nanoTime();
        long deadline = now - this.redeliverInterval().toNanos();
        ObjectRef warnings = ObjectRef.create((Object)package$.MODULE$.Vector().empty());
        this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed().iterator().filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                AtLeastOnceDelivery.Internal.Delivery delivery = (AtLeastOnceDelivery.Internal.Delivery)tuple2._2();
                return delivery.timestamp() <= deadline;
            }
            throw new MatchError((Object)tuple2);
        }).take(this.redeliveryBurstLimit()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long deliveryId = BoxesRunTime.unboxToLong((Object)tuple2._1());
                AtLeastOnceDelivery.Internal.Delivery delivery = (AtLeastOnceDelivery.Internal.Delivery)tuple2._2();
                this.send(deliveryId, delivery, now);
                if (delivery.attempt() == this.warnAfterNumberOfUnconfirmedAttempts()) {
                    warnings$1.elem = (Vector)((Vector)warnings$1.elem).$colon$plus((Object)AtLeastOnceDelivery$UnconfirmedDelivery$.MODULE$.apply(deliveryId, delivery.destination(), delivery.message()));
                    return;
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        if (((Vector)warnings.elem).nonEmpty()) {
            this.self().$bang((Object)AtLeastOnceDelivery$UnconfirmedWarning$.MODULE$.apply((Seq<AtLeastOnceDelivery.UnconfirmedDelivery>)((Vector)warnings.elem)), this.self());
            return;
        }
    }

    private void send(long deliveryId, AtLeastOnceDelivery.Internal.Delivery d, long timestamp) {
        ActorSelection$.MODULE$.toScala(this.context().actorSelection(d.destination())).$bang(d.message(), this.self());
        int n = d.attempt() + 1;
        ActorPath actorPath = d.copy$default$1();
        Object object = d.copy$default$2();
        this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed_$eq((SortedMap<Object, AtLeastOnceDelivery.Internal.Delivery>)((SortedMap)this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed().updated((Object)BoxesRunTime.boxToLong((long)deliveryId), (Object)d.copy(actorPath, object, timestamp, n))));
        this.startRedeliverTask();
    }

    public static AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot getDeliverySnapshot$(AtLeastOnceDeliveryLike $this) {
        return $this.getDeliverySnapshot();
    }

    default public AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot getDeliverySnapshot() {
        return AtLeastOnceDelivery$AtLeastOnceDeliverySnapshot$.MODULE$.apply(this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$deliverySequenceNr(), (Seq<AtLeastOnceDelivery.UnconfirmedDelivery>)((Seq)this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed().iterator().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long deliveryId = BoxesRunTime.unboxToLong((Object)tuple2._1());
                AtLeastOnceDelivery.Internal.Delivery d = (AtLeastOnceDelivery.Internal.Delivery)tuple2._2();
                return AtLeastOnceDelivery$UnconfirmedDelivery$.MODULE$.apply(deliveryId, d.destination(), d.message());
            }
            throw new MatchError((Object)tuple2);
        }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$))));
    }

    public static void setDeliverySnapshot$(AtLeastOnceDeliveryLike $this, AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot snapshot) {
        $this.setDeliverySnapshot(snapshot);
    }

    default public void setDeliverySnapshot(AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot snapshot) {
        this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$deliverySequenceNr_$eq(snapshot.currentDeliveryId());
        long now = System.nanoTime() - this.redeliverInterval().toNanos();
        this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed_$eq((SortedMap<Object, AtLeastOnceDelivery.Internal.Delivery>)SortedMap$.MODULE$.from((IterableOnce)snapshot.unconfirmedDeliveries().iterator().map((Function1 & Serializable)d -> {
            Long l = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)d.deliveryId()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l, (Object)AtLeastOnceDelivery$Internal$Delivery$.MODULE$.apply(d.destination(), d.message(), now, 0));
        }), (Ordering)Ordering.Long$.MODULE$));
    }

    public static void aroundPreRestart$(AtLeastOnceDeliveryLike $this, Throwable reason, Option message) {
        $this.aroundPreRestart(reason, (Option<Object>)message);
    }

    @Override
    default public void aroundPreRestart(Throwable reason, Option<Object> message) {
        this.cancelRedeliveryTask();
        this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$super$aroundPreRestart(reason, message);
    }

    public static void aroundPostStop$(AtLeastOnceDeliveryLike $this) {
        $this.aroundPostStop();
    }

    @Override
    default public void aroundPostStop() {
        this.cancelRedeliveryTask();
        this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$super$aroundPostStop();
    }

    public static void onReplaySuccess$(AtLeastOnceDeliveryLike $this) {
        $this.onReplaySuccess();
    }

    @Override
    default public void onReplaySuccess() {
        if (this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$unconfirmed().nonEmpty()) {
            this.redeliverOverdue();
            this.startRedeliverTask();
        }
        this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$super$onReplaySuccess();
    }

    public static void aroundReceive$(AtLeastOnceDeliveryLike $this, PartialFunction receive, Object message) {
        $this.aroundReceive((PartialFunction<Object, BoxedUnit>)receive, message);
    }

    @Override
    default public void aroundReceive(PartialFunction<Object, BoxedUnit> receive, Object message) {
        Object object = message;
        if (AtLeastOnceDelivery$Internal$RedeliveryTick$.MODULE$.equals(object)) {
            this.redeliverOverdue();
            return;
        }
        this.org$apache$pekko$persistence$AtLeastOnceDeliveryLike$$super$aroundReceive(receive, message);
    }

    private static Object internalDeliver$$anonfun$1() {
        return "Delivering to wildcard actor selections is not supported by AtLeastOnceDelivery. Introduce an mediator Actor which this AtLeastOnceDelivery Actor will deliver the messages to,and will handle the logic of fan-out and collecting individual confirmations, until it can signal confirmation back to this Actor.";
    }
}

