/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.snapshot.local;

import com.typesafe.config.Config;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.pattern.CircuitBreaker;
import org.apache.pekko.persistence.DeleteSnapshotsFailure;
import org.apache.pekko.persistence.DeleteSnapshotsSuccess;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.SaveSnapshotFailure;
import org.apache.pekko.persistence.SaveSnapshotSuccess;
import org.apache.pekko.persistence.SaveSnapshotSuccess$;
import org.apache.pekko.persistence.SelectedSnapshot;
import org.apache.pekko.persistence.SelectedSnapshot$;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.SnapshotMetadata$;
import org.apache.pekko.persistence.SnapshotSelectionCriteria;
import org.apache.pekko.persistence.serialization.Snapshot;
import org.apache.pekko.persistence.serialization.Snapshot$;
import org.apache.pekko.persistence.serialization.package$;
import org.apache.pekko.persistence.snapshot.SnapshotStore;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.Helpers;
import org.apache.pekko.util.Helpers$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public class LocalSnapshotStore
implements Actor,
ActorLogging,
SnapshotStore {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private Persistence org$apache$pekko$persistence$snapshot$SnapshotStore$$extension;
    private boolean org$apache$pekko$persistence$snapshot$SnapshotStore$$publish;
    private CircuitBreaker org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker;
    private PartialFunction receiveSnapshotStore;
    public final Regex org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern;
    public final int org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx;
    private final int maxLoadAttempts;
    private final MessageDispatcher streamDispatcher;
    private final File dir;
    private final Serialization serializationExtension;
    public Set<SnapshotMetadata> org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving;
    public final String org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding;

    public LocalSnapshotStore(Config config) {
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        SnapshotStore.$init$(this);
        this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^snapshot-(.+)-(\\d+)-(\\d+)"));
        this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx = 9;
        Integer n = (Integer)Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToInteger((int)config.getInt("max-load-attempts")));
        this.maxLoadAttempts = BoxesRunTime.unboxToInt((Object)Helpers.Requiring$.MODULE$.requiring$extension((Object)n, (Function1)(JFunction1.mcZI.sp & Serializable)_$1 -> _$1 > 1, LocalSnapshotStore::$init$$$anonfun$2));
        this.streamDispatcher = this.context().system().dispatchers().lookup(config.getString("stream-dispatcher"));
        this.dir = new File(config.getString("dir"));
        this.serializationExtension = (Serialization)SerializationExtension$.MODULE$.apply(this.context().system());
        this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving = Set$.MODULE$.empty();
        this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding = System.getProperty("file.encoding");
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public Persistence org$apache$pekko$persistence$snapshot$SnapshotStore$$extension() {
        return this.org$apache$pekko$persistence$snapshot$SnapshotStore$$extension;
    }

    @Override
    public boolean org$apache$pekko$persistence$snapshot$SnapshotStore$$publish() {
        return this.org$apache$pekko$persistence$snapshot$SnapshotStore$$publish;
    }

    @Override
    public CircuitBreaker org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker() {
        return this.org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker;
    }

    public final PartialFunction receiveSnapshotStore() {
        return this.receiveSnapshotStore;
    }

    @Override
    public void org$apache$pekko$persistence$snapshot$SnapshotStore$_setter_$org$apache$pekko$persistence$snapshot$SnapshotStore$$extension_$eq(Persistence x$0) {
        this.org$apache$pekko$persistence$snapshot$SnapshotStore$$extension = x$0;
    }

    @Override
    public void org$apache$pekko$persistence$snapshot$SnapshotStore$_setter_$org$apache$pekko$persistence$snapshot$SnapshotStore$$publish_$eq(boolean x$0) {
        this.org$apache$pekko$persistence$snapshot$SnapshotStore$$publish = x$0;
    }

    @Override
    public void org$apache$pekko$persistence$snapshot$SnapshotStore$_setter_$org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker_$eq(CircuitBreaker x$0) {
        this.org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker = x$0;
    }

    @Override
    public void org$apache$pekko$persistence$snapshot$SnapshotStore$_setter_$receiveSnapshotStore_$eq(PartialFunction x$0) {
        this.receiveSnapshotStore = x$0;
    }

    @Override
    public Future<Option<SelectedSnapshot>> loadAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        Seq metadata = (Seq)((IterableOps)this.snapshotMetadatas(persistenceId, criteria).sorted(SnapshotMetadata$.MODULE$.ordering())).takeRight(this.maxLoadAttempts);
        return Future$.MODULE$.apply(() -> this.loadAsync$$anonfun$1(metadata), (ExecutionContext)this.streamDispatcher).recoverWith((PartialFunction)new Serializable(persistenceId, criteria, this){
            private final String persistenceId$1;
            private final SnapshotSelectionCriteria criteria$1;
            private final /* synthetic */ LocalSnapshotStore $outer;
            {
                this.persistenceId$1 = persistenceId$2;
                this.criteria$1 = criteria$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof NoSuchFileException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof NoSuchFileException) {
                    return this.$outer.loadAsync(this.persistenceId$1, this.criteria$1);
                }
                return function1.apply((Object)x);
            }
        }, (ExecutionContext)this.streamDispatcher);
    }

    @Override
    public Future<BoxedUnit> saveAsync(SnapshotMetadata metadata, Object snapshot) {
        this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving = (Set)this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving.$plus((Object)metadata);
        Future completion = Future$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$anonfun$1(metadata, snapshot);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.streamDispatcher);
        return completion;
    }

    @Override
    public Future<BoxedUnit> deleteAsync(SnapshotMetadata metadata) {
        this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving = (Set)this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving.$minus((Object)metadata);
        return Future$.MODULE$.apply(() -> this.deleteAsync$$anonfun$1(metadata), (ExecutionContext)this.streamDispatcher).map((Function1)(JProcedure1 & Serializable)_$3 -> {}, (ExecutionContext)this.streamDispatcher);
    }

    @Override
    public Future<BoxedUnit> deleteAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        Seq<SnapshotMetadata> metadatas = this.snapshotMetadatas(persistenceId, criteria);
        return Future$.MODULE$.sequence((IterableOnce)metadatas.map((Function1 & Serializable)metadata -> this.deleteAsync((SnapshotMetadata)metadata)), IterableFactory$.MODULE$.toBuildFrom((IterableFactory)IndexedSeq$.MODULE$), (ExecutionContext)this.streamDispatcher).map((Function1)(JProcedure1 & Serializable)_$4 -> {}, (ExecutionContext)this.streamDispatcher);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receivePluginInternal() {
        return new Serializable(this){
            private final /* synthetic */ LocalSnapshotStore $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof SaveSnapshotSuccess) {
                    SnapshotMetadata snapshotMetadata;
                    SaveSnapshotSuccess saveSnapshotSuccess = SaveSnapshotSuccess$.MODULE$.unapply((SaveSnapshotSuccess)object);
                    SnapshotMetadata metadata = snapshotMetadata = saveSnapshotSuccess._1();
                    return true;
                }
                if (object instanceof SaveSnapshotFailure) {
                    return true;
                }
                if (object instanceof DeleteSnapshotsSuccess) {
                    return true;
                }
                return object instanceof DeleteSnapshotsFailure;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof SaveSnapshotSuccess) {
                    SnapshotMetadata snapshotMetadata;
                    SaveSnapshotSuccess saveSnapshotSuccess = SaveSnapshotSuccess$.MODULE$.unapply((SaveSnapshotSuccess)object);
                    SnapshotMetadata metadata = snapshotMetadata = saveSnapshotSuccess._1();
                    this.$outer.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving = (Set)this.$outer.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving.$minus((Object)metadata);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof SaveSnapshotFailure) {
                    return BoxedUnit.UNIT;
                }
                if (object instanceof DeleteSnapshotsSuccess) {
                    return BoxedUnit.UNIT;
                }
                if (object instanceof DeleteSnapshotsFailure) {
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    private Seq<File> snapshotFiles(SnapshotMetadata metadata) {
        return Predef$.MODULE$.wrapRefArray((Object[])this.snapshotDir().listFiles(new SnapshotSeqNrFilenameFilter(this, metadata))).toVector();
    }

    private Try<Option<SelectedSnapshot>> load(Seq<SnapshotMetadata> metadata) {
        Option option;
        block4: {
            Try try_;
            while (true) {
                if (None$.MODULE$.equals(option = metadata.lastOption())) {
                    return Success$.MODULE$.apply((Object)None$.MODULE$);
                }
                if (!(option instanceof Some)) break block4;
                SnapshotMetadata md = (SnapshotMetadata)((Some)option).value();
                try_ = Try$.MODULE$.apply(() -> this.load$$anonfun$1(md));
                if (try_ instanceof Success) {
                    Snapshot s = (Snapshot)((Success)try_).value();
                    return Success$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)SelectedSnapshot$.MODULE$.apply(md, s.data())));
                }
                if (!(try_ instanceof Failure)) break;
                Throwable e = ((Failure)try_).exception();
                Seq remaining = (Seq)metadata.init();
                this.log().error(e, "Error loading snapshot [{}], remaining attempts: [{}]", (Object)md, (Object)BoxesRunTime.boxToInteger((int)remaining.size()));
                if (remaining.isEmpty()) {
                    return Failure$.MODULE$.apply(e);
                }
                metadata = remaining;
            }
            throw new MatchError((Object)try_);
        }
        throw new MatchError((Object)option);
    }

    public void save(SnapshotMetadata metadata, Object snapshot) {
        File tmpFile = this.withOutputStream(metadata, (Function1<OutputStream, BoxedUnit>)(JProcedure1 & Serializable)_$5 -> this.serialize((OutputStream)_$5, Snapshot$.MODULE$.apply(snapshot)));
        tmpFile.renameTo(this.snapshotFileForWrite(metadata, this.snapshotFileForWrite$default$2()));
    }

    public Snapshot deserialize(InputStream inputStream) {
        return (Snapshot)this.serializationExtension.deserialize(package$.MODULE$.streamToBytes(inputStream), Snapshot.class).get();
    }

    public void serialize(OutputStream outputStream, Snapshot snapshot) {
        outputStream.write((byte[])this.serializationExtension.serialize((Object)snapshot).get());
    }

    public File withOutputStream(SnapshotMetadata metadata, Function1<OutputStream, BoxedUnit> p) {
        File tmpFile = this.snapshotFileForWrite(metadata, "tmp");
        this.withStream(new BufferedOutputStream(Files.newOutputStream(tmpFile.toPath(), new OpenOption[0])), p);
        return tmpFile;
    }

    private <T> T withInputStream(SnapshotMetadata metadata, Function1<InputStream, T> p) {
        return this.withStream(new BufferedInputStream(Files.newInputStream(this.snapshotFileForWrite(metadata, this.snapshotFileForWrite$default$2()).toPath(), new OpenOption[0])), p);
    }

    private <A extends Closeable, B> B withStream(A stream, Function1<A, B> p) {
        Object object;
        try {
            object = p.apply(stream);
        }
        finally {
            stream.close();
        }
        return (B)object;
    }

    public File snapshotFileForWrite(SnapshotMetadata metadata, String extension) {
        return new File(this.snapshotDir(), new StringBuilder(11).append("snapshot-").append(URLEncoder.encode(metadata.persistenceId(), ByteString$.MODULE$.UTF_8())).append("-").append(metadata.sequenceNr()).append("-").append(metadata.timestamp()).append(extension).toString());
    }

    public String snapshotFileForWrite$default$2() {
        return "";
    }

    private Seq<SnapshotMetadata> snapshotMetadatas(String persistenceId, SnapshotSelectionCriteria criteria) {
        Nil$ nil$;
        Object[] files = this.snapshotDir().listFiles(new SnapshotFilenameFilter(persistenceId));
        if (files == null) {
            nil$ = scala.package$.MODULE$.Nil();
        } else {
            Object object = Predef$.MODULE$.refArrayOps(files);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$6 -> _$6.getName(), ClassTag$.MODULE$.apply(String.class)));
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)filename -> this.extractMetadata((String)filename).map((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    String pid = (String)tuple3._1();
                    long snr = BoxesRunTime.unboxToLong((Object)tuple3._2());
                    long tms = BoxesRunTime.unboxToLong((Object)tuple3._3());
                    return SnapshotMetadata$.MODULE$.apply(URLDecoder.decode(pid, ByteString$.MODULE$.UTF_8()), snr, tms);
                }
                throw new MatchError((Object)tuple3);
            }), ClassTag$.MODULE$.apply(SnapshotMetadata.class)));
            nil$ = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(object3, (Function1 & Serializable)md -> criteria.matches((SnapshotMetadata)md) && !this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving.contains(md))).toVector();
        }
        return (Seq)nil$;
    }

    public void preStart() {
        this.snapshotDir();
        Actor.preStart$((Actor)this);
    }

    private File snapshotDir() {
        if (!(this.dir.isDirectory() || this.dir.mkdirs() || this.dir.isDirectory())) {
            throw new IOException(new StringBuilder(38).append("Failed to create snapshot directory [").append(this.dir.getCanonicalPath()).append("]").toString());
        }
        return this.dir;
    }

    private Option<Tuple3<String, Object, Object>> extractMetadata(String filename) {
        int sequenceNumberEndIdx = filename.lastIndexOf(45);
        int persistenceIdEndIdx = filename.lastIndexOf(45, sequenceNumberEndIdx - 1);
        String timestampString = filename.substring(sequenceNumberEndIdx + 1);
        if (this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx >= persistenceIdEndIdx || StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(timestampString), (Function1 & Serializable)_$7 -> LocalSnapshotStore.extractMetadata$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$7)))) {
            return None$.MODULE$;
        }
        String persistenceId = filename.substring(this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx, persistenceIdEndIdx);
        long sequenceNumber = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(filename.substring(persistenceIdEndIdx + 1, sequenceNumberEndIdx)));
        long timestamp = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(filename.substring(sequenceNumberEndIdx + 1)));
        return Some$.MODULE$.apply((Object)Tuple3$.MODULE$.apply((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)sequenceNumber), (Object)BoxesRunTime.boxToLong((long)timestamp)));
    }

    private static final Object $init$$$anonfun$2() {
        return "max-load-attempts must be >= 1";
    }

    private final Option loadAsync$$anonfun$1(Seq metadata$1) {
        Try<Option<SelectedSnapshot>> try_ = this.load((Seq<SnapshotMetadata>)metadata$1);
        if (try_ instanceof Success) {
            Option s = (Option)((Success)try_).value();
            return s;
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            throw e;
        }
        throw new MatchError(try_);
    }

    private final void $anonfun$1(SnapshotMetadata metadata$2, Object snapshot$1) {
        this.save(metadata$2, snapshot$1);
    }

    private final Seq deleteAsync$$anonfun$1(SnapshotMetadata metadata$3) {
        return (Seq)this.snapshotFiles(metadata$3).map((Function1 & Serializable)_$2 -> _$2.delete());
    }

    private final Snapshot load$$anonfun$1(SnapshotMetadata md$1) {
        return (Snapshot)this.withInputStream(md$1, (Function1 & Serializable)inputStream -> this.deserialize((InputStream)inputStream));
    }

    public static final boolean org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$SnapshotSeqNrFilenameFilter$$_$matches$$anonfun$2() {
        return false;
    }

    private static final /* synthetic */ boolean extractMetadata$$anonfun$1(char _$7) {
        return !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(_$7));
    }

    public final class SnapshotFilenameFilter
    implements FilenameFilter {
        private final String encodedPersistenceId;

        public SnapshotFilenameFilter(String persistenceId) {
            if (LocalSnapshotStore.this == null) {
                throw new NullPointerException();
            }
            this.encodedPersistenceId = URLEncoder.encode(persistenceId, LocalSnapshotStore.this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding);
        }

        public String encodedPersistenceId() {
            return this.encodedPersistenceId;
        }

        @Override
        public boolean accept(File dir, String name) {
            int persistenceIdEndIdx = name.lastIndexOf(45, name.lastIndexOf(45) - 1);
            return LocalSnapshotStore.this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx + this.encodedPersistenceId().length() == persistenceIdEndIdx && name.startsWith(this.encodedPersistenceId(), LocalSnapshotStore.this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx);
        }

        public final /* synthetic */ LocalSnapshotStore org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$SnapshotFilenameFilter$$$outer() {
            return LocalSnapshotStore.this;
        }
    }

    public final class SnapshotSeqNrFilenameFilter
    implements FilenameFilter {
        private final SnapshotMetadata md;
        private final /* synthetic */ LocalSnapshotStore $outer;

        public SnapshotSeqNrFilenameFilter(LocalSnapshotStore $outer, SnapshotMetadata md) {
            this.md = md;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        private final boolean matches(String pid, String snr, String tms) {
            return pid.equals(URLEncoder.encode(this.md.persistenceId(), this.$outer.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding)) && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply(() -> this.matches$$anonfun$1(snr, tms)).getOrElse(LocalSnapshotStore::org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$SnapshotSeqNrFilenameFilter$$_$matches$$anonfun$2));
        }

        @Override
        public boolean accept(File dir, String name) {
            List list;
            Option option;
            String string = name;
            if (string != null && !(option = this.$outer.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(3) == 0) {
                String string2 = (String)list.apply(0);
                String string3 = (String)list.apply(1);
                String string4 = (String)list.apply(2);
                String pid = string2;
                String snr = string3;
                String tms = string4;
                return this.matches(pid, snr, tms);
            }
            return false;
        }

        public final /* synthetic */ LocalSnapshotStore org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$SnapshotSeqNrFilenameFilter$$$outer() {
            return this.$outer;
        }

        private final boolean matches$$anonfun$1(String snr$1, String tms$1) {
            return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(snr$1)) == this.md.sequenceNr() && (this.md.timestamp() == 0L || StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(tms$1)) == this.md.timestamp());
        }
    }
}

