/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.serialization;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.apache.pekko.actor.Actor$;
import org.apache.pekko.actor.ActorPath$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.persistence.AtLeastOnceDelivery;
import org.apache.pekko.persistence.AtLeastOnceDelivery$AtLeastOnceDeliverySnapshot$;
import org.apache.pekko.persistence.AtLeastOnceDelivery$UnconfirmedDelivery$;
import org.apache.pekko.persistence.AtomicWrite;
import org.apache.pekko.persistence.AtomicWrite$;
import org.apache.pekko.persistence.PersistentImpl;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.PersistentRepr$;
import org.apache.pekko.persistence.fsm.PersistentFSM;
import org.apache.pekko.persistence.fsm.PersistentFSM$PersistentFSMSnapshot$;
import org.apache.pekko.persistence.fsm.PersistentFSM$StateChangeEvent$;
import org.apache.pekko.persistence.serialization.Message;
import org.apache.pekko.persistence.serialization.MessageFormats;
import org.apache.pekko.protobufv3.internal.ByteString;
import org.apache.pekko.protobufv3.internal.UnsafeByteOperations;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;

public class MessageSerializer
implements Serializer,
BaseSerializer {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MessageSerializer.class.getDeclaredField("serialization$lzy1"));
    private int identifier;
    private final ExtendedActorSystem system;
    private final Class AtomicWriteClass;
    private final Class PersistentReprClass;
    private final Class PersistentImplClass;
    private final Class AtLeastOnceDeliverySnapshotClass;
    private final Class PersistentStateChangeEventClass;
    private final Class PersistentFSMSnapshotClass;
    private volatile Object serialization$lzy1;
    private final boolean includeManifest;

    public MessageSerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$((BaseSerializer)this);
        this.AtomicWriteClass = AtomicWrite.class;
        this.PersistentReprClass = PersistentRepr.class;
        this.PersistentImplClass = PersistentImpl.class;
        this.AtLeastOnceDeliverySnapshotClass = AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot.class;
        this.PersistentStateChangeEventClass = PersistentFSM.StateChangeEvent.class;
        this.PersistentFSMSnapshotClass = PersistentFSM.PersistentFSMSnapshot.class;
        this.includeManifest = true;
        Statics.releaseFence();
    }

    public int identifier() {
        return this.identifier;
    }

    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$0) {
        this.identifier = x$0;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Class<AtomicWrite> AtomicWriteClass() {
        return this.AtomicWriteClass;
    }

    public Class<PersistentRepr> PersistentReprClass() {
        return this.PersistentReprClass;
    }

    public Class<PersistentImpl> PersistentImplClass() {
        return this.PersistentImplClass;
    }

    public Class<AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot> AtLeastOnceDeliverySnapshotClass() {
        return this.AtLeastOnceDeliverySnapshotClass;
    }

    public Class<PersistentFSM.StateChangeEvent> PersistentStateChangeEventClass() {
        return this.PersistentStateChangeEventClass;
    }

    public Class<PersistentFSM.PersistentFSMSnapshot<Object>> PersistentFSMSnapshotClass() {
        return this.PersistentFSMSnapshotClass;
    }

    private Serialization serialization() {
        Object object = this.serialization$lzy1;
        if (object instanceof Serialization) {
            return (Serialization)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Serialization)this.serialization$lzyINIT1();
    }

    private Object serialization$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.serialization$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Serialization serialization = null;
                    try {
                        serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                        object2 = serialization == null ? LazyVals.NullValue$.MODULE$ : serialization;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.serialization$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serialization;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean includeManifest() {
        return this.includeManifest;
    }

    public byte[] toBinary(Object o) {
        Object object = o;
        if (object instanceof PersistentRepr) {
            PersistentRepr p = (PersistentRepr)object;
            return this.persistentMessageBuilder(p).build().toByteArray();
        }
        if (object instanceof AtomicWrite) {
            AtomicWrite a = (AtomicWrite)object;
            return this.atomicWriteBuilder(a).build().toByteArray();
        }
        if (object instanceof AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot) {
            AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot a = (AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot)object;
            return this.atLeastOnceDeliverySnapshotBuilder(a).build().toByteArray();
        }
        if (object instanceof PersistentFSM.StateChangeEvent) {
            PersistentFSM.StateChangeEvent s = (PersistentFSM.StateChangeEvent)object;
            return this.stateChangeBuilder(s).build().toByteArray();
        }
        if (object instanceof PersistentFSM.PersistentFSMSnapshot) {
            PersistentFSM.PersistentFSMSnapshot p = (PersistentFSM.PersistentFSMSnapshot)object;
            return this.persistentFSMSnapshotBuilder(p).build().toByteArray();
        }
        throw new IllegalArgumentException(new StringBuilder(31).append("Can't serialize object of type ").append(o.getClass()).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        Message message;
        Option<Class<?>> option = manifest;
        if (None$.MODULE$.equals(option)) {
            message = this.persistent(MessageFormats.PersistentMessage.parseFrom(bytes));
            return message;
        } else {
            Class c;
            if (!(option instanceof Some)) throw new MatchError(option);
            Class clazz = c = (Class)((Some)option).value();
            Class<PersistentImpl> clazz2 = this.PersistentImplClass();
            Class clazz3 = clazz;
            if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                message = this.persistent(MessageFormats.PersistentMessage.parseFrom(bytes));
                return message;
            } else {
                Class<PersistentRepr> clazz4 = this.PersistentReprClass();
                Class clazz5 = clazz;
                if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                    message = this.persistent(MessageFormats.PersistentMessage.parseFrom(bytes));
                    return message;
                } else {
                    Class<AtomicWrite> clazz6 = this.AtomicWriteClass();
                    Class clazz7 = clazz;
                    if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
                        message = this.atomicWrite(MessageFormats.AtomicWrite.parseFrom(bytes));
                        return message;
                    } else {
                        Class<AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot> clazz8 = this.AtLeastOnceDeliverySnapshotClass();
                        Class clazz9 = clazz;
                        if (!(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null)) {
                            message = this.atLeastOnceDeliverySnapshot(MessageFormats.AtLeastOnceDeliverySnapshot.parseFrom(bytes));
                            return message;
                        } else {
                            Class<PersistentFSM.StateChangeEvent> clazz10 = this.PersistentStateChangeEventClass();
                            Class clazz11 = clazz;
                            if (!(clazz10 != null ? !clazz10.equals(clazz11) : clazz11 != null)) {
                                message = this.stateChange(MessageFormats.PersistentStateChangeEvent.parseFrom(bytes));
                                return message;
                            } else {
                                Class<PersistentFSM.PersistentFSMSnapshot<Object>> clazz12 = this.PersistentFSMSnapshotClass();
                                Class clazz13 = clazz;
                                if (clazz12 != null ? !clazz12.equals(clazz13) : clazz13 != null) throw new NotSerializableException(new StringBuilder(33).append("Can't deserialize object of type ").append(c).toString());
                                message = this.persistentFSMSnapshot(MessageFormats.PersistentFSMSnapshot.parseFrom(bytes));
                            }
                        }
                    }
                }
            }
        }
        return message;
    }

    public MessageFormats.AtLeastOnceDeliverySnapshot.Builder atLeastOnceDeliverySnapshotBuilder(AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot snap) {
        MessageFormats.AtLeastOnceDeliverySnapshot.Builder builder = MessageFormats.AtLeastOnceDeliverySnapshot.newBuilder();
        builder.setCurrentDeliveryId(snap.currentDeliveryId());
        snap.unconfirmedDeliveries().foreach((Function1 & Serializable)unconfirmed -> {
            MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.Builder unconfirmedBuilder = MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.newBuilder().setDeliveryId(unconfirmed.deliveryId()).setDestination(unconfirmed.destination().toString()).setPayload(this.persistentPayloadBuilder(unconfirmed.message()));
            return builder.addUnconfirmedDeliveries(unconfirmedBuilder);
        });
        return builder;
    }

    public MessageFormats.PersistentStateChangeEvent.Builder stateChangeBuilder(PersistentFSM.StateChangeEvent stateChange) {
        MessageFormats.PersistentStateChangeEvent.Builder builder = MessageFormats.PersistentStateChangeEvent.newBuilder().setStateIdentifier(stateChange.stateIdentifier());
        Option<FiniteDuration> option = stateChange.timeout();
        if (None$.MODULE$.equals(option)) {
            return builder;
        }
        if (option instanceof Some) {
            FiniteDuration timeout = (FiniteDuration)((Some)option).value();
            return builder.setTimeoutNanos(timeout.toNanos());
        }
        throw new MatchError(option);
    }

    public MessageFormats.PersistentFSMSnapshot.Builder persistentFSMSnapshotBuilder(PersistentFSM.PersistentFSMSnapshot<Object> persistentFSMSnapshot) {
        MessageFormats.PersistentFSMSnapshot.Builder builder = MessageFormats.PersistentFSMSnapshot.newBuilder().setStateIdentifier(persistentFSMSnapshot.stateIdentifier()).setData(this.persistentPayloadBuilder(persistentFSMSnapshot.data()));
        Option<FiniteDuration> option = persistentFSMSnapshot.timeout();
        if (None$.MODULE$.equals(option)) {
            return builder;
        }
        if (option instanceof Some) {
            FiniteDuration timeout = (FiniteDuration)((Some)option).value();
            return builder.setTimeoutNanos(timeout.toNanos());
        }
        throw new MatchError(option);
    }

    public AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot atLeastOnceDeliverySnapshot(MessageFormats.AtLeastOnceDeliverySnapshot atLeastOnceDeliverySnapshot) {
        VectorBuilder unconfirmedDeliveries = new VectorBuilder();
        package.JavaConverters$.MODULE$.IteratorHasAsScala(atLeastOnceDeliverySnapshot.getUnconfirmedDeliveriesList().iterator()).asScala().foreach((Function1 & Serializable)next -> (VectorBuilder)unconfirmedDeliveries.$plus$eq((Object)AtLeastOnceDelivery$UnconfirmedDelivery$.MODULE$.apply(next.getDeliveryId(), ActorPath$.MODULE$.fromString(next.getDestination()), this.payload(next.getPayload()))));
        return AtLeastOnceDelivery$AtLeastOnceDeliverySnapshot$.MODULE$.apply(atLeastOnceDeliverySnapshot.getCurrentDeliveryId(), (Seq<AtLeastOnceDelivery.UnconfirmedDelivery>)unconfirmedDeliveries.result());
    }

    public PersistentFSM.StateChangeEvent stateChange(MessageFormats.PersistentStateChangeEvent persistentStateChange) {
        return PersistentFSM$StateChangeEvent$.MODULE$.apply(persistentStateChange.getStateIdentifier(), (Option<FiniteDuration>)(persistentStateChange.hasTimeoutNanos() ? Some$.MODULE$.apply((Object)Duration$.MODULE$.fromNanos(persistentStateChange.getTimeoutNanos())) : (persistentStateChange.hasTimeout() ? Some$.MODULE$.apply((Object)((FiniteDuration)Duration$.MODULE$.apply(persistentStateChange.getTimeout()))) : None$.MODULE$)));
    }

    public PersistentFSM.PersistentFSMSnapshot<Object> persistentFSMSnapshot(MessageFormats.PersistentFSMSnapshot persistentFSMSnapshot) {
        return PersistentFSM$PersistentFSMSnapshot$.MODULE$.apply(persistentFSMSnapshot.getStateIdentifier(), this.payload(persistentFSMSnapshot.getData()), (Option<FiniteDuration>)(persistentFSMSnapshot.hasTimeoutNanos() ? Some$.MODULE$.apply((Object)Duration$.MODULE$.fromNanos(persistentFSMSnapshot.getTimeoutNanos())) : None$.MODULE$));
    }

    private MessageFormats.AtomicWrite.Builder atomicWriteBuilder(AtomicWrite a) {
        MessageFormats.AtomicWrite.Builder builder = MessageFormats.AtomicWrite.newBuilder();
        a.payload().foreach((Function1 & Serializable)p -> builder.addPayload(this.persistentMessageBuilder((PersistentRepr)p)));
        return builder;
    }

    private MessageFormats.PersistentMessage.Builder persistentMessageBuilder(PersistentRepr persistent) {
        Object object;
        MessageFormats.PersistentMessage.Builder builder = MessageFormats.PersistentMessage.newBuilder();
        String string = persistent.persistenceId();
        String string2 = PersistentRepr$.MODULE$.Undefined();
        if (string == null ? string2 != null : !string.equals(string2)) {
            builder.setPersistenceId(persistent.persistenceId());
        }
        ActorRef actorRef = persistent.sender();
        ActorRef actorRef2 = Actor$.MODULE$.noSender();
        if (actorRef == null ? actorRef2 != null : !actorRef.equals(actorRef2)) {
            builder.setSender(Serialization$.MODULE$.serializedActorPath(persistent.sender()));
        }
        String string3 = persistent.manifest();
        String string4 = PersistentRepr$.MODULE$.Undefined();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            builder.setManifest(persistent.manifest());
        }
        builder.setPayload(this.persistentPayloadBuilder(persistent.payload()));
        Option<Object> option = persistent.metadata();
        if (option instanceof Some) {
            Object meta = ((Some)option).value();
            object = builder.setMetadata(this.persistentPayloadBuilder(meta));
        } else {
            object = BoxedUnit.UNIT;
        }
        builder.setSequenceNr(persistent.sequenceNr());
        String string5 = persistent.writerUuid();
        String string6 = PersistentRepr$.MODULE$.Undefined();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            builder.setWriterUuid(persistent.writerUuid());
        }
        if (persistent.timestamp() > 0L) {
            builder.setTimestamp(persistent.timestamp());
        }
        return builder;
    }

    private MessageFormats.PersistentPayload.Builder persistentPayloadBuilder(Object payload) {
        MessageFormats.PersistentPayload.Builder builder;
        Serialization.Information oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.system().provider().serializationInformation());
            }
            builder = this.payloadBuilder$1(payload);
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return builder;
    }

    private PersistentRepr persistent(MessageFormats.PersistentMessage persistentMessage) {
        PersistentRepr repr = PersistentRepr$.MODULE$.apply(this.payload(persistentMessage.getPayload()), persistentMessage.getSequenceNr(), persistentMessage.hasPersistenceId() ? persistentMessage.getPersistenceId() : PersistentRepr$.MODULE$.Undefined(), persistentMessage.hasManifest() ? persistentMessage.getManifest() : PersistentRepr$.MODULE$.Undefined(), persistentMessage.hasDeleted() ? persistentMessage.getDeleted() : false, persistentMessage.hasSender() ? this.system().provider().resolveActorRef(persistentMessage.getSender()) : Actor$.MODULE$.noSender(), persistentMessage.hasWriterUuid() ? persistentMessage.getWriterUuid() : PersistentRepr$.MODULE$.Undefined());
        PersistentRepr persistentRepr = repr = persistentMessage.hasTimestamp() ? repr.withTimestamp(persistentMessage.getTimestamp()) : repr;
        if (persistentMessage.hasMetadata()) {
            return repr.withMetadata(this.payload(persistentMessage.getMetadata()));
        }
        return repr;
    }

    private AtomicWrite atomicWrite(MessageFormats.AtomicWrite atomicWrite) {
        return AtomicWrite$.MODULE$.apply((Seq<PersistentRepr>)((Seq)package.JavaConverters$.MODULE$.ListHasAsScala(atomicWrite.getPayloadList()).asScala().iterator().map((Function1 & Serializable)persistentMessage -> this.persistent((MessageFormats.PersistentMessage)persistentMessage)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$))));
    }

    private Object payload(MessageFormats.PersistentPayload persistentPayload) {
        String manifest = persistentPayload.hasPayloadManifest() ? persistentPayload.getPayloadManifest().toStringUtf8() : "";
        return this.serialization().deserialize(persistentPayload.getPayload().toByteArray(), persistentPayload.getSerializerId(), manifest).get();
    }

    private final MessageFormats.PersistentPayload.Builder payloadBuilder$1(Object payload$1) {
        Serializer serializer = this.serialization().findSerializerFor(payload$1);
        MessageFormats.PersistentPayload.Builder builder = MessageFormats.PersistentPayload.newBuilder();
        String ms = Serializers$.MODULE$.manifestFor(serializer, payload$1);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ms))) {
            builder.setPayloadManifest(ByteString.copyFromUtf8((String)ms));
        }
        builder.setPayload(UnsafeByteOperations.unsafeWrap((byte[])serializer.toBinary(payload$1)));
        builder.setSerializerId(serializer.identifier());
        return builder;
    }
}

