/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.japi.Pair;
import org.apache.pekko.japi.Pair$;
import org.apache.pekko.persistence.Persistence$;
import org.apache.pekko.persistence.Persistence$PluginHolder$;
import org.apache.pekko.persistence.PersistenceSettings;
import org.apache.pekko.persistence.RecoveryPermitter$;
import org.apache.pekko.persistence.StashOverflowStrategy;
import org.apache.pekko.persistence.StashOverflowStrategyConfigurator;
import org.apache.pekko.persistence.journal.EventAdapters;
import org.apache.pekko.persistence.journal.EventAdapters$;
import org.apache.pekko.persistence.journal.IdentityEventAdapters$;
import org.apache.pekko.util.Collections;
import org.apache.pekko.util.Reflect$;
import org.apache.pekko.util.ccompat.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public class Persistence
implements Extension {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(Persistence.class.getDeclaredField("defaultInternalStashOverflowStrategy$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Persistence.class.getDeclaredField("defaultSnapshotPluginId$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Persistence.class.getDeclaredField("defaultJournalPluginId$lzy1"));
    private final ExtendedActorSystem system;
    private String NoSnapshotStorePluginId;
    private final Config config;
    @InternalApi
    private final ActorRef recoveryPermitter;
    private volatile Object defaultJournalPluginId$lzy1;
    private volatile Object defaultSnapshotPluginId$lzy1;
    private volatile Object defaultInternalStashOverflowStrategy$lzy1;
    private final PersistenceSettings settings;
    private final AtomicReference<Map<String, ExtensionId<PluginHolder>>> pluginExtensionId;

    public static String JournalFallbackConfigPath() {
        return Persistence$.MODULE$.JournalFallbackConfigPath();
    }

    public static String SnapshotStoreFallbackConfigPath() {
        return Persistence$.MODULE$.SnapshotStoreFallbackConfigPath();
    }

    public static Extension apply(ActorSystem actorSystem) {
        return Persistence$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return Persistence$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Persistence createExtension(ExtendedActorSystem extendedActorSystem) {
        return Persistence$.MODULE$.createExtension(extendedActorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return Persistence$.MODULE$.get(actorSystem);
    }

    public static Persistence get(ActorSystem actorSystem) {
        return Persistence$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Persistence$.MODULE$.get(classicActorSystemProvider);
    }

    public static Persistence get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Persistence$.MODULE$.get(classicActorSystemProvider);
    }

    public static ExtensionId<? extends Extension> lookup() {
        return Persistence$.MODULE$.lookup();
    }

    @InternalApi
    public static void verifyPluginConfigExists(Config config, String string, String string2) {
        Persistence$.MODULE$.verifyPluginConfigExists(config, string, string2);
    }

    @InternalApi
    public static void verifyPluginConfigIsDefined(String string, String string2) {
        Persistence$.MODULE$.verifyPluginConfigIsDefined(string, string2);
    }

    public Persistence(ExtendedActorSystem system) {
        this.system = system;
        this.NoSnapshotStorePluginId = "pekko.persistence.no-snapshot-store";
        this.config = system.settings().config().getConfig("pekko.persistence");
        int maxPermits = this.config.getInt("max-concurrent-recoveries");
        this.recoveryPermitter = system.systemActorOf(RecoveryPermitter$.MODULE$.props(maxPermits), "recoveryPermitter");
        this.settings = new PersistenceSettings(this.config);
        this.pluginExtensionId = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        this.config.getStringList("journal.auto-start-journals").forEach(new Consumer<String>(this){
            private final /* synthetic */ Persistence $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void accept(String id) {
                this.$outer.org$apache$pekko$persistence$Persistence$$log().info(new StringBuilder(31).append("Auto-starting journal plugin `").append(id).append("`").toString());
                this.$outer.journalFor(id, this.$outer.journalFor$default$2());
            }
        });
        this.config.getStringList("snapshot-store.auto-start-snapshot-stores").forEach(new Consumer<String>(this){
            private final /* synthetic */ Persistence $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void accept(String id) {
                this.$outer.org$apache$pekko$persistence$Persistence$$log().info(new StringBuilder(31).append("Auto-starting snapshot store `").append(id).append("`").toString());
                this.$outer.snapshotStoreFor(id, this.$outer.snapshotStoreFor$default$2());
            }
        });
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public LoggingAdapter org$apache$pekko$persistence$Persistence$$log() {
        return Logging$.MODULE$.apply((ActorSystem)this.system(), Persistence.class, LogSource$.MODULE$.fromAnyClass());
    }

    public ActorRef recoveryPermitter() {
        return this.recoveryPermitter;
    }

    private String defaultJournalPluginId() {
        Object object = this.defaultJournalPluginId$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.defaultJournalPluginId$lzyINIT1();
    }

    private Object defaultJournalPluginId$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.defaultJournalPluginId$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        String configPath = this.config.getString("journal.plugin");
                        Persistence$.MODULE$.verifyPluginConfigIsDefined(configPath, "Default journal");
                        this.verifyJournalPluginConfigExists(ConfigFactory.empty(), configPath);
                        string = configPath;
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultJournalPluginId$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private String defaultSnapshotPluginId() {
        Object object = this.defaultSnapshotPluginId$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.defaultSnapshotPluginId$lzyINIT1();
    }

    private Object defaultSnapshotPluginId$lzyINIT1() {
        Object object;
        block10: {
            while (true) {
                if ((object = this.defaultSnapshotPluginId$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        String string2;
                        String configPath = this.config.getString("snapshot-store.plugin");
                        if (Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$$isEmpty(configPath)) {
                            this.org$apache$pekko$persistence$Persistence$$log().warning("No default snapshot store configured! To configure a default snapshot-store plugin set the `pekko.persistence.snapshot-store.plugin` key. For details see 'reference.conf'");
                            string2 = this.NoSnapshotStorePluginId;
                        } else {
                            this.verifySnapshotPluginConfigExists(ConfigFactory.empty(), configPath);
                            string2 = configPath;
                        }
                        string = string2;
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        this.NoSnapshotStorePluginId = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultSnapshotPluginId$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public StashOverflowStrategy defaultInternalStashOverflowStrategy() {
        Object object = this.defaultInternalStashOverflowStrategy$lzy1;
        if (object instanceof StashOverflowStrategy) {
            return (StashOverflowStrategy)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (StashOverflowStrategy)this.defaultInternalStashOverflowStrategy$lzyINIT1();
    }

    private Object defaultInternalStashOverflowStrategy$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.defaultInternalStashOverflowStrategy$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    StashOverflowStrategy stashOverflowStrategy = null;
                    try {
                        stashOverflowStrategy = (StashOverflowStrategy)this.system().dynamicAccess().createInstanceFor(this.config.getString("internal-stash-overflow-strategy"), (scala.collection.immutable.Seq)Collections.EmptyImmutableSeq$.MODULE$, ClassTag$.MODULE$.apply(StashOverflowStrategyConfigurator.class)).map((Function1 & Serializable)_$1 -> _$1.create(this.system().settings().config())).get();
                        object2 = stashOverflowStrategy == null ? LazyVals.NullValue$.MODULE$ : stashOverflowStrategy;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultInternalStashOverflowStrategy$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultInternalStashOverflowStrategy$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return stashOverflowStrategy;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public PersistenceSettings settings() {
        return this.settings;
    }

    private void verifyJournalPluginConfigExists(Config pluginConfig, String configPath) {
        Persistence$.MODULE$.verifyPluginConfigExists(pluginConfig.withFallback((ConfigMergeable)this.system().settings().config()), configPath, "Journal");
    }

    private void verifySnapshotPluginConfigExists(Config pluginConfig, String configPath) {
        Persistence$.MODULE$.verifyPluginConfigExists(pluginConfig.withFallback((ConfigMergeable)this.system().settings().config()), configPath, "Snapshot store");
    }

    public final EventAdapters adaptersFor(String journalPluginId) {
        return this.adaptersFor(journalPluginId, ConfigFactory.empty());
    }

    public final EventAdapters adaptersFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).adapters();
    }

    public final EventAdapters adaptersFor(ActorRef journalPluginActor) {
        Option option = ((MapOps)this.pluginExtensionId.get()).values().collectFirst((PartialFunction)new Serializable(journalPluginActor, this){
            private final ActorRef journalPluginActor$1;
            private final /* synthetic */ Persistence $outer;
            {
                this.journalPluginActor$1 = journalPluginActor$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(ExtensionId x) {
                ExtensionId extensionId;
                ExtensionId ext = extensionId = x;
                ActorRef actorRef = ((PluginHolder)ext.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$1;
                return !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null);
            }

            public final Object applyOrElse(ExtensionId x, Function1 function1) {
                ExtensionId extensionId;
                ExtensionId ext = extensionId = x;
                ActorRef actorRef = ((PluginHolder)ext.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$1;
                if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
                    return ((PluginHolder)ext.apply((ActorSystem)this.$outer.system())).adapters();
                }
                return function1.apply((Object)x);
            }
        });
        if (option instanceof Some) {
            EventAdapters adapters = (EventAdapters)((Some)option).value();
            return adapters;
        }
        return IdentityEventAdapters$.MODULE$;
    }

    public final Config journalConfigFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).config();
    }

    public Config journalConfigFor$default$2() {
        return ConfigFactory.empty();
    }

    public final Config configFor(ActorRef journalPluginActor) {
        Option option = ((MapOps)this.pluginExtensionId.get()).values().collectFirst((PartialFunction)new Serializable(journalPluginActor, this){
            private final ActorRef journalPluginActor$2;
            private final /* synthetic */ Persistence $outer;
            {
                this.journalPluginActor$2 = journalPluginActor$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(ExtensionId x) {
                ExtensionId extensionId;
                ExtensionId ext = extensionId = x;
                ActorRef actorRef = ((PluginHolder)ext.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$2;
                return !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null);
            }

            public final Object applyOrElse(ExtensionId x, Function1 function1) {
                ExtensionId extensionId;
                ExtensionId ext = extensionId = x;
                ActorRef actorRef = ((PluginHolder)ext.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$2;
                if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
                    return ((PluginHolder)ext.apply((ActorSystem)this.$outer.system())).config();
                }
                return function1.apply((Object)x);
            }
        });
        if (option instanceof Some) {
            Config conf = (Config)((Some)option).value();
            return conf;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(21).append("Unknown plugin actor ").append(journalPluginActor).toString());
        }
        throw new MatchError((Object)option);
    }

    @InternalStableApi
    public final ActorRef journalFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).actor();
    }

    public Config journalFor$default$2() {
        return ConfigFactory.empty();
    }

    @InternalStableApi
    public final ActorRef snapshotStoreFor(String snapshotPluginId, Config snapshotPluginConfig) {
        String configPath = Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$$isEmpty(snapshotPluginId) ? this.defaultSnapshotPluginId() : snapshotPluginId;
        this.verifySnapshotPluginConfigExists(snapshotPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.SnapshotStoreFallbackConfigPath(), snapshotPluginConfig).actor();
    }

    public Config snapshotStoreFor$default$2() {
        return ConfigFactory.empty();
    }

    private PluginHolder pluginHolderFor(String configPath, String fallbackPath, Config additionalConfig) {
        Option option;
        while (true) {
            Map<String, ExtensionId<PluginHolder>> extensionIdMap;
            if ((option = (extensionIdMap = this.pluginExtensionId.get()).get((Object)configPath)) instanceof Some) {
                ExtensionId extensionId = (ExtensionId)((Some)option).value();
                return (PluginHolder)extensionId.apply((ActorSystem)this.system());
            }
            if (!None$.MODULE$.equals(option)) break;
            PluginHolderExtensionId extensionId = new PluginHolderExtensionId(this, configPath, fallbackPath, additionalConfig);
            this.pluginExtensionId.compareAndSet(extensionIdMap, (Map<String, ExtensionId<PluginHolder>>)extensionIdMap.updated((Object)configPath, (Object)extensionId));
        }
        throw new MatchError((Object)option);
    }

    public ActorRef org$apache$pekko$persistence$Persistence$$createPlugin(String configPath, Config pluginConfig) {
        List list;
        String pluginDispatcherId;
        Class pluginClass;
        String pluginActorName;
        block7: {
            pluginActorName = configPath;
            String pluginClassName = pluginConfig.getString("class");
            if (Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$$isEmpty(pluginClassName)) {
                throw new IllegalArgumentException(new StringBuilder(61).append("Plugin class name must be defined in config property [").append(configPath).append(".class]").toString());
            }
            this.org$apache$pekko$persistence$Persistence$$log().debug(new StringBuilder(16).append("Create plugin: ").append(pluginActorName).append(" ").append(pluginClassName).toString());
            pluginClass = (Class)this.system().dynamicAccess().getClassFor(pluginClassName, ClassTag$.MODULE$.Any()).get();
            pluginDispatcherId = pluginConfig.getString("plugin-dispatcher");
            try {
                Reflect$.MODULE$.findConstructor(pluginClass, (scala.collection.immutable.Seq)new .colon.colon((Object)pluginConfig, (List)new .colon.colon((Object)configPath, (List)Nil$.MODULE$)));
                list = (List)new .colon.colon((Object)pluginConfig, (List)new .colon.colon((Object)configPath, (List)Nil$.MODULE$));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3 = (Throwable)option.get();
                    try {
                        Reflect$.MODULE$.findConstructor(pluginClass, (scala.collection.immutable.Seq)new .colon.colon((Object)pluginConfig, (List)Nil$.MODULE$));
                        list = (List)new .colon.colon((Object)pluginConfig, (List)Nil$.MODULE$);
                    }
                    catch (Throwable throwable4) {
                        Option option2;
                        Throwable throwable5 = throwable4;
                        if (throwable5 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable5)).isEmpty()) {
                            Throwable throwable6 = (Throwable)option2.get();
                            list = package$.MODULE$.Nil();
                            break block7;
                        }
                        throw throwable4;
                    }
                }
                throw throwable;
            }
        }
        List pluginActorArgs = list;
        Props pluginActorProps = Props$.MODULE$.apply(Deploy$.MODULE$.apply(Deploy$.MODULE$.apply$default$1(), Deploy$.MODULE$.apply$default$2(), Deploy$.MODULE$.apply$default$3(), Deploy$.MODULE$.apply$default$4(), pluginDispatcherId, Deploy$.MODULE$.apply$default$6()), pluginClass, (scala.collection.immutable.Seq)pluginActorArgs);
        return this.system().systemActorOf(pluginActorProps, pluginActorName);
    }

    public EventAdapters org$apache$pekko$persistence$Persistence$$createAdapters(String configPath, Config additionalConfig) {
        Config pluginConfig = additionalConfig.withFallback((ConfigMergeable)this.system().settings().config()).getConfig(configPath);
        return EventAdapters$.MODULE$.apply(this.system(), pluginConfig);
    }

    public String persistenceId(ActorRef persistentActor) {
        return this.id(persistentActor);
    }

    private String id(ActorRef ref) {
        return ref.path().toStringWithoutAddress();
    }

    public final int numberOfSlices() {
        return 1024;
    }

    public final int sliceForPersistenceId(String persistenceId) {
        return scala.math.package$.MODULE$.abs(persistenceId.hashCode() % this.numberOfSlices());
    }

    public final IndexedSeq<Range> sliceRanges(int numberOfRanges) {
        int rangeSize = this.numberOfSlices() / numberOfRanges;
        Predef$.MODULE$.require(numberOfRanges * rangeSize == this.numberOfSlices(), () -> this.sliceRanges$$anonfun$1(numberOfRanges));
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numberOfRanges).map((Function1 & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)i) * rangeSize), BoxesRunTime.unboxToInt((Object)i) * rangeSize + rangeSize)).toVector();
    }

    public final java.util.List<Pair<Integer, Integer>> getSliceRanges(int numberOfRanges) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.sliceRanges(numberOfRanges).map((Function1 & Serializable)range -> Pair$.MODULE$.apply((Object)range.min((Ordering)Ordering.Int$.MODULE$), (Object)range.max((Ordering)Ordering.Int$.MODULE$)))).asJava();
    }

    private final Object sliceRanges$$anonfun$1(int numberOfRanges$1) {
        return new StringBuilder(70).append("numberOfRanges [").append(numberOfRanges$1).append("] must be a whole number divisor of numberOfSlices [").append(this.numberOfSlices()).append("].").toString();
    }

    public static class PluginHolder
    implements Extension,
    Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PluginHolder.class.getDeclaredField("actor$lzy1"));
        private final Function0 actorFactory;
        private final EventAdapters adapters;
        private final Config config;
        private volatile Object actor$lzy1;

        public static PluginHolder apply(Function0<ActorRef> function0, EventAdapters eventAdapters, Config config) {
            return Persistence$PluginHolder$.MODULE$.apply(function0, eventAdapters, config);
        }

        public static PluginHolder fromProduct(Product product) {
            return Persistence$PluginHolder$.MODULE$.fromProduct(product);
        }

        public static PluginHolder unapply(PluginHolder pluginHolder) {
            return Persistence$PluginHolder$.MODULE$.unapply(pluginHolder);
        }

        public PluginHolder(Function0<ActorRef> actorFactory, EventAdapters adapters, Config config) {
            this.actorFactory = actorFactory;
            this.adapters = adapters;
            this.config = config;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PluginHolder)) return false;
            PluginHolder pluginHolder = (PluginHolder)object;
            Function0<ActorRef> function0 = this.actorFactory();
            Function0<ActorRef> function02 = pluginHolder.actorFactory();
            if (function0 == null) {
                if (function02 != null) {
                    return false;
                }
            } else if (!function0.equals(function02)) return false;
            EventAdapters eventAdapters = this.adapters();
            EventAdapters eventAdapters2 = pluginHolder.adapters();
            if (eventAdapters == null) {
                if (eventAdapters2 != null) {
                    return false;
                }
            } else if (!eventAdapters.equals(eventAdapters2)) return false;
            Config config = this.config();
            Config config2 = pluginHolder.config();
            if (config == null) {
                if (config2 != null) {
                    return false;
                }
            } else if (!config.equals(config2)) return false;
            if (!pluginHolder.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PluginHolder;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "PluginHolder";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "actorFactory";
                }
                case 1: {
                    return "adapters";
                }
                case 2: {
                    return "config";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function0<ActorRef> actorFactory() {
            return this.actorFactory;
        }

        public EventAdapters adapters() {
            return this.adapters;
        }

        public Config config() {
            return this.config;
        }

        public ActorRef actor() {
            Object object = this.actor$lzy1;
            if (object instanceof ActorRef) {
                return (ActorRef)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (ActorRef)this.actor$lzyINIT1();
        }

        private Object actor$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.actor$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        ActorRef actorRef = null;
                        try {
                            actorRef = (ActorRef)this.actorFactory().apply();
                            object2 = actorRef == null ? LazyVals.NullValue$.MODULE$ : actorRef;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.actor$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return actorRef;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public PluginHolder copy(Function0<ActorRef> actorFactory, EventAdapters adapters, Config config) {
            return new PluginHolder(actorFactory, adapters, config);
        }

        public Function0<ActorRef> copy$default$1() {
            return this.actorFactory();
        }

        public EventAdapters copy$default$2() {
            return this.adapters();
        }

        public Config copy$default$3() {
            return this.config();
        }

        public Function0<ActorRef> _1() {
            return this.actorFactory();
        }

        public EventAdapters _2() {
            return this.adapters();
        }

        public Config _3() {
            return this.config();
        }
    }

    public class PluginHolderExtensionId
    implements ExtensionId<PluginHolder> {
        private final String configPath;
        private final String fallbackPath;
        private final Config additionalConfig;
        private final /* synthetic */ Persistence $outer;

        public PluginHolderExtensionId(Persistence $outer, String configPath, String fallbackPath, Config additionalConfig) {
            this.configPath = configPath;
            this.fallbackPath = fallbackPath;
            this.additionalConfig = additionalConfig;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public PluginHolderExtensionId(Persistence $outer, String configPath, String fallbackPath) {
            this($outer, configPath, fallbackPath, ConfigFactory.empty());
        }

        public PluginHolder createExtension(ExtendedActorSystem system) {
            Config mergedConfig = this.additionalConfig.withFallback((ConfigMergeable)system.settings().config());
            Predef$.MODULE$.require(!Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$$isEmpty(this.configPath) && mergedConfig.hasPath(this.configPath), this::createExtension$$anonfun$1);
            Config config = mergedConfig.getConfig(this.configPath).withFallback((ConfigMergeable)mergedConfig.getConfig(this.fallbackPath));
            Function0 & Serializable pluginActorFactory = (Function0 & Serializable)() -> this.$outer.org$apache$pekko$persistence$Persistence$$createPlugin(this.configPath, config);
            EventAdapters adapters = this.$outer.org$apache$pekko$persistence$Persistence$$createAdapters(this.configPath, mergedConfig);
            return Persistence$PluginHolder$.MODULE$.apply((Function0<ActorRef>)pluginActorFactory, adapters, config);
        }

        public final /* synthetic */ Persistence org$apache$pekko$persistence$Persistence$PluginHolderExtensionId$$$outer() {
            return this.$outer;
        }

        private final Object createExtension$$anonfun$1() {
            return new StringBuilder(62).append("'reference.conf' is missing persistence plugin config path: '").append(this.configPath).append("'").toString();
        }
    }
}

