/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit.state.scaladsl;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.Persistence$;
import org.apache.pekko.persistence.query.DurableStateChange;
import org.apache.pekko.persistence.query.NoOffset$;
import org.apache.pekko.persistence.query.Offset;
import org.apache.pekko.persistence.query.Sequence;
import org.apache.pekko.persistence.query.Sequence$;
import org.apache.pekko.persistence.query.scaladsl.DurableStateStorePagedPersistenceIdsQuery;
import org.apache.pekko.persistence.query.scaladsl.DurableStateStoreQuery;
import org.apache.pekko.persistence.query.typed.scaladsl.DurableStateStoreBySliceQuery;
import org.apache.pekko.persistence.state.scaladsl.DurableStateUpdateStore;
import org.apache.pekko.persistence.state.scaladsl.GetObjectResult;
import org.apache.pekko.persistence.state.scaladsl.GetObjectResult$;
import org.apache.pekko.persistence.testkit.state.scaladsl.PersistenceTestKitDurableStateStore$;
import org.apache.pekko.persistence.testkit.state.scaladsl.Record;
import org.apache.pekko.persistence.testkit.state.scaladsl.Record$;
import org.apache.pekko.persistence.typed.PersistenceId$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.OverflowStrategy$;
import org.apache.pekko.stream.scaladsl.BroadcastHub$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.typed.scaladsl.ActorSource$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public class PersistenceTestKitDurableStateStore<A>
implements DurableStateUpdateStore<A>,
DurableStateStoreQuery<A>,
DurableStateStoreBySliceQuery<A>,
DurableStateStorePagedPersistenceIdsQuery<A> {
    private final ExtendedActorSystem system;
    private final Persistence persistence;
    private Map<String, Record<A>> store;
    private final ActorRef<Record<A>> publisher;
    private final Source<Record<A>, NotUsed> changesSource;
    private final long EarliestOffset;
    private final AtomicLong lastGlobalOffset;

    public static String Identifier() {
        return PersistenceTestKitDurableStateStore$.MODULE$.Identifier();
    }

    public PersistenceTestKitDurableStateStore(ExtendedActorSystem system) {
        this.system = system;
        ExtendedActorSystem sys = system;
        this.persistence = (Persistence)Persistence$.MODULE$.apply((ActorSystem)system);
        this.store = Predef$.MODULE$.Map().empty();
        Tuple2 tuple2 = (Tuple2)ActorSource$.MODULE$.actorRef(PartialFunction$.MODULE$.empty(), PartialFunction$.MODULE$.empty(), 256, OverflowStrategy$.MODULE$.dropHead()).toMat((Graph)BroadcastHub$.MODULE$.sink(), Keep$.MODULE$.both()).run(Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)sys));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ActorRef publisher = (ActorRef)tuple2._1();
        Source changesSource = (Source)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)publisher, (Object)changesSource);
        this.publisher = (ActorRef)tuple22._1();
        this.changesSource = (Source)tuple22._2();
        this.EarliestOffset = 0L;
        this.lastGlobalOffset = new AtomicLong(this.EarliestOffset);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    /*
     * Unable to fully structure code
     */
    public Future<GetObjectResult<A>> getObject(String persistenceId) {
        var2_2 = this;
        synchronized (var2_2) {
            var4_3 = this.store.get((Object)persistenceId);
            if (!(var4_3 instanceof Some) || (var5_4 = (Record)((Some)var4_3).value()) == null) ** GOTO lbl-1000
            var6_5 = Record$.MODULE$.unapply(var5_4);
            var7_6 = var6_5._1();
            var9_7 = var6_5._2();
            var10_8 = var6_5._3();
            var12_9 = var6_5._4();
            var13_10 = var6_5._5();
            var14_11 = var6_5._6();
            revision = var10_8;
            if (var12_9 instanceof Some) {
                value = ((Some)var12_9).value();
                v0 = GetObjectResult$.MODULE$.apply((Option)Some$.MODULE$.apply(value), revision);
            } else {
                revision = var10_8;
                if (None$.MODULE$.equals(var12_9)) {
                    v0 = GetObjectResult$.MODULE$.apply((Option)None$.MODULE$, revision);
                } else if (None$.MODULE$.equals(var4_3)) {
                    v0 = GetObjectResult$.MODULE$.apply((Option)None$.MODULE$, 0L);
                } else {
                    throw new MatchError((Object)var4_3);
                }
            }
            var3_15 = Future$.MODULE$.successful((Object)v0);
        }
        return var3_15;
    }

    public Future<Done> upsertObject(String persistenceId, long revision, A value, String tag) {
        Future future;
        PersistenceTestKitDurableStateStore persistenceTestKitDurableStateStore = this;
        synchronized (persistenceTestKitDurableStateStore) {
            long globalOffset = this.lastGlobalOffset.incrementAndGet();
            Record record = Record$.MODULE$.apply(globalOffset, persistenceId, revision, Some$.MODULE$.apply(value), tag, Record$.MODULE$.$lessinit$greater$default$6());
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)persistenceId);
            this.store = (Map)this.store.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, record));
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.publisher);
            ActorRef.ActorRefOps$.MODULE$.$bang$extension(actorRef, record);
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    public Future<Done> deleteObject(String persistenceId) {
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    public Future<Done> deleteObject(String persistenceId, long revision) {
        Future future;
        PersistenceTestKitDurableStateStore persistenceTestKitDurableStateStore = this;
        synchronized (persistenceTestKitDurableStateStore) {
            Map map;
            Option option = this.store.get((Object)persistenceId);
            if (option instanceof Some) {
                Record record = (Record)((Some)option).value();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)persistenceId);
                None$ none$ = None$.MODULE$;
                long l = record.copy$default$1();
                String string2 = record.copy$default$2();
                String string3 = record.copy$default$5();
                long l2 = record.copy$default$6();
                map = (Map)this.store.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, record.copy(l, string2, revision, none$, string3, l2)));
            } else if (None$.MODULE$.equals(option)) {
                map = this.store;
            } else {
                throw new MatchError((Object)option);
            }
            this.store = map;
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    private boolean storeContains(String persistenceId) {
        boolean bl;
        PersistenceTestKitDurableStateStore persistenceTestKitDurableStateStore = this;
        synchronized (persistenceTestKitDurableStateStore) {
            bl = this.store.contains((Object)persistenceId);
        }
        return bl;
    }

    public Source<DurableStateChange<A>, NotUsed> changes(String tag, Offset offset) {
        Source source;
        PersistenceTestKitDurableStateStore persistenceTestKitDurableStateStore = this;
        synchronized (persistenceTestKitDurableStateStore) {
            long l;
            Offset offset2 = offset;
            if (NoOffset$.MODULE$.equals(offset2)) {
                l = this.EarliestOffset;
            } else if (offset2 instanceof Sequence) {
                long l2;
                long fromOffset;
                Sequence sequence = Sequence$.MODULE$.unapply((Sequence)offset2);
                l = fromOffset = (l2 = sequence._1());
            } else {
                Offset offset3 = offset2;
                throw new UnsupportedOperationException(new StringBuilder(54).append(offset3).append(" not supported in PersistenceTestKitDurableStateStore.").toString());
            }
            long fromOffset = l;
            source = (Source)Source$.MODULE$.apply((Iterable)((SeqOps)this.store.values().toVector().filter((Function1 & Serializable)rec -> PersistenceTestKitDurableStateStore.byTagFromOffset$1(tag, fromOffset, rec))).sortBy((Function1 & Serializable)_$1 -> _$1.globalOffset(), (Ordering)Ordering.Long$.MODULE$)).concat(this.changesSource).filter((Function1 & Serializable)rec -> this.byTagFromOffsetNotDeleted$1(tag, fromOffset, (Record)rec)).statefulMap((Function0 & Serializable)() -> this.EarliestOffset, (Function2 & Serializable)(globalOffsetSeen, record) -> PersistenceTestKitDurableStateStore.changes$$anonfun$5(BoxesRunTime.unboxToLong((Object)globalOffsetSeen), (Record)record), (Function1 & Serializable)_$2 -> PersistenceTestKitDurableStateStore.changes$$anonfun$6(BoxesRunTime.unboxToLong((Object)_$2))).collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Option x) {
                    Option option = x;
                    if (option instanceof Some) {
                        Record record = (Record)((Some)option).value();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Option x, Function1 function1) {
                    Option option = x;
                    if (option instanceof Some) {
                        Record record = (Record)((Some)option).value();
                        return record;
                    }
                    return function1.apply((Object)x);
                }
            }).map((Function1 & Serializable)_$3 -> _$3.toDurableStateChange());
        }
        return source;
    }

    public Source<DurableStateChange<A>, NotUsed> currentChanges(String tag, Offset offset) {
        Source source;
        PersistenceTestKitDurableStateStore persistenceTestKitDurableStateStore = this;
        synchronized (persistenceTestKitDurableStateStore) {
            long currentGlobalOffset = this.lastGlobalOffset.get();
            source = (Source)this.changes(tag, offset).takeWhile((Function1 & Serializable)_$4 -> {
                Offset offset = _$4.offset();
                if (offset instanceof Sequence) {
                    Sequence sequence = Sequence$.MODULE$.unapply((Sequence)offset);
                    long l = sequence._1();
                    long fromOffset = l;
                    return fromOffset < currentGlobalOffset;
                }
                Offset offset2 = offset;
                throw new UnsupportedOperationException(new StringBuilder(54).append(offset2).append(" not supported in PersistenceTestKitDurableStateStore.").toString());
            }, true);
        }
        return source;
    }

    public Source<DurableStateChange<A>, NotUsed> currentChangesBySlices(String entityType, int minSlice, int maxSlice, Offset offset) {
        Source source;
        PersistenceTestKitDurableStateStore persistenceTestKitDurableStateStore = this;
        synchronized (persistenceTestKitDurableStateStore) {
            long currentGlobalOffset = this.lastGlobalOffset.get();
            source = (Source)this.changesBySlices(entityType, minSlice, maxSlice, offset).takeWhile((Function1 & Serializable)_$5 -> {
                Offset offset = _$5.offset();
                if (offset instanceof Sequence) {
                    Sequence sequence = Sequence$.MODULE$.unapply((Sequence)offset);
                    long l = sequence._1();
                    long fromOffset = l;
                    return fromOffset < currentGlobalOffset;
                }
                Offset offset2 = offset;
                throw new UnsupportedOperationException(new StringBuilder(54).append(offset2).append(" not supported in PersistenceTestKitDurableStateStore.").toString());
            }, true);
        }
        return source;
    }

    public Source<DurableStateChange<A>, NotUsed> changesBySlices(String entityType, int minSlice, int maxSlice, Offset offset) {
        Source source;
        PersistenceTestKitDurableStateStore persistenceTestKitDurableStateStore = this;
        synchronized (persistenceTestKitDurableStateStore) {
            long l;
            Offset offset2 = offset;
            if (NoOffset$.MODULE$.equals(offset2)) {
                l = this.EarliestOffset;
            } else if (offset2 instanceof Sequence) {
                long l2;
                long fromOffset;
                Sequence sequence = Sequence$.MODULE$.unapply((Sequence)offset2);
                l = fromOffset = (l2 = sequence._1());
            } else {
                Offset offset3 = offset2;
                throw new UnsupportedOperationException(new StringBuilder(54).append(offset3).append(" not supported in PersistenceTestKitDurableStateStore.").toString());
            }
            long fromOffset = l;
            source = (Source)Source$.MODULE$.apply((Iterable)((SeqOps)this.store.values().toVector().filter((Function1 & Serializable)rec -> this.bySliceFromOffset$1(entityType, minSlice, maxSlice, fromOffset, (Record)rec))).sortBy((Function1 & Serializable)_$6 -> _$6.globalOffset(), (Ordering)Ordering.Long$.MODULE$)).concat(this.changesSource).filter((Function1 & Serializable)rec -> this.bySliceFromOffsetNotDeleted$1(entityType, minSlice, maxSlice, fromOffset, (Record)rec)).statefulMap((Function0 & Serializable)() -> this.EarliestOffset, (Function2 & Serializable)(globalOffsetSeen, record) -> PersistenceTestKitDurableStateStore.changesBySlices$$anonfun$5(BoxesRunTime.unboxToLong((Object)globalOffsetSeen), (Record)record), (Function1 & Serializable)_$7 -> PersistenceTestKitDurableStateStore.changesBySlices$$anonfun$6(BoxesRunTime.unboxToLong((Object)_$7))).collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Option x) {
                    Option option = x;
                    if (option instanceof Some) {
                        Record record = (Record)((Some)option).value();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Option x, Function1 function1) {
                    Option option = x;
                    if (option instanceof Some) {
                        Record record = (Record)((Some)option).value();
                        return record;
                    }
                    return function1.apply((Object)x);
                }
            }).map((Function1 & Serializable)_$8 -> _$8.toDurableStateChange());
        }
        return source;
    }

    public int sliceForPersistenceId(String persistenceId) {
        return this.persistence.sliceForPersistenceId(persistenceId);
    }

    public Seq<Range> sliceRanges(int numberOfRanges) {
        return this.persistence.sliceRanges(numberOfRanges);
    }

    public Source<String, NotUsed> currentPersistenceIds(Option<String> afterId, long limit) {
        Source source;
        PersistenceTestKitDurableStateStore persistenceTestKitDurableStateStore = this;
        synchronized (persistenceTestKitDurableStateStore) {
            Vector vector;
            if (limit < 1L) {
                throw new IllegalArgumentException("Limit must be greater than 0");
            }
            Vector allKeys = (Vector)this.store.keys().toVector().sorted((Ordering)Ordering.String$.MODULE$);
            Option<String> option = afterId;
            if (option instanceof Some) {
                String id = (String)((Some)option).value();
                vector = (Vector)allKeys.dropWhile((Function1 & Serializable)_$9 -> StringOps$.MODULE$.$less$eq$extension(Predef$.MODULE$.augmentString(_$9), id));
            } else if (None$.MODULE$.equals(option)) {
                vector = allKeys;
            } else {
                throw new MatchError(option);
            }
            Vector keys = vector;
            source = (Source)Source$.MODULE$.apply((Iterable)keys).take(limit);
        }
        return source;
    }

    private static final boolean byTagFromOffset$1(String tag$2, long fromOffset$1, Record rec) {
        String string = rec.tag();
        String string2 = tag$2;
        return !(string != null ? !string.equals(string2) : string2 != null) && rec.globalOffset() > fromOffset$1;
    }

    private final boolean byTagFromOffsetNotDeleted$1(String tag$3, long fromOffset$3, Record rec) {
        return PersistenceTestKitDurableStateStore.byTagFromOffset$1(tag$3, fromOffset$3, rec) && this.storeContains(rec.persistenceId());
    }

    private static final /* synthetic */ Tuple2 changes$$anonfun$5(long globalOffsetSeen, Record record) {
        if (record.globalOffset() > globalOffsetSeen) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)record.globalOffset()), (Object)Some$.MODULE$.apply((Object)record));
        }
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)globalOffsetSeen), (Object)None$.MODULE$);
    }

    private static final /* synthetic */ Option changes$$anonfun$6(long _$2) {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean bySliceFromOffset$1(String entityType$1, int minSlice$1, int maxSlice$1, long fromOffset$2, Record rec) {
        int slice = this.persistence.sliceForPersistenceId(rec.persistenceId());
        String string = PersistenceId$.MODULE$.extractEntityType(rec.persistenceId());
        String string2 = entityType$1;
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (slice < minSlice$1) return false;
        if (slice > maxSlice$1) return false;
        if (rec.globalOffset() <= fromOffset$2) return false;
        return true;
    }

    private final boolean bySliceFromOffsetNotDeleted$1(String entityType$2, int minSlice$2, int maxSlice$2, long fromOffset$6, Record rec) {
        return this.bySliceFromOffset$1(entityType$2, minSlice$2, maxSlice$2, fromOffset$6, rec) && this.storeContains(rec.persistenceId());
    }

    private static final /* synthetic */ Tuple2 changesBySlices$$anonfun$5(long globalOffsetSeen, Record record) {
        if (record.globalOffset() > globalOffsetSeen) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)record.globalOffset()), (Object)Some$.MODULE$.apply((Object)record));
        }
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)globalOffsetSeen), (Object)None$.MODULE$);
    }

    private static final /* synthetic */ Option changesBySlices$$anonfun$6(long _$7) {
        return None$.MODULE$;
    }
}

