/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit.scaladsl;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.Persistence$;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.SnapshotMetadata$;
import org.apache.pekko.persistence.testkit.DeleteSnapshot;
import org.apache.pekko.persistence.testkit.PersistenceTestKitSnapshotPlugin$;
import org.apache.pekko.persistence.testkit.ProcessingPolicy;
import org.apache.pekko.persistence.testkit.ReadSnapshot;
import org.apache.pekko.persistence.testkit.SnapshotMeta;
import org.apache.pekko.persistence.testkit.SnapshotMeta$;
import org.apache.pekko.persistence.testkit.SnapshotOperation;
import org.apache.pekko.persistence.testkit.SnapshotStorage;
import org.apache.pekko.persistence.testkit.SnapshotStorage$SnapshotPolicies$;
import org.apache.pekko.persistence.testkit.WriteSnapshot;
import org.apache.pekko.persistence.testkit.internal.SnapshotStorageEmulatorExtension;
import org.apache.pekko.persistence.testkit.internal.SnapshotStorageEmulatorExtension$;
import org.apache.pekko.persistence.testkit.scaladsl.CommonTestKitOps;
import org.apache.pekko.persistence.testkit.scaladsl.ExpectOps;
import org.apache.pekko.persistence.testkit.scaladsl.HasStorage;
import org.apache.pekko.persistence.testkit.scaladsl.SnapshotTestKit$;
import org.apache.pekko.persistence.testkit.scaladsl.SnapshotTestKit$Settings$;
import org.apache.pekko.testkit.TestKitBase;
import org.apache.pekko.testkit.TestProbe$;
import org.apache.pekko.util.Helpers;
import org.apache.pekko.util.Helpers$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;

@ApiMayChange
public class SnapshotTestKit
implements CommonTestKitOps<Tuple2<SnapshotMetadata, Object>, SnapshotOperation>,
ExpectOps<Tuple2<SnapshotMetadata, Object>>,
HasStorage<SnapshotOperation, Tuple2<SnapshotMetadata, Object>> {
    private volatile Map org$apache$pekko$persistence$testkit$scaladsl$HasStorage$$nextIndexByPersistenceId;
    private final ActorSystem system;
    private final SnapshotStorage storage;
    private final TestKitBase probe;
    private final FiniteDuration pollInterval;
    private final FiniteDuration maxTimeout;
    private final ProcessingPolicy.DefaultPolicies Policies;

    public static SnapshotTestKit apply(ActorSystem actorSystem) {
        return SnapshotTestKit$.MODULE$.apply(actorSystem);
    }

    public static SnapshotTestKit apply(org.apache.pekko.actor.typed.ActorSystem<?> actorSystem) {
        return SnapshotTestKit$.MODULE$.apply(actorSystem);
    }

    public SnapshotTestKit(ActorSystem system) {
        this.system = system;
        HasStorage.$init$(this);
        Predef$.MODULE$.require(Try$.MODULE$.apply(() -> SnapshotTestKit.$init$$$anonfun$1(system)).isSuccess(), SnapshotTestKit::$init$$$anonfun$2);
        this.storage = ((SnapshotStorageEmulatorExtension)SnapshotStorageEmulatorExtension$.MODULE$.apply(system)).storageFor(PersistenceTestKitSnapshotPlugin$.MODULE$.PluginId());
        Settings settings = (Settings)SnapshotTestKit$Settings$.MODULE$.apply(system);
        this.probe = TestProbe$.MODULE$.apply(system);
        this.pollInterval = settings.pollInterval();
        this.maxTimeout = settings.assertTimeout();
        this.Policies = SnapshotStorage$SnapshotPolicies$.MODULE$;
    }

    @Override
    public Map org$apache$pekko$persistence$testkit$scaladsl$HasStorage$$nextIndexByPersistenceId() {
        return this.org$apache$pekko$persistence$testkit$scaladsl$HasStorage$$nextIndexByPersistenceId;
    }

    @Override
    public void org$apache$pekko$persistence$testkit$scaladsl$HasStorage$$nextIndexByPersistenceId_$eq(Map x$1) {
        this.org$apache$pekko$persistence$testkit$scaladsl$HasStorage$$nextIndexByPersistenceId = x$1;
    }

    public SnapshotStorage storage() {
        return this.storage;
    }

    @Override
    public Option<Object> getItem(String persistenceId, int nextInd) {
        return this.storage().firstInExpectNextQueue(persistenceId).map((Function1 & Serializable)repr -> this.reprToAny((Tuple2<SnapshotMetadata, Object>)repr));
    }

    @Override
    public <A> A expectNextPersisted(String persistenceId, A event) {
        Object item = ExpectOps.expectNextPersisted$(this, persistenceId, event);
        this.storage().removeFirstInExpectNextQueue(persistenceId);
        return (A)item;
    }

    @Override
    public TestKitBase probe() {
        return this.probe;
    }

    @Override
    public FiniteDuration pollInterval() {
        return this.pollInterval;
    }

    @Override
    public FiniteDuration maxTimeout() {
        return this.maxTimeout;
    }

    @Override
    public ProcessingPolicy.DefaultPolicies<SnapshotOperation> Policies() {
        return this.Policies;
    }

    @Override
    public void failNextNPersisted(String persistenceId, int n, Throwable cause) {
        this.failNextNOpsCond((Function2 & Serializable)(pid, op) -> {
            String string = pid;
            String string2 = persistenceId;
            return !(string != null ? !string.equals(string2) : string2 != null) && op instanceof WriteSnapshot;
        }, n, cause);
    }

    @Override
    public void failNextNPersisted(int n, Throwable cause) {
        this.failNextNOpsCond((Function2 & Serializable)(_$1, op) -> op instanceof WriteSnapshot, n, cause);
    }

    @Override
    public void failNextNReads(int n, Throwable cause) {
        this.failNextNOpsCond((Function2 & Serializable)(_$2, op) -> op instanceof ReadSnapshot, n, cause);
    }

    @Override
    public void failNextNReads(String persistenceId, int n, Throwable cause) {
        this.failNextNOpsCond((Function2 & Serializable)(pid, op) -> {
            String string = pid;
            String string2 = persistenceId;
            return !(string != null ? !string.equals(string2) : string2 != null) && op instanceof ReadSnapshot;
        }, n, cause);
    }

    @Override
    public void failNextNDeletes(int n, Throwable cause) {
        this.failNextNOpsCond((Function2 & Serializable)(_$3, op) -> op instanceof DeleteSnapshot, n, cause);
    }

    @Override
    public void failNextNDeletes(String persistenceId, int n, Throwable cause) {
        this.failNextNOpsCond((Function2 & Serializable)(pid, op) -> {
            String string = pid;
            String string2 = persistenceId;
            return !(string != null ? !string.equals(string2) : string2 != null) && op instanceof DeleteSnapshot;
        }, n, cause);
    }

    public void persistForRecovery(String persistenceId, Seq<Tuple2<SnapshotMeta, Object>> elems) {
        elems.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                SnapshotMeta m = (SnapshotMeta)tuple2._1();
                Object p = tuple2._2();
                this.storage().add(persistenceId, Tuple2$.MODULE$.apply((Object)SnapshotMetadata$.MODULE$.apply(persistenceId, m.sequenceNr(), m.timestamp()), p));
                this.addToIndex(persistenceId, 1);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void persistForRecovery(String persistenceId, Tuple2<SnapshotMeta, Object> elem) {
        this.persistForRecovery(persistenceId, (Seq<Tuple2<SnapshotMeta, Object>>)((Seq)((SeqOps)new .colon.colon(elem, (List)Nil$.MODULE$))));
    }

    public Seq<Tuple2<SnapshotMeta, Object>> persistedInStorage(String persistenceId) {
        return (Seq)this.storage().read(persistenceId).map((Function1 & Serializable)_$4 -> (Vector)_$4.map((Function1 & Serializable)m -> Tuple2$.MODULE$.apply((Object)SnapshotMeta$.MODULE$.apply(((SnapshotMetadata)m._1()).sequenceNr(), ((SnapshotMetadata)m._1()).timestamp()), m._2()))).getOrElse(SnapshotTestKit::persistedInStorage$$anonfun$2);
    }

    @Override
    public Object reprToAny(Tuple2<SnapshotMetadata, Object> repr) {
        return repr._2();
    }

    private static final ActorRef $init$$$anonfun$1(ActorSystem system$1) {
        Persistence persistence = (Persistence)Persistence$.MODULE$.apply(system$1);
        return persistence.journalFor(PersistenceTestKitSnapshotPlugin$.MODULE$.PluginId(), persistence.journalFor$default$2());
    }

    private static final Object $init$$$anonfun$2() {
        return "The test persistence plugin for snapshots is not configured.";
    }

    private static final Vector persistedInStorage$$anonfun$2() {
        return package$.MODULE$.Vector().empty();
    }

    public static class Settings
    implements Extension {
        private final boolean serialize;
        private final FiniteDuration assertTimeout;
        private final FiniteDuration pollInterval;

        public static Extension apply(ActorSystem actorSystem) {
            return SnapshotTestKit$Settings$.MODULE$.apply(actorSystem);
        }

        public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
            return SnapshotTestKit$Settings$.MODULE$.apply(classicActorSystemProvider);
        }

        public static String configPath() {
            return SnapshotTestKit$Settings$.MODULE$.configPath();
        }

        public static Settings createExtension(ExtendedActorSystem extendedActorSystem) {
            return SnapshotTestKit$Settings$.MODULE$.createExtension(extendedActorSystem);
        }

        public static /* synthetic */ Extension get(ActorSystem actorSystem) {
            return SnapshotTestKit$Settings$.MODULE$.get(actorSystem);
        }

        public static Settings get(ActorSystem actorSystem) {
            return SnapshotTestKit$Settings$.MODULE$.get(actorSystem);
        }

        public static Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
            return SnapshotTestKit$Settings$.MODULE$.get(classicActorSystemProvider);
        }

        public Settings(Config config) {
            this.serialize = config.getBoolean("serialize");
            this.assertTimeout = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "assert-timeout");
            this.pollInterval = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "assert-poll-interval");
        }

        public boolean serialize() {
            return this.serialize;
        }

        public FiniteDuration assertTimeout() {
            return this.assertTimeout;
        }

        public FiniteDuration pollInterval() {
            return this.pollInterval;
        }
    }
}

