/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit.scaladsl;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.Persistence$;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.journal.Tagged;
import org.apache.pekko.persistence.journal.Tagged$;
import org.apache.pekko.persistence.testkit.DeleteEvents;
import org.apache.pekko.persistence.testkit.EventStorage;
import org.apache.pekko.persistence.testkit.EventStorage$JournalPolicies$;
import org.apache.pekko.persistence.testkit.JournalOperation;
import org.apache.pekko.persistence.testkit.PersistenceTestKitPlugin$;
import org.apache.pekko.persistence.testkit.ProcessingPolicy;
import org.apache.pekko.persistence.testkit.ReadEvents;
import org.apache.pekko.persistence.testkit.ReadSeqNum$;
import org.apache.pekko.persistence.testkit.WriteEvents;
import org.apache.pekko.persistence.testkit.internal.InMemStorageExtension;
import org.apache.pekko.persistence.testkit.internal.InMemStorageExtension$;
import org.apache.pekko.persistence.testkit.scaladsl.ExpectOps;
import org.apache.pekko.persistence.testkit.scaladsl.HasStorage;
import org.apache.pekko.persistence.testkit.scaladsl.PersistenceTestKit$;
import org.apache.pekko.persistence.testkit.scaladsl.PersistenceTestKit$Settings$;
import org.apache.pekko.persistence.testkit.scaladsl.PersistenceTestKitOps;
import org.apache.pekko.testkit.TestKitBase;
import org.apache.pekko.testkit.TestProbe$;
import org.apache.pekko.util.Helpers;
import org.apache.pekko.util.Helpers$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Try$;

@ApiMayChange
public class PersistenceTestKit
implements PersistenceTestKitOps<PersistentRepr, JournalOperation>,
ExpectOps<PersistentRepr>,
HasStorage<JournalOperation, PersistentRepr> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PersistenceTestKit.class.getDeclaredField("settings$lzy1"));
    private volatile Map org$apache$pekko$persistence$testkit$scaladsl$HasStorage$$nextIndexByPersistenceId;
    private final ActorSystem system;
    private final EventStorage storage;
    private volatile Object settings$lzy1;
    private final TestKitBase probe;
    private final ProcessingPolicy.DefaultPolicies Policies;
    private final FiniteDuration pollInterval;
    private final FiniteDuration maxTimeout;

    public static PersistenceTestKit apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return PersistenceTestKit$.MODULE$.apply(classicActorSystemProvider);
    }

    public PersistenceTestKit(ActorSystem system) {
        this.system = system;
        HasStorage.$init$(this);
        Predef$.MODULE$.require(Try$.MODULE$.apply(() -> PersistenceTestKit.$init$$$anonfun$3(system)).isSuccess(), PersistenceTestKit::$init$$$anonfun$4);
        this.storage = ((InMemStorageExtension)InMemStorageExtension$.MODULE$.apply(system)).storageFor(PersistenceTestKitPlugin$.MODULE$.PluginId());
        this.probe = TestProbe$.MODULE$.apply(system);
        this.Policies = EventStorage$JournalPolicies$.MODULE$;
        this.pollInterval = this.settings().pollInterval();
        this.maxTimeout = this.settings().assertTimeout();
    }

    @Override
    public Map org$apache$pekko$persistence$testkit$scaladsl$HasStorage$$nextIndexByPersistenceId() {
        return this.org$apache$pekko$persistence$testkit$scaladsl$HasStorage$$nextIndexByPersistenceId;
    }

    @Override
    public void org$apache$pekko$persistence$testkit$scaladsl$HasStorage$$nextIndexByPersistenceId_$eq(Map x$1) {
        this.org$apache$pekko$persistence$testkit$scaladsl$HasStorage$$nextIndexByPersistenceId = x$1;
    }

    public EventStorage storage() {
        return this.storage;
    }

    private final Settings settings() {
        Object object = this.settings$lzy1;
        if (object instanceof Settings) {
            return (Settings)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Settings)this.settings$lzyINIT1();
    }

    private Object settings$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.settings$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Settings settings = null;
                    try {
                        settings = (Settings)PersistenceTestKit$Settings$.MODULE$.apply(this.system);
                        object2 = settings == null ? LazyVals.NullValue$.MODULE$ : settings;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.settings$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return settings;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public TestKitBase probe() {
        return this.probe;
    }

    @Override
    public ProcessingPolicy.DefaultPolicies<JournalOperation> Policies() {
        return this.Policies;
    }

    @Override
    public FiniteDuration pollInterval() {
        return this.pollInterval;
    }

    @Override
    public FiniteDuration maxTimeout() {
        return this.maxTimeout;
    }

    @Override
    public void rejectNextNPersisted(String persistenceId, int n, Throwable cause) {
        this.rejectNextNOpsCond((Function2 & Serializable)(pid, op) -> {
            String string = pid;
            String string2 = persistenceId;
            return !(string != null ? !string.equals(string2) : string2 != null) && op instanceof WriteEvents;
        }, n, cause);
    }

    @Override
    public void rejectNextNPersisted(int n, Throwable cause) {
        this.rejectNextNOpsCond((Function2 & Serializable)(_$5, op) -> op instanceof WriteEvents, n, cause);
    }

    @Override
    public void rejectNextNReads(int n, Throwable cause) {
        this.rejectNextNOpsCond((Function2 & Serializable)(_$6, op) -> op instanceof ReadEvents || op == ReadSeqNum$.MODULE$, n, cause);
    }

    @Override
    public void rejectNextNReads(String persistenceId, int n, Throwable cause) {
        this.rejectNextNOpsCond((Function2 & Serializable)(pid, op) -> {
            String string = pid;
            String string2 = persistenceId;
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (op instanceof ReadEvents) return true;
            if (op != ReadSeqNum$.MODULE$) return false;
            return true;
        }, n, cause);
    }

    @Override
    public void rejectNextNDeletes(int n, Throwable cause) {
        this.rejectNextNOpsCond((Function2 & Serializable)(_$7, op) -> op instanceof DeleteEvents, n, cause);
    }

    @Override
    public void rejectNextNDeletes(String persistenceId, int n, Throwable cause) {
        this.rejectNextNOpsCond((Function2 & Serializable)(pid, op) -> {
            String string = pid;
            String string2 = persistenceId;
            return !(string != null ? !string.equals(string2) : string2 != null) && op instanceof DeleteEvents;
        }, n, cause);
    }

    @Override
    public void failNextNPersisted(String persistenceId, int n, Throwable cause) {
        this.failNextNOpsCond((Function2 & Serializable)(pid, op) -> {
            String string = pid;
            String string2 = persistenceId;
            return !(string != null ? !string.equals(string2) : string2 != null) && op instanceof WriteEvents;
        }, n, cause);
    }

    @Override
    public void failNextNPersisted(int n, Throwable cause) {
        this.failNextNOpsCond((Function2 & Serializable)(_$8, op) -> op instanceof WriteEvents, n, cause);
    }

    @Override
    public void failNextNReads(int n, Throwable cause) {
        this.failNextNOpsCond((Function2 & Serializable)(_$9, op) -> op instanceof ReadEvents || op == ReadSeqNum$.MODULE$, n, cause);
    }

    @Override
    public void failNextNReads(String persistenceId, int n, Throwable cause) {
        this.failNextNOpsCond((Function2 & Serializable)(pid, op) -> {
            String string = pid;
            String string2 = persistenceId;
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (op instanceof ReadEvents) return true;
            if (op != ReadSeqNum$.MODULE$) return false;
            return true;
        }, n, cause);
    }

    @Override
    public void failNextNDeletes(int n, Throwable cause) {
        this.failNextNOpsCond((Function2 & Serializable)(_$10, op) -> op instanceof DeleteEvents, n, cause);
    }

    @Override
    public void failNextNDeletes(String persistenceId, int n, Throwable cause) {
        this.failNextNOpsCond((Function2 & Serializable)(pid, op) -> {
            String string = pid;
            String string2 = persistenceId;
            return !(string != null ? !string.equals(string2) : string2 != null) && op instanceof DeleteEvents;
        }, n, cause);
    }

    @Override
    public void persistForRecovery(String persistenceId, Seq<Object> events) {
        this.storage().addAny(persistenceId, events);
        this.addToIndex(persistenceId, events.size());
    }

    @Override
    public Seq<Object> persistedInStorage(String persistenceId) {
        return (Seq)((IterableOps)this.storage().read(persistenceId).getOrElse(PersistenceTestKit::persistedInStorage$$anonfun$3)).map((Function1 & Serializable)repr -> this.reprToAny((PersistentRepr)repr));
    }

    @Override
    public Object reprToAny(PersistentRepr repr) {
        Object object = repr.payload();
        if (object instanceof Tagged) {
            Tagged tagged = Tagged$.MODULE$.unapply((Tagged)object);
            Object object2 = tagged._1();
            Set set = tagged._2();
            Object payload = object2;
            return payload;
        }
        Object payload = object;
        return payload;
    }

    private static final ActorRef $init$$$anonfun$3(ActorSystem system$2) {
        Persistence persistence = (Persistence)Persistence$.MODULE$.apply(system$2);
        return persistence.journalFor(PersistenceTestKitPlugin$.MODULE$.PluginId(), persistence.journalFor$default$2());
    }

    private static final Object $init$$$anonfun$4() {
        return "The test persistence plugin is not configured.";
    }

    private static final AbstractSeq persistedInStorage$$anonfun$3() {
        return package$.MODULE$.List().empty();
    }

    public static class Settings
    implements Extension {
        private final boolean serialize;
        private final FiniteDuration assertTimeout;
        private final FiniteDuration pollInterval;

        public static Extension apply(ActorSystem actorSystem) {
            return PersistenceTestKit$Settings$.MODULE$.apply(actorSystem);
        }

        public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
            return PersistenceTestKit$Settings$.MODULE$.apply(classicActorSystemProvider);
        }

        public static String configPath() {
            return PersistenceTestKit$Settings$.MODULE$.configPath();
        }

        public static Settings createExtension(ExtendedActorSystem extendedActorSystem) {
            return PersistenceTestKit$Settings$.MODULE$.createExtension(extendedActorSystem);
        }

        public static /* synthetic */ Extension get(ActorSystem actorSystem) {
            return PersistenceTestKit$Settings$.MODULE$.get(actorSystem);
        }

        public static Settings get(ActorSystem actorSystem) {
            return PersistenceTestKit$Settings$.MODULE$.get(actorSystem);
        }

        public static Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
            return PersistenceTestKit$Settings$.MODULE$.get(classicActorSystemProvider);
        }

        public Settings(Config config) {
            this.serialize = config.getBoolean("serialize");
            this.assertTimeout = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "assert-timeout");
            this.pollInterval = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "assert-poll-interval");
        }

        public boolean serialize() {
            return this.serialize;
        }

        public FiniteDuration assertTimeout() {
            return this.assertTimeout;
        }

        public FiniteDuration pollInterval() {
            return this.pollInterval;
        }
    }
}

