/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit.scaladsl;

import java.io.Serializable;
import org.apache.pekko.persistence.testkit.scaladsl.HasStorage;
import org.apache.pekko.testkit.TestKitBase;
import org.apache.pekko.testkit.package;
import org.apache.pekko.testkit.package$;
import org.apache.pekko.util.BoxedType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.Scala3RunTime$;

public interface ExpectOps<U> {
    public TestKitBase probe();

    public FiniteDuration pollInterval();

    public FiniteDuration maxTimeout();

    public Object reprToAny(U var1);

    public static Object expectNextPersisted$(ExpectOps $this, String persistenceId, Object event) {
        return $this.expectNextPersisted(persistenceId, event);
    }

    default public <A> A expectNextPersisted(String persistenceId, A event) {
        return this.expectNextPersisted(persistenceId, event, this.maxTimeout());
    }

    public static Option getItem$(ExpectOps $this, String persistenceId, int nextInd) {
        return $this.getItem(persistenceId, nextInd);
    }

    default public Option<Object> getItem(String persistenceId, int nextInd) {
        return ((HasStorage)((Object)this)).storage().findOneByIndex(persistenceId, nextInd).map((Function1 & Serializable)repr -> this.reprToAny(repr));
    }

    public static Object expectNextPersisted$(ExpectOps $this, String persistenceId, Object event, FiniteDuration max) {
        return $this.expectNextPersisted(persistenceId, event, max);
    }

    default public <A> A expectNextPersisted(String persistenceId, A event, FiniteDuration max) {
        int nextInd = ((HasStorage)((Object)this)).nextIndex(persistenceId);
        Some expected = Some$.MODULE$.apply(event);
        Option res = (Option)this.probe().awaitAssert(() -> this.$anonfun$5(persistenceId, nextInd, expected, event), (Duration)package.TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.probe().system()), (Duration)this.pollInterval());
        ((HasStorage)((Object)this)).setIndex(persistenceId, nextInd + 1);
        return (A)res.get();
    }

    public static Object expectNextPersistedType$(ExpectOps $this, String persistenceId, ClassTag t) {
        return $this.expectNextPersistedType(persistenceId, t);
    }

    default public <A> A expectNextPersistedType(String persistenceId, ClassTag<A> t) {
        return this.expectNextPersistedType(persistenceId, this.maxTimeout(), t);
    }

    public static Object expectNextPersistedType$(ExpectOps $this, String persistenceId, FiniteDuration max, ClassTag t) {
        return $this.expectNextPersistedType(persistenceId, max, t);
    }

    default public <A> A expectNextPersistedType(String persistenceId, FiniteDuration max, ClassTag<A> t) {
        return this.expectNextPersistedClass(persistenceId, t.runtimeClass(), max);
    }

    public static Object expectNextPersistedClass$(ExpectOps $this, String persistenceId, Class cla) {
        return $this.expectNextPersistedClass(persistenceId, cla);
    }

    default public <A> A expectNextPersistedClass(String persistenceId, Class<A> cla) {
        return this.expectNextPersistedClass(persistenceId, cla, this.maxTimeout());
    }

    public static Object expectNextPersistedClass$(ExpectOps $this, String persistenceId, Class cla, FiniteDuration max) {
        return $this.expectNextPersistedClass(persistenceId, cla, max);
    }

    default public <A> A expectNextPersistedClass(String persistenceId, Class<A> cla, FiniteDuration max) {
        int nextInd = ((HasStorage)((Object)this)).nextIndex(persistenceId);
        Class c = BoxedType$.MODULE$.apply(cla);
        Object res = this.probe().awaitAssert(() -> this.$anonfun$6(persistenceId, nextInd, cla, c), (Duration)package.TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.probe().system()), (Duration)this.pollInterval());
        ((HasStorage)((Object)this)).setIndex(persistenceId, nextInd + 1);
        return (A)res;
    }

    public static void expectNothingPersisted$(ExpectOps $this, String persistenceId) {
        $this.expectNothingPersisted(persistenceId);
    }

    default public void expectNothingPersisted(String persistenceId) {
        this.expectNothingPersisted(persistenceId, this.maxTimeout());
    }

    public static void expectNothingPersisted$(ExpectOps $this, String persistenceId, FiniteDuration max) {
        $this.expectNothingPersisted(persistenceId, max);
    }

    default public void expectNothingPersisted(String persistenceId, FiniteDuration max) {
        int nextInd = ((HasStorage)((Object)this)).nextIndex(persistenceId);
        this.probe().assertForDuration((Function0 & Serializable)() -> {
            this.expectNothingPersisted$$anonfun$1(persistenceId, nextInd);
            return BoxedUnit.UNIT;
        }, package.TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.probe().system()), (Duration)this.pollInterval());
    }

    public static Seq receivePersisted$(ExpectOps $this, String persistenceId, int n, FiniteDuration max, ClassTag t) {
        return $this.receivePersisted(persistenceId, n, max, t);
    }

    default public <A> Seq<A> receivePersisted(String persistenceId, int n, FiniteDuration max, ClassTag<A> t) {
        return this.receivePersisted(persistenceId, n, t.runtimeClass(), max);
    }

    public static Seq receivePersisted$(ExpectOps $this, String persistenceId, int n, ClassTag t) {
        return $this.receivePersisted(persistenceId, n, t);
    }

    default public <A> Seq<A> receivePersisted(String persistenceId, int n, ClassTag<A> t) {
        return this.receivePersisted(persistenceId, n, t.runtimeClass(), this.maxTimeout());
    }

    public static Seq receivePersisted$(ExpectOps $this, String persistenceId, int n, Class cla) {
        return $this.receivePersisted(persistenceId, n, cla);
    }

    default public <A> Seq<A> receivePersisted(String persistenceId, int n, Class<A> cla) {
        return this.receivePersisted(persistenceId, n, cla, this.maxTimeout());
    }

    public static Seq receivePersisted$(ExpectOps $this, String persistenceId, int n, Class cla, FiniteDuration max) {
        return $this.receivePersisted(persistenceId, n, cla, max);
    }

    default public <A> Seq<A> receivePersisted(String persistenceId, int n, Class<A> cla, FiniteDuration max) {
        int nextInd = ((HasStorage)((Object)this)).nextIndex(persistenceId);
        Class bt = BoxedType$.MODULE$.apply(cla);
        Vector res = (Vector)this.probe().awaitAssert(() -> this.$anonfun$9(persistenceId, nextInd, n, bt), (Duration)package.TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.probe().system()), (Duration)this.pollInterval());
        ((HasStorage)((Object)this)).setIndex(persistenceId, nextInd + n);
        return res;
    }

    private Option $anonfun$5(String persistenceId$1, int nextInd$1, Some expected$1, Object event$1) {
        Option<Object> actual;
        Option<Object> option = actual = this.getItem(persistenceId$1, nextInd$1);
        Some some = expected$1;
        if (option == null ? some != null : !option.equals((Object)some)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(32).append("Failed to persist ").append(event$1).append(", got ").append(actual).append(" instead").toString());
        }
        return actual;
    }

    private Object $anonfun$6(String persistenceId$2, int nextInd$2, Class cla$1, Class c$1) {
        Option actual = ((HasStorage)((Object)this)).storage().findOneByIndex(persistenceId$2, nextInd$2).map((Function1 & Serializable)repr -> this.reprToAny(repr));
        if (!actual.isDefined()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(27).append("Expected: ").append(cla$1).append(" but got no event").toString());
        }
        Object a = actual.get();
        if (!c$1.isInstance(a)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(30).append("Expected: ").append(cla$1).append(" but got unexpected ").append(a.getClass()).toString());
        }
        return a;
    }

    private void expectNothingPersisted$$anonfun$1(String persistenceId$3, int nextInd$3) {
        Option actual = ((HasStorage)((Object)this)).storage().findOneByIndex(persistenceId$3, nextInd$3).map((Function1 & Serializable)repr -> this.reprToAny(repr));
        boolean res = actual.isEmpty();
        if (!res) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(49).append("Found persisted event ").append(actual).append(", but expected None instead").toString());
        }
    }

    private Vector $anonfun$9(String persistenceId$4, int nextInd$4, int n$1, Class bt$1) {
        Option actual = ((HasStorage)((Object)this)).storage().findMany(persistenceId$4, nextInd$4, n$1);
        Option option = actual;
        if (option instanceof Some) {
            Vector reprs = (Vector)((Some)option).value();
            Vector ls = (Vector)reprs.map((Function1 & Serializable)repr -> this.reprToAny(repr));
            Vector filtered = (Vector)ls.filter((Function1 & Serializable)e -> !bt$1.isInstance(e));
            if (ls.size() != n$1) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(44).append("Could read only ").append(ls.size()).append(" events instead of expected ").append(n$1).toString());
            }
            if (!filtered.isEmpty()) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(52).append("Persisted events ").append(filtered).append(" do not correspond to expected type").toString());
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"No events were persisted");
            }
            throw new MatchError(option);
        }
        return (Vector)((StrictOptimizedIterableOps)actual.get()).map((Function1 & Serializable)repr -> this.reprToAny(repr));
    }
}

