/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit.query.scaladsl;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.Persistence$;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.journal.Tagged;
import org.apache.pekko.persistence.journal.Tagged$;
import org.apache.pekko.persistence.query.EventEnvelope$;
import org.apache.pekko.persistence.query.NoOffset$;
import org.apache.pekko.persistence.query.Offset;
import org.apache.pekko.persistence.query.Sequence$;
import org.apache.pekko.persistence.query.scaladsl.CurrentEventsByPersistenceIdQuery;
import org.apache.pekko.persistence.query.scaladsl.CurrentEventsByTagQuery;
import org.apache.pekko.persistence.query.scaladsl.EventsByPersistenceIdQuery;
import org.apache.pekko.persistence.query.scaladsl.EventsByTagQuery;
import org.apache.pekko.persistence.query.scaladsl.PagedPersistenceIdsQuery;
import org.apache.pekko.persistence.query.typed.EventEnvelope;
import org.apache.pekko.persistence.query.typed.scaladsl.CurrentEventsBySliceQuery;
import org.apache.pekko.persistence.query.typed.scaladsl.EventsBySliceQuery;
import org.apache.pekko.persistence.testkit.EventStorage;
import org.apache.pekko.persistence.testkit.internal.InMemStorageExtension;
import org.apache.pekko.persistence.testkit.internal.InMemStorageExtension$;
import org.apache.pekko.persistence.testkit.query.internal.EventsByPersistenceIdStage;
import org.apache.pekko.persistence.testkit.query.internal.EventsBySliceStage;
import org.apache.pekko.persistence.testkit.query.internal.EventsByTagStage;
import org.apache.pekko.persistence.testkit.query.scaladsl.PersistenceTestKitReadJournal$;
import org.apache.pekko.persistence.typed.PersistenceId$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;

public final class PersistenceTestKitReadJournal
implements EventsByPersistenceIdQuery,
CurrentEventsByPersistenceIdQuery,
CurrentEventsByTagQuery,
CurrentEventsBySliceQuery,
PagedPersistenceIdsQuery,
EventsByTagQuery,
EventsBySliceQuery {
    private final EventStorage storage;
    private final Persistence persistence;

    public static String Identifier() {
        return PersistenceTestKitReadJournal$.MODULE$.Identifier();
    }

    public PersistenceTestKitReadJournal(ExtendedActorSystem system, Config config, String configPath) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        String storagePluginId = configPath.replaceAll("query$", "journal");
        log.debug("Using in memory storage [{}] for test kit read journal", (Object)storagePluginId);
        this.storage = ((InMemStorageExtension)InMemStorageExtension$.MODULE$.apply((ActorSystem)system)).storageFor(storagePluginId);
        this.persistence = (Persistence)Persistence$.MODULE$.apply((ActorSystem)system);
    }

    private Object unwrapTaggedPayload(Object payload) {
        Object object = payload;
        if (object instanceof Tagged) {
            Tagged tagged = Tagged$.MODULE$.unapply((Tagged)object);
            Object object2 = tagged._1();
            Set set = tagged._2();
            Object payload2 = object2;
            return payload2;
        }
        Object payload3 = object;
        return payload3;
    }

    public Source<org.apache.pekko.persistence.query.EventEnvelope, NotUsed> eventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        return Source$.MODULE$.fromGraph((Graph)new EventsByPersistenceIdStage(persistenceId, fromSequenceNr, toSequenceNr, this.storage));
    }

    public long eventsByPersistenceId$default$2() {
        return 0L;
    }

    public long eventsByPersistenceId$default$3() {
        return Long.MAX_VALUE;
    }

    public Source<org.apache.pekko.persistence.query.EventEnvelope, NotUsed> currentEventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        return (Source)Source$.MODULE$.apply(this.storage.tryRead(persistenceId, fromSequenceNr, toSequenceNr, Long.MAX_VALUE)).map((Function1 & Serializable)pr -> EventEnvelope$.MODULE$.apply((Offset)Sequence$.MODULE$.apply(pr.sequenceNr()), persistenceId, pr.sequenceNr(), this.unwrapTaggedPayload(pr.payload()), pr.timestamp(), pr.metadata()));
    }

    public long currentEventsByPersistenceId$default$2() {
        return 0L;
    }

    public long currentEventsByPersistenceId$default$3() {
        return Long.MAX_VALUE;
    }

    public Source<org.apache.pekko.persistence.query.EventEnvelope, NotUsed> currentEventsByTag(String tag, Offset offset) {
        Offset offset2 = offset;
        if (!NoOffset$.MODULE$.equals(offset2)) {
            throw new UnsupportedOperationException("Offsets not supported for persistence test kit currentEventsByTag yet");
        }
        return (Source)Source$.MODULE$.apply(this.storage.tryReadByTag(tag)).map((Function1 & Serializable)pr -> EventEnvelope$.MODULE$.apply((Offset)Sequence$.MODULE$.apply(pr.sequenceNr()), pr.persistenceId(), pr.sequenceNr(), this.unwrapTaggedPayload(pr.payload()), pr.timestamp(), pr.metadata()));
    }

    public Offset currentEventsByTag$default$2() {
        return NoOffset$.MODULE$;
    }

    public <Event> Source<EventEnvelope<Event>, NotUsed> currentEventsBySlices(String entityType, int minSlice, int maxSlice, Offset offset) {
        Offset offset2 = offset;
        if (!NoOffset$.MODULE$.equals(offset2)) {
            throw new UnsupportedOperationException("Offsets not supported for persistence test kit currentEventsByTag yet");
        }
        Seq<PersistentRepr> prs = this.storage.tryRead(entityType, (Function1<PersistentRepr, Object>)(Function1 & Serializable)repr -> {
            String pid = repr.persistenceId();
            int slice = this.persistence.sliceForPersistenceId(pid);
            String string = PersistenceId$.MODULE$.extractEntityType(pid);
            String string2 = entityType;
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (slice < minSlice) return false;
            if (slice > maxSlice) return false;
            return true;
        });
        return (Source)Source$.MODULE$.apply(prs).map((Function1 & Serializable)pr -> {
            int slice = this.persistence.sliceForPersistenceId(pr.persistenceId());
            return new EventEnvelope((Offset)Sequence$.MODULE$.apply(pr.sequenceNr()), pr.persistenceId(), pr.sequenceNr(), (Option)Some$.MODULE$.apply(pr.payload()), pr.timestamp(), pr.metadata(), entityType, slice);
        });
    }

    public int sliceForPersistenceId(String persistenceId) {
        return this.persistence.sliceForPersistenceId(persistenceId);
    }

    public Seq<Range> sliceRanges(int numberOfRanges) {
        return this.persistence.sliceRanges(numberOfRanges);
    }

    public Source<String, NotUsed> currentPersistenceIds(Option<String> afterId, long limit) {
        return this.storage.currentPersistenceIds(afterId, limit);
    }

    public Source<org.apache.pekko.persistence.query.EventEnvelope, NotUsed> eventsByTag(String tag, Offset offset) {
        Offset offset2 = offset;
        NoOffset$ noOffset$ = NoOffset$.MODULE$;
        if (offset2 == null ? noOffset$ != null : !offset2.equals(noOffset$)) {
            throw new UnsupportedOperationException("Offsets not supported for persistence test kit currentEventsByTag yet");
        }
        return Source$.MODULE$.fromGraph((Graph)new EventsByTagStage(tag, this.storage));
    }

    public Offset eventsByTag$default$2() {
        return NoOffset$.MODULE$;
    }

    public <Event> Source<EventEnvelope<Event>, NotUsed> eventsBySlices(String entityType, int minSlice, int maxSlice, Offset offset) {
        Offset offset2 = offset;
        NoOffset$ noOffset$ = NoOffset$.MODULE$;
        if (offset2 == null ? noOffset$ != null : !offset2.equals(noOffset$)) {
            throw new UnsupportedOperationException("Offsets not supported for persistence test kit eventsBySlices yet");
        }
        return Source$.MODULE$.fromGraph(new EventsBySliceStage(entityType, minSlice, maxSlice, this.storage, this.persistence));
    }
}

