/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit.query.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.journal.Tagged;
import org.apache.pekko.persistence.journal.Tagged$;
import org.apache.pekko.persistence.query.EventEnvelope;
import org.apache.pekko.persistence.query.EventEnvelope$;
import org.apache.pekko.persistence.query.Offset;
import org.apache.pekko.persistence.query.Sequence;
import org.apache.pekko.persistence.query.Sequence$;
import org.apache.pekko.persistence.testkit.EventStorage;
import org.apache.pekko.persistence.testkit.PersistenceTestKitPlugin;
import org.apache.pekko.persistence.testkit.PersistenceTestKitPlugin$TagWrite$;
import org.apache.pekko.persistence.testkit.query.internal.EventsByTagStage$State$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.SourceShape$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.OutHandler;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public final class EventsByTagStage
extends GraphStage<SourceShape<EventEnvelope>> {
    public final String org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$tag;
    public final EventStorage org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$storage;
    private final Outlet out;

    public EventsByTagStage(String tag, EventStorage storage) {
        this.org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$tag = tag;
        this.org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$storage = storage;
        this.out = Outlet$.MODULE$.apply("EventsByTagSource");
    }

    public Outlet<EventEnvelope> out() {
        return this.out;
    }

    public SourceShape<EventEnvelope> shape() {
        return SourceShape$.MODULE$.apply(this.out());
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new OutHandler(this){
            private Option state;
            private ActorRef stageActorRef;
            private final /* synthetic */ EventsByTagStage $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.state = Option$.MODULE$.empty();
                this.stageActorRef = null;
                this.setHandler($outer.out(), this);
            }

            public void preStart() {
                this.stageActorRef = this.getStageActor((Function1)(JProcedure1 & Serializable)in -> this.receiveNotifications((Tuple2)in)).ref();
                this.materializer().system().eventStream().subscribe(this.stageActorRef, PersistenceTestKitPlugin.TagWrite.class);
            }

            private void receiveNotifications(Tuple2 in) {
                Object object;
                Tuple2 tuple2 = in;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object msg = tuple2._2();
                Object msg2 = msg;
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(msg2, (Object)this.state);
                if (tuple22 != null && (object = tuple22._1()) instanceof PersistenceTestKitPlugin.TagWrite) {
                    PersistenceTestKitPlugin.TagWrite tagWrite = (PersistenceTestKitPlugin.TagWrite)object;
                    PersistenceTestKitPlugin.TagWrite tagWrite2 = PersistenceTestKitPlugin$TagWrite$.MODULE$.unapply(tagWrite);
                    String string = tagWrite2._1();
                    long l = tagWrite2._2();
                    long l2 = tagWrite2._3();
                    long timestamp = l;
                    long highestSequenceNr = l2;
                    PersistenceTestKitPlugin.TagWrite tagWrite3 = tagWrite;
                    Option maybeState = (Option)tuple22._2();
                    String string2 = tagWrite3.tag();
                    String string3 = this.$outer.org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$tag;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null) && maybeState.forall(arg_0 -> EventsByTagStage.org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$anon$1$$_$receiveNotifications$$anonfun$1(timestamp, highestSequenceNr, arg_0))) {
                        this.tryPush();
                        return;
                    }
                }
            }

            private void tryPush() {
                if (this.isAvailable(this.$outer.out())) {
                    Option maybeNextEvent = ((IterableOnceOps)this.$outer.org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$storage.tryReadByTag(this.$outer.org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$tag).sortBy(EventsByTagStage::org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$anon$1$$_$_$$anonfun$1, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$))).find((Function1 & Serializable)pr -> this.state.forall(arg_0 -> EventsByTagStage.org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$anon$1$$_$$anonfun$2$$anonfun$1(pr, arg_0)));
                    this.log().debug("tryPush available. State {} event {}", (Object)this.state, (Object)maybeNextEvent);
                    maybeNextEvent.foreach((Function1)(JProcedure1 & Serializable)pr -> {
                        Object object;
                        Outlet<EventEnvelope> outlet = this.$outer.out();
                        Sequence sequence = Sequence$.MODULE$.apply(pr.sequenceNr());
                        String string = pr.persistenceId();
                        long l = pr.sequenceNr();
                        Object object2 = pr.payload();
                        if (object2 instanceof Tagged) {
                            Object payload;
                            Tagged tagged = Tagged$.MODULE$.unapply((Tagged)object2);
                            Object object3 = tagged._1();
                            Set set = tagged._2();
                            object = payload = object3;
                        } else {
                            Object payload;
                            object = payload = object2;
                        }
                        this.push(outlet, EventEnvelope$.MODULE$.apply((Offset)sequence, string, l, object, pr.timestamp(), pr.metadata()));
                        this.state = Some$.MODULE$.apply((Object)EventsByTagStage$State$.MODULE$.apply(pr.timestamp(), pr.sequenceNr()));
                    });
                    return;
                }
                this.log().debug("tryPush, no demand");
            }

            public void onPull() {
                this.tryPush();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{preStart$$anonfun$1(scala.Tuple2 ), org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$anon$1$$_$receiveNotifications$$anonfun$1(long long org.apache.pekko.persistence.testkit.query.internal.EventsByTagStage$State ), org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$anon$1$$_$_$$anonfun$1(org.apache.pekko.persistence.PersistentRepr ), $anonfun$2(org.apache.pekko.persistence.PersistentRepr ), tryPush$$anonfun$1(org.apache.pekko.persistence.PersistentRepr ), org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$anon$1$$_$$anonfun$2$$anonfun$1(org.apache.pekko.persistence.PersistentRepr org.apache.pekko.persistence.testkit.query.internal.EventsByTagStage$State )}, serializedLambda);
            }
        };
    }

    public static final /* synthetic */ boolean org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$anon$1$$_$receiveNotifications$$anonfun$1(long timestamp$1, long highestSequenceNr$1, State _$1) {
        return _$1.isAfter(timestamp$1, highestSequenceNr$1);
    }

    public static final /* synthetic */ Tuple2 org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$anon$1$$_$_$$anonfun$1(PersistentRepr pr) {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)pr.timestamp()), (Object)BoxesRunTime.boxToLong((long)pr.sequenceNr()));
    }

    public static final /* synthetic */ boolean org$apache$pekko$persistence$testkit$query$internal$EventsByTagStage$$anon$1$$_$$anonfun$2$$anonfun$1(PersistentRepr pr$1, State _$2) {
        return _$2.isAfter(pr$1.timestamp(), pr$1.sequenceNr());
    }

    public static class State
    implements Product,
    Serializable {
        private final long currentTimestamp;
        private final long lastSequenceNr;

        public static State apply(long l, long l2) {
            return EventsByTagStage$State$.MODULE$.apply(l, l2);
        }

        public static State fromProduct(Product product) {
            return EventsByTagStage$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return EventsByTagStage$State$.MODULE$.unapply(state);
        }

        public State(long currentTimestamp, long lastSequenceNr) {
            this.currentTimestamp = currentTimestamp;
            this.lastSequenceNr = lastSequenceNr;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.currentTimestamp()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lastSequenceNr()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.currentTimestamp() != state.currentTimestamp()) return false;
            if (this.lastSequenceNr() != state.lastSequenceNr()) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            long l;
            int n2 = n;
            if (0 == n2) {
                l = this._1();
            } else if (1 == n2) {
                l = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)l);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "currentTimestamp";
            }
            if (1 == n2) {
                return "lastSequenceNr";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long currentTimestamp() {
            return this.currentTimestamp;
        }

        public long lastSequenceNr() {
            return this.lastSequenceNr;
        }

        public boolean isAfter(long timestamp, long sequenceNr) {
            return timestamp > this.currentTimestamp() || timestamp == this.currentTimestamp() && sequenceNr > this.lastSequenceNr();
        }

        public State copy(long currentTimestamp, long lastSequenceNr) {
            return new State(currentTimestamp, lastSequenceNr);
        }

        public long copy$default$1() {
            return this.currentTimestamp();
        }

        public long copy$default$2() {
            return this.lastSequenceNr();
        }

        public long _1() {
            return this.currentTimestamp();
        }

        public long _2() {
            return this.lastSequenceNr();
        }
    }
}

