/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit.query.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.query.Offset;
import org.apache.pekko.persistence.query.Sequence$;
import org.apache.pekko.persistence.query.typed.EventEnvelope;
import org.apache.pekko.persistence.testkit.EventStorage;
import org.apache.pekko.persistence.testkit.PersistenceTestKitPlugin;
import org.apache.pekko.persistence.testkit.PersistenceTestKitPlugin$SliceWrite$;
import org.apache.pekko.persistence.testkit.query.internal.EventsBySliceStage$State$;
import org.apache.pekko.persistence.typed.PersistenceId$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.SourceShape$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.OutHandler;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public final class EventsBySliceStage<Event>
extends GraphStage<SourceShape<EventEnvelope<Event>>> {
    public final String org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$entityType;
    public final int org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$minSlice;
    public final int org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$maxSlice;
    public final EventStorage org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$storage;
    public final Persistence org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$persistence;
    private final Outlet out;

    public EventsBySliceStage(String entityType, int minSlice, int maxSlice, EventStorage storage, Persistence persistence) {
        this.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$entityType = entityType;
        this.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$minSlice = minSlice;
        this.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$maxSlice = maxSlice;
        this.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$storage = storage;
        this.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$persistence = persistence;
        this.out = Outlet$.MODULE$.apply("EventsByTagSource");
    }

    public Outlet<EventEnvelope<Event>> out() {
        return this.out;
    }

    public SourceShape<EventEnvelope<Event>> shape() {
        return SourceShape$.MODULE$.apply(this.out());
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new OutHandler(this){
            private Option state;
            private ActorRef stageActorRef;
            private final /* synthetic */ EventsBySliceStage $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.state = Option$.MODULE$.empty();
                this.stageActorRef = null;
                this.setHandler($outer.out(), this);
            }

            public void preStart() {
                this.stageActorRef = this.getStageActor((Function1)(JProcedure1 & Serializable)in -> this.receiveNotifications((Tuple2)in)).ref();
                this.materializer().system().eventStream().subscribe(this.stageActorRef, PersistenceTestKitPlugin.SliceWrite.class);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private boolean shouldFilter(String persistenceId) {
                int slice = this.$outer.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$persistence.sliceForPersistenceId(persistenceId);
                String string = PersistenceId$.MODULE$.extractEntityType(persistenceId);
                String string2 = this.$outer.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$entityType;
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                if (slice < this.$outer.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$minSlice) return false;
                if (slice > this.$outer.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$maxSlice) return false;
                return true;
            }

            private void receiveNotifications(Tuple2 in) {
                Object object;
                Tuple2 tuple2 = in;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object msg = tuple2._2();
                Object msg2 = msg;
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(msg2, (Object)this.state);
                if (tuple22 != null && (object = tuple22._1()) instanceof PersistenceTestKitPlugin.SliceWrite) {
                    PersistenceTestKitPlugin.SliceWrite sliceWrite = PersistenceTestKitPlugin$SliceWrite$.MODULE$.unapply((PersistenceTestKitPlugin.SliceWrite)object);
                    String string = sliceWrite._1();
                    long l = sliceWrite._2();
                    long l2 = sliceWrite._3();
                    String persistenceId = string;
                    long timestamp = l;
                    long highestSequenceNr = l2;
                    Option maybeState = (Option)tuple22._2();
                    if (this.shouldFilter(persistenceId) && maybeState.forall(arg_0 -> EventsBySliceStage.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$anon$1$$_$receiveNotifications$$anonfun$1(timestamp, highestSequenceNr, arg_0))) {
                        this.tryPush();
                        return;
                    }
                }
            }

            private void tryPush() {
                if (this.isAvailable(this.$outer.out())) {
                    Option maybeNextEvent = ((IterableOnceOps)this.$outer.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$storage.tryRead(this.$outer.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$entityType, (Function1<PersistentRepr, Object>)(Function1 & Serializable)repr -> this.shouldFilter(repr.persistenceId())).sortBy(EventsBySliceStage::org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$anon$1$$_$_$$anonfun$2, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$))).find((Function1 & Serializable)pr -> this.state.forall(arg_0 -> EventsBySliceStage.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$anon$1$$_$$anonfun$3$$anonfun$1(pr, arg_0)));
                    this.log().debug("tryPush available. State {} event {}", (Object)this.state, (Object)maybeNextEvent);
                    maybeNextEvent.foreach((Function1)(JProcedure1 & Serializable)pr -> {
                        int slice = this.$outer.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$persistence.sliceForPersistenceId(pr.persistenceId());
                        this.push(this.$outer.out(), new EventEnvelope((Offset)Sequence$.MODULE$.apply(pr.sequenceNr()), pr.persistenceId(), pr.sequenceNr(), (Option)Some$.MODULE$.apply(pr.payload()), pr.timestamp(), pr.metadata(), this.$outer.org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$entityType, slice));
                        this.state = Some$.MODULE$.apply((Object)EventsBySliceStage$State$.MODULE$.apply(pr.timestamp(), pr.sequenceNr()));
                    });
                    return;
                }
                this.log().debug("tryPush, no demand");
            }

            public void onPull() {
                this.tryPush();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{preStart$$anonfun$1(scala.Tuple2 ), org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$anon$1$$_$receiveNotifications$$anonfun$1(long long org.apache.pekko.persistence.testkit.query.internal.EventsBySliceStage$State ), $anonfun$1(org.apache.pekko.persistence.PersistentRepr ), org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$anon$1$$_$_$$anonfun$2(org.apache.pekko.persistence.PersistentRepr ), $anonfun$3(org.apache.pekko.persistence.PersistentRepr ), tryPush$$anonfun$1(org.apache.pekko.persistence.PersistentRepr ), org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$anon$1$$_$$anonfun$3$$anonfun$1(org.apache.pekko.persistence.PersistentRepr org.apache.pekko.persistence.testkit.query.internal.EventsBySliceStage$State )}, serializedLambda);
            }
        };
    }

    public static final /* synthetic */ boolean org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$anon$1$$_$receiveNotifications$$anonfun$1(long timestamp$1, long highestSequenceNr$1, State _$1) {
        return _$1.isAfter(timestamp$1, highestSequenceNr$1);
    }

    public static final /* synthetic */ Tuple2 org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$anon$1$$_$_$$anonfun$2(PersistentRepr pr) {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)pr.timestamp()), (Object)BoxesRunTime.boxToLong((long)pr.sequenceNr()));
    }

    public static final /* synthetic */ boolean org$apache$pekko$persistence$testkit$query$internal$EventsBySliceStage$$anon$1$$_$$anonfun$3$$anonfun$1(PersistentRepr pr$1, State _$2) {
        return _$2.isAfter(pr$1.timestamp(), pr$1.sequenceNr());
    }

    public static class State
    implements Product,
    Serializable {
        private final long currentTimestamp;
        private final long lastSequenceNr;

        public static State apply(long l, long l2) {
            return EventsBySliceStage$State$.MODULE$.apply(l, l2);
        }

        public static State fromProduct(Product product) {
            return EventsBySliceStage$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return EventsBySliceStage$State$.MODULE$.unapply(state);
        }

        public State(long currentTimestamp, long lastSequenceNr) {
            this.currentTimestamp = currentTimestamp;
            this.lastSequenceNr = lastSequenceNr;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.currentTimestamp()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lastSequenceNr()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.currentTimestamp() != state.currentTimestamp()) return false;
            if (this.lastSequenceNr() != state.lastSequenceNr()) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            long l;
            int n2 = n;
            if (0 == n2) {
                l = this._1();
            } else if (1 == n2) {
                l = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)l);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "currentTimestamp";
            }
            if (1 == n2) {
                return "lastSequenceNr";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long currentTimestamp() {
            return this.currentTimestamp;
        }

        public long lastSequenceNr() {
            return this.lastSequenceNr;
        }

        public boolean isAfter(long timestamp, long sequenceNr) {
            return timestamp > this.currentTimestamp() || timestamp == this.currentTimestamp() && sequenceNr > this.lastSequenceNr();
        }

        public State copy(long currentTimestamp, long lastSequenceNr) {
            return new State(currentTimestamp, lastSequenceNr);
        }

        public long copy$default$1() {
            return this.currentTimestamp();
        }

        public long copy$default$2() {
            return this.lastSequenceNr();
        }

        public long _1() {
            return this.currentTimestamp();
        }

        public long _2() {
            return this.lastSequenceNr();
        }
    }
}

