/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit.javadsl;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.japi.Pair;
import org.apache.pekko.japi.Pair$;
import org.apache.pekko.persistence.testkit.ExpectedFailure$;
import org.apache.pekko.persistence.testkit.ProcessingPolicy;
import org.apache.pekko.persistence.testkit.SnapshotMeta;
import org.apache.pekko.persistence.testkit.SnapshotOperation;
import org.apache.pekko.persistence.testkit.javadsl.SnapshotTestKit$;
import org.apache.pekko.util.JavaDurationConverters;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.Function2;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

@ApiMayChange
public class SnapshotTestKit {
    private final org.apache.pekko.persistence.testkit.scaladsl.SnapshotTestKit scalaTestkit;

    public static SnapshotTestKit create(ActorSystem actorSystem) {
        return SnapshotTestKit$.MODULE$.create(actorSystem);
    }

    public static SnapshotTestKit create(org.apache.pekko.actor.typed.ActorSystem<?> actorSystem) {
        return SnapshotTestKit$.MODULE$.create(actorSystem);
    }

    public SnapshotTestKit(org.apache.pekko.persistence.testkit.scaladsl.SnapshotTestKit scalaTestkit) {
        this.scalaTestkit = scalaTestkit;
    }

    public SnapshotTestKit(ActorSystem system) {
        this(new org.apache.pekko.persistence.testkit.scaladsl.SnapshotTestKit(system));
    }

    public void expectNothingPersisted(String persistenceId) {
        this.scalaTestkit.expectNothingPersisted(persistenceId);
    }

    public void expectNothingPersisted(String persistenceId, Duration max) {
        this.scalaTestkit.expectNothingPersisted(persistenceId, JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)));
    }

    public <A> A expectNextPersisted(String persistenceId, A snapshot) {
        return this.scalaTestkit.expectNextPersisted(persistenceId, snapshot);
    }

    public <A> A expectNextPersisted(String persistenceId, A snapshot, Duration max) {
        return (A)this.scalaTestkit.expectNextPersisted(persistenceId, (Object)snapshot, JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)));
    }

    public <A> A expectNextPersistedClass(String persistenceId, Class<A> cla) {
        return (A)this.scalaTestkit.expectNextPersistedClass(persistenceId, (Class)cla);
    }

    public <A> A expectNextPersistedClass(String persistenceId, Class<A> cla, Duration max) {
        return (A)this.scalaTestkit.expectNextPersistedClass(persistenceId, (Class)cla, JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)));
    }

    public void failNextNPersisted(String persistenceId, int n, Throwable cause) {
        this.scalaTestkit.failNextNPersisted(persistenceId, n, cause);
    }

    public void failNextNPersisted(String persistenceId, int n) {
        this.failNextNPersisted(persistenceId, n, ExpectedFailure$.MODULE$);
    }

    public void failNextNPersisted(int n, Throwable cause) {
        this.scalaTestkit.failNextNPersisted(n, cause);
    }

    public void failNextNPersisted(int n) {
        this.failNextNPersisted(n, ExpectedFailure$.MODULE$);
    }

    public void failNextPersisted(String persistenceId, Throwable cause) {
        this.failNextNPersisted(persistenceId, 1, cause);
    }

    public void failNextPersisted(String persistenceId) {
        this.failNextNPersisted(persistenceId, 1);
    }

    public void failNextPersisted(Throwable cause) {
        this.failNextNPersisted(1, cause);
    }

    public void failNextPersisted() {
        this.failNextNPersisted(1);
    }

    public void failNextRead(Throwable cause) {
        this.failNextNReads(1, cause);
    }

    public void failNextRead() {
        this.failNextNReads(1);
    }

    public void failNextRead(String persistenceId, Throwable cause) {
        this.failNextNReads(persistenceId, 1, cause);
    }

    public void failNextRead(String persistenceId) {
        this.failNextNReads(persistenceId, 1);
    }

    public void failNextNReads(int n, Throwable cause) {
        this.scalaTestkit.failNextNReads(n, cause);
    }

    public void failNextNReads(int n) {
        this.failNextNReads(n, ExpectedFailure$.MODULE$);
    }

    public void failNextNReads(String persistenceId, int n, Throwable cause) {
        this.scalaTestkit.failNextNReads(persistenceId, n, cause);
    }

    public void failNextNReads(String persistenceId, int n) {
        this.failNextNReads(persistenceId, n, ExpectedFailure$.MODULE$);
    }

    public void failNextDelete(Throwable cause) {
        this.failNextNDeletes(1, cause);
    }

    public void failNextDelete() {
        this.failNextNDeletes(1);
    }

    public void failNextDelete(String persistenceId, Throwable cause) {
        this.failNextNDeletes(persistenceId, 1, cause);
    }

    public void failNextDelete(String persistenceId) {
        this.failNextNDeletes(persistenceId, 1);
    }

    public void failNextNDeletes(int n, Throwable cause) {
        this.scalaTestkit.failNextNDeletes(n, cause);
    }

    public void failNextNDeletes(int n) {
        this.failNextNDeletes(n, ExpectedFailure$.MODULE$);
    }

    public void failNextNDeletes(String persistenceId, int n, Throwable cause) {
        this.scalaTestkit.failNextNDeletes(persistenceId, n, cause);
    }

    public void failNextNDeletes(String persistenceId, int n) {
        this.failNextNDeletes(persistenceId, n, ExpectedFailure$.MODULE$);
    }

    public <A> List<A> receivePersisted(String persistenceId, int n, Class<A> cla) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.scalaTestkit.receivePersisted(persistenceId, n, (Class)cla)).asJava();
    }

    public <A> List<A> receivePersisted(String persistenceId, int n, Class<A> cla, Duration max) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.scalaTestkit.receivePersisted(persistenceId, n, (Class)cla, JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)))).asJava();
    }

    public void persistForRecovery(String persistenceId, List<Pair<SnapshotMeta, Object>> snapshots) {
        this.scalaTestkit.persistForRecovery(persistenceId, (scala.collection.immutable.Seq<Tuple2<SnapshotMeta, Object>>)((scala.collection.immutable.Seq)package.JavaConverters$.MODULE$.ListHasAsScala(snapshots).asScala().toVector().map((Function1 & Serializable)_$1 -> _$1.toScala())));
    }

    public List<Pair<SnapshotMeta, Object>> persistedInStorage(String persistenceId) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.scalaTestkit.persistedInStorage(persistenceId).map((Function1 & Serializable)p -> Pair$.MODULE$.apply(p._1(), p._2()))).asJava();
    }

    public void clearAll() {
        this.scalaTestkit.clearAll();
    }

    public void clearByPersistenceId(String persistenceId) {
        this.scalaTestkit.clearByPersistenceId(persistenceId);
    }

    public void failNextNOpsCond(BiFunction<String, SnapshotOperation, Object> cond, int n) {
        this.failNextNOpsCond(cond, n, ExpectedFailure$.MODULE$);
    }

    public void failNextNOpsCond(BiFunction<String, SnapshotOperation, Object> cond, int n, Throwable cause) {
        this.scalaTestkit.failNextNOpsCond((Function2 & Serializable)(l, r) -> BoxesRunTime.unboxToBoolean(cond.apply((String)l, (SnapshotOperation)r)), n, cause);
    }

    public void failNextNOps(int n) {
        this.failNextNOps(n, ExpectedFailure$.MODULE$);
    }

    public void failNextNOps(int n, Throwable cause) {
        this.scalaTestkit.failNextNOps(n, cause);
    }

    public SnapshotTestKit withPolicy(ProcessingPolicy<SnapshotOperation> policy) {
        this.scalaTestkit.withPolicy(policy);
        return this;
    }

    public void resetPolicy() {
        this.scalaTestkit.resetPolicy();
    }
}

