/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit.javadsl;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.persistence.testkit.ExpectedFailure$;
import org.apache.pekko.persistence.testkit.ExpectedRejection$;
import org.apache.pekko.persistence.testkit.JournalOperation;
import org.apache.pekko.persistence.testkit.ProcessingPolicy;
import org.apache.pekko.persistence.testkit.javadsl.PersistenceTestKit$;
import org.apache.pekko.util.JavaDurationConverters;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.ccompat.package;
import scala.Function2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

@ApiMayChange
public class PersistenceTestKit {
    private final org.apache.pekko.persistence.testkit.scaladsl.PersistenceTestKit scalaTestkit;

    public static PersistenceTestKit create(ActorSystem actorSystem) {
        return PersistenceTestKit$.MODULE$.create(actorSystem);
    }

    public static PersistenceTestKit create(org.apache.pekko.actor.typed.ActorSystem<?> actorSystem) {
        return PersistenceTestKit$.MODULE$.create(actorSystem);
    }

    public PersistenceTestKit(org.apache.pekko.persistence.testkit.scaladsl.PersistenceTestKit scalaTestkit) {
        this.scalaTestkit = scalaTestkit;
    }

    public PersistenceTestKit(ActorSystem system) {
        this(new org.apache.pekko.persistence.testkit.scaladsl.PersistenceTestKit(system));
    }

    public void expectNothingPersisted(String persistenceId) {
        this.scalaTestkit.expectNothingPersisted(persistenceId);
    }

    public void expectNothingPersisted(String persistenceId, Duration max) {
        this.scalaTestkit.expectNothingPersisted(persistenceId, JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)));
    }

    public <A> A expectNextPersisted(String persistenceId, A event) {
        return (A)this.scalaTestkit.expectNextPersisted(persistenceId, (Object)event);
    }

    public <A> A expectNextPersisted(String persistenceId, A event, Duration max) {
        return (A)this.scalaTestkit.expectNextPersisted(persistenceId, (Object)event, JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)));
    }

    public <A> A expectNextPersistedClass(String persistenceId, Class<A> cla) {
        return (A)this.scalaTestkit.expectNextPersistedClass(persistenceId, (Class)cla);
    }

    public <A> A expectNextPersistedClass(String persistenceId, Class<A> cla, Duration max) {
        return (A)this.scalaTestkit.expectNextPersistedClass(persistenceId, (Class)cla, JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)));
    }

    public void failNextNPersisted(String persistenceId, int n, Throwable cause) {
        this.scalaTestkit.failNextNPersisted(persistenceId, n, cause);
    }

    public void failNextNPersisted(String persistenceId, int n) {
        this.failNextNPersisted(persistenceId, n, ExpectedFailure$.MODULE$);
    }

    public void failNextNPersisted(int n, Throwable cause) {
        this.scalaTestkit.failNextNPersisted(n, cause);
    }

    public void failNextNPersisted(int n) {
        this.failNextNPersisted(n, ExpectedFailure$.MODULE$);
    }

    public void failNextPersisted(String persistenceId, Throwable cause) {
        this.failNextNPersisted(persistenceId, 1, cause);
    }

    public void failNextPersisted(String persistenceId) {
        this.failNextNPersisted(persistenceId, 1);
    }

    public void failNextPersisted(Throwable cause) {
        this.failNextNPersisted(1, cause);
    }

    public void failNextPersisted() {
        this.failNextNPersisted(1);
    }

    public void failNextRead(Throwable cause) {
        this.failNextNReads(1, cause);
    }

    public void failNextRead() {
        this.failNextNReads(1);
    }

    public void failNextRead(String persistenceId, Throwable cause) {
        this.failNextNReads(persistenceId, 1, cause);
    }

    public void failNextRead(String persistenceId) {
        this.failNextNReads(persistenceId, 1);
    }

    public void failNextNReads(int n, Throwable cause) {
        this.scalaTestkit.failNextNReads(n, cause);
    }

    public void failNextNReads(int n) {
        this.failNextNReads(n, ExpectedFailure$.MODULE$);
    }

    public void failNextNReads(String persistenceId, int n, Throwable cause) {
        this.scalaTestkit.failNextNReads(persistenceId, n, cause);
    }

    public void failNextNReads(String persistenceId, int n) {
        this.failNextNReads(persistenceId, n, ExpectedFailure$.MODULE$);
    }

    public void failNextDelete(Throwable cause) {
        this.failNextNDeletes(1, cause);
    }

    public void failNextDelete() {
        this.failNextNDeletes(1);
    }

    public void failNextDelete(String persistenceId, Throwable cause) {
        this.failNextNDeletes(persistenceId, 1, cause);
    }

    public void failNextDelete(String persistenceId) {
        this.failNextNDeletes(persistenceId, 1);
    }

    public void failNextNDeletes(int n, Throwable cause) {
        this.scalaTestkit.failNextNDeletes(n, cause);
    }

    public void failNextNDeletes(int n) {
        this.failNextNDeletes(n, ExpectedFailure$.MODULE$);
    }

    public void failNextNDeletes(String persistenceId, int n, Throwable cause) {
        this.scalaTestkit.failNextNDeletes(persistenceId, n, cause);
    }

    public void failNextNDeletes(String persistenceId, int n) {
        this.failNextNDeletes(persistenceId, n, ExpectedFailure$.MODULE$);
    }

    public <A> List<A> receivePersisted(String persistenceId, int n, Class<A> cla) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.scalaTestkit.receivePersisted(persistenceId, n, (Class)cla)).asJava();
    }

    public <A> List<A> receivePersisted(String persistenceId, int n, Class<A> cla, Duration max) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.scalaTestkit.receivePersisted(persistenceId, n, (Class)cla, JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)))).asJava();
    }

    public void rejectNextNPersisted(String persistenceId, int n, Throwable cause) {
        this.scalaTestkit.rejectNextNPersisted(persistenceId, n, cause);
    }

    public void rejectNextNPersisted(String persistenceId, int n) {
        this.rejectNextNPersisted(persistenceId, n, ExpectedRejection$.MODULE$);
    }

    public void rejectNextNPersisted(int n) {
        this.rejectNextNPersisted(n, ExpectedRejection$.MODULE$);
    }

    public void rejectNextNPersisted(int n, Throwable cause) {
        this.scalaTestkit.rejectNextNPersisted(n, cause);
    }

    public void rejectNextPersisted(String persistenceId) {
        this.rejectNextNPersisted(persistenceId, 1);
    }

    public void rejectNextPersisted(String persistenceId, Throwable cause) {
        this.rejectNextNPersisted(persistenceId, 1, cause);
    }

    public void rejectNextPersisted(Throwable cause) {
        this.rejectNextNPersisted(1, cause);
    }

    public void rejectNextPersisted() {
        this.rejectNextNPersisted(1);
    }

    public void rejectNextRead() {
        this.rejectNextNReads(1);
    }

    public void rejectNextRead(Throwable cause) {
        this.rejectNextNReads(1, cause);
    }

    public void rejectNextNReads(int n) {
        this.rejectNextNReads(n, ExpectedRejection$.MODULE$);
    }

    public void rejectNextNReads(int n, Throwable cause) {
        this.scalaTestkit.rejectNextNReads(n, cause);
    }

    public void rejectNextRead(String persistenceId) {
        this.rejectNextNReads(persistenceId, 1);
    }

    public void rejectNextRead(String persistenceId, Throwable cause) {
        this.rejectNextNReads(persistenceId, 1, cause);
    }

    public void rejectNextNReads(String persistenceId, int n) {
        this.rejectNextNReads(persistenceId, n, ExpectedRejection$.MODULE$);
    }

    public void rejectNextNReads(String persistenceId, int n, Throwable cause) {
        this.scalaTestkit.rejectNextNReads(persistenceId, n, cause);
    }

    public void rejectNextDelete() {
        this.rejectNextNDeletes(1);
    }

    public void rejectNextDelete(Throwable cause) {
        this.rejectNextNDeletes(1, cause);
    }

    public void rejectNextNDeletes(int n) {
        this.rejectNextNDeletes(n, ExpectedRejection$.MODULE$);
    }

    public void rejectNextNDeletes(int n, Throwable cause) {
        this.scalaTestkit.rejectNextNDeletes(n, cause);
    }

    public void rejectNextDelete(String persistenceId) {
        this.rejectNextNDeletes(persistenceId, 1);
    }

    public void rejectNextDelete(String persistenceId, Throwable cause) {
        this.rejectNextNDeletes(persistenceId, 1, cause);
    }

    public void rejectNextNDeletes(String persistenceId, int n) {
        this.rejectNextNDeletes(persistenceId, n, ExpectedRejection$.MODULE$);
    }

    public void rejectNextNDeletes(String persistenceId, int n, Throwable cause) {
        this.scalaTestkit.rejectNextNDeletes(persistenceId, n, cause);
    }

    public void rejectNextNOpsCond(BiFunction<String, JournalOperation, Object> cond, int n) {
        this.rejectNextNOpsCond(cond, n, ExpectedRejection$.MODULE$);
    }

    public void rejectNextNOpsCond(BiFunction<String, JournalOperation, Object> cond, int n, Throwable cause) {
        this.scalaTestkit.rejectNextNOpsCond((Function2 & Serializable)(l, r) -> BoxesRunTime.unboxToBoolean(cond.apply((String)l, (JournalOperation)r)), n, cause);
    }

    public void rejectNextNOps(int n) {
        this.rejectNextNOps(n, ExpectedRejection$.MODULE$);
    }

    public void rejectNextNOps(int n, Throwable cause) {
        this.scalaTestkit.rejectNextNOps(n, cause);
    }

    public void persistForRecovery(String persistenceId, List<Object> events) {
        this.scalaTestkit.persistForRecovery(persistenceId, (scala.collection.immutable.Seq<Object>)package.JavaConverters$.MODULE$.ListHasAsScala(events).asScala().toVector());
    }

    public List<Object> persistedInStorage(String persistenceId) {
        return package.JavaConverters$.MODULE$.SeqHasAsJava(this.scalaTestkit.persistedInStorage(persistenceId)).asJava();
    }

    public void clearAll() {
        this.scalaTestkit.clearAll();
    }

    public void clearByPersistenceId(String persistenceId) {
        this.scalaTestkit.clearByPersistenceId(persistenceId);
    }

    public void clearAllPreservingSeqNumbers() {
        this.scalaTestkit.clearAllPreservingSeqNumbers();
    }

    public void clearByIdPreservingSeqNumbers(String persistenceId) {
        this.scalaTestkit.clearByIdPreservingSeqNumbers(persistenceId);
    }

    public void failNextNOpsCond(BiFunction<String, JournalOperation, Object> cond, int n) {
        this.failNextNOpsCond(cond, n, ExpectedFailure$.MODULE$);
    }

    public void failNextNOpsCond(BiFunction<String, JournalOperation, Object> cond, int n, Throwable cause) {
        this.scalaTestkit.failNextNOpsCond((Function2 & Serializable)(l, r) -> BoxesRunTime.unboxToBoolean(cond.apply((String)l, (JournalOperation)r)), n, cause);
    }

    public void failNextNOps(int n) {
        this.failNextNOps(n, ExpectedFailure$.MODULE$);
    }

    public void failNextNOps(int n, Throwable cause) {
        this.scalaTestkit.failNextNOps(n, cause);
    }

    public PersistenceTestKit withPolicy(ProcessingPolicy<JournalOperation> policy) {
        this.scalaTestkit.withPolicy(policy);
        return this;
    }

    public void resetPolicy() {
        this.scalaTestkit.resetPolicy();
    }
}

