/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit.javadsl;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.persistence.testkit.javadsl.EventSourcedBehaviorTestKit$;
import org.apache.pekko.persistence.testkit.javadsl.PersistenceTestKit;
import org.apache.pekko.persistence.testkit.javadsl.SnapshotTestKit;
import org.apache.pekko.persistence.testkit.scaladsl.EventSourcedBehaviorTestKit;
import org.apache.pekko.util.OptionConverters;
import org.apache.pekko.util.OptionConverters$;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

@ApiMayChange
public final class EventSourcedBehaviorTestKit<Command, Event, State> {
    private final org.apache.pekko.persistence.testkit.scaladsl.EventSourcedBehaviorTestKit<Command, Event, State> delegate;
    private final PersistenceTestKit _persistenceTestKit;
    private final Optional<SnapshotTestKit> _snapshotTestKit;

    public static Config config() {
        return EventSourcedBehaviorTestKit$.MODULE$.config();
    }

    public static <Command, Event, State> EventSourcedBehaviorTestKit<Command, Event, State> create(ActorSystem<?> actorSystem, Behavior<Command> behavior) {
        return EventSourcedBehaviorTestKit$.MODULE$.create(actorSystem, behavior);
    }

    public static <Command, Event, State> EventSourcedBehaviorTestKit<Command, Event, State> create(ActorSystem<?> actorSystem, Behavior<Command> behavior, SerializationSettings serializationSettings) {
        return EventSourcedBehaviorTestKit$.MODULE$.create(actorSystem, behavior, serializationSettings);
    }

    public static SerializationSettings disabledSerializationSettings() {
        return EventSourcedBehaviorTestKit$.MODULE$.disabledSerializationSettings();
    }

    public static SerializationSettings enabledSerializationSettings() {
        return EventSourcedBehaviorTestKit$.MODULE$.enabledSerializationSettings();
    }

    public EventSourcedBehaviorTestKit(org.apache.pekko.persistence.testkit.scaladsl.EventSourcedBehaviorTestKit<Command, Event, State> delegate) {
        this.delegate = delegate;
        this._persistenceTestKit = new PersistenceTestKit(delegate.persistenceTestKit());
        Option option = OptionConverters$.MODULE$.RichOption(delegate.snapshotTestKit().map((Function1 & Serializable)_$1 -> new SnapshotTestKit((org.apache.pekko.persistence.testkit.scaladsl.SnapshotTestKit)_$1)));
        this._snapshotTestKit = OptionConverters.RichOption$.MODULE$.toJava$extension(option);
    }

    public CommandResult<Command, Event, State> runCommand(Command command) {
        return new CommandResult<Command, Event, State>(this.delegate.runCommand(command));
    }

    public <R> CommandResultWithReply<Command, Event, State, R> runCommand(Function<ActorRef<R>, Command> creator) {
        return new CommandResultWithReply(this.delegate.runCommand((Function1 & Serializable)replyTo -> creator.apply((ActorRef)replyTo)));
    }

    public State getState() {
        return this.delegate.getState();
    }

    public RestartResult<State> restart() {
        return new RestartResult<State>(this.delegate.restart());
    }

    public void clear() {
        this.delegate.clear();
    }

    public void initialize(State state, Seq<Event> events) {
        this.delegate.initialize(state, events);
    }

    public void initialize(State state, Event ... events) {
        this.initialize(state, (Seq<Event>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])events));
    }

    public void initialize(Seq<Event> events) {
        this.delegate.initialize(events);
    }

    public void initialize(Event ... events) {
        this.initialize((Seq<Event>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])events));
    }

    public PersistenceTestKit persistenceTestKit() {
        return this._persistenceTestKit;
    }

    public Optional<SnapshotTestKit> snapshotTestKit() {
        return this._snapshotTestKit;
    }

    @DoNotInherit
    public static class CommandResult<Command, Event, State> {
        private final EventSourcedBehaviorTestKit.CommandResult<Command, Event, State> delegate;

        public CommandResult(EventSourcedBehaviorTestKit.CommandResult<Command, Event, State> delegate) {
            this.delegate = delegate;
        }

        public Command command() {
            return this.delegate.command();
        }

        public List<Event> events() {
            return package.JavaConverters$.MODULE$.SeqHasAsJava(this.delegate.events()).asJava();
        }

        public boolean hasNoEvents() {
            return this.delegate.hasNoEvents();
        }

        public Event event() {
            return this.delegate.event();
        }

        public <E extends Event> E eventOfType(Class<E> eventClass) {
            return this.delegate.eventOfType(ClassTag$.MODULE$.apply(eventClass));
        }

        public State state() {
            return this.delegate.state();
        }

        public <S extends State> S stateOfType(Class<S> stateClass) {
            return this.delegate.stateOfType(ClassTag$.MODULE$.apply(stateClass));
        }
    }

    public static final class CommandResultWithReply<Command, Event, State, Reply>
    extends CommandResult<Command, Event, State> {
        private final EventSourcedBehaviorTestKit.CommandResultWithReply<Command, Event, State, Reply> delegate;

        public CommandResultWithReply(EventSourcedBehaviorTestKit.CommandResultWithReply<Command, Event, State, Reply> delegate) {
            this.delegate = delegate;
            super(delegate);
        }

        public Reply reply() {
            return this.delegate.reply();
        }

        public <R extends Reply> R replyOfType(Class<R> replyClass) {
            return this.delegate.replyOfType(ClassTag$.MODULE$.apply(replyClass));
        }

        public boolean hasNoReply() {
            return this.delegate.hasNoReply();
        }
    }

    public static final class RestartResult<State> {
        private final EventSourcedBehaviorTestKit.RestartResult<State> delegate;

        public RestartResult(EventSourcedBehaviorTestKit.RestartResult<State> delegate) {
            this.delegate = delegate;
        }

        public State state() {
            return this.delegate.state();
        }
    }

    public static final class SerializationSettings {
        private final boolean enabled;
        private final boolean verifyEquality;
        private final boolean verifyCommands;
        private final boolean verifyEvents;
        private final boolean verifyState;

        public SerializationSettings(boolean enabled, boolean verifyEquality, boolean verifyCommands, boolean verifyEvents, boolean verifyState) {
            this.enabled = enabled;
            this.verifyEquality = verifyEquality;
            this.verifyCommands = verifyCommands;
            this.verifyEvents = verifyEvents;
            this.verifyState = verifyState;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public boolean verifyEquality() {
            return this.verifyEquality;
        }

        public boolean verifyCommands() {
            return this.verifyCommands;
        }

        public boolean verifyEvents() {
            return this.verifyEvents;
        }

        public boolean verifyState() {
            return this.verifyState;
        }

        public SerializationSettings withEnabled(boolean value) {
            return this.copy(value, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public SerializationSettings withVerifyEquality(boolean value) {
            return this.copy(this.copy$default$1(), value, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public SerializationSettings withVerifyCommands(boolean value) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), value, this.copy$default$4(), this.copy$default$5());
        }

        public SerializationSettings withVerifyEvents(boolean value) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), value, this.copy$default$5());
        }

        public SerializationSettings withVerifyState(boolean value) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), value);
        }

        private SerializationSettings copy(boolean enabled, boolean verifyEquality, boolean verifyCommands, boolean verifyEvents, boolean verifyState) {
            return new SerializationSettings(enabled, verifyEquality, verifyCommands, verifyEvents, verifyState);
        }

        private boolean copy$default$1() {
            return this.enabled();
        }

        private boolean copy$default$2() {
            return this.verifyEquality();
        }

        private boolean copy$default$3() {
            return this.verifyCommands();
        }

        private boolean copy$default$4() {
            return this.verifyEvents();
        }

        private boolean copy$default$5() {
            return this.verifyState();
        }
    }
}

