/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit.internal;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.testkit.EventStorage;
import org.apache.pekko.persistence.testkit.JournalOperation;
import org.apache.pekko.persistence.testkit.PersistenceTestKitPlugin$;
import org.apache.pekko.persistence.testkit.ProcessingPolicy;
import org.apache.pekko.persistence.testkit.internal.InMemStorageExtension$;
import org.apache.pekko.persistence.testkit.internal.SerializedEventStorageImpl;
import org.apache.pekko.persistence.testkit.internal.SimpleEventStorageImpl;
import org.apache.pekko.persistence.testkit.scaladsl.PersistenceTestKit;
import org.apache.pekko.persistence.testkit.scaladsl.PersistenceTestKit$Settings$;

@InternalApi
public final class InMemStorageExtension
implements Extension {
    private final ExtendedActorSystem system;
    private final ConcurrentHashMap<String, EventStorage> stores;

    public static Extension apply(ActorSystem actorSystem) {
        return InMemStorageExtension$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return InMemStorageExtension$.MODULE$.apply(classicActorSystemProvider);
    }

    public static InMemStorageExtension createExtension(ExtendedActorSystem extendedActorSystem) {
        return InMemStorageExtension$.MODULE$.createExtension(extendedActorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return InMemStorageExtension$.MODULE$.get(actorSystem);
    }

    public static InMemStorageExtension get(ActorSystem actorSystem) {
        return InMemStorageExtension$.MODULE$.get(actorSystem);
    }

    public static Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return InMemStorageExtension$.MODULE$.get(classicActorSystemProvider);
    }

    public static ExtensionId<? extends Extension> lookup() {
        return InMemStorageExtension$.MODULE$.lookup();
    }

    public InMemStorageExtension(ExtendedActorSystem system) {
        this.system = system;
        this.stores = new ConcurrentHashMap();
    }

    public EventStorage defaultStorage() {
        return this.storageFor(PersistenceTestKitPlugin$.MODULE$.PluginId());
    }

    public ProcessingPolicy<JournalOperation> currentPolicy() {
        return this.defaultStorage().currentPolicy();
    }

    public void setPolicy(ProcessingPolicy<JournalOperation> policy) {
        this.defaultStorage().setPolicy(policy);
    }

    public void resetPolicy() {
        this.defaultStorage().resetPolicy();
    }

    public EventStorage storageFor(String key) {
        return this.stores.computeIfAbsent(key, _$1 -> {
            if (((PersistenceTestKit.Settings)PersistenceTestKit$Settings$.MODULE$.apply((ActorSystem)this.system)).serialize()) {
                return new SerializedEventStorageImpl((ActorSystem)this.system);
            }
            return new SimpleEventStorageImpl();
        });
    }
}

