/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit.internal;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.testkit.internal.InternalReprSupport;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

@InternalApi
public interface InMemStorage<K, R>
extends InternalReprSupport<R> {
    public static void $init$(InMemStorage $this) {
        $this.org$apache$pekko$persistence$testkit$internal$InMemStorage$_setter_$org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock_$eq(new Object());
        $this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue_$eq(Predef$.MODULE$.Map().empty());
        $this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap_$eq(Predef$.MODULE$.Map().empty());
    }

    public Object org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock();

    public void org$apache$pekko$persistence$testkit$internal$InMemStorage$_setter_$org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock_$eq(Object var1);

    public Map<K, Vector<Object>> org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue();

    public void org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue_$eq(Map<K, Vector<Object>> var1);

    public Map<K, Tuple2<Object, Vector<Object>>> org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap();

    public void org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap_$eq(Map<K, Tuple2<Object, Vector<Object>>> var1);

    public long reprToSeqNum(R var1);

    public static Option findMany$(InMemStorage $this, Object key, int fromInclusive, int maxNum) {
        return $this.findMany(key, fromInclusive, maxNum);
    }

    default public Option<Vector<R>> findMany(K key, int fromInclusive, int maxNum) {
        return this.read(key).flatMap((Function1 & Serializable)value -> {
            if (value.size() > fromInclusive) {
                return Some$.MODULE$.apply((Object)value.drop(fromInclusive).take(maxNum));
            }
            return None$.MODULE$;
        });
    }

    public static void removeFirstInExpectNextQueue$(InMemStorage $this, Object key) {
        $this.removeFirstInExpectNextQueue(key);
    }

    default public void removeFirstInExpectNextQueue(K key) {
        Object object = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock();
        synchronized (object) {
            this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue().get(key).foreach((Function1)(JProcedure1 & Serializable)item -> this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue_$eq((Map)this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue().updated(key, (Object)item.tail())));
        }
    }

    public static Option firstInExpectNextQueue$(InMemStorage $this, Object key) {
        return $this.firstInExpectNextQueue(key);
    }

    default public Option<R> firstInExpectNextQueue(K key) {
        Option option;
        Object object = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock();
        synchronized (object) {
            option = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue().get(key).flatMap((Function1 & Serializable)item -> item.headOption().map((Function1 & Serializable)internal -> this.toRepr(internal)));
        }
        return option;
    }

    public static Option findOneByIndex$(InMemStorage $this, Object key, int index) {
        return $this.findOneByIndex(key, index);
    }

    default public Option<R> findOneByIndex(K key, int index) {
        Option option;
        Object object = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock();
        synchronized (object) {
            option = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap().get(key).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Vector value = (Vector)tuple2._2();
                    if (value.size() > index) {
                        return Some$.MODULE$.apply(value.apply(index));
                    }
                    return None$.MODULE$;
                }
                throw new MatchError((Object)tuple2);
            }).map((Function1 & Serializable)internal -> this.toRepr(internal));
        }
        return option;
    }

    public static void add$(InMemStorage $this, Object key, Object p) {
        $this.add(key, p);
    }

    default public void add(K key, R p) {
        Object object = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock();
        synchronized (object) {
            if (!this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue().contains(key)) {
                Object object2 = Predef$.MODULE$.ArrowAssoc(key);
                this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue_$eq((Map)this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object2, (Object)scala.package$.MODULE$.Vector().empty())));
            }
            this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue().get(key).foreach((Function1)(JProcedure1 & Serializable)items -> {
                this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue_$eq((Map)this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue().$minus(key));
                Vector newItems = (Vector)items.$colon$plus(this.toInternal(p));
                Object object = Predef$.MODULE$.ArrowAssoc(key);
                this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue_$eq((Map)this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$expectNextQueue().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)newItems)));
            });
            this.add(key, (Seq)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{p})));
        }
    }

    public static void add$(InMemStorage $this, Object key, Seq elems) {
        $this.add(key, elems);
    }

    default public void add(K key, Seq<R> elems) {
        this.updateOrSetNew(key, (Function1 & Serializable)v -> (Vector)v.$plus$plus((IterableOnce)elems));
    }

    public static Vector delete$(InMemStorage $this, Object key, Function1 needsToBeDeleted) {
        return $this.delete(key, needsToBeDeleted);
    }

    default public Vector<R> delete(K key, Function1<R, Object> needsToBeDeleted) {
        return this.updateOrSetNew(key, (Function1 & Serializable)v -> (Vector)v.filterNot(needsToBeDeleted));
    }

    public static Vector updateOrSetNew$(InMemStorage $this, Object key, Function1 updater) {
        return $this.updateOrSetNew(key, updater);
    }

    default public Vector<R> updateOrSetNew(K key, Function1<Vector<R>, Vector<R>> updater) {
        Vector vector;
        Object object = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock();
        synchronized (object) {
            Tuple2 tuple2 = (Tuple2)this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap().getOrElse(key, InMemStorage::$anonfun$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long oldSn = BoxesRunTime.unboxToLong((Object)tuple2._1());
            Vector oldElems = (Vector)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)oldSn), (Object)oldElems);
            long oldSn2 = BoxesRunTime.unboxToLong((Object)tuple22._1());
            Vector oldElems2 = (Vector)tuple22._2();
            Vector upd = (Vector)((SeqOps)updater.apply(oldElems2.map((Function1 & Serializable)internal -> this.toRepr(internal)))).sortBy((Function1 & Serializable)repr -> this.reprToSeqNum(repr), (Ordering)Ordering.Long$.MODULE$);
            Tuple2 newValue = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.max(this.getLastSeqNumber((Seq<R>)upd), oldSn2)), upd.map((Function1 & Serializable)repr -> this.toInternal(repr)));
            this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap_$eq((Map)this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap().updated(key, (Object)newValue));
            vector = (Vector)((StrictOptimizedIterableOps)newValue._2()).map((Function1 & Serializable)internal -> this.toRepr(internal));
        }
        return vector;
    }

    public static Option read$(InMemStorage $this, Object key) {
        return $this.read(key);
    }

    default public Option<Vector<R>> read(K key) {
        Option option;
        Object object = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock();
        synchronized (object) {
            option = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap().get(key).map((Function1 & Serializable)_$1 -> (Vector)((StrictOptimizedIterableOps)_$1._2()).map((Function1 & Serializable)internal -> this.toRepr(internal)));
        }
        return option;
    }

    public static Iterable readAll$(InMemStorage $this) {
        return $this.readAll();
    }

    default public Iterable<R> readAll() {
        Iterable iterable;
        Object object = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock();
        synchronized (object) {
            iterable = (Iterable)((IterableOps)this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap().values().flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Vector events = (Vector)tuple2._2();
                    return events;
                }
                throw new MatchError((Object)tuple2);
            })).map((Function1 & Serializable)internal -> this.toRepr(internal));
        }
        return iterable;
    }

    public static void clearAll$(InMemStorage $this) {
        $this.clearAll();
    }

    default public void clearAll() {
        Object object = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock();
        synchronized (object) {
            this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap_$eq(Predef$.MODULE$.Map().empty());
        }
    }

    public static Vector removeKey$(InMemStorage $this, Object key) {
        return $this.removeKey(key);
    }

    default public Vector<R> removeKey(K key) {
        Vector vector;
        Object object = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock();
        synchronized (object) {
            Option ret = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap().get(key);
            this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap_$eq((Map)this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap().$minus(key));
            vector = (Vector)((StrictOptimizedIterableOps)ret.map((Function1 & Serializable)_$2 -> (Vector)_$2._2()).getOrElse(InMemStorage::removeKey$$anonfun$2)).map((Function1 & Serializable)internal -> this.toRepr(internal));
        }
        return vector;
    }

    public static Seq read$(InMemStorage $this, Object key, long fromInclusive, long toInclusive, long maxNumber) {
        return $this.read(key, fromInclusive, toInclusive, maxNumber);
    }

    default public Seq<R> read(K key, long fromInclusive, long toInclusive, long maxNumber) {
        Vector vector;
        Object object = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock();
        synchronized (object) {
            vector = ((Vector)((IterableOps)((IterableOps)this.read(key).getOrElse(InMemStorage::read$$anonfun$2)).dropWhile((Function1 & Serializable)_$3 -> this.reprToSeqNum(_$3) < fromInclusive)).takeWhile((Function1 & Serializable)_$4 -> this.reprToSeqNum(_$4) <= toInclusive)).take(maxNumber > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxNumber);
        }
        return vector;
    }

    public static void removePreservingSeqNumber$(InMemStorage $this, Object key) {
        $this.removePreservingSeqNumber(key);
    }

    default public void removePreservingSeqNumber(K key) {
        this.updateOrSetNew(key, (Function1 & Serializable)_$5 -> scala.package$.MODULE$.Vector().empty());
    }

    public static long getHighestSeqNumber$(InMemStorage $this, Object key) {
        return $this.getHighestSeqNumber(key);
    }

    default public long getHighestSeqNumber(K key) {
        long l;
        Object object = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock();
        synchronized (object) {
            l = BoxesRunTime.unboxToLong((Object)this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap().get(key).map((Function1 & Serializable)_$6 -> BoxesRunTime.unboxToLong((Object)_$6._1())).getOrElse(InMemStorage::getHighestSeqNumber$$anonfun$2));
        }
        return l;
    }

    public static void deleteToSeqNumber$(InMemStorage $this, Object key, long toSeqNumberInclusive) {
        $this.deleteToSeqNumber(key, toSeqNumberInclusive);
    }

    default public void deleteToSeqNumber(K key, long toSeqNumberInclusive) {
        this.updateOrSetNew(key, (Function1 & Serializable)value -> (Vector)value.dropWhile((Function1 & Serializable)_$7 -> this.reprToSeqNum(_$7) <= toSeqNumberInclusive));
    }

    public static void clearAllPreservingSeqNumbers$(InMemStorage $this) {
        $this.clearAllPreservingSeqNumbers();
    }

    default public void clearAllPreservingSeqNumbers() {
        Object object = this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$lock();
        synchronized (object) {
            this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap().keys().foreach((Function1)(JProcedure1 & Serializable)key -> this.removePreservingSeqNumber(key));
        }
    }

    public static Seq keys$(InMemStorage $this) {
        return $this.keys();
    }

    default public Seq<K> keys() {
        return this.org$apache$pekko$persistence$testkit$internal$InMemStorage$$eventsMap().keys().toList();
    }

    private long getLastSeqNumber(Seq<R> elems) {
        return BoxesRunTime.unboxToLong((Object)elems.lastOption().map((Function1 & Serializable)repr -> this.reprToSeqNum(repr)).getOrElse(InMemStorage::getLastSeqNumber$$anonfun$2));
    }

    private static Tuple2 $anonfun$1() {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L), (Object)scala.package$.MODULE$.Vector().empty());
    }

    private static Vector removeKey$$anonfun$2() {
        return scala.package$.MODULE$.Vector().empty();
    }

    private static Vector read$$anonfun$2() {
        return scala.package$.MODULE$.Vector().empty();
    }

    private static long getHighestSeqNumber$$anonfun$2() {
        return 0L;
    }

    private static long getLastSeqNumber$$anonfun$2() {
        return 0L;
    }
}

