/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit.internal;

import java.io.Serializable;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.testkit.typed.scaladsl.ActorTestKit;
import org.apache.pekko.actor.testkit.typed.scaladsl.SerializationTestKit;
import org.apache.pekko.actor.testkit.typed.scaladsl.TestProbe;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.query.EventEnvelope;
import org.apache.pekko.persistence.query.PersistenceQuery;
import org.apache.pekko.persistence.query.PersistenceQuery$;
import org.apache.pekko.persistence.query.scaladsl.CurrentEventsByPersistenceIdQuery;
import org.apache.pekko.persistence.testkit.SnapshotMeta;
import org.apache.pekko.persistence.testkit.SnapshotMeta$;
import org.apache.pekko.persistence.testkit.internal.EventSourcedBehaviorTestKitImpl$;
import org.apache.pekko.persistence.testkit.internal.EventSourcedBehaviorTestKitImpl$CommandResultImpl$;
import org.apache.pekko.persistence.testkit.internal.EventSourcedBehaviorTestKitImpl$RestartResultImpl$;
import org.apache.pekko.persistence.testkit.query.scaladsl.PersistenceTestKitReadJournal$;
import org.apache.pekko.persistence.testkit.scaladsl.EventSourcedBehaviorTestKit;
import org.apache.pekko.persistence.testkit.scaladsl.PersistenceTestKit;
import org.apache.pekko.persistence.testkit.scaladsl.PersistenceTestKit$;
import org.apache.pekko.persistence.testkit.scaladsl.SnapshotTestKit;
import org.apache.pekko.persistence.testkit.scaladsl.SnapshotTestKit$;
import org.apache.pekko.persistence.typed.PersistenceId;
import org.apache.pekko.persistence.typed.internal.EventSourcedBehaviorImpl;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.scaladsl.Sink$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

@InternalApi
public class EventSourcedBehaviorTestKitImpl<Command, Event, State>
implements EventSourcedBehaviorTestKit<Command, Event, State> {
    private final ActorTestKit actorTestKit;
    private final Behavior<Command> behavior;
    private final EventSourcedBehaviorTestKit.SerializationSettings serializationSettings;
    private final PersistenceTestKit persistenceTestKit;
    private final Option snapshotTestKit;
    private final CurrentEventsByPersistenceIdQuery queries;
    private final TestProbe<EventSourcedBehaviorImpl.GetStateReply<State>> stateProbe;
    private ActorRef<Command> actor;
    private final PersistenceId persistenceId;
    private final SerializationTestKit serializationTestKit;
    private boolean emptyStateVerified;

    public EventSourcedBehaviorTestKitImpl(ActorTestKit actorTestKit, Behavior<Command> behavior, EventSourcedBehaviorTestKit.SerializationSettings serializationSettings) {
        PersistenceId persistenceId;
        this.actorTestKit = actorTestKit;
        this.behavior = behavior;
        this.serializationSettings = serializationSettings;
        if (this.system().settings().config().getBoolean("pekko.persistence.testkit.events.serialize") || this.system().settings().config().getBoolean("pekko.persistence.testkit.snapshots.serialize")) {
            this.system().log().warn("Persistence TestKit serialization enabled when using EventSourcedBehaviorTestKit, this is not intended. make sure you create the system used in the test with the config from EventSourcedBehaviorTestKit.config as described in the docs https://pekko.apache.org/docs/pekko/current/typed/persistence-testing.html#unit-testing");
        }
        this.persistenceTestKit = PersistenceTestKit$.MODULE$.apply((ClassicActorSystemProvider)this.system());
        this.persistenceTestKit().clearAll();
        String string = this.system().settings().config().getString("pekko.persistence.snapshot-store.plugin");
        String string2 = "";
        this.snapshotTestKit = (string == null ? string2 != null : !string.equals(string2)) ? Some$.MODULE$.apply((Object)SnapshotTestKit$.MODULE$.apply(this.system())) : None$.MODULE$;
        this.snapshotTestKit().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.clearAll());
        this.queries = (CurrentEventsByPersistenceIdQuery)((PersistenceQuery)PersistenceQuery$.MODULE$.apply(this.system())).readJournalFor(PersistenceTestKitReadJournal$.MODULE$.Identifier());
        TestProbe probe = actorTestKit.createTestProbe();
        this.stateProbe = actorTestKit.createTestProbe();
        this.actor = actorTestKit.spawn(behavior);
        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.internalActor());
        ActorRef.ActorRefOps$.MODULE$.$bang$extension(actorRef, (Object)EventSourcedBehaviorImpl.GetPersistenceId$.MODULE$.apply(probe.ref()));
        EventSourcedBehaviorTestKitImpl eventSourcedBehaviorTestKitImpl = this;
        try {
            persistenceId = (PersistenceId)probe.expectMessageType(ClassTag$.MODULE$.apply(PersistenceId.class));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                throw new IllegalArgumentException("Only EventSourcedBehavior, or nested EventSourcedBehavior allowed.");
            }
            throw throwable;
        }
        PersistenceId persistenceId2 = persistenceId;
        EventSourcedBehaviorTestKitImpl eventSourcedBehaviorTestKitImpl2 = eventSourcedBehaviorTestKitImpl;
        eventSourcedBehaviorTestKitImpl = null;
        PersistenceId persistenceId3 = persistenceId2;
        persistenceId2 = null;
        eventSourcedBehaviorTestKitImpl2.persistenceId = persistenceId3;
        this.serializationTestKit = new SerializationTestKit(this.system());
        this.emptyStateVerified = false;
    }

    private ActorSystem<?> system() {
        return this.actorTestKit.system();
    }

    @Override
    public PersistenceTestKit persistenceTestKit() {
        return this.persistenceTestKit;
    }

    @Override
    public Option<SnapshotTestKit> snapshotTestKit() {
        return this.snapshotTestKit;
    }

    private ActorRef<Object> internalActor() {
        return this.actor.unsafeUpcast();
    }

    @Override
    public EventSourcedBehaviorTestKit.CommandResult<Command, Event, State> runCommand(Command command) {
        this.preCommandCheck(command);
        long seqNrBefore = this.getHighestSeqNr();
        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.actor);
        ActorRef.ActorRefOps$.MODULE$.$bang$extension(actorRef, command);
        State newState = this.getState();
        Seq<Event> newEvents = this.getEvents(seqNrBefore + 1L);
        this.postCommandCheck(newEvents, newState, (Option<Object>)None$.MODULE$);
        return EventSourcedBehaviorTestKitImpl$CommandResultImpl$.MODULE$.apply(command, newEvents, newState, None$.MODULE$);
    }

    @Override
    public <R> EventSourcedBehaviorTestKit.CommandResultWithReply<Command, Event, State, R> runCommand(Function1<ActorRef<R>, Command> creator) {
        Object object;
        TestProbe replyProbe = this.actorTestKit.createTestProbe();
        Object command = creator.apply((Object)replyProbe.ref());
        this.preCommandCheck(command);
        long seqNrBefore = this.getHighestSeqNr();
        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.actor);
        ActorRef.ActorRefOps$.MODULE$.$bang$extension(actorRef, command);
        try {
            try {
                object = replyProbe.receiveMessage();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3 = (Throwable)option.get();
                    throw new AssertionError((Object)new StringBuilder(38).append("Missing expected reply for command [").append(command).append("].").toString());
                }
                throw throwable;
            }
        }
        finally {
            replyProbe.stop();
        }
        Object reply = object;
        State newState = this.getState();
        Seq<Event> newEvents = this.getEvents(seqNrBefore + 1L);
        this.postCommandCheck(newEvents, newState, (Option<Object>)Some$.MODULE$.apply(reply));
        return EventSourcedBehaviorTestKitImpl$CommandResultImpl$.MODULE$.apply(command, newEvents, newState, Some$.MODULE$.apply(reply));
    }

    private long getHighestSeqNr() {
        ActorSystem<?> sys = this.system();
        Future result = (Future)this.queries.currentEventsByPersistenceId(this.persistenceId.id(), 0L, Long.MAX_VALUE).runWith((Graph)Sink$.MODULE$.lastOption(), Materializer$.MODULE$.matFromSystem(sys));
        Option option = (Option)Await$.MODULE$.result((Awaitable)result, (Duration)this.actorTestKit.testKitSettings().SingleExpectDefaultTimeout());
        if (None$.MODULE$.equals(option)) {
            return 0L;
        }
        if (option instanceof Some) {
            EventEnvelope env = (EventEnvelope)((Some)option).value();
            return env.sequenceNr();
        }
        throw new MatchError((Object)option);
    }

    private Seq<Event> getEvents(long fromSeqNr) {
        ActorSystem<?> sys = this.system();
        Future result = (Future)this.queries.currentEventsByPersistenceId(this.persistenceId.id(), fromSeqNr, Long.MAX_VALUE).runWith((Graph)Sink$.MODULE$.seq(), Materializer$.MODULE$.matFromSystem(sys));
        return (Seq)((IterableOps)Await$.MODULE$.result((Awaitable)result, (Duration)this.actorTestKit.testKitSettings().SingleExpectDefaultTimeout())).map((Function1 & Serializable)_$2 -> _$2.event());
    }

    @Override
    public State getState() {
        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.internalActor());
        ActorRef.ActorRefOps$.MODULE$.$bang$extension(actorRef, (Object)EventSourcedBehaviorImpl.GetState$.MODULE$.apply(this.stateProbe.ref()));
        return (State)((EventSourcedBehaviorImpl.GetStateReply)this.stateProbe.receiveMessage()).currentState();
    }

    private void preCommandCheck(Command command) {
        if (this.serializationSettings.enabled()) {
            if (this.serializationSettings.verifyCommands()) {
                this.verifySerializationAndThrow(command, "Command");
            }
            if (this.serializationSettings.verifyState() && !this.emptyStateVerified) {
                State emptyState = this.getState();
                this.verifySerializationAndThrow(emptyState, "Empty State");
                this.emptyStateVerified = true;
                return;
            }
            return;
        }
    }

    private void postCommandCheck(Seq<Event> newEvents, State newState, Option<Object> reply) {
        if (this.serializationSettings.enabled()) {
            if (this.serializationSettings.verifyEvents()) {
                newEvents.foreach((Function1)(JProcedure1 & Serializable)_$3 -> this.verifySerializationAndThrow(_$3, "Event"));
            }
            if (this.serializationSettings.verifyState()) {
                this.verifySerializationAndThrow(newState, "State");
            }
            if (this.serializationSettings.verifyCommands()) {
                reply.foreach((Function1)(JProcedure1 & Serializable)_$4 -> this.verifySerializationAndThrow(_$4, "Reply"));
                return;
            }
            return;
        }
    }

    @Override
    public EventSourcedBehaviorTestKit.RestartResult<State> restart() {
        RestartResultImpl<Object> restartResultImpl;
        this.actorTestKit.stop(this.actor, this.actorTestKit.stop$default$2());
        this.actor = this.actorTestKit.spawn(this.behavior);
        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.internalActor());
        ActorRef.ActorRefOps$.MODULE$.$bang$extension(actorRef, (Object)EventSourcedBehaviorImpl.GetState$.MODULE$.apply(this.stateProbe.ref()));
        try {
            EventSourcedBehaviorImpl.GetStateReply state = (EventSourcedBehaviorImpl.GetStateReply)this.stateProbe.receiveMessage();
            restartResultImpl = EventSourcedBehaviorTestKitImpl$RestartResultImpl$.MODULE$.apply(state.currentState());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                throw new IllegalStateException("Could not restart. Maybe exception from event handler. See logs.");
            }
            throw throwable;
        }
        return restartResultImpl;
    }

    @Override
    public void clear() {
        this.persistenceTestKit().clearByPersistenceId(this.persistenceId.id());
        this.snapshotTestKit().foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.clearByPersistenceId(this.persistenceId.id()));
        this.restart();
    }

    private void verifySerializationAndThrow(Object obj, String errorMessagePrefix) {
        try {
            this.serializationTestKit.verifySerialization(obj, this.serializationSettings.verifyEquality());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable exc = throwable3 = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(23).append(errorMessagePrefix).append(" [").append(obj).append("] isn't serializable.").toString(), exc);
            }
            throw throwable;
        }
    }

    @Override
    public void initialize(State state, Seq<Event> events) {
        this.internalInitialize((Option<State>)Some$.MODULE$.apply(state), events);
    }

    @Override
    public void initialize(Seq<Event> events) {
        this.internalInitialize((Option<State>)None$.MODULE$, events);
    }

    private EventSourcedBehaviorTestKit.RestartResult<State> internalInitialize(Option<State> stateOption, Seq<Event> events) {
        this.clear();
        stateOption.foreach((Function1)(JProcedure1 & Serializable)state -> {
            Option<SnapshotTestKit> option = this.snapshotTestKit();
            if (option instanceof Some) {
                SnapshotTestKit kit = (SnapshotTestKit)((Some)option).value();
                kit.persistForRecovery(this.persistenceId.id(), (Tuple2<SnapshotMeta, Object>)Tuple2$.MODULE$.apply((Object)SnapshotMeta$.MODULE$.apply(0L, SnapshotMeta$.MODULE$.$lessinit$greater$default$2()), state));
                return;
            }
            throw new IllegalArgumentException("Cannot initialize from state when snapshots are not used.");
        });
        this.persistenceTestKit().persistForRecovery(this.persistenceId.id(), (Seq<Object>)((Seq)Seq$.MODULE$.empty().$plus$plus(events)));
        return this.restart();
    }

    public static final class CommandResultImpl<Command, Event, State, Reply>
    implements EventSourcedBehaviorTestKit.CommandResultWithReply<Command, Event, State, Reply>,
    Product,
    Serializable {
        private final Object command;
        private final Seq events;
        private final Object state;
        private final Option replyOption;

        public static <Command, Event, State, Reply> CommandResultImpl<Command, Event, State, Reply> apply(Command Command, Seq<Event> seq, State State2, Option<Reply> option) {
            return EventSourcedBehaviorTestKitImpl$CommandResultImpl$.MODULE$.apply(Command, seq, State2, option);
        }

        public static CommandResultImpl<?, ?, ?, ?> fromProduct(Product product) {
            return EventSourcedBehaviorTestKitImpl$CommandResultImpl$.MODULE$.fromProduct(product);
        }

        public static <Command, Event, State, Reply> CommandResultImpl<Command, Event, State, Reply> unapply(CommandResultImpl<Command, Event, State, Reply> commandResultImpl) {
            return EventSourcedBehaviorTestKitImpl$CommandResultImpl$.MODULE$.unapply(commandResultImpl);
        }

        public CommandResultImpl(Command command, Seq<Event> events, State state, Option<Reply> replyOption) {
            this.command = command;
            this.events = events;
            this.state = state;
            this.replyOption = replyOption;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CommandResultImpl)) return false;
            CommandResultImpl commandResultImpl = (CommandResultImpl)object;
            if (!BoxesRunTime.equals(this.command(), commandResultImpl.command())) return false;
            Seq<Event> seq = this.events();
            Seq<Event> seq2 = commandResultImpl.events();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!BoxesRunTime.equals(this.state(), commandResultImpl.state())) return false;
            Option<Reply> option = this.replyOption();
            Option<Reply> option2 = commandResultImpl.replyOption();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CommandResultImpl;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "CommandResultImpl";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "command";
                }
                case 1: {
                    return "events";
                }
                case 2: {
                    return "state";
                }
                case 3: {
                    return "replyOption";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Command command() {
            return (Command)this.command;
        }

        @Override
        public Seq<Event> events() {
            return this.events;
        }

        @Override
        public State state() {
            return (State)this.state;
        }

        public Option<Reply> replyOption() {
            return this.replyOption;
        }

        @Override
        public boolean hasNoEvents() {
            return this.events().isEmpty();
        }

        @Override
        public Event event() {
            if (this.events().nonEmpty()) {
                return (Event)this.events().head();
            }
            throw new AssertionError((Object)"No events");
        }

        @Override
        public <E extends Event> E eventOfType(ClassTag<E> evidence$1) {
            return this.ofType(this.event(), "event", evidence$1);
        }

        @Override
        public <S extends State> S stateOfType(ClassTag<S> evidence$1) {
            return this.ofType(this.state(), "state", evidence$1);
        }

        @Override
        public Reply reply() {
            return (Reply)this.replyOption().getOrElse(EventSourcedBehaviorTestKitImpl$::org$apache$pekko$persistence$testkit$internal$EventSourcedBehaviorTestKitImpl$CommandResultImpl$$_$reply$$anonfun$1);
        }

        @Override
        public <R extends Reply> R replyOfType(ClassTag<R> evidence$1) {
            return this.ofType(this.reply(), "reply", evidence$1);
        }

        private <A> A ofType(Object obj, String errorParam, ClassTag<A> evidence$1) {
            Option option;
            Object object = obj;
            if (object != null && !(option = evidence$1.unapply(object)).isEmpty()) {
                Object object2;
                Object a = object2 = option.get();
                return (A)a;
            }
            Object other = object;
            Class expectedClass = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
            throw new AssertionError((Object)new StringBuilder(20).append("Expected ").append(errorParam).append(" class [").append(expectedClass.getName()).append("], ").append(new StringBuilder(10).append("but was [").append(other.getClass().getName()).append("]").toString()).toString());
        }

        @Override
        public boolean hasNoReply() {
            return this.replyOption().isEmpty();
        }

        public <Command, Event, State, Reply> CommandResultImpl<Command, Event, State, Reply> copy(Command command, Seq<Event> events, State state, Option<Reply> replyOption) {
            return new CommandResultImpl<Command, Event, State, Reply>(command, events, state, replyOption);
        }

        public <Command, Event, State, Reply> Command copy$default$1() {
            return this.command();
        }

        public <Command, Event, State, Reply> Seq<Event> copy$default$2() {
            return this.events();
        }

        public <Command, Event, State, Reply> State copy$default$3() {
            return this.state();
        }

        public <Command, Event, State, Reply> Option<Reply> copy$default$4() {
            return this.replyOption();
        }

        public Command _1() {
            return this.command();
        }

        public Seq<Event> _2() {
            return this.events();
        }

        public State _3() {
            return this.state();
        }

        public Option<Reply> _4() {
            return this.replyOption();
        }
    }

    public static final class RestartResultImpl<State>
    implements EventSourcedBehaviorTestKit.RestartResult<State>,
    Product,
    Serializable {
        private final Object state;

        public static <State> RestartResultImpl<State> apply(State State2) {
            return EventSourcedBehaviorTestKitImpl$RestartResultImpl$.MODULE$.apply(State2);
        }

        public static RestartResultImpl<?> fromProduct(Product product) {
            return EventSourcedBehaviorTestKitImpl$RestartResultImpl$.MODULE$.fromProduct(product);
        }

        public static <State> RestartResultImpl<State> unapply(RestartResultImpl<State> restartResultImpl) {
            return EventSourcedBehaviorTestKitImpl$RestartResultImpl$.MODULE$.unapply(restartResultImpl);
        }

        public RestartResultImpl(State state) {
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RestartResultImpl)) return false;
            RestartResultImpl restartResultImpl = (RestartResultImpl)object;
            if (!BoxesRunTime.equals(this.state(), restartResultImpl.state())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RestartResultImpl;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RestartResultImpl";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public State state() {
            return (State)this.state;
        }

        public <State> RestartResultImpl<State> copy(State state) {
            return new RestartResultImpl<State>(state);
        }

        public <State> State copy$default$1() {
            return this.state();
        }

        public State _1() {
            return this.state();
        }
    }
}

