/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit;

import java.io.Serializable;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.SelectedSnapshot;
import org.apache.pekko.persistence.SelectedSnapshot$;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.SnapshotSelectionCriteria;
import org.apache.pekko.persistence.testkit.DeleteSnapshotByMeta$;
import org.apache.pekko.persistence.testkit.DeleteSnapshotsByCriteria$;
import org.apache.pekko.persistence.testkit.ProcessingFailure;
import org.apache.pekko.persistence.testkit.ProcessingPolicy;
import org.apache.pekko.persistence.testkit.ProcessingResult;
import org.apache.pekko.persistence.testkit.ProcessingSuccess$;
import org.apache.pekko.persistence.testkit.ReadSnapshot$;
import org.apache.pekko.persistence.testkit.SnapshotMeta$;
import org.apache.pekko.persistence.testkit.SnapshotOperation;
import org.apache.pekko.persistence.testkit.SnapshotStorage$SnapshotPolicies$;
import org.apache.pekko.persistence.testkit.WriteSnapshot$;
import org.apache.pekko.persistence.testkit.internal.TestKitStorage;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;
import scala.util.Success$;

@InternalApi
public interface SnapshotStorage
extends TestKitStorage<SnapshotOperation, Tuple2<SnapshotMetadata, Object>>,
Extension {
    public static void $init$(SnapshotStorage $this) {
        $this.org$apache$pekko$persistence$testkit$SnapshotStorage$_setter_$DefaultPolicy_$eq(SnapshotStorage$SnapshotPolicies$.MODULE$.PassAll());
    }

    public static long reprToSeqNum$(SnapshotStorage $this, Tuple2 repr) {
        return $this.reprToSeqNum((Tuple2<SnapshotMetadata, Object>)repr);
    }

    @Override
    default public long reprToSeqNum(Tuple2<SnapshotMetadata, Object> repr) {
        return ((SnapshotMetadata)repr._1()).sequenceNr();
    }

    @Override
    public ProcessingPolicy<SnapshotOperation> DefaultPolicy();

    public void org$apache$pekko$persistence$testkit$SnapshotStorage$_setter_$DefaultPolicy_$eq(ProcessingPolicy var1);

    public static void tryAdd$(SnapshotStorage $this, SnapshotMetadata meta, Object payload) {
        $this.tryAdd(meta, payload);
    }

    default public void tryAdd(SnapshotMetadata meta, Object payload) {
        ProcessingResult processingResult = this.currentPolicy().tryProcess(meta.persistenceId(), WriteSnapshot$.MODULE$.apply(SnapshotMeta$.MODULE$.apply(meta.sequenceNr(), meta.timestamp()), payload));
        if (ProcessingSuccess$.MODULE$.equals(processingResult)) {
            this.add(meta.persistenceId(), Tuple2$.MODULE$.apply((Object)meta, payload));
            Success$.MODULE$.apply((Object)BoxedUnit.UNIT);
            return;
        }
        if (processingResult instanceof ProcessingFailure) {
            ProcessingFailure f = (ProcessingFailure)processingResult;
            throw f.error();
        }
        throw new MatchError((Object)processingResult);
    }

    public static Option tryRead$(SnapshotStorage $this, String persistenceId, SnapshotSelectionCriteria criteria) {
        return $this.tryRead(persistenceId, criteria);
    }

    default public Option<SelectedSnapshot> tryRead(String persistenceId, SnapshotSelectionCriteria criteria) {
        Option selectedSnapshot = this.read(persistenceId).flatMap((Function1 & Serializable)_$1 -> _$1.reverseIterator().find((Function1 & Serializable)v -> criteria.matches((SnapshotMetadata)v._1())).map((Function1 & Serializable)v -> SelectedSnapshot$.MODULE$.apply((SnapshotMetadata)v._1(), v._2())));
        ProcessingResult processingResult = this.currentPolicy().tryProcess(persistenceId, ReadSnapshot$.MODULE$.apply(criteria, (Option<Object>)selectedSnapshot.map((Function1 & Serializable)_$2 -> _$2.snapshot())));
        if (ProcessingSuccess$.MODULE$.equals(processingResult)) {
            return selectedSnapshot;
        }
        if (processingResult instanceof ProcessingFailure) {
            ProcessingFailure f = (ProcessingFailure)processingResult;
            throw f.error();
        }
        throw new MatchError((Object)processingResult);
    }

    public static void tryDelete$(SnapshotStorage $this, String persistenceId, SnapshotSelectionCriteria selectionCriteria) {
        $this.tryDelete(persistenceId, selectionCriteria);
    }

    default public void tryDelete(String persistenceId, SnapshotSelectionCriteria selectionCriteria) {
        ProcessingResult processingResult = this.currentPolicy().tryProcess(persistenceId, DeleteSnapshotsByCriteria$.MODULE$.apply(selectionCriteria));
        if (ProcessingSuccess$.MODULE$.equals(processingResult)) {
            this.delete(persistenceId, (Function1 & Serializable)v -> selectionCriteria.matches((SnapshotMetadata)v._1()));
            return;
        }
        if (processingResult instanceof ProcessingFailure) {
            ProcessingFailure f = (ProcessingFailure)processingResult;
            throw f.error();
        }
        throw new MatchError((Object)processingResult);
    }

    public static void tryDelete$(SnapshotStorage $this, SnapshotMetadata meta) {
        $this.tryDelete(meta);
    }

    default public void tryDelete(SnapshotMetadata meta) {
        ProcessingResult processingResult = this.currentPolicy().tryProcess(meta.persistenceId(), DeleteSnapshotByMeta$.MODULE$.apply(SnapshotMeta$.MODULE$.apply(meta.sequenceNr(), meta.timestamp())));
        if (ProcessingSuccess$.MODULE$.equals(processingResult)) {
            this.delete(meta.persistenceId(), (Function1 & Serializable)_$3 -> ((SnapshotMetadata)_$3._1()).sequenceNr() == meta.sequenceNr());
            return;
        }
        if (processingResult instanceof ProcessingFailure) {
            ProcessingFailure f = (ProcessingFailure)processingResult;
            throw f.error();
        }
        throw new MatchError((Object)processingResult);
    }
}

