/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.pattern.CircuitBreaker;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.SelectedSnapshot;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.SnapshotSelectionCriteria;
import org.apache.pekko.persistence.snapshot.SnapshotStore;
import org.apache.pekko.persistence.testkit.PersistenceTestKitSnapshotPlugin$;
import org.apache.pekko.persistence.testkit.SnapshotStorage;
import org.apache.pekko.persistence.testkit.internal.SnapshotStorageEmulatorExtension;
import org.apache.pekko.persistence.testkit.internal.SnapshotStorageEmulatorExtension$;
import scala.Function0;
import scala.Option;
import scala.PartialFunction;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Try$;

@InternalApi
public class PersistenceTestKitSnapshotPlugin
implements Actor,
ActorLogging,
SnapshotStore {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private Persistence org$apache$pekko$persistence$snapshot$SnapshotStore$$extension;
    private boolean org$apache$pekko$persistence$snapshot$SnapshotStore$$publish;
    private CircuitBreaker org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker;
    private PartialFunction receiveSnapshotStore;
    private final SnapshotStorage storage;

    public static String PluginId() {
        return PersistenceTestKitSnapshotPlugin$.MODULE$.PluginId();
    }

    public static Config config() {
        return PersistenceTestKitSnapshotPlugin$.MODULE$.config();
    }

    public static PersistenceTestKitSnapshotPlugin$ getInstance() {
        return PersistenceTestKitSnapshotPlugin$.MODULE$.getInstance();
    }

    public PersistenceTestKitSnapshotPlugin(Config cfg, String cfgPath) {
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        SnapshotStore.$init$((SnapshotStore)this);
        this.log().debug("Using snapshot storage emulator extension [{}] for test kit snapshot storage", (Object)cfgPath);
        this.storage = ((SnapshotStorageEmulatorExtension)SnapshotStorageEmulatorExtension$.MODULE$.apply(this.context().system())).storageFor(cfgPath);
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public Persistence org$apache$pekko$persistence$snapshot$SnapshotStore$$extension() {
        return this.org$apache$pekko$persistence$snapshot$SnapshotStore$$extension;
    }

    public boolean org$apache$pekko$persistence$snapshot$SnapshotStore$$publish() {
        return this.org$apache$pekko$persistence$snapshot$SnapshotStore$$publish;
    }

    public CircuitBreaker org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker() {
        return this.org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker;
    }

    public final PartialFunction receiveSnapshotStore() {
        return this.receiveSnapshotStore;
    }

    public void org$apache$pekko$persistence$snapshot$SnapshotStore$_setter_$org$apache$pekko$persistence$snapshot$SnapshotStore$$extension_$eq(Persistence x$0) {
        this.org$apache$pekko$persistence$snapshot$SnapshotStore$$extension = x$0;
    }

    public void org$apache$pekko$persistence$snapshot$SnapshotStore$_setter_$org$apache$pekko$persistence$snapshot$SnapshotStore$$publish_$eq(boolean x$0) {
        this.org$apache$pekko$persistence$snapshot$SnapshotStore$$publish = x$0;
    }

    public void org$apache$pekko$persistence$snapshot$SnapshotStore$_setter_$org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker_$eq(CircuitBreaker x$0) {
        this.org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker = x$0;
    }

    public void org$apache$pekko$persistence$snapshot$SnapshotStore$_setter_$receiveSnapshotStore_$eq(PartialFunction x$0) {
        this.receiveSnapshotStore = x$0;
    }

    public Future<Option<SelectedSnapshot>> loadAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply(() -> this.loadAsync$$anonfun$1(persistenceId, criteria)));
    }

    public Future<BoxedUnit> saveAsync(SnapshotMetadata metadata, Object snapshot) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.saveAsync$$anonfun$1(metadata, snapshot);
            return BoxedUnit.UNIT;
        }));
    }

    public Future<BoxedUnit> deleteAsync(SnapshotMetadata metadata) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.deleteAsync$$anonfun$1(metadata);
            return BoxedUnit.UNIT;
        }));
    }

    public Future<BoxedUnit> deleteAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.deleteAsync$$anonfun$2(persistenceId, criteria);
            return BoxedUnit.UNIT;
        });
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    private final Option loadAsync$$anonfun$1(String persistenceId$4, SnapshotSelectionCriteria criteria$1) {
        return this.storage.tryRead(persistenceId$4, criteria$1);
    }

    private final void saveAsync$$anonfun$1(SnapshotMetadata metadata$1, Object snapshot$1) {
        this.storage.tryAdd(metadata$1, snapshot$1);
    }

    private final void deleteAsync$$anonfun$1(SnapshotMetadata metadata$2) {
        this.storage.tryDelete(metadata$2);
    }

    private final void deleteAsync$$anonfun$2(String persistenceId$5, SnapshotSelectionCriteria criteria$2) {
        this.storage.tryDelete(persistenceId$5, criteria$2);
    }
}

