/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.pattern.CircuitBreaker;
import org.apache.pekko.persistence.AtomicWrite;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.journal.AsyncWriteJournal;
import org.apache.pekko.persistence.journal.EventAdapters;
import org.apache.pekko.persistence.journal.ReplayFilter;
import org.apache.pekko.persistence.journal.Tagged;
import org.apache.pekko.persistence.journal.Tagged$;
import org.apache.pekko.persistence.journal.WriteJournalBase;
import org.apache.pekko.persistence.testkit.EventStorage;
import org.apache.pekko.persistence.testkit.PersistenceTestKitPlugin$;
import org.apache.pekko.persistence.testkit.PersistenceTestKitPlugin$SliceWrite$;
import org.apache.pekko.persistence.testkit.PersistenceTestKitPlugin$TagWrite$;
import org.apache.pekko.persistence.testkit.PersistenceTestKitPlugin$Write$;
import org.apache.pekko.persistence.testkit.internal.CurrentTime$;
import org.apache.pekko.persistence.testkit.internal.InMemStorageExtension;
import org.apache.pekko.persistence.testkit.internal.InMemStorageExtension$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.Try$;

@InternalApi
public class PersistenceTestKitPlugin
implements Actor,
WriteJournalBase,
AsyncWriteJournal,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private Persistence persistence;
    private EventAdapters org$apache$pekko$persistence$journal$WriteJournalBase$$eventAdapters;
    private Persistence org$apache$pekko$persistence$journal$AsyncWriteJournal$$extension;
    private boolean org$apache$pekko$persistence$journal$AsyncWriteJournal$$publish;
    private Config org$apache$pekko$persistence$journal$AsyncWriteJournal$$config;
    private CircuitBreaker org$apache$pekko$persistence$journal$AsyncWriteJournal$$breaker;
    private ReplayFilter.Mode org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMode;
    private int org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterWindowSize;
    private int org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMaxOldWriters;
    private ActorRef org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencer;
    private long org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencerCounter;
    private PartialFunction receiveWriteJournal;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private final EventStorage storage;
    private final EventStream eventStream;

    public static String PluginId() {
        return PersistenceTestKitPlugin$.MODULE$.PluginId();
    }

    public static Config config() {
        return PersistenceTestKitPlugin$.MODULE$.config();
    }

    public static PersistenceTestKitPlugin$ getInstance() {
        return PersistenceTestKitPlugin$.MODULE$.getInstance();
    }

    public PersistenceTestKitPlugin(Config cfg, String cfgPath) {
        Actor.$init$((Actor)this);
        WriteJournalBase.$init$((WriteJournalBase)this);
        AsyncWriteJournal.$init$((AsyncWriteJournal)this);
        ActorLogging.$init$((ActorLogging)this);
        this.log().debug("Using in memory storage [{}] for test kit journal", (Object)cfgPath);
        this.storage = ((InMemStorageExtension)InMemStorageExtension$.MODULE$.apply(this.context().system())).storageFor(cfgPath);
        this.eventStream = this.context().system().eventStream();
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public Persistence persistence() {
        return this.persistence;
    }

    public EventAdapters org$apache$pekko$persistence$journal$WriteJournalBase$$eventAdapters() {
        return this.org$apache$pekko$persistence$journal$WriteJournalBase$$eventAdapters;
    }

    public void org$apache$pekko$persistence$journal$WriteJournalBase$_setter_$persistence_$eq(Persistence x$0) {
        this.persistence = x$0;
    }

    public void org$apache$pekko$persistence$journal$WriteJournalBase$_setter_$org$apache$pekko$persistence$journal$WriteJournalBase$$eventAdapters_$eq(EventAdapters x$0) {
        this.org$apache$pekko$persistence$journal$WriteJournalBase$$eventAdapters = x$0;
    }

    public Persistence org$apache$pekko$persistence$journal$AsyncWriteJournal$$extension() {
        return this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$extension;
    }

    public boolean org$apache$pekko$persistence$journal$AsyncWriteJournal$$publish() {
        return this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$publish;
    }

    public Config org$apache$pekko$persistence$journal$AsyncWriteJournal$$config() {
        return this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$config;
    }

    public CircuitBreaker org$apache$pekko$persistence$journal$AsyncWriteJournal$$breaker() {
        return this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$breaker;
    }

    public ReplayFilter.Mode org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMode() {
        return this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMode;
    }

    public int org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterWindowSize() {
        return this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterWindowSize;
    }

    public int org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMaxOldWriters() {
        return this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMaxOldWriters;
    }

    public ActorRef org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencer() {
        return this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencer;
    }

    public long org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencerCounter() {
        return this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencerCounter;
    }

    public final PartialFunction receiveWriteJournal() {
        return this.receiveWriteJournal;
    }

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencerCounter_$eq(long x$1) {
        this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencerCounter = x$1;
    }

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$extension_$eq(Persistence x$0) {
        this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$extension = x$0;
    }

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$publish_$eq(boolean x$0) {
        this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$publish = x$0;
    }

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$config_$eq(Config x$0) {
        this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$config = x$0;
    }

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$breaker_$eq(CircuitBreaker x$0) {
        this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$breaker = x$0;
    }

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMode_$eq(ReplayFilter.Mode x$0) {
        this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMode = x$0;
    }

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterWindowSize_$eq(int x$0) {
        this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterWindowSize = x$0;
    }

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMaxOldWriters_$eq(int x$0) {
        this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$replayFilterMaxOldWriters = x$0;
    }

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencer_$eq(ActorRef x$0) {
        this.org$apache$pekko$persistence$journal$AsyncWriteJournal$$resequencer = x$0;
    }

    public void org$apache$pekko$persistence$journal$AsyncWriteJournal$_setter_$receiveWriteJournal_$eq(PartialFunction x$0) {
        this.receiveWriteJournal = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public Future<Seq<Try<BoxedUnit>>> asyncWriteMessages(Seq<AtomicWrite> messages) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply(() -> this.asyncWriteMessages$$anonfun$1(messages)));
    }

    public Future<BoxedUnit> asyncDeleteMessagesTo(String persistenceId, long toSequenceNr) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.asyncDeleteMessagesTo$$anonfun$1(persistenceId, toSequenceNr);
            return BoxedUnit.UNIT;
        }));
    }

    public Future<BoxedUnit> asyncReplayMessages(String persistenceId, long fromSequenceNr, long toSequenceNr, long max, Function1<PersistentRepr, BoxedUnit> recoveryCallback) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.asyncReplayMessages$$anonfun$1(persistenceId, fromSequenceNr, toSequenceNr, max, recoveryCallback);
            return BoxedUnit.UNIT;
        }));
    }

    public Future<Object> asyncReadHighestSequenceNr(String persistenceId, long fromSequenceNr) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply(() -> this.asyncReadHighestSequenceNr$$anonfun$1(persistenceId, fromSequenceNr)));
    }

    private final Seq asyncWriteMessages$$anonfun$1(Seq messages$1) {
        return (Seq)messages$1.map((Function1 & Serializable)aw -> {
            long timestamp = CurrentTime$.MODULE$.now();
            Seq data = (Seq)aw.payload().map((Function1 & Serializable)pl -> {
                Object object = pl.payload();
                return pl.withTimestamp(timestamp);
            });
            Try<BoxedUnit> result = this.storage.tryAdd((Seq<PersistentRepr>)data);
            result.foreach((Function1)(JProcedure1 & Serializable)_$1 -> {
                messages$1.foreach((Function1)(JProcedure1 & Serializable)aw -> this.eventStream.publish((Object)PersistenceTestKitPlugin$Write$.MODULE$.apply(aw.persistenceId(), aw.highestSequenceNr())));
                ((IterableOps)data.flatMap((Function1 & Serializable)pr -> {
                    Set set;
                    Object object = pr.payload();
                    if (object instanceof Tagged) {
                        Set set2;
                        Set tags;
                        Tagged tagged = Tagged$.MODULE$.unapply((Tagged)object);
                        Object object2 = tagged._1();
                        set = tags = (set2 = tagged._2());
                    } else {
                        set = Predef$.MODULE$.Set().empty();
                    }
                    Set tags = set;
                    return (IterableOnce)tags.toSeq().map((Function1 & Serializable)tag -> Tuple2$.MODULE$.apply(tag, pr));
                })).groupBy((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String tag = (String)tuple2._1();
                        return tag;
                    }
                    throw new MatchError((Object)tuple2);
                }).map((Function1 & Serializable)x$12 -> {
                    Tuple2 tuple2 = x$12;
                    if (tuple2 != null) {
                        String tag = (String)tuple2._1();
                        Seq pr = (Seq)tuple2._2();
                        return Tuple2$.MODULE$.apply((Object)tag, ((IterableOnceOps)pr.map((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                PersistentRepr pr = (PersistentRepr)tuple2._2();
                                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)pr.timestamp()), (Object)BoxesRunTime.boxToLong((long)pr.sequenceNr()));
                            }
                            throw new MatchError((Object)tuple2);
                        })).max(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$)));
                    }
                    throw new MatchError((Object)tuple2);
                }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        String tag = (String)tuple2._1();
                        if (tuple22 != null) {
                            long timestamp = tuple22._1$mcJ$sp();
                            long highestSequenceNr = tuple22._2$mcJ$sp();
                            this.eventStream.publish((Object)PersistenceTestKitPlugin$TagWrite$.MODULE$.apply(tag, timestamp, highestSequenceNr));
                            return;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
                this.eventStream.publish((Object)PersistenceTestKitPlugin$SliceWrite$.MODULE$.apply(aw.persistenceId(), timestamp, aw.highestSequenceNr()));
            });
            return result;
        });
    }

    private final void asyncDeleteMessagesTo$$anonfun$1(String persistenceId$1, long toSequenceNr$1) {
        this.storage.tryDelete(persistenceId$1, toSequenceNr$1);
    }

    private final void asyncReplayMessages$$anonfun$1(String persistenceId$2, long fromSequenceNr$1, long toSequenceNr$2, long max$1, Function1 recoveryCallback$1) {
        ((IterableOnceOps)this.storage.tryRead(persistenceId$2, fromSequenceNr$1, toSequenceNr$2, max$1).map((Function1 & Serializable)repr -> {
            Object object = repr.payload();
            if (object instanceof Tagged) {
                Tagged tagged = Tagged$.MODULE$.unapply((Tagged)object);
                Object object2 = tagged._1();
                Set set = tagged._2();
                Object payload = object2;
                return repr.withPayload(payload);
            }
            return repr;
        })).foreach(recoveryCallback$1);
    }

    private final long asyncReadHighestSequenceNr$$anonfun$1(String persistenceId$3, long fromSequenceNr$2) {
        long found = this.storage.tryReadSeqNumber(persistenceId$3);
        if (found < fromSequenceNr$2) {
            return fromSequenceNr$2;
        }
        return found;
    }

    public static class SliceWrite
    implements Product,
    Serializable {
        private final String persistenceId;
        private final long timestamp;
        private final long highestSequenceNr;

        public static SliceWrite apply(String string, long l, long l2) {
            return PersistenceTestKitPlugin$SliceWrite$.MODULE$.apply(string, l, l2);
        }

        public static SliceWrite fromProduct(Product product) {
            return PersistenceTestKitPlugin$SliceWrite$.MODULE$.fromProduct(product);
        }

        public static SliceWrite unapply(SliceWrite sliceWrite) {
            return PersistenceTestKitPlugin$SliceWrite$.MODULE$.unapply(sliceWrite);
        }

        public SliceWrite(String persistenceId, long timestamp, long highestSequenceNr) {
            this.persistenceId = persistenceId;
            this.timestamp = timestamp;
            this.highestSequenceNr = highestSequenceNr;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.persistenceId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.highestSequenceNr()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SliceWrite)) return false;
            SliceWrite sliceWrite = (SliceWrite)object;
            if (this.timestamp() != sliceWrite.timestamp()) return false;
            if (this.highestSequenceNr() != sliceWrite.highestSequenceNr()) return false;
            String string = this.persistenceId();
            String string2 = sliceWrite.persistenceId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!sliceWrite.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SliceWrite;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "SliceWrite";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "persistenceId";
                }
                case 1: {
                    return "timestamp";
                }
                case 2: {
                    return "highestSequenceNr";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String persistenceId() {
            return this.persistenceId;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long highestSequenceNr() {
            return this.highestSequenceNr;
        }

        public SliceWrite copy(String persistenceId, long timestamp, long highestSequenceNr) {
            return new SliceWrite(persistenceId, timestamp, highestSequenceNr);
        }

        public String copy$default$1() {
            return this.persistenceId();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.highestSequenceNr();
        }

        public String _1() {
            return this.persistenceId();
        }

        public long _2() {
            return this.timestamp();
        }

        public long _3() {
            return this.highestSequenceNr();
        }
    }

    public static class TagWrite
    implements Product,
    Serializable {
        private final String tag;
        private final long timestamp;
        private final long highestSequenceNr;

        public static TagWrite apply(String string, long l, long l2) {
            return PersistenceTestKitPlugin$TagWrite$.MODULE$.apply(string, l, l2);
        }

        public static TagWrite fromProduct(Product product) {
            return PersistenceTestKitPlugin$TagWrite$.MODULE$.fromProduct(product);
        }

        public static TagWrite unapply(TagWrite tagWrite) {
            return PersistenceTestKitPlugin$TagWrite$.MODULE$.unapply(tagWrite);
        }

        public TagWrite(String tag, long timestamp, long highestSequenceNr) {
            this.tag = tag;
            this.timestamp = timestamp;
            this.highestSequenceNr = highestSequenceNr;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tag()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.highestSequenceNr()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TagWrite)) return false;
            TagWrite tagWrite = (TagWrite)object;
            if (this.timestamp() != tagWrite.timestamp()) return false;
            if (this.highestSequenceNr() != tagWrite.highestSequenceNr()) return false;
            String string = this.tag();
            String string2 = tagWrite.tag();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!tagWrite.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TagWrite;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "TagWrite";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "tag";
                }
                case 1: {
                    return "timestamp";
                }
                case 2: {
                    return "highestSequenceNr";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String tag() {
            return this.tag;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long highestSequenceNr() {
            return this.highestSequenceNr;
        }

        public TagWrite copy(String tag, long timestamp, long highestSequenceNr) {
            return new TagWrite(tag, timestamp, highestSequenceNr);
        }

        public String copy$default$1() {
            return this.tag();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.highestSequenceNr();
        }

        public String _1() {
            return this.tag();
        }

        public long _2() {
            return this.timestamp();
        }

        public long _3() {
            return this.highestSequenceNr();
        }
    }

    public static class Write
    implements Product,
    Serializable {
        private final String persistenceId;
        private final long toSequenceNr;

        public static Write apply(String string, long l) {
            return PersistenceTestKitPlugin$Write$.MODULE$.apply(string, l);
        }

        public static Write fromProduct(Product product) {
            return PersistenceTestKitPlugin$Write$.MODULE$.fromProduct(product);
        }

        public static Write unapply(Write write) {
            return PersistenceTestKitPlugin$Write$.MODULE$.unapply(write);
        }

        public Write(String persistenceId, long toSequenceNr) {
            this.persistenceId = persistenceId;
            this.toSequenceNr = toSequenceNr;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.persistenceId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.toSequenceNr()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Write)) return false;
            Write write = (Write)object;
            if (this.toSequenceNr() != write.toSequenceNr()) return false;
            String string = this.persistenceId();
            String string2 = write.persistenceId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!write.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Write;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Write";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong((long)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "persistenceId";
            }
            if (1 == n2) {
                return "toSequenceNr";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String persistenceId() {
            return this.persistenceId;
        }

        public long toSequenceNr() {
            return this.toSequenceNr;
        }

        public Write copy(String persistenceId, long toSequenceNr) {
            return new Write(persistenceId, toSequenceNr);
        }

        public String copy$default$1() {
            return this.persistenceId();
        }

        public long copy$default$2() {
            return this.toSequenceNr();
        }

        public String _1() {
            return this.persistenceId();
        }

        public long _2() {
            return this.toSequenceNr();
        }
    }
}

