/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.testkit;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.PersistentRepr$;
import org.apache.pekko.persistence.journal.Tagged;
import org.apache.pekko.persistence.journal.Tagged$;
import org.apache.pekko.persistence.testkit.DeleteEvents$;
import org.apache.pekko.persistence.testkit.EventStorage$;
import org.apache.pekko.persistence.testkit.EventStorage$JournalPolicies$;
import org.apache.pekko.persistence.testkit.JournalOperation;
import org.apache.pekko.persistence.testkit.ProcessingPolicy;
import org.apache.pekko.persistence.testkit.ProcessingResult;
import org.apache.pekko.persistence.testkit.ProcessingSuccess$;
import org.apache.pekko.persistence.testkit.ReadEvents$;
import org.apache.pekko.persistence.testkit.ReadSeqNum$;
import org.apache.pekko.persistence.testkit.Reject;
import org.apache.pekko.persistence.testkit.Reject$;
import org.apache.pekko.persistence.testkit.StorageFailure;
import org.apache.pekko.persistence.testkit.StorageFailure$;
import org.apache.pekko.persistence.testkit.WriteEvents$;
import org.apache.pekko.persistence.testkit.internal.TestKitStorage;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;

@InternalApi
public interface EventStorage
extends TestKitStorage<JournalOperation, PersistentRepr> {
    public static Ordering<PersistentRepr> persistentReprOrdering() {
        return EventStorage$.MODULE$.persistentReprOrdering();
    }

    public static void $init$(EventStorage $this) {
        $this.org$apache$pekko$persistence$testkit$EventStorage$_setter_$DefaultPolicy_$eq(EventStorage$JournalPolicies$.MODULE$.PassAll());
    }

    public static void addAny$(EventStorage $this, String key, Object elem) {
        $this.addAny(key, elem);
    }

    default public void addAny(String key, Object elem) {
        this.addAny(key, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{elem}))));
    }

    public static void addAny$(EventStorage $this, String key, Seq elems) {
        $this.addAny(key, (Seq<Object>)elems);
    }

    default public void addAny(String key, Seq<Object> elems) {
        this.updateOrSetNew(key, (Function1 & Serializable)v -> (Vector)v.$plus$plus((IterableOnce)this.mapAny(key, elems).toVector()));
    }

    public static long reprToSeqNum$(EventStorage $this, PersistentRepr repr) {
        return $this.reprToSeqNum(repr);
    }

    @Override
    default public long reprToSeqNum(PersistentRepr repr) {
        return repr.sequenceNr();
    }

    public static void add$(EventStorage $this, Seq elems) {
        $this.add((Seq<PersistentRepr>)elems);
    }

    default public void add(Seq<PersistentRepr> elems) {
        elems.groupBy((Function1 & Serializable)_$1 -> _$1.persistenceId()).foreach((Function1)(JProcedure1 & Serializable)gr -> this.add(gr._1(), (Seq)gr._2()));
    }

    @Override
    public ProcessingPolicy<JournalOperation> DefaultPolicy();

    public void org$apache$pekko$persistence$testkit$EventStorage$_setter_$DefaultPolicy_$eq(ProcessingPolicy var1);

    public static Try tryAdd$(EventStorage $this, Seq elems) {
        return $this.tryAdd((Seq<PersistentRepr>)elems);
    }

    default public Try<BoxedUnit> tryAdd(Seq<PersistentRepr> elems) {
        Map grouped = elems.groupBy((Function1 & Serializable)_$2 -> _$2.persistenceId());
        Iterable processed = (Iterable)grouped.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String pid = (String)tuple2._1();
                Seq els = (Seq)tuple2._2();
                return this.currentPolicy().tryProcess(pid, WriteEvents$.MODULE$.apply((Seq<Object>)((Seq)els.map((Function1 & Serializable)_$3 -> {
                    Object object = _$3.payload();
                    if (object instanceof Tagged) {
                        Tagged tagged = Tagged$.MODULE$.unapply((Tagged)object);
                        Object object2 = tagged._1();
                        Set set = tagged._2();
                        Object payload = object2;
                        return payload;
                    }
                    Object nonTagged = object;
                    return nonTagged;
                }))));
            }
            throw new MatchError((Object)tuple2);
        });
        ProcessingResult reduced = (ProcessingResult)processed.foldLeft((Object)ProcessingSuccess$.MODULE$, (Function2 & Serializable)(left, right) -> {
            ProcessingResult processingResult;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(left, right);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            ProcessingResult processingResult2 = (ProcessingResult)tuple2._1();
            ProcessingResult processingResult3 = (ProcessingResult)tuple2._2();
            if (ProcessingSuccess$.MODULE$.equals(processingResult2) && ProcessingSuccess$.MODULE$.equals(processingResult3)) {
                processingResult = ProcessingSuccess$.MODULE$;
                return processingResult;
            } else if (processingResult2 instanceof StorageFailure) {
                StorageFailure f = (StorageFailure)processingResult2;
                processingResult = f;
                return processingResult;
            } else if (processingResult3 instanceof StorageFailure) {
                StorageFailure f = (StorageFailure)processingResult3;
                processingResult = f;
                return processingResult;
            } else if (processingResult2 instanceof Reject) {
                Reject r = (Reject)processingResult2;
                processingResult = r;
                return processingResult;
            } else {
                if (!(processingResult3 instanceof Reject)) throw new MatchError((Object)tuple2);
                Reject r = (Reject)processingResult3;
                processingResult = r;
            }
            return processingResult;
        });
        ProcessingResult processingResult = reduced;
        if (ProcessingSuccess$.MODULE$.equals(processingResult)) {
            this.add(elems);
            return Success$.MODULE$.apply((Object)BoxedUnit.UNIT);
        }
        if (processingResult instanceof Reject) {
            Throwable throwable;
            Reject reject = Reject$.MODULE$.unapply((Reject)processingResult);
            Throwable ex = throwable = reject._1();
            return Failure$.MODULE$.apply(ex);
        }
        if (processingResult instanceof StorageFailure) {
            Throwable throwable;
            StorageFailure storageFailure = StorageFailure$.MODULE$.unapply((StorageFailure)processingResult);
            Throwable ex = throwable = storageFailure._1();
            throw ex;
        }
        throw new MatchError((Object)processingResult);
    }

    public static Seq tryRead$(EventStorage $this, String persistenceId, long fromSequenceNr, long toSequenceNr, long max) {
        return $this.tryRead(persistenceId, fromSequenceNr, toSequenceNr, max);
    }

    default public Seq<PersistentRepr> tryRead(String persistenceId, long fromSequenceNr, long toSequenceNr, long max) {
        Seq batch = this.read(persistenceId, fromSequenceNr, toSequenceNr, max);
        ProcessingResult processingResult = this.currentPolicy().tryProcess(persistenceId, ReadEvents$.MODULE$.apply(batch));
        if (ProcessingSuccess$.MODULE$.equals(processingResult)) {
            return batch;
        }
        if (processingResult instanceof Reject) {
            Throwable throwable;
            Reject reject = Reject$.MODULE$.unapply((Reject)processingResult);
            Throwable ex = throwable = reject._1();
            throw ex;
        }
        if (processingResult instanceof StorageFailure) {
            Throwable throwable;
            StorageFailure storageFailure = StorageFailure$.MODULE$.unapply((StorageFailure)processingResult);
            Throwable ex = throwable = storageFailure._1();
            throw ex;
        }
        throw new MatchError((Object)processingResult);
    }

    public static Seq tryReadByTag$(EventStorage $this, String tag) {
        return $this.tryReadByTag(tag);
    }

    default public Seq<PersistentRepr> tryReadByTag(String tag) {
        Vector batch = (Vector)((IterableOnceOps)this.readAll().filter((Function1 & Serializable)repr -> {
            Object object = repr.payload();
            if (object instanceof Tagged) {
                Set set;
                Tagged tagged = Tagged$.MODULE$.unapply((Tagged)object);
                Object object2 = tagged._1();
                Set tags = set = tagged._2();
                return tags.contains((Object)tag);
            }
            return false;
        })).toVector().sortBy((Function1 & Serializable)_$4 -> _$4.timestamp(), (Ordering)Ordering.Long$.MODULE$);
        ProcessingResult processingResult = this.currentPolicy().tryProcess(tag, ReadEvents$.MODULE$.apply((Seq<Object>)batch));
        if (ProcessingSuccess$.MODULE$.equals(processingResult)) {
            return batch;
        }
        if (processingResult instanceof Reject) {
            Throwable throwable;
            Reject reject = Reject$.MODULE$.unapply((Reject)processingResult);
            Throwable ex = throwable = reject._1();
            throw ex;
        }
        if (processingResult instanceof StorageFailure) {
            Throwable throwable;
            StorageFailure storageFailure = StorageFailure$.MODULE$.unapply((StorageFailure)processingResult);
            Throwable ex = throwable = storageFailure._1();
            throw ex;
        }
        throw new MatchError((Object)processingResult);
    }

    public static Seq tryRead$(EventStorage $this, String processId, Function1 predicate) {
        return $this.tryRead(processId, (Function1<PersistentRepr, Object>)predicate);
    }

    default public Seq<PersistentRepr> tryRead(String processId, Function1<PersistentRepr, Object> predicate) {
        Vector batch = (Vector)((IterableOnceOps)this.readAll().filter(predicate)).toVector().sorted(EventStorage$.MODULE$.persistentReprOrdering());
        ProcessingResult processingResult = this.currentPolicy().tryProcess(processId, ReadEvents$.MODULE$.apply((Seq<Object>)batch));
        if (ProcessingSuccess$.MODULE$.equals(processingResult)) {
            return batch;
        }
        if (processingResult instanceof Reject) {
            Throwable throwable;
            Reject reject = Reject$.MODULE$.unapply((Reject)processingResult);
            Throwable ex = throwable = reject._1();
            throw ex;
        }
        if (processingResult instanceof StorageFailure) {
            Throwable throwable;
            StorageFailure storageFailure = StorageFailure$.MODULE$.unapply((StorageFailure)processingResult);
            Throwable ex = throwable = storageFailure._1();
            throw ex;
        }
        throw new MatchError((Object)processingResult);
    }

    public static long tryReadSeqNumber$(EventStorage $this, String persistenceId) {
        return $this.tryReadSeqNumber(persistenceId);
    }

    default public long tryReadSeqNumber(String persistenceId) {
        ProcessingResult processingResult = this.currentPolicy().tryProcess(persistenceId, ReadSeqNum$.MODULE$);
        if (ProcessingSuccess$.MODULE$.equals(processingResult)) {
            return this.getHighestSeqNumber(persistenceId);
        }
        if (processingResult instanceof Reject) {
            Throwable throwable;
            Reject reject = Reject$.MODULE$.unapply((Reject)processingResult);
            Throwable ex = throwable = reject._1();
            throw ex;
        }
        if (processingResult instanceof StorageFailure) {
            Throwable throwable;
            StorageFailure storageFailure = StorageFailure$.MODULE$.unapply((StorageFailure)processingResult);
            Throwable ex = throwable = storageFailure._1();
            throw ex;
        }
        throw new MatchError((Object)processingResult);
    }

    public static void tryDelete$(EventStorage $this, String persistenceId, long toSeqNumber) {
        $this.tryDelete(persistenceId, toSeqNumber);
    }

    default public void tryDelete(String persistenceId, long toSeqNumber) {
        ProcessingResult processingResult = this.currentPolicy().tryProcess(persistenceId, DeleteEvents$.MODULE$.apply(toSeqNumber));
        if (ProcessingSuccess$.MODULE$.equals(processingResult)) {
            this.deleteToSeqNumber(persistenceId, toSeqNumber);
            return;
        }
        if (processingResult instanceof Reject) {
            Throwable throwable;
            Reject reject = Reject$.MODULE$.unapply((Reject)processingResult);
            Throwable ex = throwable = reject._1();
            throw ex;
        }
        if (processingResult instanceof StorageFailure) {
            Throwable throwable;
            StorageFailure storageFailure = StorageFailure$.MODULE$.unapply((StorageFailure)processingResult);
            Throwable ex = throwable = storageFailure._1();
            throw ex;
        }
        throw new MatchError((Object)processingResult);
    }

    public static Source currentPersistenceIds$(EventStorage $this, Option afterId, long limit) {
        return $this.currentPersistenceIds((Option<String>)afterId, limit);
    }

    default public Source<String, NotUsed> currentPersistenceIds(Option<String> afterId, long limit) {
        Option<String> option = afterId;
        if (option instanceof Some) {
            String id = (String)((Some)option).value();
            Seq seq = (Seq)((IterableOps)this.keys().sorted((Ordering)Ordering.String$.MODULE$)).dropWhile((Function1 & Serializable)_$5 -> {
                String string = _$5;
                String string2 = id;
                return string == null ? string2 != null : !string.equals(string2);
            });
            Seq s = seq;
            if (s.size() < 2) {
                return Source$.MODULE$.empty();
            }
            Seq s2 = seq;
            return (Source)Source$.MODULE$.apply((Iterable)s2.tail()).take(limit);
        }
        if (None$.MODULE$.equals(option)) {
            return (Source)Source$.MODULE$.apply((Iterable)this.keys().sorted((Ordering)Ordering.String$.MODULE$)).take(limit);
        }
        throw new MatchError(option);
    }

    private Seq<PersistentRepr> mapAny(String key, Seq<Object> elems) {
        long sn = this.getHighestSeqNumber(key) + 1L;
        return (Seq)((IterableOps)elems.zipWithIndex()).map((Function1 & Serializable)p -> PersistentRepr$.MODULE$.apply(p._1(), (long)BoxesRunTime.unboxToInt((Object)p._2()) + sn, key, PersistentRepr$.MODULE$.apply$default$4(), PersistentRepr$.MODULE$.apply$default$5(), PersistentRepr$.MODULE$.apply$default$6(), PersistentRepr$.MODULE$.apply$default$7()));
    }
}

