/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.snapshot;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pekko.persistence.CapabilityFlag;
import org.apache.pekko.persistence.CapabilityFlag$;
import org.apache.pekko.persistence.DeleteSnapshotSuccess$;
import org.apache.pekko.persistence.DeleteSnapshotsSuccess$;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.PluginSpec;
import org.apache.pekko.persistence.SaveSnapshotSuccess;
import org.apache.pekko.persistence.SaveSnapshotSuccess$;
import org.apache.pekko.persistence.SelectedSnapshot;
import org.apache.pekko.persistence.SelectedSnapshot$;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.SnapshotMetadata$;
import org.apache.pekko.persistence.SnapshotProtocol;
import org.apache.pekko.persistence.SnapshotSelectionCriteria;
import org.apache.pekko.persistence.SnapshotSelectionCriteria$;
import org.apache.pekko.persistence.SnapshotStoreCapabilityFlags;
import org.apache.pekko.persistence.TestPayload;
import org.apache.pekko.persistence.TestPayload$;
import org.apache.pekko.persistence.scalatest.MayVerb;
import org.apache.pekko.persistence.scalatest.OptionalTests;
import org.apache.pekko.persistence.snapshot.SnapshotStoreSpec$;
import org.apache.pekko.testkit.TestProbe;
import org.apache.pekko.testkit.TestProbe$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.compatible.Assertion;
import org.scalatest.wordspec.AnyWordSpecLike;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;

public abstract class SnapshotStoreSpec
extends PluginSpec
implements MayVerb,
OptionalTests,
SnapshotStoreCapabilityFlags {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SnapshotStoreSpec.class.getDeclaredField("system$lzy1"));
    private volatile Object system$lzy1;
    private TestProbe senderProbe;
    private Seq<SnapshotMetadata> metadata = package$.MODULE$.Nil();

    public SnapshotStoreSpec(Config config) {
        super(config);
        this.convertToStringMustWrapperForVerb("A snapshot store", Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91)).must((Function0 & Serializable)() -> {
            this.$init$$$anonfun$1();
            return BoxedUnit.UNIT;
        }, this.subjectRegistrationFunction());
        this.convertToStringMayWrapper("A snapshot store optionally").may((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$init$$$anonfun$2();
            return BoxedUnit.UNIT;
        }, this.subjectRegistrationFunction(), Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
    }

    private Config config$accessor() {
        return super.config();
    }

    public ActorSystem system() {
        Object object = this.system$lzy1;
        if (object instanceof ActorSystem) {
            return (ActorSystem)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ActorSystem)this.system$lzyINIT1();
    }

    private Object system$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.system$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ActorSystem actorSystem = null;
                    try {
                        actorSystem = ActorSystem$.MODULE$.apply("SnapshotStoreSpec", this.config$accessor().withFallback((ConfigMergeable)SnapshotStoreSpec$.MODULE$.config()));
                        object2 = actorSystem == null ? LazyVals.NullValue$.MODULE$ : actorSystem;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.system$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return actorSystem;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public CapabilityFlag supportsSerialization() {
        return CapabilityFlag$.MODULE$.mkFlag(true);
    }

    @Override
    public CapabilityFlag supportsMetadata() {
        return CapabilityFlag$.MODULE$.mkFlag(false);
    }

    @Override
    public void beforeEach() {
        super.beforeEach();
        this.senderProbe = TestProbe$.MODULE$.apply(this.system());
        this.metadata = this.writeSnapshots();
    }

    public ActorRef snapshotStore() {
        Persistence persistence = this.extension();
        return persistence.snapshotStoreFor(null, persistence.snapshotStoreFor$default$2());
    }

    public Seq<SnapshotMetadata> writeSnapshots() {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable)i -> this.writeSnapshots$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
    }

    public int snapshotByteSizeLimit() {
        return 10000;
    }

    private final SnapshotProtocol.LoadSnapshotResult f$proxy1$1() {
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply("invalid", SnapshotSelectionCriteria$.MODULE$.Latest(), Long.MAX_VALUE), this.senderProbe.ref());
        return (SnapshotProtocol.LoadSnapshotResult)this.senderProbe.expectMsg((Object)SnapshotProtocol.LoadSnapshotResult$.MODULE$.apply((Option)None$.MODULE$, Long.MAX_VALUE));
    }

    private final SnapshotProtocol.LoadSnapshotResult f$proxy2$1() {
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.Latest().copy(SnapshotSelectionCriteria$.MODULE$.Latest().copy$default$1(), 100L, SnapshotSelectionCriteria$.MODULE$.Latest().copy$default$3(), SnapshotSelectionCriteria$.MODULE$.Latest().copy$default$4()), Long.MAX_VALUE), this.senderProbe.ref());
        return (SnapshotProtocol.LoadSnapshotResult)this.senderProbe.expectMsg((Object)SnapshotProtocol.LoadSnapshotResult$.MODULE$.apply((Option)None$.MODULE$, Long.MAX_VALUE));
    }

    private final SnapshotProtocol.LoadSnapshotResult f$proxy3$1() {
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.apply(7L, SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$2(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$3(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$4()), Long.MAX_VALUE), this.senderProbe.ref());
        this.senderProbe.expectMsg((Object)SnapshotProtocol.LoadSnapshotResult$.MODULE$.apply((Option)None$.MODULE$, Long.MAX_VALUE));
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.Latest(), 7L), this.senderProbe.ref());
        return (SnapshotProtocol.LoadSnapshotResult)this.senderProbe.expectMsg((Object)SnapshotProtocol.LoadSnapshotResult$.MODULE$.apply((Option)None$.MODULE$, 7L));
    }

    private final SnapshotProtocol.LoadSnapshotResult f$proxy4$1() {
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.Latest(), Long.MAX_VALUE), this.senderProbe.ref());
        return (SnapshotProtocol.LoadSnapshotResult)this.senderProbe.expectMsg((Object)SnapshotProtocol.LoadSnapshotResult$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)SelectedSnapshot$.MODULE$.apply((SnapshotMetadata)this.metadata.apply(4), (Object)"s-5")), Long.MAX_VALUE));
    }

    private final SnapshotProtocol.LoadSnapshotResult f$proxy5$1() {
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.apply(13L, SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$2(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$3(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$4()), Long.MAX_VALUE), this.senderProbe.ref());
        this.senderProbe.expectMsg((Object)SnapshotProtocol.LoadSnapshotResult$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)SelectedSnapshot$.MODULE$.apply((SnapshotMetadata)this.metadata.apply(2), (Object)"s-3")), Long.MAX_VALUE));
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.Latest(), 13L), this.senderProbe.ref());
        return (SnapshotProtocol.LoadSnapshotResult)this.senderProbe.expectMsg((Object)SnapshotProtocol.LoadSnapshotResult$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)SelectedSnapshot$.MODULE$.apply((SnapshotMetadata)this.metadata.apply(2), (Object)"s-3")), 13L));
    }

    private final SnapshotProtocol.LoadSnapshotResult f$proxy6$1() {
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.apply(13L, ((SnapshotMetadata)this.metadata.apply(2)).timestamp(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$3(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$4()), Long.MAX_VALUE), this.senderProbe.ref());
        this.senderProbe.expectMsg((Object)SnapshotProtocol.LoadSnapshotResult$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)SelectedSnapshot$.MODULE$.apply((SnapshotMetadata)this.metadata.apply(2), (Object)"s-3")), Long.MAX_VALUE));
        long l = ((SnapshotMetadata)this.metadata.apply(2)).timestamp();
        long l2 = SnapshotSelectionCriteria$.MODULE$.Latest().copy$default$1();
        long l3 = SnapshotSelectionCriteria$.MODULE$.Latest().copy$default$3();
        long l4 = SnapshotSelectionCriteria$.MODULE$.Latest().copy$default$4();
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.Latest().copy(l2, l, l3, l4), 13L), this.senderProbe.ref());
        return (SnapshotProtocol.LoadSnapshotResult)this.senderProbe.expectMsg((Object)SnapshotProtocol.LoadSnapshotResult$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)SelectedSnapshot$.MODULE$.apply((SnapshotMetadata)this.metadata.apply(2), (Object)"s-3")), 13L));
    }

    private final SnapshotProtocol.LoadSnapshotResult f$proxy7$1() {
        SnapshotMetadata snapshotMetadata = (SnapshotMetadata)this.metadata.apply(2);
        SnapshotMetadata md = snapshotMetadata.copy(snapshotMetadata.copy$default$1(), snapshotMetadata.copy$default$2(), 0L);
        SnapshotProtocol.DeleteSnapshot cmd = SnapshotProtocol.DeleteSnapshot$.MODULE$.apply(md);
        TestProbe sub = TestProbe$.MODULE$.apply(this.system());
        this.subscribe(sub.ref(), ClassTag$.MODULE$.apply(SnapshotProtocol.DeleteSnapshot.class));
        this.snapshotStore().tell((Object)cmd, this.senderProbe.ref());
        sub.expectMsg((Object)cmd);
        this.senderProbe.expectMsg((Object)DeleteSnapshotSuccess$.MODULE$.apply(md));
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.apply(md.sequenceNr(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$2(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$3(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$4()), Long.MAX_VALUE), this.senderProbe.ref());
        return (SnapshotProtocol.LoadSnapshotResult)this.senderProbe.expectMsg((Object)SnapshotProtocol.LoadSnapshotResult$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)SelectedSnapshot$.MODULE$.apply((SnapshotMetadata)this.metadata.apply(1), (Object)"s-2")), Long.MAX_VALUE));
    }

    private final SnapshotProtocol.LoadSnapshotResult f$proxy8$1() {
        SnapshotMetadata md = (SnapshotMetadata)this.metadata.apply(2);
        SnapshotSelectionCriteria criteria = SnapshotSelectionCriteria$.MODULE$.apply(md.sequenceNr(), md.timestamp(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$3(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$4());
        SnapshotProtocol.DeleteSnapshots cmd = SnapshotProtocol.DeleteSnapshots$.MODULE$.apply(this.pid(), criteria);
        TestProbe sub = TestProbe$.MODULE$.apply(this.system());
        this.subscribe(sub.ref(), ClassTag$.MODULE$.apply(SnapshotProtocol.DeleteSnapshots.class));
        this.snapshotStore().tell((Object)cmd, this.senderProbe.ref());
        sub.expectMsg((Object)cmd);
        this.senderProbe.expectMsg((Object)DeleteSnapshotsSuccess$.MODULE$.apply(criteria));
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.apply(md.sequenceNr(), md.timestamp(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$3(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$4()), Long.MAX_VALUE), this.senderProbe.ref());
        this.senderProbe.expectMsg((Object)SnapshotProtocol.LoadSnapshotResult$.MODULE$.apply((Option)None$.MODULE$, Long.MAX_VALUE));
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.apply(((SnapshotMetadata)this.metadata.apply(3)).sequenceNr(), ((SnapshotMetadata)this.metadata.apply(3)).timestamp(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$3(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$4()), Long.MAX_VALUE), this.senderProbe.ref());
        return (SnapshotProtocol.LoadSnapshotResult)this.senderProbe.expectMsg((Object)SnapshotProtocol.LoadSnapshotResult$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)SelectedSnapshot$.MODULE$.apply((SnapshotMetadata)this.metadata.apply(3), (Object)"s-4")), Long.MAX_VALUE));
    }

    private final SnapshotProtocol.LoadSnapshotResult f$proxy9$1() {
        SnapshotMetadata md = (SnapshotMetadata)this.metadata.apply(3);
        SnapshotSelectionCriteria criteria = SnapshotSelectionCriteria$.MODULE$.apply(md.sequenceNr(), md.timestamp() - 1L, SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$3(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$4());
        SnapshotProtocol.DeleteSnapshots cmd = SnapshotProtocol.DeleteSnapshots$.MODULE$.apply(this.pid(), criteria);
        TestProbe sub = TestProbe$.MODULE$.apply(this.system());
        this.subscribe(sub.ref(), ClassTag$.MODULE$.apply(SnapshotProtocol.DeleteSnapshots.class));
        this.snapshotStore().tell((Object)cmd, this.senderProbe.ref());
        sub.expectMsg((Object)cmd);
        this.senderProbe.expectMsg((Object)DeleteSnapshotsSuccess$.MODULE$.apply(criteria));
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.apply(((SnapshotMetadata)this.metadata.apply(3)).sequenceNr(), ((SnapshotMetadata)this.metadata.apply(3)).timestamp(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$3(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$4()), Long.MAX_VALUE), this.senderProbe.ref());
        return (SnapshotProtocol.LoadSnapshotResult)this.senderProbe.expectMsg((Object)SnapshotProtocol.LoadSnapshotResult$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)SelectedSnapshot$.MODULE$.apply((SnapshotMetadata)this.metadata.apply(3), (Object)"s-4")), Long.MAX_VALUE));
    }

    private final Assertion f$proxy10$1() {
        SnapshotMetadata md = (SnapshotMetadata)this.metadata.apply(4);
        this.snapshotStore().tell((Object)SnapshotProtocol.SaveSnapshot$.MODULE$.apply(md, (Object)"s-5-modified"), this.senderProbe.ref());
        TestProbe testProbe = this.senderProbe;
        SnapshotMetadata md2 = (SnapshotMetadata)testProbe.expectMsgPF(testProbe.expectMsgPF$default$1(), testProbe.expectMsgPF$default$2(), (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof SaveSnapshotSuccess) {
                    SnapshotMetadata snapshotMetadata;
                    SaveSnapshotSuccess saveSnapshotSuccess = SaveSnapshotSuccess$.MODULE$.unapply((SaveSnapshotSuccess)object);
                    SnapshotMetadata md2 = snapshotMetadata = saveSnapshotSuccess._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof SaveSnapshotSuccess) {
                    SnapshotMetadata snapshotMetadata;
                    SaveSnapshotSuccess saveSnapshotSuccess = SaveSnapshotSuccess$.MODULE$.unapply((SaveSnapshotSuccess)object);
                    SnapshotMetadata md2 = snapshotMetadata = saveSnapshotSuccess._1();
                    return md2;
                }
                return function1.apply(x);
            }
        });
        this.should((Object)BoxesRunTime.boxToLong((long)md2.sequenceNr()), Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181), Prettifier$.MODULE$.default(), this.be().apply((Object)BoxesRunTime.boxToLong((long)md.sequenceNr())));
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.apply(md.sequenceNr(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$2(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$3(), SnapshotSelectionCriteria$.MODULE$.$lessinit$greater$default$4()), Long.MAX_VALUE), this.senderProbe.ref());
        SnapshotProtocol.LoadSnapshotResult result = (SnapshotProtocol.LoadSnapshotResult)this.senderProbe.expectMsgType(ClassTag$.MODULE$.apply(SnapshotProtocol.LoadSnapshotResult.class));
        this.should(((SelectedSnapshot)result.snapshot().get()).snapshot(), Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184), Prettifier$.MODULE$.default(), this.be().apply((Object)"s-5-modified"));
        return this.should((Object)BoxesRunTime.boxToLong((long)((SelectedSnapshot)result.snapshot().get()).metadata().sequenceNr()), Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185), Prettifier$.MODULE$.default(), this.be().apply((Object)BoxesRunTime.boxToLong((long)md.sequenceNr())));
    }

    private final SnapshotMetadata f$proxy11$1() {
        SnapshotMetadata metadata = SnapshotMetadata$.MODULE$.apply(this.pid(), 100L);
        String bigSnapshot = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), this.snapshotByteSizeLimit());
        this.snapshotStore().tell((Object)SnapshotProtocol.SaveSnapshot$.MODULE$.apply(metadata, (Object)bigSnapshot), this.senderProbe.ref());
        TestProbe testProbe = this.senderProbe;
        return (SnapshotMetadata)testProbe.expectMsgPF(testProbe.expectMsgPF$default$1(), testProbe.expectMsgPF$default$2(), (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof SaveSnapshotSuccess) {
                    SnapshotMetadata snapshotMetadata;
                    SaveSnapshotSuccess saveSnapshotSuccess = SaveSnapshotSuccess$.MODULE$.unapply((SaveSnapshotSuccess)object);
                    SnapshotMetadata md = snapshotMetadata = saveSnapshotSuccess._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof SaveSnapshotSuccess) {
                    SnapshotMetadata snapshotMetadata;
                    SaveSnapshotSuccess saveSnapshotSuccess = SaveSnapshotSuccess$.MODULE$.unapply((SaveSnapshotSuccess)object);
                    SnapshotMetadata md = snapshotMetadata = saveSnapshotSuccess._1();
                    return md;
                }
                return function1.apply(x);
            }
        });
    }

    private final void $init$$$anonfun$1() {
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this = this.convertToWordSpecStringWrapper("not load a snapshot given an invalid persistenceId");
        SnapshotStoreSpec AnyWordSpecLike_this = (SnapshotStoreSpec)WordSpecStringWrapper_this.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position = Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92);
        AnyWordSpecLike_this.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy1$1(), position);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this2 = this.convertToWordSpecStringWrapper("not load a snapshot given non-matching timestamp criteria");
        SnapshotStoreSpec AnyWordSpecLike_this2 = (SnapshotStoreSpec)WordSpecStringWrapper_this2.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position2 = Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96);
        AnyWordSpecLike_this2.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this2.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy2$1(), position2);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this3 = this.convertToWordSpecStringWrapper("not load a snapshot given non-matching sequence number criteria");
        SnapshotStoreSpec AnyWordSpecLike_this3 = (SnapshotStoreSpec)WordSpecStringWrapper_this3.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position3 = Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102);
        AnyWordSpecLike_this3.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this3.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy3$1(), position3);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this4 = this.convertToWordSpecStringWrapper("load the most recent snapshot");
        SnapshotStoreSpec AnyWordSpecLike_this4 = (SnapshotStoreSpec)WordSpecStringWrapper_this4.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position4 = Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108);
        AnyWordSpecLike_this4.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this4.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy4$1(), position4);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this5 = this.convertToWordSpecStringWrapper("load the most recent snapshot matching an upper sequence number bound");
        SnapshotStoreSpec AnyWordSpecLike_this5 = (SnapshotStoreSpec)WordSpecStringWrapper_this5.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position5 = Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112);
        AnyWordSpecLike_this5.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this5.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy5$1(), position5);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this6 = this.convertToWordSpecStringWrapper("load the most recent snapshot matching upper sequence number and timestamp bounds");
        SnapshotStoreSpec AnyWordSpecLike_this6 = (SnapshotStoreSpec)WordSpecStringWrapper_this6.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position6 = Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118);
        AnyWordSpecLike_this6.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this6.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy6$1(), position6);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this7 = this.convertToWordSpecStringWrapper("delete a single snapshot identified by sequenceNr in snapshot metadata");
        SnapshotStoreSpec AnyWordSpecLike_this7 = (SnapshotStoreSpec)WordSpecStringWrapper_this7.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position7 = Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128);
        AnyWordSpecLike_this7.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this7.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy7$1(), position7);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this8 = this.convertToWordSpecStringWrapper("delete all snapshots matching upper sequence number and timestamp bounds");
        SnapshotStoreSpec AnyWordSpecLike_this8 = (SnapshotStoreSpec)WordSpecStringWrapper_this8.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position8 = Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141);
        AnyWordSpecLike_this8.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this8.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy8$1(), position8);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this9 = this.convertToWordSpecStringWrapper("not delete snapshots with non-matching upper timestamp bounds");
        SnapshotStoreSpec AnyWordSpecLike_this9 = (SnapshotStoreSpec)WordSpecStringWrapper_this9.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position9 = Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161);
        AnyWordSpecLike_this9.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this9.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy9$1(), position9);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this10 = this.convertToWordSpecStringWrapper("save and overwrite snapshot with same sequence number");
        SnapshotStoreSpec AnyWordSpecLike_this10 = (SnapshotStoreSpec)WordSpecStringWrapper_this10.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position10 = Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177);
        AnyWordSpecLike_this10.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this10.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy10$1(), position10);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this11 = this.convertToWordSpecStringWrapper(new StringBuilder(34).append("save bigger size snapshot (").append(this.snapshotByteSizeLimit()).append(" bytes)").toString());
        SnapshotStoreSpec AnyWordSpecLike_this11 = (SnapshotStoreSpec)WordSpecStringWrapper_this11.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position11 = Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188);
        AnyWordSpecLike_this11.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this11.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy11$1(), position11);
    }

    private final Assertion f$proxy12$1() {
        TestProbe probe = TestProbe$.MODULE$.apply(this.system());
        SnapshotMetadata metadata = SnapshotMetadata$.MODULE$.apply(this.pid(), 100L);
        TestPayload snap = TestPayload$.MODULE$.apply(probe.ref());
        this.snapshotStore().tell((Object)SnapshotProtocol.SaveSnapshot$.MODULE$.apply(metadata, (Object)snap), this.senderProbe.ref());
        TestProbe testProbe = this.senderProbe;
        testProbe.expectMsgPF(testProbe.expectMsgPF$default$1(), testProbe.expectMsgPF$default$2(), (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof SaveSnapshotSuccess) {
                    SnapshotMetadata snapshotMetadata;
                    SaveSnapshotSuccess saveSnapshotSuccess = SaveSnapshotSuccess$.MODULE$.unapply((SaveSnapshotSuccess)object);
                    SnapshotMetadata md = snapshotMetadata = saveSnapshotSuccess._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof SaveSnapshotSuccess) {
                    SnapshotMetadata snapshotMetadata;
                    SaveSnapshotSuccess saveSnapshotSuccess = SaveSnapshotSuccess$.MODULE$.unapply((SaveSnapshotSuccess)object);
                    SnapshotMetadata md = snapshotMetadata = saveSnapshotSuccess._1();
                    return md;
                }
                return function1.apply(x);
            }
        });
        String Pid = this.pid();
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.Latest(), Long.MAX_VALUE), this.senderProbe.ref());
        TestProbe testProbe2 = this.senderProbe;
        return (Assertion)testProbe2.expectMsgPF(testProbe2.expectMsgPF$default$1(), testProbe2.expectMsgPF$default$2(), (PartialFunction)new Serializable(Pid, snap, this){
            private final String Pid$1;
            private final TestPayload snap$1;
            private final /* synthetic */ SnapshotStoreSpec $outer;
            {
                this.Pid$1 = Pid$3;
                this.snap$1 = snap$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof SnapshotProtocol.LoadSnapshotResult) {
                    SelectedSnapshot selectedSnapshot;
                    SnapshotProtocol.LoadSnapshotResult loadSnapshotResult = SnapshotProtocol.LoadSnapshotResult$.MODULE$.unapply((SnapshotProtocol.LoadSnapshotResult)object);
                    Option option = loadSnapshotResult._1();
                    long l = loadSnapshotResult._2();
                    if (option instanceof Some && (selectedSnapshot = (SelectedSnapshot)((Some)option).value()) != null) {
                        Option option2;
                        SelectedSnapshot selectedSnapshot2 = SelectedSnapshot$.MODULE$.unapply(selectedSnapshot);
                        SnapshotMetadata snapshotMetadata = selectedSnapshot2._1();
                        Object object2 = selectedSnapshot2._2();
                        if (snapshotMetadata != null && !(option2 = SnapshotMetadata$.MODULE$.unapply(snapshotMetadata)).isEmpty()) {
                            Tuple3 tuple3 = (Tuple3)option2.get();
                            String string = this.Pid$1;
                            Object object3 = tuple3._1();
                            if (!(string != null ? !string.equals(object3) : object3 != null) && 100L == BoxesRunTime.unboxToLong((Object)tuple3._2())) {
                                Object payload = object2;
                                if (Long.MAX_VALUE == l) {
                                    return true;
                                }
                            }
                        }
                    }
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof SnapshotProtocol.LoadSnapshotResult) {
                    SelectedSnapshot selectedSnapshot;
                    SnapshotProtocol.LoadSnapshotResult loadSnapshotResult = SnapshotProtocol.LoadSnapshotResult$.MODULE$.unapply((SnapshotProtocol.LoadSnapshotResult)object);
                    Option option = loadSnapshotResult._1();
                    long l = loadSnapshotResult._2();
                    if (option instanceof Some && (selectedSnapshot = (SelectedSnapshot)((Some)option).value()) != null) {
                        Option option2;
                        SelectedSnapshot selectedSnapshot2 = SelectedSnapshot$.MODULE$.unapply(selectedSnapshot);
                        SnapshotMetadata snapshotMetadata = selectedSnapshot2._1();
                        Object object2 = selectedSnapshot2._2();
                        if (snapshotMetadata != null && !(option2 = SnapshotMetadata$.MODULE$.unapply(snapshotMetadata)).isEmpty()) {
                            Tuple3 tuple3 = (Tuple3)option2.get();
                            String string = this.Pid$1;
                            Object object3 = tuple3._1();
                            if (!(string != null ? !string.equals(object3) : object3 != null) && 100L == BoxesRunTime.unboxToLong((Object)tuple3._2())) {
                                Object payload = object2;
                                if (Long.MAX_VALUE == l) {
                                    return this.$outer.should(payload, Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209), Prettifier$.MODULE$.default(), this.$outer.be().apply((Object)this.snap$1));
                                }
                            }
                        }
                    }
                }
                return function1.apply(x);
            }
        });
    }

    private final void $init$$$anonfun$2$$anonfun$1() {
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this = this.convertToWordSpecStringWrapper("serialize snapshots");
        SnapshotStoreSpec AnyWordSpecLike_this = (SnapshotStoreSpec)WordSpecStringWrapper_this.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position = Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198);
        AnyWordSpecLike_this.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy12$1(), position);
    }

    private final Assertion f$proxy13$1() {
        String fictionalMeta = "fictional metadata";
        SnapshotMetadata metadata = SnapshotMetadata$.MODULE$.apply(this.pid(), 100L).withMetadata((Object)fictionalMeta);
        String snap = "snap";
        this.snapshotStore().tell((Object)SnapshotProtocol.SaveSnapshot$.MODULE$.apply(metadata, (Object)snap), this.senderProbe.ref());
        TestProbe testProbe = this.senderProbe;
        testProbe.expectMsgPF(testProbe.expectMsgPF$default$1(), testProbe.expectMsgPF$default$2(), (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof SaveSnapshotSuccess) {
                    SnapshotMetadata snapshotMetadata;
                    SaveSnapshotSuccess saveSnapshotSuccess = SaveSnapshotSuccess$.MODULE$.unapply((SaveSnapshotSuccess)object);
                    SnapshotMetadata md = snapshotMetadata = saveSnapshotSuccess._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof SaveSnapshotSuccess) {
                    SnapshotMetadata snapshotMetadata;
                    SaveSnapshotSuccess saveSnapshotSuccess = SaveSnapshotSuccess$.MODULE$.unapply((SaveSnapshotSuccess)object);
                    SnapshotMetadata md = snapshotMetadata = saveSnapshotSuccess._1();
                    return md;
                }
                return function1.apply(x);
            }
        });
        String Pid = this.pid();
        this.snapshotStore().tell((Object)SnapshotProtocol.LoadSnapshot$.MODULE$.apply(this.pid(), SnapshotSelectionCriteria$.MODULE$.Latest(), Long.MAX_VALUE), this.senderProbe.ref());
        TestProbe testProbe2 = this.senderProbe;
        return (Assertion)testProbe2.expectMsgPF(testProbe2.expectMsgPF$default$1(), testProbe2.expectMsgPF$default$2(), (PartialFunction)new Serializable(Pid, snap, fictionalMeta, this){
            private final String Pid$2;
            private final String snap$2;
            private final String fictionalMeta$1;
            private final /* synthetic */ SnapshotStoreSpec $outer;
            {
                this.Pid$2 = Pid$4;
                this.snap$2 = snap$4;
                this.fictionalMeta$1 = fictionalMeta$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof SnapshotProtocol.LoadSnapshotResult) {
                    SelectedSnapshot selectedSnapshot;
                    SnapshotProtocol.LoadSnapshotResult loadSnapshotResult = SnapshotProtocol.LoadSnapshotResult$.MODULE$.unapply((SnapshotProtocol.LoadSnapshotResult)object);
                    Option option = loadSnapshotResult._1();
                    long l = loadSnapshotResult._2();
                    if (option instanceof Some && (selectedSnapshot = (SelectedSnapshot)((Some)option).value()) != null) {
                        Option option2;
                        SelectedSnapshot selectedSnapshot2 = SelectedSnapshot$.MODULE$.unapply(selectedSnapshot);
                        SnapshotMetadata snapshotMetadata = selectedSnapshot2._1();
                        Object object2 = selectedSnapshot2._2();
                        if (snapshotMetadata != null && !(option2 = SnapshotMetadata$.MODULE$.unapply(snapshotMetadata)).isEmpty()) {
                            Tuple3 tuple3 = (Tuple3)option2.get();
                            String string = this.Pid$2;
                            Object object3 = tuple3._1();
                            if (!(string != null ? !string.equals(object3) : object3 != null) && 100L == BoxesRunTime.unboxToLong((Object)tuple3._2())) {
                                SnapshotMetadata meta = snapshotMetadata;
                                Object payload = object2;
                                if (Long.MAX_VALUE == l) {
                                    return true;
                                }
                            }
                        }
                    }
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof SnapshotProtocol.LoadSnapshotResult) {
                    SelectedSnapshot selectedSnapshot;
                    SnapshotProtocol.LoadSnapshotResult loadSnapshotResult = SnapshotProtocol.LoadSnapshotResult$.MODULE$.unapply((SnapshotProtocol.LoadSnapshotResult)object);
                    Option option = loadSnapshotResult._1();
                    long l = loadSnapshotResult._2();
                    if (option instanceof Some && (selectedSnapshot = (SelectedSnapshot)((Some)option).value()) != null) {
                        Option option2;
                        SelectedSnapshot selectedSnapshot2 = SelectedSnapshot$.MODULE$.unapply(selectedSnapshot);
                        SnapshotMetadata snapshotMetadata = selectedSnapshot2._1();
                        Object object2 = selectedSnapshot2._2();
                        if (snapshotMetadata != null && !(option2 = SnapshotMetadata$.MODULE$.unapply(snapshotMetadata)).isEmpty()) {
                            Tuple3 tuple3 = (Tuple3)option2.get();
                            String string = this.Pid$2;
                            Object object3 = tuple3._1();
                            if (!(string != null ? !string.equals(object3) : object3 != null) && 100L == BoxesRunTime.unboxToLong((Object)tuple3._2())) {
                                SnapshotMetadata meta = snapshotMetadata;
                                Object payload = object2;
                                if (Long.MAX_VALUE == l) {
                                    this.$outer.should(payload, Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230), Prettifier$.MODULE$.default(), this.$outer.be().apply((Object)this.snap$2));
                                    return this.$outer.should((Object)meta.metadata(), Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231), Prettifier$.MODULE$.default(), this.$outer.$eq$eq$eq(Some$.MODULE$.apply((Object)this.fictionalMeta$1)), this.$outer.unconstrainedEquality(Equality$.MODULE$.default()));
                                }
                            }
                        }
                    }
                }
                return function1.apply(x);
            }
        });
    }

    private final void $init$$$anonfun$2$$anonfun$2() {
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this = this.convertToWordSpecStringWrapper("store metadata");
        SnapshotStoreSpec AnyWordSpecLike_this = (SnapshotStoreSpec)WordSpecStringWrapper_this.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position = Position$.MODULE$.apply("SnapshotStoreSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214);
        AnyWordSpecLike_this.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy13$1(), position);
    }

    private final void $init$$$anonfun$2() {
        this.optional(this.supportsSerialization(), (Function0 & Serializable)() -> {
            this.$init$$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        });
        this.optional(this.supportsMetadata(), (Function0 & Serializable)() -> {
            this.$init$$$anonfun$2$$anonfun$2();
            return BoxedUnit.UNIT;
        });
    }

    private final /* synthetic */ SnapshotMetadata writeSnapshots$$anonfun$1(int i) {
        SnapshotMetadata metadata = SnapshotMetadata$.MODULE$.apply(this.pid(), Int$.MODULE$.int2long(i + 10));
        this.snapshotStore().tell((Object)SnapshotProtocol.SaveSnapshot$.MODULE$.apply(metadata, (Object)new StringBuilder(2).append("s-").append(i).toString()), this.senderProbe.ref());
        TestProbe testProbe = this.senderProbe;
        return (SnapshotMetadata)testProbe.expectMsgPF(testProbe.expectMsgPF$default$1(), testProbe.expectMsgPF$default$2(), (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof SaveSnapshotSuccess) {
                    SnapshotMetadata snapshotMetadata;
                    SaveSnapshotSuccess saveSnapshotSuccess = SaveSnapshotSuccess$.MODULE$.unapply((SaveSnapshotSuccess)object);
                    SnapshotMetadata md = snapshotMetadata = saveSnapshotSuccess._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof SaveSnapshotSuccess) {
                    SnapshotMetadata snapshotMetadata;
                    SaveSnapshotSuccess saveSnapshotSuccess = SaveSnapshotSuccess$.MODULE$.unapply((SaveSnapshotSuccess)object);
                    SnapshotMetadata md = snapshotMetadata = saveSnapshotSuccess._1();
                    return md;
                }
                return function1.apply(x);
            }
        });
    }
}

