/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence;

import java.io.NotSerializableException;
import java.nio.charset.StandardCharsets;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.persistence.TestPayload;
import org.apache.pekko.persistence.TestPayload$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializerWithStringManifest;

public class TestSerializer
extends SerializerWithStringManifest {
    private final ExtendedActorSystem system;

    public TestSerializer(ExtendedActorSystem system) {
        this.system = system;
    }

    public int identifier() {
        return 666;
    }

    public String manifest(Object o) {
        Object object = o;
        if (object instanceof TestPayload) {
            return "A";
        }
        throw new RuntimeException();
    }

    public byte[] toBinary(Object o) {
        Object object = o;
        if (object instanceof TestPayload) {
            ActorRef actorRef;
            TestPayload testPayload = TestPayload$.MODULE$.unapply((TestPayload)object);
            ActorRef ref = actorRef = testPayload._1();
            this.verifyTransportInfo();
            String refStr = Serialization$.MODULE$.serializedActorPath(ref);
            return refStr.getBytes(StandardCharsets.UTF_8);
        }
        throw new NotSerializableException();
    }

    public Object fromBinary(byte[] bytes, String manifest) {
        this.verifyTransportInfo();
        String string = manifest;
        if ("A".equals(string)) {
            String refStr = new String(bytes, StandardCharsets.UTF_8);
            ActorRef ref = this.system.provider().resolveActorRef(refStr);
            return TestPayload$.MODULE$.apply(ref);
        }
        throw new NotSerializableException();
    }

    private void verifyTransportInfo() {
        Serialization.Information information = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
        if (information == null) {
            throw new IllegalStateException("currentTransportInformation was not set");
        }
        Serialization.Information t = information;
        if (t.system() != this.system) {
            throw new IllegalStateException(new StringBuilder(49).append("wrong system in currentTransportInformation, ").append(t.system()).append(" != ").append(this.system).toString());
        }
        Address address = t.address();
        Address address2 = this.system.provider().getDefaultAddress();
        if (address == null ? address2 != null : !address.equals(address2)) {
            throw new IllegalStateException(new StringBuilder(50).append("wrong address in currentTransportInformation, ").append(t.address()).append(" != ").append(this.system.provider().getDefaultAddress()).toString());
        }
    }
}

