/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.r2dbc.migration;

import io.r2dbc.spi.ConnectionFactory;
import java.io.Serializable;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.persistence.r2dbc.internal.R2dbcExecutor;
import org.apache.pekko.persistence.r2dbc.internal.Sql;
import org.apache.pekko.persistence.r2dbc.internal.Sql$;
import org.apache.pekko.persistence.r2dbc.journal.JournalDao$;
import org.apache.pekko.persistence.r2dbc.migration.MigrationToolDao$CurrentProgress$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public class MigrationToolDao {
    private final R2dbcExecutor r2dbcExecutor;

    public MigrationToolDao(ConnectionFactory connectionFactory, FiniteDuration logDbCallsExceeding, ExecutionContext ec, ActorSystem<?> system) {
        this.r2dbcExecutor = new R2dbcExecutor(connectionFactory, JournalDao$.MODULE$.log(), logDbCallsExceeding, ec, system);
    }

    public Future<Done> createProgressTable() {
        return this.r2dbcExecutor.executeDdl("create migration progress table", (Function1 & Serializable)connection -> connection.createStatement(Sql.Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        CREATE TABLE IF NOT EXISTS migration_progress(\n          persistence_id VARCHAR(255) NOT NULL,\n          event_seq_nr BIGINT,\n          snapshot_seq_nr BIGINT,\n          PRIMARY KEY(persistence_id)\n        )"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))));
    }

    public Future<Done> updateEventProgress(String persistenceId, long seqNr) {
        return this.r2dbcExecutor.updateOne(new StringBuilder(28).append("upsert migration progress [").append(persistenceId).append("]").toString(), (Function1 & Serializable)connection -> connection.createStatement(Sql.Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n              INSERT INTO migration_progress\n              (persistence_id, event_seq_nr)\n              VALUES (?, ?)\n              ON CONFLICT (persistence_id)\n              DO UPDATE SET\n              event_seq_nr = excluded.event_seq_nr"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))).bind(0, (Object)persistenceId).bind(1, (Object)BoxesRunTime.boxToLong((long)seqNr))).map((Function1 & Serializable)_$1 -> MigrationToolDao.updateEventProgress$$anonfun$2(BoxesRunTime.unboxToLong((Object)_$1)), ExecutionContexts$.MODULE$.parasitic());
    }

    public Future<Done> updateSnapshotProgress(String persistenceId, long seqNr) {
        return this.r2dbcExecutor.updateOne(new StringBuilder(28).append("upsert migration progress [").append(persistenceId).append("]").toString(), (Function1 & Serializable)connection -> connection.createStatement(Sql.Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n              INSERT INTO migration_progress\n              (persistence_id, snapshot_seq_nr)\n              VALUES (?, ?)\n              ON CONFLICT (persistence_id)\n              DO UPDATE SET\n              snapshot_seq_nr = excluded.snapshot_seq_nr"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))).bind(0, (Object)persistenceId).bind(1, (Object)BoxesRunTime.boxToLong((long)seqNr))).map((Function1 & Serializable)_$2 -> MigrationToolDao.updateSnapshotProgress$$anonfun$2(BoxesRunTime.unboxToLong((Object)_$2)), ExecutionContexts$.MODULE$.parasitic());
    }

    public Future<Option<CurrentProgress>> currentProgress(String persistenceId) {
        return this.r2dbcExecutor.selectOne(new StringBuilder(26).append("read migration progress [").append(persistenceId).append("]").toString(), (Function1 & Serializable)_$3 -> _$3.createStatement(Sql.Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM migration_progress WHERE persistence_id = ?"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))).bind(0, (Object)persistenceId), (Function1 & Serializable)row -> MigrationToolDao$CurrentProgress$.MODULE$.apply(persistenceId, this.zeroIfNull((Long)row.get("event_seq_nr", Long.class)), this.zeroIfNull((Long)row.get("snapshot_seq_nr", Long.class))));
    }

    private long zeroIfNull(Long n) {
        if (n == null) {
            return 0L;
        }
        return Predef$.MODULE$.Long2long(n);
    }

    private static final /* synthetic */ Done$ updateEventProgress$$anonfun$2(long _$1) {
        return Done$.MODULE$;
    }

    private static final /* synthetic */ Done$ updateSnapshotProgress$$anonfun$2(long _$2) {
        return Done$.MODULE$;
    }

    public static final class CurrentProgress
    implements Product,
    Serializable {
        private final String persistenceId;
        private final long eventSeqNr;
        private final long snapshotSeqNr;

        public static CurrentProgress apply(String string, long l, long l2) {
            return MigrationToolDao$CurrentProgress$.MODULE$.apply(string, l, l2);
        }

        public static CurrentProgress fromProduct(Product product) {
            return MigrationToolDao$CurrentProgress$.MODULE$.fromProduct(product);
        }

        public static CurrentProgress unapply(CurrentProgress currentProgress) {
            return MigrationToolDao$CurrentProgress$.MODULE$.unapply(currentProgress);
        }

        public CurrentProgress(String persistenceId, long eventSeqNr, long snapshotSeqNr) {
            this.persistenceId = persistenceId;
            this.eventSeqNr = eventSeqNr;
            this.snapshotSeqNr = snapshotSeqNr;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.persistenceId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.eventSeqNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.snapshotSeqNr()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CurrentProgress)) return false;
            CurrentProgress currentProgress = (CurrentProgress)object;
            if (this.eventSeqNr() != currentProgress.eventSeqNr()) return false;
            if (this.snapshotSeqNr() != currentProgress.snapshotSeqNr()) return false;
            String string = this.persistenceId();
            String string2 = currentProgress.persistenceId();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CurrentProgress;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "CurrentProgress";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "persistenceId";
                }
                case 1: {
                    return "eventSeqNr";
                }
                case 2: {
                    return "snapshotSeqNr";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String persistenceId() {
            return this.persistenceId;
        }

        public long eventSeqNr() {
            return this.eventSeqNr;
        }

        public long snapshotSeqNr() {
            return this.snapshotSeqNr;
        }

        public CurrentProgress copy(String persistenceId, long eventSeqNr, long snapshotSeqNr) {
            return new CurrentProgress(persistenceId, eventSeqNr, snapshotSeqNr);
        }

        public String copy$default$1() {
            return this.persistenceId();
        }

        public long copy$default$2() {
            return this.eventSeqNr();
        }

        public long copy$default$3() {
            return this.snapshotSeqNr();
        }

        public String _1() {
            return this.persistenceId();
        }

        public long _2() {
            return this.eventSeqNr();
        }

        public long _3() {
            return this.snapshotSeqNr();
        }
    }
}

