/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.r2dbc.migration;

import com.typesafe.config.Config;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import org.apache.pekko.Done;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.Persistence$;
import org.apache.pekko.persistence.SelectedSnapshot;
import org.apache.pekko.persistence.SelectedSnapshot$;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.SnapshotProtocol;
import org.apache.pekko.persistence.SnapshotSelectionCriteria;
import org.apache.pekko.persistence.SnapshotSelectionCriteria$;
import org.apache.pekko.persistence.query.EventEnvelope;
import org.apache.pekko.persistence.query.PersistenceQuery;
import org.apache.pekko.persistence.query.PersistenceQuery$;
import org.apache.pekko.persistence.query.scaladsl.CurrentEventsByPersistenceIdQuery;
import org.apache.pekko.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import org.apache.pekko.persistence.query.scaladsl.ReadJournal;
import org.apache.pekko.persistence.r2dbc.ConnectionFactoryProvider;
import org.apache.pekko.persistence.r2dbc.ConnectionFactoryProvider$;
import org.apache.pekko.persistence.r2dbc.R2dbcSettings;
import org.apache.pekko.persistence.r2dbc.R2dbcSettings$;
import org.apache.pekko.persistence.r2dbc.journal.JournalDao;
import org.apache.pekko.persistence.r2dbc.journal.JournalDao$;
import org.apache.pekko.persistence.r2dbc.migration.MigrationTool$;
import org.apache.pekko.persistence.r2dbc.migration.MigrationTool$Result$;
import org.apache.pekko.persistence.r2dbc.migration.MigrationToolDao;
import org.apache.pekko.persistence.r2dbc.snapshot.SnapshotDao;
import org.apache.pekko.persistence.typed.PersistenceId$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class MigrationTool {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(MigrationTool.class.getDeclaredField("createProgressTable$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MigrationTool.class.getDeclaredField("sourceSnapshotStore$lzy1"));
    public final ActorSystem<?> org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system;
    private final ActorSystem<?> sys;
    public final Logger org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$log;
    private final Persistence persistenceExt;
    private final int parallelism;
    private final Serialization serialization;
    public final JournalDao org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$targetJournalDao;
    private final SnapshotDao targetSnapshotDao;
    private final int targetBatch;
    private final CurrentPersistenceIdsQuery sourcePersistenceIdsQuery;
    private final CurrentEventsByPersistenceIdQuery sourceEventsByPersistenceIdQuery;
    private final String sourceSnapshotPluginId;
    private volatile Object sourceSnapshotStore$lzy1;
    private final MigrationToolDao migrationDao;
    private volatile Object createProgressTable$lzy1;

    public static void main(String[] stringArray) {
        MigrationTool$.MODULE$.main(stringArray);
    }

    public MigrationTool(ActorSystem<?> system) {
        this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system = system;
        this.sys = system;
        this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$log = LoggerFactory.getLogger(this.getClass());
        this.persistenceExt = (Persistence)Persistence$.MODULE$.apply(system);
        Config migrationConfig = system.settings().config().getConfig("pekko.persistence.r2dbc.migration");
        this.parallelism = migrationConfig.getInt("parallelism");
        String targetPluginId = migrationConfig.getString("target.persistence-plugin-id");
        R2dbcSettings targetR2dbcSettings = R2dbcSettings$.MODULE$.apply(system.settings().config().getConfig(targetPluginId));
        this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(system);
        ConnectionFactory targetConnectionFactory = ((ConnectionFactoryProvider)ConnectionFactoryProvider$.MODULE$.apply(system)).connectionFactoryFor(new StringBuilder(19).append(targetPluginId).append(".connection-factory").toString());
        this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$targetJournalDao = new JournalDao(targetR2dbcSettings, targetConnectionFactory, (ExecutionContext)system.executionContext(), this.sys);
        this.targetSnapshotDao = new SnapshotDao(targetR2dbcSettings, targetConnectionFactory, (ExecutionContext)system.executionContext(), this.sys);
        this.targetBatch = migrationConfig.getInt("target.batch");
        String sourceQueryPluginId = migrationConfig.getString("source.query-plugin-id");
        ReadJournal sourceReadJournal = ((PersistenceQuery)PersistenceQuery$.MODULE$.apply(system)).readJournalFor(sourceQueryPluginId);
        this.sourcePersistenceIdsQuery = (CurrentPersistenceIdsQuery)sourceReadJournal;
        this.sourceEventsByPersistenceIdQuery = (CurrentEventsByPersistenceIdQuery)sourceReadJournal;
        this.sourceSnapshotPluginId = migrationConfig.getString("source.snapshot-plugin-id");
        this.migrationDao = new MigrationToolDao(targetConnectionFactory, targetR2dbcSettings.logDbCallsExceeding(), (ExecutionContext)system.executionContext(), this.sys);
    }

    private ActorRef sourceSnapshotStore() {
        Object object = this.sourceSnapshotStore$lzy1;
        if (object instanceof ActorRef) {
            return (ActorRef)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ActorRef)this.sourceSnapshotStore$lzyINIT1();
    }

    private Object sourceSnapshotStore$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.sourceSnapshotStore$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ActorRef actorRef = null;
                    try {
                        Persistence persistence = (Persistence)Persistence$.MODULE$.apply(this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system);
                        actorRef = persistence.snapshotStoreFor(this.sourceSnapshotPluginId, persistence.snapshotStoreFor$default$2());
                        object2 = actorRef == null ? LazyVals.NullValue$.MODULE$ : actorRef;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.sourceSnapshotStore$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return actorRef;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public MigrationToolDao migrationDao() {
        return this.migrationDao;
    }

    private Future<Done> createProgressTable() {
        Object object = this.createProgressTable$lzy1;
        if (object instanceof Future) {
            return (Future)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Future)this.createProgressTable$lzyINIT1();
    }

    private Object createProgressTable$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.createProgressTable$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Future<Done> future = null;
                    Future<Done> future2 = null;
                    try {
                        future2 = this.migrationDao().createProgressTable();
                        future = future2 == null ? LazyVals.NullValue$.MODULE$ : future2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, future)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.createProgressTable$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, future);
                            waiting.countDown();
                        }
                    }
                    return future2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Future<Result> migrateAll() {
        this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$log.info("Migration started.");
        Future result = (Future)((Source)this.sourcePersistenceIdsQuery.currentPersistenceIds().mapAsyncUnordered(this.parallelism, (Function1 & Serializable)persistenceId -> this.createProgressTable().flatMap((Function1 & Serializable)x$1 -> {
            Done done = x$1;
            return this.migrationDao().currentProgress((String)persistenceId).flatMap((Function1 & Serializable)currentProgress -> this.migrateEvents((String)persistenceId, (Option<MigrationToolDao.CurrentProgress>)currentProgress).flatMap((Function1 & Serializable)eventCount -> this.$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1((String)persistenceId, (Option)currentProgress, BoxesRunTime.unboxToLong((Object)eventCount)), (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext()), (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
        }, (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext())).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Result result = (Result)tuple2._2();
                String pid = (String)tuple2._1();
                if (result != null) {
                    Result result2 = MigrationTool$Result$.MODULE$.unapply(result);
                    long l = result2._1();
                    long l2 = result2._2();
                    long l3 = result2._3();
                    long events = l2;
                    long snapshots = l3;
                    Result result3 = result;
                    this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$log.debug("Migrated persistenceId [{}] with [{}] events{}.", new Object[]{pid, Predef$.MODULE$.long2Long(events), snapshots == 0L ? "" : " and snapshot"});
                    return result3;
                }
            }
            throw new MatchError((Object)tuple2);
        })).runWith((Graph)Sink$.MODULE$.fold((Object)MigrationTool$Result$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Result result = (Result)tuple2._1();
                Result result2 = (Result)tuple2._2();
                if (result != null) {
                    Result acc = result;
                    if (result2 != null) {
                        Result result3 = MigrationTool$Result$.MODULE$.unapply(result2);
                        long l = result3._1();
                        long l2 = result3._2();
                        long l3 = result3._3();
                        long events = l2;
                        long snapshots = l3;
                        Result result4 = MigrationTool$Result$.MODULE$.apply(acc.persistenceIds() + 1L, acc.events() + events, acc.snapshots() + snapshots);
                        if (result4.persistenceIds() % 100L == 0L) {
                            this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$log.info("Migrated [{}] persistenceIds with [{}] events and [{}] snapshots.", new Object[]{Predef$.MODULE$.long2Long(result4.persistenceIds()), Predef$.MODULE$.long2Long(result4.events()), Predef$.MODULE$.long2Long(result4.snapshots())});
                        }
                        return result4;
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }), Materializer$.MODULE$.matFromSystem(this.sys));
        return result.transform((Function1 & Serializable)x$1 -> {
            Success success;
            Result result;
            Try try_ = x$1;
            if (try_ instanceof Success && (result = (Result)(success = (Success)try_).value()) != null) {
                Result result2 = MigrationTool$Result$.MODULE$.unapply(result);
                long l = result2._1();
                long l2 = result2._2();
                long l3 = result2._3();
                long persistenceIds = l;
                long events = l2;
                long snapshots = l3;
                Success s = success;
                this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$log.info("Migration successful. Migrated [{}] persistenceIds with [{}] events and [{}] snapshots.", new Object[]{Predef$.MODULE$.long2Long(persistenceIds), Predef$.MODULE$.long2Long(events), Predef$.MODULE$.long2Long(snapshots)});
                return s;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exc = failure.exception();
                Failure f = failure;
                this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$log.error("Migration failed.", exc);
                return f;
            }
            throw new MatchError((Object)try_);
        }, (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
    }

    public Future<Object> migrateEvents(String persistenceId) {
        return this.createProgressTable().flatMap((Function1 & Serializable)x$1 -> {
            Done done = x$1;
            return this.migrationDao().currentProgress(persistenceId).flatMap((Function1 & Serializable)currentProgress -> this.migrateEvents(persistenceId, (Option<MigrationToolDao.CurrentProgress>)currentProgress).map((Function1)(JFunction1.mcJJ.sp & Serializable)eventCount -> eventCount, (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext()), (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
        }, (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
    }

    private Future<Object> migrateEvents(String persistenceId, Option<MigrationToolDao.CurrentProgress> currentProgress) {
        long progressSeqNr = BoxesRunTime.unboxToLong((Object)currentProgress.map((Function1 & Serializable)_$1 -> _$1.eventSeqNr()).getOrElse(MigrationTool::$anonfun$5));
        return (Future)((Source)this.sourceEventsByPersistenceIdQuery.currentEventsByPersistenceId(persistenceId, progressSeqNr + 1L, Long.MAX_VALUE).map((Function1 & Serializable)env -> this.serializedJournalRow((EventEnvelope)env)).grouped(this.targetBatch).mapAsync(1, (Function1 & Serializable)events -> this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$targetJournalDao.writeEvents(events).recoverWith((PartialFunction)new Serializable((Seq)events, this){
            private final Seq events$1;
            private final /* synthetic */ MigrationTool $outer;
            {
                this.events$1 = events$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof R2dbcDataIntegrityViolationException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof R2dbcDataIntegrityViolationException) {
                    return Future$.MODULE$.sequence((IterableOnce)this.events$1.map((Function1 & Serializable)event -> this.$outer.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$targetJournalDao.writeEvents((Seq)new .colon.colon(event, (List)Nil$.MODULE$)).recoverWith((PartialFunction)new Serializable((JournalDao.SerializedJournalRow)event, this){
                        private final JournalDao.SerializedJournalRow event$1;
                        private final /* synthetic */ $anon$1 $outer;
                        {
                            this.event$1 = event$2;
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable = x;
                            return throwable instanceof R2dbcDataIntegrityViolationException;
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Throwable throwable = x;
                            if (throwable instanceof R2dbcDataIntegrityViolationException) {
                                this.$outer.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$_$_$$anon$$$outer().org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$log.debug("event already exists, persistenceId [{}], seqNr [{}]", (Object)this.event$1.persistenceId(), (Object)BoxesRunTime.boxToLong((long)this.event$1.seqNr()));
                                return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
                            }
                            return function1.apply((Object)x);
                        }
                    }, (ExecutionContext)this.$outer.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext())), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.$outer.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
                }
                return function1.apply((Object)x);
            }

            public final /* synthetic */ MigrationTool org$apache$pekko$persistence$r2dbc$migration$MigrationTool$_$_$$anon$$$outer() {
                return this.$outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(org.apache.pekko.persistence.r2dbc.journal.JournalDao$SerializedJournalRow )}, serializedLambda);
            }
        }, (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext()).map((Function1 & Serializable)_$2 -> {
            Long l = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)((JournalDao.SerializedJournalRow)events.last()).seqNr()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l, (Object)BoxesRunTime.boxToInteger((int)events.size()));
        }, (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext())).mapAsync(1, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long seqNr = tuple2._1$mcJ$sp();
                int count = tuple2._2$mcI$sp();
                return this.migrationDao().updateEventProgress(persistenceId, seqNr).map((Function1 & Serializable)_$3 -> count, (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
            }
            throw new MatchError((Object)tuple2);
        })).runWith((Graph)Sink$.MODULE$.fold((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJI.sp & Serializable)(x$1, x$2) -> {
            Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(x$1, x$2);
            if (sp2 != null) {
                long acc = sp2._1$mcJ$sp();
                int count = sp2._2$mcI$sp();
                return acc + (long)count;
            }
            throw new MatchError((Object)sp2);
        }), Materializer$.MODULE$.matFromSystem(this.sys));
    }

    private JournalDao.SerializedJournalRow serializedJournalRow(EventEnvelope env) {
        String entityType = PersistenceId$.MODULE$.extractEntityType(env.persistenceId());
        int slice = this.persistenceExt.sliceForPersistenceId(env.persistenceId());
        Object event = env.event();
        byte[] serialized = (byte[])this.serialization.serialize(event).get();
        Serializer serializer = this.serialization.findSerializerFor(event);
        String manifest = Serializers$.MODULE$.manifestFor(serializer, event);
        Option metadata = env.eventMetadata().map((Function1 & Serializable)meta -> {
            Object m = meta;
            byte[] serializedMeta = (byte[])this.serialization.serialize(m).get();
            Serializer metaSerializer = this.serialization.findSerializerFor(m);
            String metaManifest = Serializers$.MODULE$.manifestFor(metaSerializer, m);
            return JournalDao.SerializedEventMetadata$.MODULE$.apply(metaSerializer.identifier(), metaManifest, serializedMeta);
        });
        return JournalDao.SerializedJournalRow$.MODULE$.apply(slice, entityType, env.persistenceId(), env.sequenceNr(), Instant.ofEpochMilli(env.timestamp()), JournalDao$.MODULE$.EmptyDbTimestamp(), (Option)Some$.MODULE$.apply((Object)serialized), serializer.identifier(), manifest, "", Predef$.MODULE$.Set().empty(), metadata);
    }

    public Future<Object> migrateSnapshot(String persistenceId) {
        return this.createProgressTable().flatMap((Function1 & Serializable)x$1 -> {
            Done done = x$1;
            return this.migrationDao().currentProgress(persistenceId).flatMap((Function1 & Serializable)currentProgress -> this.migrateSnapshot(persistenceId, (Option<MigrationToolDao.CurrentProgress>)currentProgress).map((Function1)(JFunction1.mcII.sp & Serializable)snapCount -> snapCount, (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext()), (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
        }, (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
    }

    private Future<Object> migrateSnapshot(String persistenceId, Option<MigrationToolDao.CurrentProgress> currentProgress) {
        long progressSeqNr = BoxesRunTime.unboxToLong((Object)currentProgress.map((Function1 & Serializable)_$4 -> _$4.snapshotSeqNr()).getOrElse(MigrationTool::$anonfun$8));
        return this.loadSourceSnapshot(persistenceId, progressSeqNr + 1L).flatMap((Function1 & Serializable)x$1 -> {
            SelectedSnapshot selectedSnapshot;
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return Future$.MODULE$.successful((Object)BoxesRunTime.boxToInteger((int)0));
            }
            if (option instanceof Some && (selectedSnapshot = (SelectedSnapshot)((Some)option).value()) != null) {
                SelectedSnapshot selectedSnapshot2 = SelectedSnapshot$.MODULE$.unapply(selectedSnapshot);
                SnapshotMetadata snapshotMetadata = selectedSnapshot2._1();
                Object object = selectedSnapshot2._2();
                SnapshotMetadata snapshotMetadata2 = snapshotMetadata;
                SelectedSnapshot selectedSnapshot3 = selectedSnapshot;
                SnapshotDao.SerializedSnapshotRow serializedRow = this.serializedSnapotRow(selectedSnapshot3);
                return this.targetSnapshotDao.store(serializedRow).map((Function1 & Serializable)_$5 -> snapshotMetadata2.sequenceNr(), ExecutionContexts$.MODULE$.parasitic()).flatMap((Function1 & Serializable)seqNr -> this.migrateSnapshot$$anonfun$2$$anonfun$2(persistenceId, BoxesRunTime.unboxToLong((Object)seqNr)), (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
            }
            throw new MatchError((Object)option);
        }, (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
    }

    private SnapshotDao.SerializedSnapshotRow serializedSnapotRow(SelectedSnapshot selectedSnapshot) {
        SnapshotMetadata snapshotMetadata = selectedSnapshot.metadata();
        Object snapshotAnyRef = selectedSnapshot.snapshot();
        byte[] serializedSnapshot = (byte[])this.serialization.serialize(snapshotAnyRef).get();
        Serializer snapshotSerializer = this.serialization.findSerializerFor(snapshotAnyRef);
        String snapshotManifest = Serializers$.MODULE$.manifestFor(snapshotSerializer, snapshotAnyRef);
        Option serializedMeta = snapshotMetadata.metadata().map((Function1 & Serializable)meta -> {
            Object metaRef = meta;
            byte[] serializedMeta = (byte[])this.serialization.serialize(metaRef).get();
            Serializer metaSerializer = this.serialization.findSerializerFor(metaRef);
            String metaManifest = Serializers$.MODULE$.manifestFor(metaSerializer, metaRef);
            return SnapshotDao.SerializedSnapshotMetadata$.MODULE$.apply(serializedMeta, metaSerializer.identifier(), metaManifest);
        });
        SnapshotDao.SerializedSnapshotRow serializedRow = SnapshotDao.SerializedSnapshotRow$.MODULE$.apply(snapshotMetadata.persistenceId(), snapshotMetadata.sequenceNr(), snapshotMetadata.timestamp(), serializedSnapshot, snapshotSerializer.identifier(), snapshotManifest, serializedMeta);
        return serializedRow;
    }

    private Future<Option<SelectedSnapshot>> loadSourceSnapshot(String persistenceId, long minSequenceNr) {
        String string = this.sourceSnapshotPluginId;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Future$.MODULE$.successful((Object)None$.MODULE$);
        }
        Timeout timeout = Timeout$.MODULE$.durationToTimeout(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        SnapshotSelectionCriteria criteria = SnapshotSelectionCriteria$.MODULE$.Latest();
        ActorRef actorRef = org.apache.pekko.pattern.package$.MODULE$.ask(this.sourceSnapshotStore());
        SnapshotProtocol.LoadSnapshot loadSnapshot = SnapshotProtocol.LoadSnapshot$.MODULE$.apply(persistenceId, criteria, Long.MAX_VALUE);
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)loadSnapshot, timeout, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)loadSnapshot)).mapTo(ClassTag$.MODULE$.apply(SnapshotProtocol.LoadSnapshotResult.class)).map((Function1 & Serializable)result -> result.snapshot().flatMap((Function1 & Serializable)s -> {
            if (s.metadata().sequenceNr() >= minSequenceNr) {
                return Some$.MODULE$.apply(s);
            }
            return None$.MODULE$;
        }), (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
    }

    private static final /* synthetic */ Tuple2 $anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String persistenceId$4, long eventCount$1, int snapshotCount) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)persistenceId$4);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)MigrationTool$Result$.MODULE$.apply(1L, eventCount$1, Int$.MODULE$.int2long(snapshotCount)));
    }

    private final /* synthetic */ Future $anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String persistenceId$3, Option currentProgress$1, long eventCount) {
        return this.migrateSnapshot(persistenceId$3, (Option<MigrationToolDao.CurrentProgress>)currentProgress$1).map((Function1 & Serializable)snapshotCount -> MigrationTool.$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(persistenceId$3, eventCount, BoxesRunTime.unboxToInt((Object)snapshotCount)), (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
    }

    private static final long $anonfun$5() {
        return 0L;
    }

    private static final long $anonfun$8() {
        return 0L;
    }

    private final /* synthetic */ Future migrateSnapshot$$anonfun$2$$anonfun$2(String persistenceId$11, long seqNr) {
        return this.migrationDao().updateSnapshotProgress(persistenceId$11, seqNr).map((Function1 & Serializable)x$1 -> {
            Done done = x$1;
            return 1;
        }, (ExecutionContext)this.org$apache$pekko$persistence$r2dbc$migration$MigrationTool$$system.executionContext());
    }

    public static final class Result
    implements Product,
    Serializable {
        private final long persistenceIds;
        private final long events;
        private final long snapshots;

        public static Result apply(long l, long l2, long l3) {
            return MigrationTool$Result$.MODULE$.apply(l, l2, l3);
        }

        public static Result empty() {
            return MigrationTool$Result$.MODULE$.empty();
        }

        public static Result fromProduct(Product product) {
            return MigrationTool$Result$.MODULE$.fromProduct(product);
        }

        public static Result unapply(Result result) {
            return MigrationTool$Result$.MODULE$.unapply(result);
        }

        public Result(long persistenceIds, long events, long snapshots) {
            this.persistenceIds = persistenceIds;
            this.events = events;
            this.snapshots = snapshots;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.persistenceIds()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.events()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.snapshots()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Result)) return false;
            Result result = (Result)object;
            if (this.persistenceIds() != result.persistenceIds()) return false;
            if (this.events() != result.events()) return false;
            if (this.snapshots() != result.snapshots()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Result;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Result";
        }

        public Object productElement(int n) {
            long l;
            int n2 = n;
            switch (n2) {
                case 0: {
                    l = this._1();
                    break;
                }
                case 1: {
                    l = this._2();
                    break;
                }
                case 2: {
                    l = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return BoxesRunTime.boxToLong((long)l);
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "persistenceIds";
                }
                case 1: {
                    return "events";
                }
                case 2: {
                    return "snapshots";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long persistenceIds() {
            return this.persistenceIds;
        }

        public long events() {
            return this.events;
        }

        public long snapshots() {
            return this.snapshots;
        }

        public Result copy(long persistenceIds, long events, long snapshots) {
            return new Result(persistenceIds, events, snapshots);
        }

        public long copy$default$1() {
            return this.persistenceIds();
        }

        public long copy$default$2() {
            return this.events();
        }

        public long copy$default$3() {
            return this.snapshots();
        }

        public long _1() {
            return this.persistenceIds();
        }

        public long _2() {
            return this.events();
        }

        public long _3() {
            return this.snapshots();
        }
    }
}

