/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.testkit;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import io.netty.channel.ChannelException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Deployer;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.RootActorPath$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.RemoteTransportException;
import org.apache.pekko.remote.testconductor.RoleName;
import org.apache.pekko.remote.testconductor.TestConductor$;
import org.apache.pekko.remote.testconductor.TestConductorExt;
import org.apache.pekko.remote.testkit.MultiNodeConfig;
import org.apache.pekko.remote.testkit.MultiNodeSpec$;
import org.apache.pekko.remote.testkit.MultiNodeSpec$Replacement$;
import org.apache.pekko.remote.testkit.MultiNodeSpecCallbacks;
import org.apache.pekko.testkit.DeadLettersFilter$;
import org.apache.pekko.testkit.EventFilter;
import org.apache.pekko.testkit.TestEvent;
import org.apache.pekko.testkit.TestKit;
import org.apache.pekko.testkit.TestKitUtils$;
import org.apache.pekko.testkit.package;
import org.apache.pekko.testkit.package$;
import org.apache.pekko.util.Timeout$;
import org.apache.pekko.util.ccompat.package;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public abstract class MultiNodeSpec
extends TestKit
implements MultiNodeSpecCallbacks {
    private final RoleName myself;
    private final Seq<RoleName> _roles;
    private final Function1<RoleName, Seq<String>> deployments;
    private final LoggingAdapter log;
    private TestConductorExt testConductor;
    private final InetSocketAddress controllerAddr;
    public final MultiNodeSpec$Replacement$ Replacement$lzy1;
    private final Seq<Replacement> replacements;
    private final Address myAddress;

    public static Config baseConfig() {
        return MultiNodeSpec$.MODULE$.baseConfig();
    }

    public static Config configureNextPortIfFixed(Config config) {
        return MultiNodeSpec$.MODULE$.configureNextPortIfFixed(config);
    }

    public static int maxNodes() {
        return MultiNodeSpec$.MODULE$.maxNodes();
    }

    public static Config nodeConfig() {
        return MultiNodeSpec$.MODULE$.nodeConfig();
    }

    public static Integer selfIndex() {
        return MultiNodeSpec$.MODULE$.selfIndex();
    }

    public static String selfName() {
        return MultiNodeSpec$.MODULE$.selfName();
    }

    public static int selfPort() {
        return MultiNodeSpec$.MODULE$.selfPort();
    }

    public static String serverName() {
        return MultiNodeSpec$.MODULE$.serverName();
    }

    public static int serverPort() {
        return MultiNodeSpec$.MODULE$.serverPort();
    }

    public static int tcpPort() {
        return MultiNodeSpec$.MODULE$.tcpPort();
    }

    public static Option<Object> udpPort() {
        return MultiNodeSpec$.MODULE$.udpPort();
    }

    public MultiNodeSpec(RoleName myself, ActorSystem _system, Seq<RoleName> _roles, Function1<RoleName, Seq<String>> deployments) {
        this.myself = myself;
        this._roles = _roles;
        this.deployments = deployments;
        super(_system);
        this.Replacement$lzy1 = new MultiNodeSpec$Replacement$(this);
        this.log = Logging$.MODULE$.apply(this.system(), (Object)this, _$8 -> _$8.getClass().getName());
        Predef$.MODULE$.require(this.initialParticipants() > 0, MultiNodeSpec::$init$$$anonfun$2);
        Predef$.MODULE$.require(this.initialParticipants() <= MultiNodeSpec$.MODULE$.maxNodes(), MultiNodeSpec::$init$$$anonfun$3);
        this.testConductor = null;
        this.controllerAddr = new InetSocketAddress(MultiNodeSpec$.MODULE$.serverName(), MultiNodeSpec$.MODULE$.serverPort());
        this.attachConductor((TestConductorExt)TestConductor$.MODULE$.apply(this.system()));
        this.replacements = (Seq)this.roles().map((Function1 & Serializable)r -> this.Replacement().apply(new StringBuilder(2).append("@").append(r.name()).append("@").toString(), (RoleName)r));
        this.injectDeployments(this.system(), myself);
        this.myAddress = ((ExtendedActorSystem)this.system()).provider().getDefaultAddress();
        this.log().info("Role [{}] started with address [{}]", (Object)myself.name(), (Object)this.myAddress());
    }

    public RoleName myself() {
        return this.myself;
    }

    public MultiNodeSpec(MultiNodeConfig config, Function1<Config, ActorSystem> actorSystemCreator) {
        this(config.myself(), (ActorSystem)actorSystemCreator.apply((Object)ConfigFactory.load((Config)config.config())), config.roles(), MultiNodeSpec.MultiNodeSpec$superArg$1(config, actorSystemCreator));
    }

    public MultiNodeSpec(MultiNodeConfig config) {
        this(config, MultiNodeSpec.MultiNodeSpec$superArg$2(config));
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public <T> AwaitHelper<T> awaitHelper(Awaitable<T> w) {
        return new AwaitHelper<T>(this, w);
    }

    @Override
    public final void multiNodeSpecBeforeAll() {
        this.atStartup();
    }

    @Override
    public final void multiNodeSpecAfterAll() {
        Integer n = MultiNodeSpec$.MODULE$.selfIndex();
        Integer n2 = BoxesRunTime.boxToInteger((int)0);
        if (!(n != null ? !((Object)n).equals(n2) : n2 != null)) {
            this.testConductor().removeNode(this.myself());
            this.within(this.testConductor().Settings().BarrierTimeout().duration(), (Function0 & Serializable)() -> {
                this.multiNodeSpecAfterAll$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }
        this.shutdown(this.system(), (Duration)this.shutdownTimeout(), this.shutdown$default$3());
        this.afterTermination();
    }

    public FiniteDuration shutdownTimeout() {
        return package.TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(15)).seconds()), this.system());
    }

    public boolean verifySystemShutdown() {
        return false;
    }

    public void atStartup() {
    }

    public void afterTermination() {
    }

    public Seq<RoleName> roles() {
        return this._roles;
    }

    public abstract int initialParticipants();

    public TestConductorExt testConductor() {
        return this.testConductor;
    }

    public void testConductor_$eq(TestConductorExt x$1) {
        this.testConductor = x$1;
    }

    public void runOn(Seq<RoleName> nodes, Function0<BoxedUnit> thunk) {
        if (this.isNode(nodes)) {
            thunk.apply$mcV$sp();
            return;
        }
    }

    public boolean isNode(Seq<RoleName> nodes) {
        return nodes.contains((Object)this.myself());
    }

    public void enterBarrier(Seq<String> name) {
        this.testConductor().enter(Timeout$.MODULE$.durationToTimeout(this.remainingOr(this.testConductor().Settings().BarrierTimeout().duration())), (Seq)name.to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$)));
    }

    public void enterBarrier(FiniteDuration max, Seq<String> name) {
        this.testConductor().enter(Timeout$.MODULE$.durationToTimeout(this.remainingOr(package.TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(max), this.system()))), (Seq)name.to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$)));
    }

    public ActorPath node(RoleName role) {
        return RootActorPath$.MODULE$.apply((Address)this.awaitHelper((Awaitable)this.testConductor().getAddressFor(role)).await(), RootActorPath$.MODULE$.$lessinit$greater$default$2());
    }

    public void muteDeadLetters(Seq<Class<?>> messageClasses, ActorSystem sys) {
        if (!sys.log().isDebugEnabled()) {
            if (messageClasses.isEmpty()) {
                MultiNodeSpec.mute$1(sys, Object.class);
                return;
            }
            messageClasses.foreach((Function1)(JProcedure1 & Serializable)clazz -> MultiNodeSpec.mute$1(sys, clazz));
            return;
        }
    }

    public ActorSystem muteDeadLetters$default$2(Seq<Class<?>> messageClasses) {
        return this.system();
    }

    public void attachConductor(TestConductorExt tc) {
        FiniteDuration timeout = tc.Settings().BarrierTimeout().duration();
        Integer n = MultiNodeSpec$.MODULE$.selfIndex();
        Integer n2 = BoxesRunTime.boxToInteger((int)0);
        Future startFuture = !(n != null ? !((Object)n).equals(n2) : n2 != null) ? tc.startController(this.initialParticipants(), this.myself(), this.controllerAddr) : tc.startClient(this.myself(), this.controllerAddr);
        try {
            Await$.MODULE$.result((Awaitable)startFuture, (Duration)timeout);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable x = throwable3 = (Throwable)option.get();
                throw new RuntimeException("failure while attaching new conductor", x);
            }
            throw throwable;
        }
        this.testConductor_$eq(tc);
    }

    private final MultiNodeSpec$Replacement$ Replacement() {
        return this.Replacement$lzy1;
    }

    public void injectDeployments(ActorSystem sys, RoleName role) {
        Deployer deployer = ((ExtendedActorSystem)sys).provider().deployer();
        ((IterableOnceOps)this.deployments.apply((Object)role)).foreach((Function1)(JProcedure1 & Serializable)str -> {
            String deployString = (String)this.replacements.foldLeft(str, (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Replacement replacement = (Replacement)tuple2._2();
                    String base = (String)tuple2._1();
                    if (replacement != null) {
                        String string;
                        Replacement replacement2 = this.Replacement().unapply(replacement);
                        String string2 = replacement2._1();
                        RoleName roleName = replacement2._2();
                        String tag = string2;
                        Replacement r = replacement;
                        int n = base.indexOf(tag);
                        if (-1 == n) {
                            return base;
                        }
                        try {
                            string = r.addr();
                        }
                        catch (Throwable throwable) {
                            Option option;
                            Throwable throwable2 = throwable;
                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                Throwable throwable3;
                                Throwable e = throwable3 = (Throwable)option.get();
                                String unresolved = new StringBuilder(31).append("pekko://unresolved-replacement-").append(r.role().name()).toString();
                                this.log().warning(new StringBuilder(9).append(unresolved).append(" due to: ").append(e.getMessage()).toString());
                                string = unresolved;
                            }
                            throw throwable;
                        }
                        String replaceWith = string;
                        return base.replace(tag, replaceWith);
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            package.JavaConverters$.MODULE$.MapHasAsScala((Map)ConfigFactory.parseString((String)deployString).root()).asScala().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    ConfigValue configValue = (ConfigValue)tuple2._2();
                    String key = string;
                    if (configValue instanceof ConfigObject) {
                        ConfigObject value = (ConfigObject)configValue;
                        deployer.parseConfig(key, value.toConfig()).foreach((Function1)(JProcedure1 & Serializable)d -> deployer.deploy(d));
                        return;
                    }
                    String key2 = string;
                    ConfigValue x = configValue;
                    throw new IllegalArgumentException(new StringBuilder(54).append("key ").append(key2).append(" must map to deployment section, not simple value ").append(x).toString());
                }
                throw new MatchError((Object)tuple2);
            });
        });
    }

    public Address myAddress() {
        return this.myAddress;
    }

    public ActorSystem startNewSystem() {
        Config config = ConfigFactory.parseString((String)new StringBuilder(47).append("pekko.remote.classic.netty.tcp{port=").append(this.myAddress().port().get()).append("\nhostname=").append(this.myAddress().host().get()).append("}").toString()).withFallback((ConfigMergeable)this.system().settings().config());
        ActorSystem sys = ActorSystem$.MODULE$.apply(this.system().name(), config);
        this.injectDeployments(sys, this.myself());
        this.attachConductor((TestConductorExt)TestConductor$.MODULE$.apply(sys));
        return sys;
    }

    private static Function1<RoleName, Seq<String>> MultiNodeSpec$superArg$1(MultiNodeConfig config, Function1<Config, ActorSystem> actorSystemCreator) {
        return (Function1 & Serializable)node -> config.deployments((RoleName)node);
    }

    private static Function1<Config, ActorSystem> MultiNodeSpec$superArg$2(MultiNodeConfig config2) {
        String name = TestKitUtils$.MODULE$.testNameFromCallStack(MultiNodeSpec.class, StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("")));
        return (Function1 & Serializable)config -> {
            ActorSystem actorSystem;
            try {
                actorSystem = ActorSystem$.MODULE$.apply(name, config);
            }
            catch (RemoteTransportException remoteTransportException) {
                actorSystem = ActorSystem$.MODULE$.apply(name, config);
            }
            catch (ChannelException channelException) {
                actorSystem = ActorSystem$.MODULE$.apply(name, config);
            }
            return actorSystem;
        };
    }

    private static final Object $init$$$anonfun$2() {
        return "initialParticipants must be a 'def' or early initializer, and it must be greater zero";
    }

    private static final Object $init$$$anonfun$3() {
        return "not enough nodes to run this test";
    }

    private final boolean p$1$1() {
        return ((IterableOnceOps)this.awaitHelper((Awaitable)this.testConductor().getNodes()).await()).forall((Function1 & Serializable)_$9 -> {
            RoleName roleName = _$9;
            RoleName roleName2 = this.myself();
            return !(roleName != null ? !((Object)roleName).equals(roleName2) : roleName2 != null);
        });
    }

    private final boolean multiNodeSpecAfterAll$$anonfun$1$$anonfun$1() {
        return this.p$1$1();
    }

    private final void multiNodeSpecAfterAll$$anonfun$1() {
        String string = new StringBuilder(20).append("Nodes not shutdown: ").append(this.awaitHelper((Awaitable)this.testConductor().getNodes()).await()).toString();
        Duration duration = this.awaitCond$default$2();
        Duration duration2 = this.awaitCond$default$3();
        this.awaitCond(this::multiNodeSpecAfterAll$$anonfun$1$$anonfun$1, duration, duration2, string);
    }

    private static final void mute$1(ActorSystem sys$1, Class clazz) {
        sys$1.eventStream().publish((Object)TestEvent.Mute$.MODULE$.apply((EventFilter)DeadLettersFilter$.MODULE$.apply(clazz, Integer.MAX_VALUE), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EventFilter[0])));
    }

    public class AwaitHelper<T> {
        private final Awaitable<T> w;
        private final /* synthetic */ MultiNodeSpec $outer;

        public AwaitHelper(MultiNodeSpec $outer, Awaitable<T> w) {
            this.w = w;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public T await() {
            return (T)Await$.MODULE$.result(this.w, (Duration)this.$outer.remainingOr(this.$outer.testConductor().Settings().QueryTimeout().duration()));
        }

        public final /* synthetic */ MultiNodeSpec org$apache$pekko$remote$testkit$MultiNodeSpec$AwaitHelper$$$outer() {
            return this.$outer;
        }
    }

    public class Replacement
    implements Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Replacement.class.getDeclaredField("addr$lzy1"));
        private final String tag;
        private final RoleName role;
        private volatile Object addr$lzy1;
        private final /* synthetic */ MultiNodeSpec $outer;

        public Replacement(MultiNodeSpec $outer, String tag, RoleName role) {
            this.tag = tag;
            this.role = role;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Replacement)) return false;
            if (((Replacement)object).org$apache$pekko$remote$testkit$MultiNodeSpec$Replacement$$$outer() != this.$outer) return false;
            Replacement replacement = (Replacement)object;
            String string = this.tag();
            String string2 = replacement.tag();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            RoleName roleName = this.role();
            RoleName roleName2 = replacement.role();
            if (roleName == null) {
                if (roleName2 != null) {
                    return false;
                }
            } else if (!((Object)roleName).equals(roleName2)) return false;
            if (!replacement.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Replacement;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Replacement";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "tag";
            }
            if (1 == n2) {
                return "role";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String tag() {
            return this.tag;
        }

        public RoleName role() {
            return this.role;
        }

        public String addr() {
            Object object = this.addr$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.addr$lzyINIT1();
        }

        private Object addr$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.addr$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = this.$outer.node(this.role()).address().toString();
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.addr$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public Replacement copy(String tag, RoleName role) {
            return new Replacement(this.$outer, tag, role);
        }

        public String copy$default$1() {
            return this.tag();
        }

        public RoleName copy$default$2() {
            return this.role();
        }

        public String _1() {
            return this.tag();
        }

        public RoleName _2() {
            return this.role();
        }

        public final /* synthetic */ MultiNodeSpec org$apache$pekko$remote$testkit$MultiNodeSpec$Replacement$$$outer() {
            return this.$outer;
        }
    }
}

