/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.testkit;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.net.InetAddress;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class MultiNodeSpec$
implements Serializable {
    private static final int maxNodes;
    private static final String selfName;
    private static final int tcpPort;
    private static final Option udpPort;
    private static final int selfPort;
    private static final String serverName;
    private static final int serverPort;
    private static final Integer selfIndex;
    private static final Config nodeConfig;
    private static final Config baseConfig;
    public static final MultiNodeSpec$ MODULE$;

    private MultiNodeSpec$() {
    }

    static {
        String string;
        MODULE$ = new MultiNodeSpec$();
        maxNodes = Predef$.MODULE$.Integer2int((Integer)Option$.MODULE$.apply((Object)Integer.getInteger("multinode.max-nodes")).getOrElse(MODULE$::$init$$$anonfun$5));
        Predef$.MODULE$.require(MODULE$.maxNodes() > 0, MODULE$::$init$$$anonfun$6);
        Option option = Option$.MODULE$.apply((Object)System.getProperty("multinode.host"));
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("need system property multinode.host to be set");
        }
        if (option instanceof Some) {
            String host;
            String string2 = (String)((Some)option).value();
            string = "".equals(string2) ? InetAddress.getLocalHost().getHostAddress() : (host = string2);
        } else {
            throw new MatchError((Object)option);
        }
        selfName = string;
        String string3 = MODULE$.selfName();
        String string4 = "";
        Predef$.MODULE$.require(string3 == null ? string4 != null : !string3.equals(string4), MODULE$::$init$$$anonfun$7);
        tcpPort = Predef$.MODULE$.Integer2int(Integer.getInteger("multinode.port", 0));
        Predef$.MODULE$.require(MODULE$.tcpPort() >= 0 && MODULE$.tcpPort() < 65535, MODULE$::$init$$$anonfun$8);
        udpPort = Option$.MODULE$.apply((Object)System.getProperty("multinode.udp.port")).map((Function1 & Serializable)_$7 -> Predef$.MODULE$.Integer2int(Integer.getInteger("multinode.udp.port", 0)));
        Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)MODULE$.udpPort().getOrElse(MODULE$::$init$$$anonfun$10)) >= 0 && BoxesRunTime.unboxToInt((Object)MODULE$.udpPort().getOrElse(MODULE$::$init$$$anonfun$11)) < 65535, MODULE$::$init$$$anonfun$12);
        String string5 = System.getProperty("multinode.protocol");
        selfPort = "udp".equals(string5) ? BoxesRunTime.unboxToInt((Object)MODULE$.udpPort().getOrElse(MODULE$::$init$$$anonfun$13)) : MODULE$.tcpPort();
        serverName = (String)Option$.MODULE$.apply((Object)System.getProperty("multinode.server-host")).getOrElse(MODULE$::$init$$$anonfun$14);
        String string6 = MODULE$.serverName();
        String string7 = "";
        Predef$.MODULE$.require(string6 == null ? string7 != null : !string6.equals(string7), MODULE$::$init$$$anonfun$15);
        serverPort = Predef$.MODULE$.Integer2int(Integer.getInteger("multinode.server-port", 4711));
        Predef$.MODULE$.require(MODULE$.serverPort() > 0 && MODULE$.serverPort() < 65535, MODULE$::$init$$$anonfun$16);
        selfIndex = (Integer)Option$.MODULE$.apply((Object)Integer.getInteger("multinode.index")).getOrElse(MODULE$::$init$$$anonfun$17);
        Predef$.MODULE$.require(Predef$.MODULE$.Integer2int(MODULE$.selfIndex()) >= 0 && Predef$.MODULE$.Integer2int(MODULE$.selfIndex()) < MODULE$.maxNodes(), MODULE$::$init$$$anonfun$18);
        Object[] objectArray = new Tuple2[5];
        String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"pekko.actor.provider");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)"remote");
        String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"pekko.remote.artery.canonical.hostname");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)MODULE$.selfName());
        String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)"pekko.remote.classic.netty.tcp.hostname");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (Object)MODULE$.selfName());
        String string11 = (String)Predef$.MODULE$.ArrowAssoc((Object)"pekko.remote.classic.netty.tcp.port");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string11, (Object)BoxesRunTime.boxToInteger((int)MODULE$.tcpPort()));
        String string12 = (String)Predef$.MODULE$.ArrowAssoc((Object)"pekko.remote.artery.canonical.port");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string12, (Object)BoxesRunTime.boxToInteger((int)MODULE$.selfPort()));
        nodeConfig = MODULE$.mapToConfig((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        baseConfig = ConfigFactory.parseString((String)"\n      pekko {\n        loggers = [\"org.apache.pekko.testkit.TestEventListener\"]\n        loglevel = \"WARNING\"\n        stdout-loglevel = \"WARNING\"\n        coordinated-shutdown.terminate-actor-system = off\n        coordinated-shutdown.run-by-actor-system-terminate = off\n        coordinated-shutdown.run-by-jvm-shutdown-hook = off\n        actor {\n          default-dispatcher {\n            executor = \"fork-join-executor\"\n            fork-join-executor {\n              parallelism-min = 8\n              parallelism-factor = 2.0\n              parallelism-max = 8\n            }\n          }\n        }\n      }\n      ");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MultiNodeSpec$.class);
    }

    public int maxNodes() {
        return maxNodes;
    }

    public String selfName() {
        return selfName;
    }

    public int tcpPort() {
        return tcpPort;
    }

    public Option<Object> udpPort() {
        return udpPort;
    }

    public int selfPort() {
        return selfPort;
    }

    public String serverName() {
        return serverName;
    }

    public int serverPort() {
        return serverPort;
    }

    public Integer selfIndex() {
        return selfIndex;
    }

    public Config nodeConfig() {
        return nodeConfig;
    }

    public Config baseConfig() {
        return baseConfig;
    }

    private Config mapToConfig(Map<String, Object> map) {
        return ConfigFactory.parseMap((java.util.Map)package.JavaConverters$.MODULE$.MapHasAsJava(map).asJava());
    }

    public Config configureNextPortIfFixed(Config config) {
        String arteryPortConfig = this.getNextPortString("pekko.remote.artery.canonical.port", config);
        String nettyPortConfig = this.getNextPortString("pekko.remote.classic.netty.tcp.port", config);
        return ConfigFactory.parseString((String)new StringBuilder(23).append("{\n      ").append(arteryPortConfig).append("\n      ").append(nettyPortConfig).append("\n      }").toString()).withFallback((ConfigMergeable)config);
    }

    private String getNextPortString(String key, Config config) {
        int port = config.getInt(key);
        if (port != 0) {
            return new StringBuilder(3).append(key).append(" = ").append(port + 1).toString();
        }
        return "";
    }

    private final Integer $init$$$anonfun$5() {
        throw new IllegalStateException("need system property multinode.max-nodes to be set");
    }

    private final Object $init$$$anonfun$6() {
        return "multinode.max-nodes must be greater than 0";
    }

    private final Object $init$$$anonfun$7() {
        return "multinode.host must not be empty";
    }

    private final Object $init$$$anonfun$8() {
        return new StringBuilder(33).append("multinode.port is out of bounds: ").append(this.tcpPort()).toString();
    }

    private final int $init$$$anonfun$10() {
        return 1;
    }

    private final int $init$$$anonfun$11() {
        return 1;
    }

    private final Object $init$$$anonfun$12() {
        return new StringBuilder(37).append("multinode.udp.port is out of bounds: ").append(this.udpPort()).toString();
    }

    private final int $init$$$anonfun$13() {
        return 0;
    }

    private final String $init$$$anonfun$14() {
        throw new IllegalStateException("need system property multinode.server-host to be set");
    }

    private final Object $init$$$anonfun$15() {
        return "multinode.server-host must not be empty";
    }

    private final Object $init$$$anonfun$16() {
        return new StringBuilder(40).append("multinode.server-port is out of bounds: ").append(this.serverPort()).toString();
    }

    private final Integer $init$$$anonfun$17() {
        throw new IllegalStateException("need system property multinode.index to be set");
    }

    private final Object $init$$$anonfun$18() {
        return new StringBuilder(34).append("multinode.index is out of bounds: ").append(this.selfIndex()).toString();
    }
}

