/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.testconductor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.PoisonPill$;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.testconductor.Client$;
import org.apache.pekko.remote.testconductor.ClientFSM;
import org.apache.pekko.remote.testconductor.ClientFSM$Connected$;
import org.apache.pekko.remote.testconductor.ClientFSM$ConnectionFailure$;
import org.apache.pekko.remote.testconductor.NetworkOp;
import org.apache.pekko.remote.testconductor.RemoteConnection;
import org.apache.pekko.remote.testconductor.RemoteConnection$;
import scala.Function0;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ChannelHandler.Sharable
public class PlayerHandler
extends ChannelInboundHandlerAdapter {
    private final InetSocketAddress server;
    private int reconnects;
    private final FiniteDuration backoff;
    private final int poolSize;
    private final ActorRef fsm;
    private final LoggingAdapter log;
    private final Scheduler scheduler;
    private final ExecutionContext executor;
    private final AtomicReference connectionRef;
    private Deadline nextAttempt;

    public PlayerHandler(InetSocketAddress server, int reconnects, FiniteDuration backoff, int poolSize, ActorRef fsm, LoggingAdapter log, Scheduler scheduler, ExecutionContext executor) {
        this.server = server;
        this.reconnects = reconnects;
        this.backoff = backoff;
        this.poolSize = poolSize;
        this.fsm = fsm;
        this.log = log;
        this.scheduler = scheduler;
        this.executor = executor;
        this.connectionRef = new AtomicReference();
        this.tryConnectToController();
    }

    private int reconnects() {
        return this.reconnects;
    }

    private void reconnects_$eq(int x$0) {
        this.reconnects = x$0;
    }

    public AtomicReference<RemoteConnection> connectionRef() {
        return this.connectionRef;
    }

    public Deadline nextAttempt() {
        return this.nextAttempt;
    }

    public void nextAttempt_$eq(Deadline x$1) {
        this.nextAttempt = x$1;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.log.error("channel {} exception {}", (Object)ctx.channel(), (Object)cause);
        Throwable throwable = cause;
        if (throwable instanceof ConnectException && this.reconnects() > 0) {
            this.reconnects_$eq(this.reconnects() - 1);
            this.scheduleReconnect();
            return;
        }
        Throwable e = throwable;
        ClientFSM.ConnectionFailure connectionFailure = ClientFSM$ConnectionFailure$.MODULE$.apply(e.getMessage());
        this.fsm.$bang((Object)connectionFailure, this.fsm.$bang$default$2((Object)connectionFailure));
    }

    private void tryConnectToController() {
        Try try_ = Try$.MODULE$.apply(this::tryConnectToController$$anonfun$1);
        if (try_ instanceof Success) {
            RemoteConnection r = (RemoteConnection)((Success)try_).value();
            this.connectionRef().set(r);
            return;
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            this.log.error("Error when trying to connect to remote addr:[{}] will retry, time left:[{}], cause:[{}].", (Object)this.server, (Object)this.nextAttempt().timeLeft(), (Object)ex.getMessage());
            this.scheduleReconnect();
            return;
        }
        throw new MatchError((Object)try_);
    }

    private void scheduleReconnect() {
        this.scheduler.scheduleOnce(this.nextAttempt().timeLeft(), (Function0 & Serializable)() -> {
            this.scheduleReconnect$$anonfun$1();
            return BoxedUnit.UNIT;
        }, this.executor);
    }

    private RemoteConnection reconnect() {
        this.nextAttempt_$eq(Deadline$.MODULE$.now().$plus(this.backoff));
        return RemoteConnection$.MODULE$.apply(Client$.MODULE$, this.server, this.poolSize, (ChannelInboundHandler)this);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        Channel ch = ctx.channel();
        this.log.debug("connected to {}", (Object)RemoteConnection$.MODULE$.getAddrString(ch));
        ClientFSM.Connected connected = ClientFSM$Connected$.MODULE$.apply(ch);
        this.fsm.$bang((Object)connected, this.fsm.$bang$default$2((Object)connected));
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        this.log.debug("disconnected from {}", (Object)RemoteConnection$.MODULE$.getAddrString(channel));
        this.fsm.$bang((Object)PoisonPill$.MODULE$, this.fsm.$bang$default$2((Object)PoisonPill$.MODULE$));
        this.executor.execute(() -> this.connectionRef().get().shutdown());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Channel channel = ctx.channel();
        this.log.debug("message from {}: {}", (Object)RemoteConnection$.MODULE$.getAddrString(channel), msg);
        Object object = msg;
        if (object instanceof NetworkOp) {
            NetworkOp msg2 = (NetworkOp)object;
            this.fsm.$bang((Object)msg2, this.fsm.$bang$default$2((Object)msg2));
            return;
        }
        Object msg3 = object;
        this.log.info("server {} sent garbage '{}', disconnecting", (Object)RemoteConnection$.MODULE$.getAddrString(channel), msg3);
        channel.close();
    }

    private final RemoteConnection tryConnectToController$$anonfun$1() {
        return this.reconnect();
    }

    private final void scheduleReconnect$$anonfun$1() {
        this.tryConnectToController();
    }
}

