/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.testconductor;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.io.Serializable;
import java.util.List;
import org.apache.pekko.actor.Address;
import org.apache.pekko.remote.testconductor.AddressReply;
import org.apache.pekko.remote.testconductor.AddressReply$;
import org.apache.pekko.remote.testconductor.BarrierResult;
import org.apache.pekko.remote.testconductor.BarrierResult$;
import org.apache.pekko.remote.testconductor.DisconnectMsg;
import org.apache.pekko.remote.testconductor.DisconnectMsg$;
import org.apache.pekko.remote.testconductor.Done;
import org.apache.pekko.remote.testconductor.EnterBarrier;
import org.apache.pekko.remote.testconductor.EnterBarrier$;
import org.apache.pekko.remote.testconductor.FailBarrier;
import org.apache.pekko.remote.testconductor.FailBarrier$;
import org.apache.pekko.remote.testconductor.GetAddress;
import org.apache.pekko.remote.testconductor.GetAddress$;
import org.apache.pekko.remote.testconductor.Hello;
import org.apache.pekko.remote.testconductor.Hello$;
import org.apache.pekko.remote.testconductor.NetworkOp;
import org.apache.pekko.remote.testconductor.RoleName;
import org.apache.pekko.remote.testconductor.TerminateMsg;
import org.apache.pekko.remote.testconductor.TerminateMsg$;
import org.apache.pekko.remote.testconductor.TestConductorProtocol;
import org.apache.pekko.remote.testconductor.ThrottleMsg;
import org.apache.pekko.remote.testconductor.ThrottleMsg$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class MsgEncoder
extends MessageToMessageEncoder<Object> {
    public TestConductorProtocol.Address address2proto(Address addr) {
        return TestConductorProtocol.Address.newBuilder().setProtocol(addr.protocol()).setSystem(addr.system()).setHost((String)addr.host().get()).setPort(BoxesRunTime.unboxToInt((Object)addr.port().get())).build();
    }

    public TestConductorProtocol.Direction direction2proto(ThrottlerTransportAdapter.Direction dir) {
        ThrottlerTransportAdapter.Direction direction = dir;
        if (ThrottlerTransportAdapter.Direction$.Send$.MODULE$.equals(direction)) {
            return TestConductorProtocol.Direction.Send;
        }
        if (ThrottlerTransportAdapter.Direction$.Receive$.MODULE$.equals(direction)) {
            return TestConductorProtocol.Direction.Receive;
        }
        if (ThrottlerTransportAdapter.Direction$.Both$.MODULE$.equals(direction)) {
            return TestConductorProtocol.Direction.Both;
        }
        throw new MatchError((Object)direction);
    }

    public void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) {
        out.add(this.encode0(msg));
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object encode0(Object msg) {
        TestConductorProtocol.Wrapper.Builder builder;
        Object object = msg;
        if (!(object instanceof NetworkOp)) throw new IllegalArgumentException(new StringBuilder(14).append("wrong message ").append(msg).toString());
        NetworkOp x = (NetworkOp)object;
        TestConductorProtocol.Wrapper.Builder w = TestConductorProtocol.Wrapper.newBuilder();
        NetworkOp networkOp = x;
        if (networkOp instanceof Hello) {
            Hello hello = Hello$.MODULE$.unapply((Hello)networkOp);
            String string = hello._1();
            Address address = hello._2();
            String name = string;
            Address address2 = address;
            builder = w.setHello(TestConductorProtocol.Hello.newBuilder().setName(name).setAddress(this.address2proto(address2)));
            return w.build();
        }
        if (networkOp instanceof EnterBarrier) {
            EnterBarrier enterBarrier = EnterBarrier$.MODULE$.unapply((EnterBarrier)networkOp);
            String string = enterBarrier._1();
            Option<FiniteDuration> option = enterBarrier._2();
            String name = string;
            Option<FiniteDuration> timeout = option;
            TestConductorProtocol.EnterBarrier.Builder barrier = TestConductorProtocol.EnterBarrier.newBuilder().setName(name);
            timeout.foreach((Function1 & Serializable)t -> barrier.setTimeout(t.toNanos()));
            barrier.setOp(TestConductorProtocol.BarrierOp.Enter);
            builder = w.setBarrier(barrier);
            return w.build();
        }
        if (networkOp instanceof BarrierResult) {
            BarrierResult barrierResult = BarrierResult$.MODULE$.unapply((BarrierResult)networkOp);
            String string = barrierResult._1();
            boolean bl = barrierResult._2();
            String name = string;
            boolean success = bl;
            TestConductorProtocol.BarrierOp res = success ? TestConductorProtocol.BarrierOp.Succeeded : TestConductorProtocol.BarrierOp.Failed;
            builder = w.setBarrier(TestConductorProtocol.EnterBarrier.newBuilder().setName(name).setOp(res));
            return w.build();
        }
        if (networkOp instanceof FailBarrier) {
            String string;
            FailBarrier failBarrier = FailBarrier$.MODULE$.unapply((FailBarrier)networkOp);
            String name = string = failBarrier._1();
            builder = w.setBarrier(TestConductorProtocol.EnterBarrier.newBuilder().setName(name).setOp(TestConductorProtocol.BarrierOp.Fail));
            return w.build();
        }
        if (networkOp instanceof ThrottleMsg) {
            ThrottleMsg throttleMsg = ThrottleMsg$.MODULE$.unapply((ThrottleMsg)networkOp);
            Address address = throttleMsg._1();
            ThrottlerTransportAdapter.Direction direction = throttleMsg._2();
            float f = throttleMsg._3();
            Address target = address;
            ThrottlerTransportAdapter.Direction dir = direction;
            float rate = f;
            builder = w.setFailure(TestConductorProtocol.InjectFailure.newBuilder().setAddress(this.address2proto(target)).setFailure(TestConductorProtocol.FailType.Throttle).setDirection(this.direction2proto(dir)).setRateMBit(rate));
            return w.build();
        }
        if (networkOp instanceof DisconnectMsg) {
            DisconnectMsg disconnectMsg = DisconnectMsg$.MODULE$.unapply((DisconnectMsg)networkOp);
            Address address = disconnectMsg._1();
            boolean bl = disconnectMsg._2();
            Address target = address;
            boolean abort = bl;
            builder = w.setFailure(TestConductorProtocol.InjectFailure.newBuilder().setAddress(this.address2proto(target)).setFailure(abort ? TestConductorProtocol.FailType.Abort : TestConductorProtocol.FailType.Disconnect));
            return w.build();
        }
        if (networkOp instanceof TerminateMsg) {
            TerminateMsg terminateMsg = TerminateMsg$.MODULE$.unapply((TerminateMsg)networkOp);
            Either<Object, Object> either = terminateMsg._1();
            if (either instanceof Right) {
                int exitValue = BoxesRunTime.unboxToInt((Object)((Right)either).value());
                builder = w.setFailure(TestConductorProtocol.InjectFailure.newBuilder().setFailure(TestConductorProtocol.FailType.Exit).setExitValue(exitValue));
                return w.build();
            }
            if (either instanceof Left) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)((Left)either).value());
                if (!bl) {
                    builder = w.setFailure(TestConductorProtocol.InjectFailure.newBuilder().setFailure(TestConductorProtocol.FailType.Shutdown));
                    return w.build();
                }
                if (bl) {
                    builder = w.setFailure(TestConductorProtocol.InjectFailure.newBuilder().setFailure(TestConductorProtocol.FailType.ShutdownAbrupt));
                    return w.build();
                }
            }
        }
        if (networkOp instanceof GetAddress) {
            RoleName roleName;
            GetAddress getAddress = GetAddress$.MODULE$.unapply((GetAddress)networkOp);
            RoleName node = roleName = getAddress._1();
            builder = w.setAddr(TestConductorProtocol.AddressRequest.newBuilder().setNode(node.name()));
            return w.build();
        }
        if (networkOp instanceof AddressReply) {
            AddressReply addressReply = AddressReply$.MODULE$.unapply((AddressReply)networkOp);
            RoleName roleName = addressReply._1();
            Address address = addressReply._2();
            RoleName node = roleName;
            Address address3 = address;
            builder = w.setAddr(TestConductorProtocol.AddressRequest.newBuilder().setNode(node.name()).setAddr(this.address2proto(address3)));
            return w.build();
        }
        if (!(networkOp instanceof Done)) throw new MatchError((Object)networkOp);
        builder = w.setDone("");
        return w.build();
    }
}

