/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.testconductor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.remote.testconductor.Controller;
import org.apache.pekko.remote.testconductor.Controller$ClientDisconnected$;
import org.apache.pekko.remote.testconductor.Controller$CreateServerFSM$;
import org.apache.pekko.remote.testconductor.NetworkOp;
import org.apache.pekko.remote.testconductor.RemoteConnection$;
import org.apache.pekko.util.Timeout;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;

@ChannelHandler.Sharable
public class ConductorHandler
extends ChannelInboundHandlerAdapter {
    private final ActorRef controller;
    private final LoggingAdapter log;
    private final Timeout createTimeout;
    private final ConcurrentHashMap clients;

    public ConductorHandler(Timeout _createTimeout, ActorRef controller, LoggingAdapter log) {
        this.controller = controller;
        this.log = log;
        this.createTimeout = _createTimeout;
        this.clients = new ConcurrentHashMap();
    }

    public Timeout createTimeout() {
        return this.createTimeout;
    }

    public ConcurrentHashMap<Channel, ActorRef> clients() {
        return this.clients;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        this.log.debug("connection from {}", (Object)RemoteConnection$.MODULE$.getAddrString(channel));
        ActorRef actorRef = package$.MODULE$.ask(this.controller);
        Controller.CreateServerFSM createServerFSM = Controller$CreateServerFSM$.MODULE$.apply(channel);
        ActorRef fsm = (ActorRef)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)createServerFSM, this.createTimeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)createServerFSM)).mapTo(scala.reflect.package$.MODULE$.classTag(ClassTag$.MODULE$.apply(ActorRef.class))), (Duration)Duration$.MODULE$.Inf());
        this.clients().put(channel, fsm);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        this.log.debug("disconnect from {}", (Object)RemoteConnection$.MODULE$.getAddrString(channel));
        ActorRef fsm = this.clients().get(channel);
        Controller$ClientDisconnected$ controller$ClientDisconnected$ = Controller$ClientDisconnected$.MODULE$;
        fsm.$bang((Object)controller$ClientDisconnected$, fsm.$bang$default$2((Object)controller$ClientDisconnected$));
        this.clients().remove(channel);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Channel channel = ctx.channel();
        this.log.debug("message from {}: {}", (Object)RemoteConnection$.MODULE$.getAddrString(channel), msg);
        Object object = msg;
        if (object instanceof NetworkOp) {
            NetworkOp msg2 = (NetworkOp)object;
            ActorRef actorRef = this.clients().get(channel);
            actorRef.$bang((Object)msg2, actorRef.$bang$default$2((Object)msg2));
            return;
        }
        Object msg3 = object;
        this.log.info("client {} sent garbage '{}', disconnecting", (Object)RemoteConnection$.MODULE$.getAddrString(channel), msg3);
        channel.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.log.error("channel {} exception {}", (Object)ctx.channel(), (Object)cause);
        ctx.close();
    }
}

