/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.testconductor;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.remote.testconductor.Controller;
import org.apache.pekko.remote.testconductor.Controller$GetNodes$;
import org.apache.pekko.remote.testconductor.Controller$GetSockAddr$;
import org.apache.pekko.remote.testconductor.Disconnect;
import org.apache.pekko.remote.testconductor.Disconnect$;
import org.apache.pekko.remote.testconductor.Done;
import org.apache.pekko.remote.testconductor.Done$;
import org.apache.pekko.remote.testconductor.Remove;
import org.apache.pekko.remote.testconductor.Remove$;
import org.apache.pekko.remote.testconductor.RoleName;
import org.apache.pekko.remote.testconductor.Terminate;
import org.apache.pekko.remote.testconductor.Terminate$;
import org.apache.pekko.remote.testconductor.TestConductorExt;
import org.apache.pekko.remote.testconductor.Throttle;
import org.apache.pekko.remote.testconductor.Throttle$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public interface Conductor {
    public static void $init$(Conductor $this) {
    }

    public ActorRef org$apache$pekko$remote$testconductor$Conductor$$_controller();

    public void org$apache$pekko$remote$testconductor$Conductor$$_controller_$eq(ActorRef var1);

    private ActorRef controller() {
        ActorRef actorRef = this.org$apache$pekko$remote$testconductor$Conductor$$_controller();
        if (actorRef == null) {
            throw new IllegalStateException("TestConductorServer was not started");
        }
        ActorRef x = actorRef;
        return x;
    }

    public static Future startController$(Conductor $this, int participants, RoleName name, InetSocketAddress controllerPort) {
        return $this.startController(participants, name, controllerPort);
    }

    default public Future<InetSocketAddress> startController(int participants, RoleName name, InetSocketAddress controllerPort) {
        if (this.org$apache$pekko$remote$testconductor$Conductor$$_controller() != null) {
            throw new RuntimeException("TestConductorServer was already started");
        }
        this.org$apache$pekko$remote$testconductor$Conductor$$_controller_$eq(((TestConductorExt)this).system().systemActorOf(Props$.MODULE$.apply(Controller.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)participants), controllerPort})), "controller"));
        ActorRef actorRef = package$.MODULE$.ask(this.controller());
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)Controller$GetSockAddr$.MODULE$, ((TestConductorExt)this).Settings().BarrierTimeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)Controller$GetSockAddr$.MODULE$)).mapTo(ClassTag$.MODULE$.apply(InetSocketAddress.class)).flatMap((Function1 & Serializable)x$1 -> {
            InetSocketAddress inetSocketAddress = x$1;
            if (inetSocketAddress != null) {
                InetSocketAddress sockAddr = inetSocketAddress;
                return ((TestConductorExt)this).startClient(name, sockAddr).map((Function1 & Serializable)_$2 -> sockAddr, (ExecutionContext)((TestConductorExt)this).system().dispatcher());
            }
            throw new MatchError((Object)inetSocketAddress);
        }, (ExecutionContext)((TestConductorExt)this).system().dispatcher());
    }

    public static Future sockAddr$(Conductor $this) {
        return $this.sockAddr();
    }

    default public Future<InetSocketAddress> sockAddr() {
        ActorRef actorRef = package$.MODULE$.ask(this.controller());
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)Controller$GetSockAddr$.MODULE$, ((TestConductorExt)this).Settings().QueryTimeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)Controller$GetSockAddr$.MODULE$)).mapTo(scala.reflect.package$.MODULE$.classTag(ClassTag$.MODULE$.apply(InetSocketAddress.class)));
    }

    public static Future throttle$(Conductor $this, RoleName node, RoleName target, ThrottlerTransportAdapter.Direction direction, double rateMBit) {
        return $this.throttle(node, target, direction, rateMBit);
    }

    default public Future<Done> throttle(RoleName node, RoleName target, ThrottlerTransportAdapter.Direction direction, double rateMBit) {
        this.requireTestConductorTranport();
        ActorRef actorRef = package$.MODULE$.ask(this.controller());
        Throttle throttle = Throttle$.MODULE$.apply(node, target, direction, (float)rateMBit);
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)throttle, ((TestConductorExt)this).Settings().QueryTimeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)throttle)).mapTo(scala.reflect.package$.MODULE$.classTag(ClassTag$.MODULE$.apply(Done.class)));
    }

    public static Future blackhole$(Conductor $this, RoleName node, RoleName target, ThrottlerTransportAdapter.Direction direction) {
        return $this.blackhole(node, target, direction);
    }

    default public Future<Done> blackhole(RoleName node, RoleName target, ThrottlerTransportAdapter.Direction direction) {
        return this.throttle(node, target, direction, 0.0);
    }

    private void requireTestConductorTranport() {
        if (((TestConductorExt)this).transport().provider().remoteSettings().Artery().Enabled()) {
            if (!((TestConductorExt)this).transport().provider().remoteSettings().Artery().Advanced().TestMode()) {
                throw new ConfigurationException("To use this feature you must activate the test mode by specifying `testTransport(on = true)` in your MultiNodeConfig.");
            }
            return;
        }
        if (!((TestConductorExt)this).transport().defaultAddress().protocol().contains(".trttl.gremlin.")) {
            throw new ConfigurationException("To use this feature you must activate the failure injector adapters (trttl, gremlin) by specifying `testTransport(on = true)` in your MultiNodeConfig.");
        }
    }

    public static Future passThrough$(Conductor $this, RoleName node, RoleName target, ThrottlerTransportAdapter.Direction direction) {
        return $this.passThrough(node, target, direction);
    }

    default public Future<Done> passThrough(RoleName node, RoleName target, ThrottlerTransportAdapter.Direction direction) {
        return this.throttle(node, target, direction, -1.0);
    }

    public static Future disconnect$(Conductor $this, RoleName node, RoleName target) {
        return $this.disconnect(node, target);
    }

    default public Future<Done> disconnect(RoleName node, RoleName target) {
        ActorRef actorRef = package$.MODULE$.ask(this.controller());
        Disconnect disconnect = Disconnect$.MODULE$.apply(node, target, false);
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)disconnect, ((TestConductorExt)this).Settings().QueryTimeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)disconnect)).mapTo(scala.reflect.package$.MODULE$.classTag(ClassTag$.MODULE$.apply(Done.class)));
    }

    public static Future abort$(Conductor $this, RoleName node, RoleName target) {
        return $this.abort(node, target);
    }

    default public Future<Done> abort(RoleName node, RoleName target) {
        ActorRef actorRef = package$.MODULE$.ask(this.controller());
        Disconnect disconnect = Disconnect$.MODULE$.apply(node, target, true);
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)disconnect, ((TestConductorExt)this).Settings().QueryTimeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)disconnect)).mapTo(scala.reflect.package$.MODULE$.classTag(ClassTag$.MODULE$.apply(Done.class)));
    }

    public static Future exit$(Conductor $this, RoleName node, int exitValue) {
        return $this.exit(node, exitValue);
    }

    default public Future<Done> exit(RoleName node, int exitValue) {
        ActorRef actorRef = package$.MODULE$.ask(this.controller());
        Terminate terminate = Terminate$.MODULE$.apply(node, (Either<Object, Object>)scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)exitValue)));
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)terminate, ((TestConductorExt)this).Settings().QueryTimeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)terminate)).mapTo(scala.reflect.package$.MODULE$.classTag(ClassTag$.MODULE$.apply(Done.class))).recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof Controller.ClientDisconnectedException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof Controller.ClientDisconnectedException) {
                    return Done$.MODULE$;
                }
                return function1.apply((Object)x);
            }
        }, (ExecutionContext)((TestConductorExt)this).system().dispatcher());
    }

    public static Future shutdown$(Conductor $this, RoleName node) {
        return $this.shutdown(node);
    }

    default public Future<Done> shutdown(RoleName node) {
        return this.shutdown(node, false);
    }

    public static Future shutdown$(Conductor $this, RoleName node, boolean abort) {
        return $this.shutdown(node, abort);
    }

    default public Future<Done> shutdown(RoleName node, boolean abort) {
        ActorRef actorRef = package$.MODULE$.ask(this.controller());
        Terminate terminate = Terminate$.MODULE$.apply(node, (Either<Object, Object>)scala.package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToBoolean((boolean)abort)));
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)terminate, ((TestConductorExt)this).Settings().QueryTimeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)terminate)).mapTo(scala.reflect.package$.MODULE$.classTag(ClassTag$.MODULE$.apply(Done.class))).recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof Controller.ClientDisconnectedException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof Controller.ClientDisconnectedException) {
                    return Done$.MODULE$;
                }
                return function1.apply((Object)x);
            }
        }, (ExecutionContext)((TestConductorExt)this).system().dispatcher());
    }

    public static Future getNodes$(Conductor $this) {
        return $this.getNodes();
    }

    default public Future<Iterable<RoleName>> getNodes() {
        ActorRef actorRef = package$.MODULE$.ask(this.controller());
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)Controller$GetNodes$.MODULE$, ((TestConductorExt)this).Settings().QueryTimeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)Controller$GetNodes$.MODULE$)).mapTo(scala.reflect.package$.MODULE$.classTag(ClassTag$.MODULE$.apply(Iterable.class)));
    }

    public static Future removeNode$(Conductor $this, RoleName node) {
        return $this.removeNode(node);
    }

    default public Future<Done> removeNode(RoleName node) {
        ActorRef actorRef = package$.MODULE$.ask(this.controller());
        Remove remove = Remove$.MODULE$.apply(node);
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)remove, ((TestConductorExt)this).Settings().QueryTimeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)remove)).mapTo(scala.reflect.package$.MODULE$.classTag(ClassTag$.MODULE$.apply(Done.class)));
    }
}

