/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.connectors.spring.web;

import java.util.Objects;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.stream.connectors.spring.web.PekkoStreamsRegistrar;
import org.apache.pekko.stream.connectors.spring.web.SpringWebPekkoStreamsProperties;
import org.apache.pekko.stream.javadsl.Source;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ReactiveAdapterRegistry;

@Configuration
@ConditionalOnClass(value={Source.class})
@EnableConfigurationProperties(value={SpringWebPekkoStreamsProperties.class})
public class SpringWebPekkoStreamsConfiguration {
    private static final String DEFAULT_FACTORY_SYSTEM_NAME = "Pekko SpringWebPekkoStreamsSystem";
    private final ActorSystem system;
    private final SpringWebPekkoStreamsProperties properties;

    public SpringWebPekkoStreamsConfiguration(SpringWebPekkoStreamsProperties springWebPekkoStreamsProperties) {
        this.properties = springWebPekkoStreamsProperties;
        ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
        this.system = ActorSystem.create((String)this.getActorSystemName(springWebPekkoStreamsProperties));
        new PekkoStreamsRegistrar((ClassicActorSystemProvider)this.system).registerAdapters(reactiveAdapterRegistry);
    }

    @Bean
    @ConditionalOnMissingBean(value={ActorSystem.class})
    public ActorSystem getActorSystem() {
        return this.system;
    }

    public SpringWebPekkoStreamsProperties getProperties() {
        return this.properties;
    }

    private String getActorSystemName(SpringWebPekkoStreamsProperties springWebPekkoStreamsProperties) {
        Objects.requireNonNull(springWebPekkoStreamsProperties, String.format("%s is not present in application context", SpringWebPekkoStreamsProperties.class.getSimpleName()));
        if (this.isBlank(springWebPekkoStreamsProperties.getActorSystemName())) {
            return DEFAULT_FACTORY_SYSTEM_NAME;
        }
        return springWebPekkoStreamsProperties.getActorSystemName();
    }

    private boolean isBlank(String string) {
        return string == null || string.isEmpty();
    }
}

