/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.connectors.ironmq;

import com.typesafe.config.Config;
import java.time.Duration;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.stream.connectors.ironmq.IronMqSettings$;
import org.apache.pekko.stream.connectors.ironmq.IronMqSettings$ConsumerSettings$;
import org.apache.pekko.util.JavaDurationConverters;
import org.apache.pekko.util.JavaDurationConverters$;
import scala.concurrent.duration.FiniteDuration;

public final class IronMqSettings {
    private final Uri endpoint;
    private final String projectId;
    private final String token;
    private final ConsumerSettings consumerSettings;

    public static String ConfigPath() {
        return IronMqSettings$.MODULE$.ConfigPath();
    }

    public static IronMqSettings apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return IronMqSettings$.MODULE$.apply(classicActorSystemProvider);
    }

    public static IronMqSettings apply(Config config) {
        return IronMqSettings$.MODULE$.apply(config);
    }

    public static IronMqSettings create(ActorSystem actorSystem) {
        return IronMqSettings$.MODULE$.create(actorSystem);
    }

    public static IronMqSettings create(ClassicActorSystemProvider classicActorSystemProvider) {
        return IronMqSettings$.MODULE$.create(classicActorSystemProvider);
    }

    public static IronMqSettings create(Config config) {
        return IronMqSettings$.MODULE$.create(config);
    }

    public IronMqSettings(Uri endpoint, String projectId, String token, ConsumerSettings consumerSettings) {
        this.endpoint = endpoint;
        this.projectId = projectId;
        this.token = token;
        this.consumerSettings = consumerSettings;
    }

    public Uri endpoint() {
        return this.endpoint;
    }

    public String projectId() {
        return this.projectId;
    }

    public String token() {
        return this.token;
    }

    public ConsumerSettings consumerSettings() {
        return this.consumerSettings;
    }

    public IronMqSettings withEndpoint(Uri value) {
        return this.copy(value, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public IronMqSettings withProjectId(String value) {
        return this.copy(this.copy$default$1(), value, this.copy$default$3(), this.copy$default$4());
    }

    public IronMqSettings withToken(String value) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), value, this.copy$default$4());
    }

    public IronMqSettings withConsumerSettings(ConsumerSettings value) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), value);
    }

    private IronMqSettings copy(Uri endpoint, String projectId, String token, ConsumerSettings consumerSettings) {
        return new IronMqSettings(endpoint, projectId, token, consumerSettings);
    }

    private Uri copy$default$1() {
        return this.endpoint();
    }

    private String copy$default$2() {
        return this.projectId();
    }

    private String copy$default$3() {
        return this.token();
    }

    private ConsumerSettings copy$default$4() {
        return this.consumerSettings();
    }

    public String toString() {
        return new StringBuilder(16).append("IronMqSettings(").append(new StringBuilder(10).append("endpoint=").append(this.endpoint()).append(",").toString()).append(new StringBuilder(11).append("projectId=").append(this.projectId()).append(",").toString()).append(new StringBuilder(7).append("token=").append(this.token()).append(",").toString()).append(new StringBuilder(17).append("consumerSettings=").append(this.consumerSettings()).toString()).append(")").toString();
    }

    public static final class ConsumerSettings {
        private final int bufferMinSize;
        private final int bufferMaxSize;
        private final FiniteDuration fetchInterval;
        private final FiniteDuration pollTimeout;
        private final FiniteDuration reservationTimeout;

        public static ConsumerSettings apply(Config config) {
            return IronMqSettings$ConsumerSettings$.MODULE$.apply(config);
        }

        public ConsumerSettings(int bufferMinSize, int bufferMaxSize, FiniteDuration fetchInterval, FiniteDuration pollTimeout, FiniteDuration reservationTimeout) {
            this.bufferMinSize = bufferMinSize;
            this.bufferMaxSize = bufferMaxSize;
            this.fetchInterval = fetchInterval;
            this.pollTimeout = pollTimeout;
            this.reservationTimeout = reservationTimeout;
        }

        public int bufferMinSize() {
            return this.bufferMinSize;
        }

        public int bufferMaxSize() {
            return this.bufferMaxSize;
        }

        public FiniteDuration fetchInterval() {
            return this.fetchInterval;
        }

        public FiniteDuration pollTimeout() {
            return this.pollTimeout;
        }

        public FiniteDuration reservationTimeout() {
            return this.reservationTimeout;
        }

        public ConsumerSettings withBufferMinSize(int value) {
            return this.copy(value, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public ConsumerSettings withBufferMaxSize(int value) {
            return this.copy(this.copy$default$1(), value, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public ConsumerSettings withFetchInterval(FiniteDuration value) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), value, this.copy$default$4(), this.copy$default$5());
        }

        public ConsumerSettings withFetchInterval(Duration value) {
            FiniteDuration finiteDuration = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(value));
            int n = this.copy$default$1();
            int n2 = this.copy$default$2();
            FiniteDuration finiteDuration2 = this.copy$default$4();
            FiniteDuration finiteDuration3 = this.copy$default$5();
            return this.copy(n, n2, finiteDuration, finiteDuration2, finiteDuration3);
        }

        public ConsumerSettings withPollTimeout(FiniteDuration value) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), value, this.copy$default$5());
        }

        public ConsumerSettings withPollTimeout(Duration value) {
            FiniteDuration finiteDuration = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(value));
            int n = this.copy$default$1();
            int n2 = this.copy$default$2();
            FiniteDuration finiteDuration2 = this.copy$default$3();
            FiniteDuration finiteDuration3 = this.copy$default$5();
            return this.copy(n, n2, finiteDuration2, finiteDuration, finiteDuration3);
        }

        public ConsumerSettings withReservationTimeout(FiniteDuration value) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), value);
        }

        public ConsumerSettings withReservationTimeout(Duration value) {
            FiniteDuration finiteDuration = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(value));
            int n = this.copy$default$1();
            int n2 = this.copy$default$2();
            FiniteDuration finiteDuration2 = this.copy$default$3();
            FiniteDuration finiteDuration3 = this.copy$default$4();
            return this.copy(n, n2, finiteDuration2, finiteDuration3, finiteDuration);
        }

        private ConsumerSettings copy(int bufferMinSize, int bufferMaxSize, FiniteDuration fetchInterval, FiniteDuration pollTimeout, FiniteDuration reservationTimeout) {
            return new ConsumerSettings(bufferMinSize, bufferMaxSize, fetchInterval, pollTimeout, reservationTimeout);
        }

        private int copy$default$1() {
            return this.bufferMinSize();
        }

        private int copy$default$2() {
            return this.bufferMaxSize();
        }

        private FiniteDuration copy$default$3() {
            return this.fetchInterval();
        }

        private FiniteDuration copy$default$4() {
            return this.pollTimeout();
        }

        private FiniteDuration copy$default$5() {
            return this.reservationTimeout();
        }

        public String toString() {
            return new StringBuilder(18).append("ConsumerSettings(").append(new StringBuilder(15).append("bufferMinSize=").append(this.bufferMinSize()).append(",").toString()).append(new StringBuilder(15).append("bufferMaxSize=").append(this.bufferMaxSize()).append(",").toString()).append(new StringBuilder(15).append("fetchInterval=").append(this.fetchInterval().toCoarsest()).append(",").toString()).append(new StringBuilder(13).append("pollTimeout=").append(this.pollTimeout().toCoarsest()).append(",").toString()).append(new StringBuilder(19).append("reservationTimeout=").append(this.reservationTimeout().toCoarsest()).toString()).append(")").toString();
        }
    }
}

