/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.connectors.ironmq.impl;

import com.typesafe.config.Config;
import io.circe.Decoder$;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.syntax.package;
import java.io.Serializable;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.NotUsed$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpExt;
import org.apache.pekko.http.scaladsl.client.RequestBuilding$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Authorization$;
import org.apache.pekko.http.scaladsl.model.headers.GenericHttpCredentials$;
import org.apache.pekko.http.scaladsl.model.headers.HttpCredentials;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.connectors.ironmq.IronMqSettings;
import org.apache.pekko.stream.connectors.ironmq.Message;
import org.apache.pekko.stream.connectors.ironmq.PushMessage;
import org.apache.pekko.stream.connectors.ironmq.impl.Codec$;
import org.apache.pekko.stream.connectors.ironmq.impl.IronMqClient$;
import org.apache.pekko.stream.connectors.ironmq.impl.Queue;
import org.apache.pekko.stream.connectors.ironmq.impl.Reservation;
import org.apache.pekko.stream.connectors.ironmq.impl.ReservedMessage;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source$;
import org.mdedetrich.pekko.http.support.CirceHttpSupport$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public final class IronMqClient {
    private final IronMqSettings settings;
    private final Materializer materializer;
    private final Flow<HttpRequest, HttpResponse, ?> pipeline;
    private final String queuesPath;

    public static IronMqClient apply(ActorSystem actorSystem, Materializer materializer) {
        return IronMqClient$.MODULE$.apply(actorSystem, materializer);
    }

    public static IronMqClient apply(Config config, ActorSystem actorSystem, Materializer materializer) {
        return IronMqClient$.MODULE$.apply(config, actorSystem, materializer);
    }

    public static IronMqClient apply(IronMqSettings ironMqSettings, ActorSystem actorSystem, Materializer materializer) {
        return IronMqClient$.MODULE$.apply(ironMqSettings, actorSystem, materializer);
    }

    public IronMqClient(IronMqSettings settings, ActorSystem actorSystem, Materializer materializer) {
        Flow flow;
        this.settings = settings;
        this.materializer = materializer;
        HttpExt http = Http$.MODULE$.apply(actorSystem);
        Uri endpoint = settings.endpoint();
        String string = endpoint.scheme();
        if ("https".equals(string)) {
            flow = http.cachedHostConnectionPoolHttps(endpoint.authority().host().address(), endpoint.authority().port(), http.cachedHostConnectionPoolHttps$default$3(), http.cachedHostConnectionPoolHttps$default$4(), http.cachedHostConnectionPoolHttps$default$5());
        } else if ("http".equals(string)) {
            flow = http.cachedHostConnectionPool(endpoint.authority().host().address(), endpoint.authority().port(), http.cachedHostConnectionPool$default$3(), http.cachedHostConnectionPool$default$4());
        } else {
            String other = string;
            throw new IllegalArgumentException(new StringBuilder(48).append("Endpoint ").append(endpoint).append(" contains an invalid HTTP/HTTPS scheme ").append(other).toString());
        }
        Flow connectionPoolFlow = flow;
        this.pipeline = (Flow)((Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)_$1 -> (HttpRequest)_$1.withHeaders((HttpHeader)Authorization$.MODULE$.apply((HttpCredentials)GenericHttpCredentials$.MODULE$.apply("OAuth", settings.token(), GenericHttpCredentials$.MODULE$.$lessinit$greater$default$3())), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HttpHeader[0]))).map((Function1 & Serializable)_$2 -> {
            HttpRequest httpRequest = (HttpRequest)Predef$.MODULE$.ArrowAssoc(_$2);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)httpRequest, (Object)NotUsed$.MODULE$);
        })).via((Graph)connectionPoolFlow).map((Function1 & Serializable)_$3 -> (Try)_$3._1()).mapAsync(1, (Function1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                HttpResponse httpResponse = (HttpResponse)((Success)try_).value();
                HttpResponse response = httpResponse;
                if (response.status().isSuccess()) {
                    return (Future)FastFuture$.MODULE$.successful().apply((Object)response);
                }
                HttpResponse response2 = httpResponse;
                return (Future)FastFuture$.MODULE$.failed().apply((Object)new RuntimeException(response2.status().reason()));
            }
            if (try_ instanceof Failure) {
                Throwable error = ((Failure)try_).exception();
                return (Future)FastFuture$.MODULE$.failed().apply((Object)error);
            }
            throw new MatchError((Object)try_);
        });
        this.queuesPath = new StringBuilder(19).append("/3/projects/").append(settings.projectId()).append("/queues").toString();
    }

    public Future<Seq<String>> listQueues(Option<String> prefix, Option<String> from, int noOfQueues, ExecutionContext ec) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"per_page");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)noOfQueues).toString());
        Uri.Query query = (Uri.Query)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{prefix.map((Function1 & Serializable)_$4 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"prefix");
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$4);
        }), from.map((Function1 & Serializable)_$5 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"previous");
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$5);
        })}))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Option x) {
                Option option = x;
                if (option instanceof Some) {
                    Tuple2 x2 = (Tuple2)((Some)option).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Option x, Function1 function1) {
                Option option = x;
                if (option instanceof Some) {
                    Tuple2 x2 = (Tuple2)((Some)option).value();
                    return x2;
                }
                return function1.apply((Object)x);
            }
        }).foldLeft((Object)Uri.Query$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function2 & Serializable)(q, x) -> q.$plus$colon(x));
        return this.makeRequest(RequestBuilding$.MODULE$.Get().apply(Uri$.MODULE$.apply(String.valueOf(this.queuesPath)).withQuery(query))).flatMap((Function1 & Serializable)_$6 -> Unmarshal$.MODULE$.apply(_$6).to(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(CirceHttpSupport$.MODULE$.circeJsonUnmarshaller()), ec, this.materializer), ec).map((Function1 & Serializable)json -> IronMqClient.parseQueues$1(json), ec).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Either x) {
                Either either = x;
                if (either instanceof Right) {
                    Seq xs = (Seq)((Right)either).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x, Function1 function1) {
                Either either = x;
                if (either instanceof Right) {
                    Seq xs = (Seq)((Right)either).value();
                    return xs;
                }
                return function1.apply((Object)x);
            }
        }, ec);
    }

    public Option<String> listQueues$default$1() {
        return None$.MODULE$;
    }

    public Option<String> listQueues$default$2() {
        return None$.MODULE$;
    }

    public int listQueues$default$3() {
        return 50;
    }

    public Future<String> createQueue(String name, ExecutionContext ec) {
        return this.makeRequest(RequestBuilding$.MODULE$.Put().apply(Uri$.MODULE$.apply(new StringBuilder(1).append(this.queuesPath).append("/").append(name).toString()), (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), CirceHttpSupport$.MODULE$.circeJsonMarshaller(CirceHttpSupport$.MODULE$.circeJsonMarshaller$default$1()), ec)).flatMap((Function1 & Serializable)_$7 -> Unmarshal$.MODULE$.apply(_$7).to(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(CirceHttpSupport$.MODULE$.circeJsonUnmarshaller()), ec, this.materializer), ec).map((Function1 & Serializable)_$8 -> _$8.hcursor().downField("queue").as(Codec$.MODULE$.queueDecoder()), ec).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Either x) {
                Either either = x;
                if (either instanceof Right) {
                    Queue queue = (Queue)((Right)either).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x, Function1 function1) {
                Either either = x;
                if (either instanceof Right) {
                    Queue queue = (Queue)((Right)either).value();
                    return queue.name();
                }
                return function1.apply((Object)x);
            }
        }, ec);
    }

    public Future<Done> deleteQueue(String name, ExecutionContext ec) {
        return this.makeRequest(RequestBuilding$.MODULE$.Delete().apply(Uri$.MODULE$.apply(new StringBuilder(1).append(this.queuesPath).append("/").append(name).toString()))).map((Function1 & Serializable)_$9 -> Done$.MODULE$, ec);
    }

    public Future<Message.Ids> pushMessages(String queueName, Seq<PushMessage> messages, ExecutionContext ec) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"messages");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromValues((Iterable)messages.map((Function1 & Serializable)pm -> {
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"body");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(pm.body()));
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"delay");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromLong(pm.delay().toSeconds()));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        })));
        Json payload = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return this.makeRequest(RequestBuilding$.MODULE$.Post().apply(Uri$.MODULE$.apply(new StringBuilder(10).append(this.queuesPath).append("/").append(queueName).append("/messages").toString()), (Object)payload, CirceHttpSupport$.MODULE$.circeJsonMarshaller(CirceHttpSupport$.MODULE$.circeJsonMarshaller$default$1()), ec)).flatMap((Function1 & Serializable)_$10 -> Unmarshal$.MODULE$.apply(_$10).to(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(CirceHttpSupport$.MODULE$.circeUnmarshaller(Codec$.MODULE$.messageIdsDecoder())), ec, this.materializer), ec);
    }

    public Future<Iterable<ReservedMessage>> reserveMessages(String queueName, int noOfMessages, Duration timeout, Duration watch, ExecutionContext ec) {
        Json json2;
        Json json3;
        if (timeout.isFinite()) {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"timeout");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromLong(timeout.toSeconds()));
            json3 = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else {
            json3 = Json$.MODULE$.Null();
        }
        if (watch.isFinite()) {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"wait");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromLong(watch.toSeconds()));
            json2 = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else {
            json2 = Json$.MODULE$.Null();
        }
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"n");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromInt(noOfMessages));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"delete");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromBoolean(false));
        Json payload = json3.deepMerge(json2).deepMerge(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        return this.makeRequest(RequestBuilding$.MODULE$.Post().apply(Uri$.MODULE$.apply(new StringBuilder(14).append(this.queuesPath).append("/").append(queueName).append("/reservations").toString()), (Object)payload, CirceHttpSupport$.MODULE$.circeJsonMarshaller(CirceHttpSupport$.MODULE$.circeJsonMarshaller$default$1()), ec)).flatMap((Function1 & Serializable)_$11 -> Unmarshal$.MODULE$.apply(_$11).to(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(CirceHttpSupport$.MODULE$.circeJsonUnmarshaller()), ec, this.materializer), ec).map((Function1 & Serializable)json -> json.hcursor().downField("messages").as(Decoder$.MODULE$.decodeIterable(Codec$.MODULE$.reservedMessageDecoder(), Iterable$.MODULE$.iterableFactory())), ec).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Either x) {
                Either either = x;
                if (either instanceof Right) {
                    Iterable xs = (Iterable)((Right)either).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x, Function1 function1) {
                Either either = x;
                if (either instanceof Right) {
                    Iterable xs = (Iterable)((Right)either).value();
                    return xs;
                }
                return function1.apply((Object)x);
            }
        }, ec);
    }

    public int reserveMessages$default$2() {
        return 1;
    }

    public Duration reserveMessages$default$3() {
        return Duration$.MODULE$.Undefined();
    }

    public Duration reserveMessages$default$4() {
        return Duration$.MODULE$.Undefined();
    }

    public Future<Iterable<Message>> pullMessages(String queueName, int noOfMessages, Duration watch, ExecutionContext ec) {
        Json json2;
        if (watch.isFinite()) {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"wait");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromLong(watch.toSeconds()));
            json2 = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else {
            json2 = Json$.MODULE$.Null();
        }
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"n");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromInt(noOfMessages));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"delete");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromBoolean(true));
        Json payload = json2.deepMerge(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        return this.makeRequest(RequestBuilding$.MODULE$.Post().apply(Uri$.MODULE$.apply(new StringBuilder(14).append(this.queuesPath).append("/").append(queueName).append("/reservations").toString()), (Object)payload, CirceHttpSupport$.MODULE$.circeJsonMarshaller(CirceHttpSupport$.MODULE$.circeJsonMarshaller$default$1()), ec)).flatMap((Function1 & Serializable)_$12 -> Unmarshal$.MODULE$.apply(_$12).to(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(CirceHttpSupport$.MODULE$.circeJsonUnmarshaller()), ec, this.materializer), ec).map((Function1 & Serializable)json -> json.hcursor().downField("messages").as(Decoder$.MODULE$.decodeIterable(Codec$.MODULE$.messageDecoder(), Iterable$.MODULE$.iterableFactory())), ec).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Either x) {
                Either either = x;
                if (either instanceof Right) {
                    Iterable xs = (Iterable)((Right)either).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x, Function1 function1) {
                Either either = x;
                if (either instanceof Right) {
                    Iterable xs = (Iterable)((Right)either).value();
                    return xs;
                }
                return function1.apply((Object)x);
            }
        }, ec);
    }

    public int pullMessages$default$2() {
        return 1;
    }

    public Duration pullMessages$default$3() {
        return Duration$.MODULE$.Undefined();
    }

    public Future<Reservation> touchMessage(String queueName, Reservation reservation, Duration timeout, ExecutionContext ec) {
        Json json2;
        if (timeout.isFinite()) {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"timeout");
            Long l = (Long)io.circe.syntax.package$.MODULE$.EncoderOps((Object)BoxesRunTime.boxToLong((long)timeout.toSeconds()));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)l, Encoder$.MODULE$.encodeLong()));
            json2 = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else {
            json2 = Json$.MODULE$.Null();
        }
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"reservation_id");
        Reservation.Id id = (Reservation.Id)io.circe.syntax.package$.MODULE$.EncoderOps((Object)new Reservation.Id(reservation.reservationId()));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)id, Codec$.MODULE$.reservationIdEncoder()));
        Json payload = json2.deepMerge(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        return this.makeRequest(RequestBuilding$.MODULE$.Post().apply(new StringBuilder(17).append(this.queuesPath).append("/").append(queueName).append("/messages/").append(new Message.Id(reservation.messageId())).append("/touch").toString(), (Object)payload, CirceHttpSupport$.MODULE$.circeJsonMarshaller(CirceHttpSupport$.MODULE$.circeJsonMarshaller$default$1()), ec)).flatMap((Function1 & Serializable)_$13 -> Unmarshal$.MODULE$.apply(_$13).to(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(CirceHttpSupport$.MODULE$.circeJsonUnmarshaller()), ec, this.materializer), ec).map((Function1 & Serializable)json -> {
            None$ none$;
            Either either = json.hcursor().downField("reservation_id").as(Codec$.MODULE$.reservationIdDecoder());
            if (either instanceof Right) {
                Object object = ((Right)either).value();
                String r = object == null ? null : ((Reservation.Id)object).value();
                none$ = Some$.MODULE$.apply((Object)new Reservation.Id(r));
            } else if (either instanceof Left) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)either);
            }
            return none$.map((Function1 & Serializable)reservationId -> reservation.copy(reservation.copy$default$1(), reservationId == null ? null : ((Reservation.Id)reservationId).value()));
        }, ec).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Option x) {
                Option option = x;
                if (option instanceof Some) {
                    Reservation r = (Reservation)((Some)option).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Option x, Function1 function1) {
                Option option = x;
                if (option instanceof Some) {
                    Reservation r = (Reservation)((Some)option).value();
                    return r;
                }
                return function1.apply((Object)x);
            }
        }, ec);
    }

    public Duration touchMessage$default$3() {
        return Duration$.MODULE$.Undefined();
    }

    public Future<Iterable<Message>> peekMessages(String queueName, int numberOfMessages, ExecutionContext ec) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"n");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)numberOfMessages).toString());
        return this.makeRequest(RequestBuilding$.MODULE$.Get().apply(Uri$.MODULE$.apply(new StringBuilder(10).append(this.queuesPath).append("/").append(queueName).append("/messages").toString()).withQuery(Uri.Query$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))))).flatMap((Function1 & Serializable)_$14 -> Unmarshal$.MODULE$.apply(_$14).to(Unmarshaller$.MODULE$.messageUnmarshallerFromEntityUnmarshaller(CirceHttpSupport$.MODULE$.circeJsonUnmarshaller()), ec, this.materializer), ec).map((Function1 & Serializable)json -> json.hcursor().downField("messages").as(Decoder$.MODULE$.decodeIterable(Codec$.MODULE$.messageDecoder(), Iterable$.MODULE$.iterableFactory())), ec).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Either x) {
                Either either = x;
                if (either instanceof Right) {
                    Iterable xs = (Iterable)((Right)either).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x, Function1 function1) {
                Either either = x;
                if (either instanceof Right) {
                    Iterable xs = (Iterable)((Right)either).value();
                    return xs;
                }
                return function1.apply((Object)x);
            }
        }, ec);
    }

    public int peekMessages$default$2() {
        return 1;
    }

    public Future<BoxedUnit> deleteMessages(String queueName, Seq<Reservation> reservations, ExecutionContext ec) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"ids");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromValues((Iterable)reservations.map((Function1 & Serializable)_$15 -> {
            Reservation reservation = (Reservation)io.circe.syntax.package$.MODULE$.EncoderOps(_$15);
            return package.EncoderOps$.MODULE$.asJson$extension((Object)reservation, Codec$.MODULE$.reservationEncoder());
        })));
        Json payload = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return this.makeRequest(RequestBuilding$.MODULE$.Delete().apply(Uri$.MODULE$.apply(new StringBuilder(10).append(this.queuesPath).append("/").append(queueName).append("/messages").toString()), (Object)payload, CirceHttpSupport$.MODULE$.circeJsonMarshaller(CirceHttpSupport$.MODULE$.circeJsonMarshaller$default$1()), ec)).map((Function1)(JProcedure1 & Serializable)_$16 -> {}, ec);
    }

    public Future<BoxedUnit> releaseMessage(String queueName, Reservation reservation, FiniteDuration delay, ExecutionContext ec) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"reservation_id");
        Reservation.Id id = (Reservation.Id)io.circe.syntax.package$.MODULE$.EncoderOps((Object)new Reservation.Id(reservation.reservationId()));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)id, Codec$.MODULE$.reservationIdEncoder()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"delay");
        Long l = (Long)io.circe.syntax.package$.MODULE$.EncoderOps((Object)BoxesRunTime.boxToLong((long)delay.toSeconds()));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)l, Encoder$.MODULE$.encodeLong()));
        Json payload = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return this.makeRequest(RequestBuilding$.MODULE$.Post().apply(Uri$.MODULE$.apply(new StringBuilder(19).append(this.queuesPath).append("/").append(queueName).append("/messages/").append(reservation.messageId()).append("/release").toString()), (Object)payload, CirceHttpSupport$.MODULE$.circeJsonMarshaller(CirceHttpSupport$.MODULE$.circeJsonMarshaller$default$1()), ec)).map((Function1)(JProcedure1 & Serializable)_$17 -> {}, ec);
    }

    public FiniteDuration releaseMessage$default$3() {
        return Duration$.MODULE$.Zero();
    }

    public Future<BoxedUnit> clearMessages(String queueName, ExecutionContext ec) {
        return this.makeRequest(RequestBuilding$.MODULE$.Delete().apply(Uri$.MODULE$.apply(new StringBuilder(10).append(this.queuesPath).append("/").append(queueName).append("/messages").toString()), (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), CirceHttpSupport$.MODULE$.circeJsonMarshaller(CirceHttpSupport$.MODULE$.circeJsonMarshaller$default$1()), ec)).map((Function1)(JProcedure1 & Serializable)_$18 -> {}, ec);
    }

    private Future<HttpResponse> makeRequest(HttpRequest request) {
        return (Future)Source$.MODULE$.single((Object)request).via(this.pipeline).runWith((Graph)Sink$.MODULE$.head(), this.materializer);
    }

    private static final Json extractName$1(Json json) {
        Either either = json.hcursor().downField("name").as(Decoder$.MODULE$.decodeJson());
        if (either instanceof Right) {
            Json r = (Json)((Right)either).value();
            return r;
        }
        if (either instanceof Left) {
            return Json$.MODULE$.Null();
        }
        throw new MatchError((Object)either);
    }

    private static final Either parseQueues$1(Json json) {
        return json.hcursor().downField("queues").withFocus((Function1 & Serializable)xsJson -> xsJson.mapArray((Function1 & Serializable)xs -> (Vector)xs.map((Function1 & Serializable)json -> IronMqClient.extractName$1(json)))).as(Decoder$.MODULE$.decodeSeq(Decoder$.MODULE$.decodeString()));
    }
}

